/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSServiceWorkerContainer.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSServiceWorker.h"
#include "JSServiceWorkerRegistration.h"
#include "JSServiceWorkerUpdateViaCache.h"
#include "JSWorkerType.h"
#include "Navigator.h"
#include "ScriptExecutionContext.h"
#include "WorkerNavigator.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> ServiceWorkerContainer::RegistrationOptions convertDictionary<ServiceWorkerContainer::RegistrationOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ServiceWorkerContainer::RegistrationOptions result;
    JSValue scopeValue;
    if (isNullOrUndefined)
        scopeValue = jsUndefined();
    else {
        scopeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "scope"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!scopeValue.isUndefined()) {
        result.scope = convert<IDLUSVString>(lexicalGlobalObject, scopeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<WorkerType>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.type = WorkerType::Classic;
    JSValue updateViaCacheValue;
    if (isNullOrUndefined)
        updateViaCacheValue = jsUndefined();
    else {
        updateViaCacheValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "updateViaCache"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!updateViaCacheValue.isUndefined()) {
        result.updateViaCache = convert<IDLEnumeration<ServiceWorkerUpdateViaCache>>(lexicalGlobalObject, updateViaCacheValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.updateViaCache = ServiceWorkerUpdateViaCache::Imports;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerContainerPrototypeFunctionRegister(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerContainerPrototypeFunctionGetRegistration(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerContainerPrototypeFunctionGetRegistrations(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerContainerPrototypeFunctionStartMessages(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsServiceWorkerContainerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerContainerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsServiceWorkerContainerController(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerContainerReady(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerContainerOncontrollerchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerContainerOncontrollerchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsServiceWorkerContainerOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerContainerOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsServiceWorkerContainerOnmessageerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerContainerOnmessageerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSServiceWorkerContainerPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSServiceWorkerContainerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSServiceWorkerContainerPrototype* ptr = new (NotNull, JSC::allocateCell<JSServiceWorkerContainerPrototype>(vm.heap)) JSServiceWorkerContainerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSServiceWorkerContainerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerContainerPrototype, JSServiceWorkerContainerPrototype::Base);

using JSServiceWorkerContainerConstructor = JSDOMConstructorNotConstructable<JSServiceWorkerContainer>;

template<> JSValue JSServiceWorkerContainerConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSServiceWorkerContainerConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSServiceWorkerContainer::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ServiceWorkerContainer"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSServiceWorkerContainerConstructor::s_info = { "ServiceWorkerContainer", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerContainerConstructor) };

/* Hash table for prototype */

static const HashTableValue JSServiceWorkerContainerPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerContainerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerContainerConstructor) } },
    { "controller", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerContainerController), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ready", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerContainerReady), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "oncontrollerchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerContainerOncontrollerchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerContainerOncontrollerchange) } },
    { "onmessage", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerContainerOnmessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerContainerOnmessage) } },
    { "onmessageerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerContainerOnmessageerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerContainerOnmessageerror) } },
    { "register", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerContainerPrototypeFunctionRegister), (intptr_t) (1) } },
    { "getRegistration", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerContainerPrototypeFunctionGetRegistration), (intptr_t) (0) } },
    { "getRegistrations", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerContainerPrototypeFunctionGetRegistrations), (intptr_t) (0) } },
    { "startMessages", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerContainerPrototypeFunctionStartMessages), (intptr_t) (0) } },
};

const ClassInfo JSServiceWorkerContainerPrototype::s_info = { "ServiceWorkerContainerPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerContainerPrototype) };

void JSServiceWorkerContainerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSServiceWorkerContainer::info(), JSServiceWorkerContainerPrototypeTableValues, *this);
}

const ClassInfo JSServiceWorkerContainer::s_info = { "ServiceWorkerContainer", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerContainer) };

JSServiceWorkerContainer::JSServiceWorkerContainer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ServiceWorkerContainer>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSServiceWorkerContainer::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, ServiceWorkerContainer>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSServiceWorkerContainer::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSServiceWorkerContainerPrototype::create(vm, &globalObject, JSServiceWorkerContainerPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSServiceWorkerContainer::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSServiceWorkerContainer>(vm, globalObject);
}

JSValue JSServiceWorkerContainer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSServiceWorkerContainerConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSServiceWorkerContainer* IDLAttribute<JSServiceWorkerContainer>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSServiceWorkerContainer*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSServiceWorkerContainer* IDLOperation<JSServiceWorkerContainer>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSServiceWorkerContainer*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsServiceWorkerContainerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerContainerPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSServiceWorkerContainer::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSServiceWorkerContainerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerContainerPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsServiceWorkerContainerControllerGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<ServiceWorker>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.controller());
    return result;
}

EncodedJSValue jsServiceWorkerContainerController(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerContainer>::get<jsServiceWorkerContainerControllerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "controller");
}

static inline JSValue jsServiceWorkerContainerReadyGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLPromise<IDLInterface<ServiceWorkerRegistration>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ready());
    return result;
}

EncodedJSValue jsServiceWorkerContainerReady(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerContainer>::get<jsServiceWorkerContainerReadyGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, "ready");
}

static inline JSValue jsServiceWorkerContainerOncontrollerchangeGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().controllerchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsServiceWorkerContainerOncontrollerchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerContainer>::get<jsServiceWorkerContainerOncontrollerchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncontrollerchange");
}

static inline bool setJSServiceWorkerContainerOncontrollerchangeSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().controllerchangeEvent, value);
    return true;
}

bool setJSServiceWorkerContainerOncontrollerchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerContainer>::set<setJSServiceWorkerContainerOncontrollerchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncontrollerchange");
}

static inline JSValue jsServiceWorkerContainerOnmessageGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().messageEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsServiceWorkerContainerOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerContainer>::get<jsServiceWorkerContainerOnmessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmessage");
}

static inline bool setJSServiceWorkerContainerOnmessageSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().messageEvent, value);
    return true;
}

bool setJSServiceWorkerContainerOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerContainer>::set<setJSServiceWorkerContainerOnmessageSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmessage");
}

static inline JSValue jsServiceWorkerContainerOnmessageerrorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().messageerrorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsServiceWorkerContainerOnmessageerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerContainer>::get<jsServiceWorkerContainerOnmessageerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmessageerror");
}

static inline bool setJSServiceWorkerContainerOnmessageerrorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().messageerrorEvent, value);
    return true;
}

bool setJSServiceWorkerContainerOnmessageerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerContainer>::set<setJSServiceWorkerContainerOnmessageerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmessageerror");
}

static inline JSC::EncodedJSValue jsServiceWorkerContainerPrototypeFunctionRegisterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerContainer>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto scriptURL = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<ServiceWorkerContainer::RegistrationOptions>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.addRegistration(WTFMove(scriptURL), WTFMove(options), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerContainerPrototypeFunctionRegister(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerContainer>::call<jsServiceWorkerContainerPrototypeFunctionRegisterBody>(*lexicalGlobalObject, *callFrame, "register");
}

static inline JSC::EncodedJSValue jsServiceWorkerContainerPrototypeFunctionGetRegistrationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerContainer>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto clientURL = callFrame->argument(0).isUndefined() ? emptyString() : convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.getRegistration(WTFMove(clientURL), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerContainerPrototypeFunctionGetRegistration(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerContainer>::call<jsServiceWorkerContainerPrototypeFunctionGetRegistrationBody>(*lexicalGlobalObject, *callFrame, "getRegistration");
}

static inline JSC::EncodedJSValue jsServiceWorkerContainerPrototypeFunctionGetRegistrationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerContainer>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.getRegistrations(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerContainerPrototypeFunctionGetRegistrations(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerContainer>::call<jsServiceWorkerContainerPrototypeFunctionGetRegistrationsBody>(*lexicalGlobalObject, *callFrame, "getRegistrations");
}

static inline JSC::EncodedJSValue jsServiceWorkerContainerPrototypeFunctionStartMessagesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSServiceWorkerContainer>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.startMessages();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerContainerPrototypeFunctionStartMessages(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSServiceWorkerContainer>::call<jsServiceWorkerContainerPrototypeFunctionStartMessagesBody>(*lexicalGlobalObject, *callFrame, "startMessages");
}

void JSServiceWorkerContainer::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSServiceWorkerContainer*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSServiceWorkerContainerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsServiceWorkerContainer = jsCast<JSServiceWorkerContainer*>(handle.slot()->asCell());
    if (jsServiceWorkerContainer->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsServiceWorkerContainer->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    NavigatorBase* root = WTF::getPtr(jsServiceWorkerContainer->wrapped().navigator());
    if (!root)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Navigator";
    return visitor.containsOpaqueRoot(root);
}

void JSServiceWorkerContainerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsServiceWorkerContainer = static_cast<JSServiceWorkerContainer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsServiceWorkerContainer->wrapped(), jsServiceWorkerContainer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ServiceWorkerContainer@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22ServiceWorkerContainerE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ServiceWorkerContainer>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7ServiceWorkerContainer@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22ServiceWorkerContainerE[2];
#endif

    // If this fails ServiceWorkerContainer does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<ServiceWorkerContainer>::value, "ServiceWorkerContainer is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // ServiceWorkerContainer has subclasses. If ServiceWorkerContainer has subclasses that get passed
    // to toJS() we currently require ServiceWorkerContainer you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<ServiceWorkerContainer>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ServiceWorkerContainer& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ServiceWorkerContainer* JSServiceWorkerContainer::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSServiceWorkerContainer*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(SERVICE_WORKER)
