/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSServiceWorkerInternals.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSFetchEvent.h"
#include "JSFetchResponse.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerInternalsPrototypeFunctionSetOnline(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerInternalsPrototypeFunctionWaitForFetchEventToFinish(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerInternalsPrototypeFunctionCreateBeingDispatchedFetchEvent(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerInternalsPrototypeFunctionCreateOpaqueWithBlobBodyResponse(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerInternalsPrototypeFunctionFetchResponseHeaderList(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsServiceWorkerInternalsProcessName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerInternalsIsThrottleable(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerInternalsProcessIdentifier(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSServiceWorkerInternalsPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSServiceWorkerInternalsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSServiceWorkerInternalsPrototype* ptr = new (NotNull, JSC::allocateCell<JSServiceWorkerInternalsPrototype>(vm.heap)) JSServiceWorkerInternalsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSServiceWorkerInternalsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerInternalsPrototype, JSServiceWorkerInternalsPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSServiceWorkerInternalsPrototypeTableValues[] =
{
    { "processName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerInternalsProcessName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "isThrottleable", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerInternalsIsThrottleable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "processIdentifier", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerInternalsProcessIdentifier), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "setOnline", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerInternalsPrototypeFunctionSetOnline), (intptr_t) (1) } },
    { "waitForFetchEventToFinish", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerInternalsPrototypeFunctionWaitForFetchEventToFinish), (intptr_t) (1) } },
    { "createBeingDispatchedFetchEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerInternalsPrototypeFunctionCreateBeingDispatchedFetchEvent), (intptr_t) (0) } },
    { "createOpaqueWithBlobBodyResponse", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerInternalsPrototypeFunctionCreateOpaqueWithBlobBodyResponse), (intptr_t) (0) } },
    { "fetchResponseHeaderList", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerInternalsPrototypeFunctionFetchResponseHeaderList), (intptr_t) (1) } },
};

const ClassInfo JSServiceWorkerInternalsPrototype::s_info = { "ServiceWorkerInternalsPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerInternalsPrototype) };

void JSServiceWorkerInternalsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSServiceWorkerInternals::info(), JSServiceWorkerInternalsPrototypeTableValues, *this);
}

const ClassInfo JSServiceWorkerInternals::s_info = { "ServiceWorkerInternals", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerInternals) };

JSServiceWorkerInternals::JSServiceWorkerInternals(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ServiceWorkerInternals>&& impl)
    : JSDOMWrapper<ServiceWorkerInternals>(structure, globalObject, WTFMove(impl))
{
}

void JSServiceWorkerInternals::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ServiceWorkerInternals>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSServiceWorkerInternals::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSServiceWorkerInternalsPrototype::create(vm, &globalObject, JSServiceWorkerInternalsPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSServiceWorkerInternals::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSServiceWorkerInternals>(vm, globalObject);
}

void JSServiceWorkerInternals::destroy(JSC::JSCell* cell)
{
    JSServiceWorkerInternals* thisObject = static_cast<JSServiceWorkerInternals*>(cell);
    thisObject->JSServiceWorkerInternals::~JSServiceWorkerInternals();
}

template<> inline JSServiceWorkerInternals* IDLAttribute<JSServiceWorkerInternals>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSServiceWorkerInternals*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSServiceWorkerInternals* IDLOperation<JSServiceWorkerInternals>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSServiceWorkerInternals*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSValue jsServiceWorkerInternalsProcessNameGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.processName());
    return result;
}

EncodedJSValue jsServiceWorkerInternalsProcessName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerInternals>::get<jsServiceWorkerInternalsProcessNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "processName");
}

static inline JSValue jsServiceWorkerInternalsIsThrottleableGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isThrottleable());
    return result;
}

EncodedJSValue jsServiceWorkerInternalsIsThrottleable(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerInternals>::get<jsServiceWorkerInternalsIsThrottleableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isThrottleable");
}

static inline JSValue jsServiceWorkerInternalsProcessIdentifierGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.processIdentifier());
    return result;
}

EncodedJSValue jsServiceWorkerInternalsProcessIdentifier(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerInternals>::get<jsServiceWorkerInternalsProcessIdentifierGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "processIdentifier");
}

static inline JSC::EncodedJSValue jsServiceWorkerInternalsPrototypeFunctionSetOnlineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSServiceWorkerInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto isOnline = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setOnline(WTFMove(isOnline));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerInternalsPrototypeFunctionSetOnline(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSServiceWorkerInternals>::call<jsServiceWorkerInternalsPrototypeFunctionSetOnlineBody>(*lexicalGlobalObject, *callFrame, "setOnline");
}

static inline JSC::EncodedJSValue jsServiceWorkerInternalsPrototypeFunctionWaitForFetchEventToFinishBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerInternals>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto event = convert<IDLInterface<FetchEvent>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "event", "ServiceWorkerInternals", "waitForFetchEventToFinish", "FetchEvent"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.waitForFetchEventToFinish(*event, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerInternalsPrototypeFunctionWaitForFetchEventToFinish(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerInternals>::call<jsServiceWorkerInternalsPrototypeFunctionWaitForFetchEventToFinishBody>(*lexicalGlobalObject, *callFrame, "waitForFetchEventToFinish");
}

static inline JSC::EncodedJSValue jsServiceWorkerInternalsPrototypeFunctionCreateBeingDispatchedFetchEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSServiceWorkerInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    return JSValue::encode(toJS<IDLInterface<FetchEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createBeingDispatchedFetchEvent(*context)));
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerInternalsPrototypeFunctionCreateBeingDispatchedFetchEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSServiceWorkerInternals>::call<jsServiceWorkerInternalsPrototypeFunctionCreateBeingDispatchedFetchEventBody>(*lexicalGlobalObject, *callFrame, "createBeingDispatchedFetchEvent");
}

static inline JSC::EncodedJSValue jsServiceWorkerInternalsPrototypeFunctionCreateOpaqueWithBlobBodyResponseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSServiceWorkerInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    return JSValue::encode(toJS<IDLInterface<FetchResponse>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createOpaqueWithBlobBodyResponse(*context)));
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerInternalsPrototypeFunctionCreateOpaqueWithBlobBodyResponse(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSServiceWorkerInternals>::call<jsServiceWorkerInternalsPrototypeFunctionCreateOpaqueWithBlobBodyResponseBody>(*lexicalGlobalObject, *callFrame, "createOpaqueWithBlobBodyResponse");
}

static inline JSC::EncodedJSValue jsServiceWorkerInternalsPrototypeFunctionFetchResponseHeaderListBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSServiceWorkerInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto response = convert<IDLInterface<FetchResponse>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "response", "ServiceWorkerInternals", "fetchResponseHeaderList", "FetchResponse"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLByteString>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.fetchResponseHeaderList(*response)));
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerInternalsPrototypeFunctionFetchResponseHeaderList(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSServiceWorkerInternals>::call<jsServiceWorkerInternalsPrototypeFunctionFetchResponseHeaderListBody>(*lexicalGlobalObject, *callFrame, "fetchResponseHeaderList");
}

void JSServiceWorkerInternals::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSServiceWorkerInternals*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSServiceWorkerInternalsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSServiceWorkerInternalsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsServiceWorkerInternals = static_cast<JSServiceWorkerInternals*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsServiceWorkerInternals->wrapped(), jsServiceWorkerInternals);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ServiceWorkerInternals>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to ServiceWorkerInternals.
    static_assert(!std::is_polymorphic<ServiceWorkerInternals>::value, "ServiceWorkerInternals is polymorphic but the IDL claims it is not");
    return createWrapper<ServiceWorkerInternals>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ServiceWorkerInternals& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ServiceWorkerInternals* JSServiceWorkerInternals::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSServiceWorkerInternals*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(SERVICE_WORKER)
