/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSServiceWorkerRegistration.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSServiceWorker.h"
#include "JSServiceWorkerUpdateViaCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerRegistrationPrototypeFunctionUpdate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerRegistrationPrototypeFunctionUnregister(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsServiceWorkerRegistrationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerRegistrationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsServiceWorkerRegistrationInstalling(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerRegistrationWaiting(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerRegistrationActive(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerRegistrationScope(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerRegistrationUpdateViaCache(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerRegistrationOnupdatefound(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerRegistrationOnupdatefound(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSServiceWorkerRegistrationPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSServiceWorkerRegistrationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSServiceWorkerRegistrationPrototype* ptr = new (NotNull, JSC::allocateCell<JSServiceWorkerRegistrationPrototype>(vm.heap)) JSServiceWorkerRegistrationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSServiceWorkerRegistrationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerRegistrationPrototype, JSServiceWorkerRegistrationPrototype::Base);

using JSServiceWorkerRegistrationConstructor = JSDOMConstructorNotConstructable<JSServiceWorkerRegistration>;

template<> JSValue JSServiceWorkerRegistrationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSServiceWorkerRegistrationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSServiceWorkerRegistration::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ServiceWorkerRegistration"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSServiceWorkerRegistrationConstructor::s_info = { "ServiceWorkerRegistration", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerRegistrationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSServiceWorkerRegistrationPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerRegistrationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerRegistrationConstructor) } },
    { "installing", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerRegistrationInstalling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "waiting", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerRegistrationWaiting), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "active", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerRegistrationActive), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "scope", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerRegistrationScope), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "updateViaCache", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerRegistrationUpdateViaCache), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onupdatefound", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerRegistrationOnupdatefound), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerRegistrationOnupdatefound) } },
    { "update", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerRegistrationPrototypeFunctionUpdate), (intptr_t) (0) } },
    { "unregister", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerRegistrationPrototypeFunctionUnregister), (intptr_t) (0) } },
};

const ClassInfo JSServiceWorkerRegistrationPrototype::s_info = { "ServiceWorkerRegistrationPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerRegistrationPrototype) };

void JSServiceWorkerRegistrationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSServiceWorkerRegistration::info(), JSServiceWorkerRegistrationPrototypeTableValues, *this);
}

const ClassInfo JSServiceWorkerRegistration::s_info = { "ServiceWorkerRegistration", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerRegistration) };

JSServiceWorkerRegistration::JSServiceWorkerRegistration(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ServiceWorkerRegistration>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSServiceWorkerRegistration::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, ServiceWorkerRegistration>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSServiceWorkerRegistration::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSServiceWorkerRegistrationPrototype::create(vm, &globalObject, JSServiceWorkerRegistrationPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSServiceWorkerRegistration::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSServiceWorkerRegistration>(vm, globalObject);
}

JSValue JSServiceWorkerRegistration::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSServiceWorkerRegistrationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSServiceWorkerRegistration* IDLAttribute<JSServiceWorkerRegistration>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSServiceWorkerRegistration*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSServiceWorkerRegistration* IDLOperation<JSServiceWorkerRegistration>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSServiceWorkerRegistration*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsServiceWorkerRegistrationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerRegistrationPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSServiceWorkerRegistration::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSServiceWorkerRegistrationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerRegistrationPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsServiceWorkerRegistrationInstallingGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<ServiceWorker>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.installing());
    return result;
}

EncodedJSValue jsServiceWorkerRegistrationInstalling(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistrationInstallingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "installing");
}

static inline JSValue jsServiceWorkerRegistrationWaitingGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<ServiceWorker>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.waiting());
    return result;
}

EncodedJSValue jsServiceWorkerRegistrationWaiting(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistrationWaitingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "waiting");
}

static inline JSValue jsServiceWorkerRegistrationActiveGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<ServiceWorker>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.active());
    return result;
}

EncodedJSValue jsServiceWorkerRegistrationActive(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistrationActiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "active");
}

static inline JSValue jsServiceWorkerRegistrationScopeGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.scope());
    return result;
}

EncodedJSValue jsServiceWorkerRegistrationScope(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistrationScopeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scope");
}

static inline JSValue jsServiceWorkerRegistrationUpdateViaCacheGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<ServiceWorkerUpdateViaCache>>(lexicalGlobalObject, throwScope, impl.updateViaCache());
    return result;
}

EncodedJSValue jsServiceWorkerRegistrationUpdateViaCache(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistrationUpdateViaCacheGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "updateViaCache");
}

static inline JSValue jsServiceWorkerRegistrationOnupdatefoundGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().updatefoundEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsServiceWorkerRegistrationOnupdatefound(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistrationOnupdatefoundGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onupdatefound");
}

static inline bool setJSServiceWorkerRegistrationOnupdatefoundSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().updatefoundEvent, value);
    return true;
}

bool setJSServiceWorkerRegistrationOnupdatefound(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerRegistration>::set<setJSServiceWorkerRegistrationOnupdatefoundSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onupdatefound");
}

static inline JSC::EncodedJSValue jsServiceWorkerRegistrationPrototypeFunctionUpdateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerRegistration>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.update(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerRegistrationPrototypeFunctionUpdate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerRegistration>::call<jsServiceWorkerRegistrationPrototypeFunctionUpdateBody>(*lexicalGlobalObject, *callFrame, "update");
}

static inline JSC::EncodedJSValue jsServiceWorkerRegistrationPrototypeFunctionUnregisterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerRegistration>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.unregister(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerRegistrationPrototypeFunctionUnregister(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerRegistration>::call<jsServiceWorkerRegistrationPrototypeFunctionUnregisterBody>(*lexicalGlobalObject, *callFrame, "unregister");
}

void JSServiceWorkerRegistration::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSServiceWorkerRegistration*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSServiceWorkerRegistrationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsServiceWorkerRegistration = jsCast<JSServiceWorkerRegistration*>(handle.slot()->asCell());
    if (jsServiceWorkerRegistration->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsServiceWorkerRegistration->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    ServiceWorkerRegistration* root = &jsServiceWorkerRegistration->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from ServiceWorkerRegistration";
    return visitor.containsOpaqueRoot(root);
}

void JSServiceWorkerRegistrationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsServiceWorkerRegistration = static_cast<JSServiceWorkerRegistration*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsServiceWorkerRegistration->wrapped(), jsServiceWorkerRegistration);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ServiceWorkerRegistration@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25ServiceWorkerRegistrationE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ServiceWorkerRegistration>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7ServiceWorkerRegistration@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore25ServiceWorkerRegistrationE[2];
#endif

    // If this fails ServiceWorkerRegistration does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<ServiceWorkerRegistration>::value, "ServiceWorkerRegistration is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // ServiceWorkerRegistration has subclasses. If ServiceWorkerRegistration has subclasses that get passed
    // to toJS() we currently require ServiceWorkerRegistration you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<ServiceWorkerRegistration>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ServiceWorkerRegistration& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ServiceWorkerRegistration* JSServiceWorkerRegistration::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSServiceWorkerRegistration*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(SERVICE_WORKER)
