/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSServiceWorkerWindowClient.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSVisibilityState.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerWindowClientPrototypeFunctionFocus(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerWindowClientPrototypeFunctionNavigate(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsServiceWorkerWindowClientConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerWindowClientConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsServiceWorkerWindowClientVisibilityState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerWindowClientFocused(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSServiceWorkerWindowClientPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSServiceWorkerWindowClientPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSServiceWorkerWindowClientPrototype* ptr = new (NotNull, JSC::allocateCell<JSServiceWorkerWindowClientPrototype>(vm.heap)) JSServiceWorkerWindowClientPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSServiceWorkerWindowClientPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerWindowClientPrototype, JSServiceWorkerWindowClientPrototype::Base);

using JSServiceWorkerWindowClientConstructor = JSDOMConstructorNotConstructable<JSServiceWorkerWindowClient>;

template<> JSValue JSServiceWorkerWindowClientConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSServiceWorkerClient::getConstructor(vm, &globalObject);
}

template<> void JSServiceWorkerWindowClientConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSServiceWorkerWindowClient::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("WindowClient"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSServiceWorkerWindowClientConstructor::s_info = { "WindowClient", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerWindowClientConstructor) };

/* Hash table for prototype */

static const HashTableValue JSServiceWorkerWindowClientPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerWindowClientConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerWindowClientConstructor) } },
    { "visibilityState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerWindowClientVisibilityState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "focused", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerWindowClientFocused), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "focus", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerWindowClientPrototypeFunctionFocus), (intptr_t) (0) } },
    { "navigate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerWindowClientPrototypeFunctionNavigate), (intptr_t) (1) } },
};

const ClassInfo JSServiceWorkerWindowClientPrototype::s_info = { "WindowClientPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerWindowClientPrototype) };

void JSServiceWorkerWindowClientPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSServiceWorkerWindowClient::info(), JSServiceWorkerWindowClientPrototypeTableValues, *this);
}

const ClassInfo JSServiceWorkerWindowClient::s_info = { "WindowClient", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerWindowClient) };

JSServiceWorkerWindowClient::JSServiceWorkerWindowClient(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ServiceWorkerWindowClient>&& impl)
    : JSServiceWorkerClient(structure, globalObject, WTFMove(impl))
{
}

void JSServiceWorkerWindowClient::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ServiceWorkerWindowClient>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSServiceWorkerWindowClient::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSServiceWorkerWindowClientPrototype::create(vm, &globalObject, JSServiceWorkerWindowClientPrototype::createStructure(vm, &globalObject, JSServiceWorkerClient::prototype(vm, globalObject)));
}

JSObject* JSServiceWorkerWindowClient::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSServiceWorkerWindowClient>(vm, globalObject);
}

JSValue JSServiceWorkerWindowClient::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSServiceWorkerWindowClientConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSServiceWorkerWindowClient* IDLAttribute<JSServiceWorkerWindowClient>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSServiceWorkerWindowClient*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSServiceWorkerWindowClient* IDLOperation<JSServiceWorkerWindowClient>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSServiceWorkerWindowClient*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsServiceWorkerWindowClientConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerWindowClientPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSServiceWorkerWindowClient::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSServiceWorkerWindowClientConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerWindowClientPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsServiceWorkerWindowClientVisibilityStateGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerWindowClient& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<VisibilityState>>(lexicalGlobalObject, throwScope, impl.visibilityState());
    return result;
}

EncodedJSValue jsServiceWorkerWindowClientVisibilityState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerWindowClient>::get<jsServiceWorkerWindowClientVisibilityStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "visibilityState");
}

static inline JSValue jsServiceWorkerWindowClientFocusedGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerWindowClient& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isFocused());
    return result;
}

EncodedJSValue jsServiceWorkerWindowClientFocused(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerWindowClient>::get<jsServiceWorkerWindowClientFocusedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "focused");
}

static inline JSC::EncodedJSValue jsServiceWorkerWindowClientPrototypeFunctionFocusBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerWindowClient>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.focus(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerWindowClientPrototypeFunctionFocus(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerWindowClient>::call<jsServiceWorkerWindowClientPrototypeFunctionFocusBody>(*lexicalGlobalObject, *callFrame, "focus");
}

static inline JSC::EncodedJSValue jsServiceWorkerWindowClientPrototypeFunctionNavigateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerWindowClient>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.navigate(WTFMove(url), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerWindowClientPrototypeFunctionNavigate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerWindowClient>::call<jsServiceWorkerWindowClientPrototypeFunctionNavigateBody>(*lexicalGlobalObject, *callFrame, "navigate");
}

void JSServiceWorkerWindowClient::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSServiceWorkerWindowClient*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}

#endif // ENABLE(SERVICE_WORKER)
