/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSShadowRoot.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "Document.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSShadowRootMode.h"
#include "JSStyleSheetList.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsShadowRootPrototypeFunctionElementFromPoint(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsShadowRootPrototypeFunctionElementsFromPoint(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsShadowRootConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSShadowRootConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsShadowRootMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsShadowRootHost(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsShadowRootInnerHTML(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSShadowRootInnerHTML(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsShadowRootActiveElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsShadowRootStyleSheets(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue jsShadowRootPointerLockElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
JSC::EncodedJSValue jsShadowRootPictureInPictureElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif

class JSShadowRootPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSShadowRootPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSShadowRootPrototype* ptr = new (NotNull, JSC::allocateCell<JSShadowRootPrototype>(vm.heap)) JSShadowRootPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSShadowRootPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSShadowRootPrototype, JSShadowRootPrototype::Base);

using JSShadowRootConstructor = JSDOMConstructorNotConstructable<JSShadowRoot>;

template<> JSValue JSShadowRootConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSDocumentFragment::getConstructor(vm, &globalObject);
}

template<> void JSShadowRootConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSShadowRoot::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ShadowRoot"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSShadowRootConstructor::s_info = { "ShadowRoot", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSShadowRootConstructor) };

/* Hash table for prototype */

static const HashTableValue JSShadowRootPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsShadowRootConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSShadowRootConstructor) } },
    { "mode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsShadowRootMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "host", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsShadowRootHost), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "innerHTML", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsShadowRootInnerHTML), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSShadowRootInnerHTML) } },
    { "activeElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsShadowRootActiveElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "styleSheets", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsShadowRootStyleSheets), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(POINTER_LOCK)
    { "pointerLockElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsShadowRootPointerLockElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "pictureInPictureElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsShadowRootPictureInPictureElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "elementFromPoint", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsShadowRootPrototypeFunctionElementFromPoint), (intptr_t) (2) } },
    { "elementsFromPoint", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsShadowRootPrototypeFunctionElementsFromPoint), (intptr_t) (2) } },
};

const ClassInfo JSShadowRootPrototype::s_info = { "ShadowRootPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSShadowRootPrototype) };

void JSShadowRootPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSShadowRoot::info(), JSShadowRootPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().pictureInPictureAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("pictureInPictureElement"), strlen("pictureInPictureElement"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSShadowRoot::s_info = { "ShadowRoot", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSShadowRoot) };

JSShadowRoot::JSShadowRoot(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ShadowRoot>&& impl)
    : JSDocumentFragment(structure, globalObject, WTFMove(impl))
{
}

void JSShadowRoot::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ShadowRoot>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSShadowRoot::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSShadowRootPrototype::create(vm, &globalObject, JSShadowRootPrototype::createStructure(vm, &globalObject, JSDocumentFragment::prototype(vm, globalObject)));
}

JSObject* JSShadowRoot::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSShadowRoot>(vm, globalObject);
}

JSValue JSShadowRoot::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSShadowRootConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSShadowRoot* IDLAttribute<JSShadowRoot>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSShadowRoot*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSShadowRoot* IDLOperation<JSShadowRoot>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSShadowRoot*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsShadowRootConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSShadowRootPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSShadowRoot::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSShadowRootConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSShadowRootPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsShadowRootModeGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<ShadowRootMode>>(lexicalGlobalObject, throwScope, impl.mode());
    return result;
}

EncodedJSValue jsShadowRootMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRootModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "mode");
}

static inline JSValue jsShadowRootHostGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Element>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.host());
    return result;
}

EncodedJSValue jsShadowRootHost(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRootHostGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "host");
}

static inline JSValue jsShadowRootInnerHTMLGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.innerHTML());
    return result;
}

EncodedJSValue jsShadowRootInnerHTML(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRootInnerHTMLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "innerHTML");
}

static inline bool setJSShadowRootInnerHTMLSetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setInnerHTML(WTFMove(nativeValue));
    });
    return true;
}

bool setJSShadowRootInnerHTML(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSShadowRoot>::set<setJSShadowRootInnerHTMLSetter>(*lexicalGlobalObject, thisValue, encodedValue, "innerHTML");
}

static inline JSValue jsShadowRootActiveElementGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.activeElement());
    return result;
}

EncodedJSValue jsShadowRootActiveElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRootActiveElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "activeElement");
}

static inline JSValue jsShadowRootStyleSheetsGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<StyleSheetList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.styleSheets());
    return result;
}

EncodedJSValue jsShadowRootStyleSheets(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRootStyleSheetsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "styleSheets");
}

#if ENABLE(POINTER_LOCK)
static inline JSValue jsShadowRootPointerLockElementGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pointerLockElement());
    return result;
}

EncodedJSValue jsShadowRootPointerLockElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRootPointerLockElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pointerLockElement");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsShadowRootPictureInPictureElementGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pictureInPictureElement());
    return result;
}

EncodedJSValue jsShadowRootPictureInPictureElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRootPictureInPictureElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pictureInPictureElement");
}

#endif

static inline JSC::EncodedJSValue jsShadowRootPrototypeFunctionElementFromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSShadowRoot>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.elementFromPoint(WTFMove(x), WTFMove(y))));
}

EncodedJSValue JSC_HOST_CALL jsShadowRootPrototypeFunctionElementFromPoint(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSShadowRoot>::call<jsShadowRootPrototypeFunctionElementFromPointBody>(*lexicalGlobalObject, *callFrame, "elementFromPoint");
}

static inline JSC::EncodedJSValue jsShadowRootPrototypeFunctionElementsFromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSShadowRoot>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.elementsFromPoint(WTFMove(x), WTFMove(y))));
}

EncodedJSValue JSC_HOST_CALL jsShadowRootPrototypeFunctionElementsFromPoint(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSShadowRoot>::call<jsShadowRootPrototypeFunctionElementsFromPointBody>(*lexicalGlobalObject, *callFrame, "elementsFromPoint");
}

void JSShadowRoot::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSShadowRoot*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ShadowRoot@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10ShadowRootE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ShadowRoot>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7ShadowRoot@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10ShadowRootE[2];
#endif

    // If this fails ShadowRoot does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<ShadowRoot>::value, "ShadowRoot is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // ShadowRoot has subclasses. If ShadowRoot has subclasses that get passed
    // to toJS() we currently require ShadowRoot you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<ShadowRoot>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ShadowRoot& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
