/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSShadowRootMode.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ShadowRootMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("user-agent"),
        MAKE_STATIC_STRING_IMPL("closed"),
        MAKE_STATIC_STRING_IMPL("open"),
    };
    static_assert(static_cast<size_t>(ShadowRootMode::UserAgent) == 0, "ShadowRootMode::UserAgent is not 0 as expected");
    static_assert(static_cast<size_t>(ShadowRootMode::Closed) == 1, "ShadowRootMode::Closed is not 1 as expected");
    static_assert(static_cast<size_t>(ShadowRootMode::Open) == 2, "ShadowRootMode::Open is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, ShadowRootMode enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<ShadowRootMode> parseEnumeration<ShadowRootMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "user-agent")
        return ShadowRootMode::UserAgent;
    if (stringValue == "closed")
        return ShadowRootMode::Closed;
    if (stringValue == "open")
        return ShadowRootMode::Open;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<ShadowRootMode>()
{
    return "\"user-agent\", \"closed\", \"open\"";
}

} // namespace WebCore
