/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSSourceBuffer.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSTimeRanges.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>

#if ENABLE(VIDEO_TRACK)
#include "JSAudioTrackList.h"
#include "JSTextTrackList.h"
#include "JSVideoTrackList.h"
#endif


namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_SOURCE)

String convertEnumerationToString(SourceBuffer::AppendMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("segments"),
        MAKE_STATIC_STRING_IMPL("sequence"),
    };
    static_assert(static_cast<size_t>(SourceBuffer::AppendMode::Segments) == 0, "SourceBuffer::AppendMode::Segments is not 0 as expected");
    static_assert(static_cast<size_t>(SourceBuffer::AppendMode::Sequence) == 1, "SourceBuffer::AppendMode::Sequence is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, SourceBuffer::AppendMode enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<SourceBuffer::AppendMode> parseEnumeration<SourceBuffer::AppendMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "segments")
        return SourceBuffer::AppendMode::Segments;
    if (stringValue == "sequence")
        return SourceBuffer::AppendMode::Sequence;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<SourceBuffer::AppendMode>()
{
    return "\"segments\", \"sequence\"";
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionAppendBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionAbort(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionRemove(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionChangeType(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsSourceBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSourceBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSourceBufferMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSourceBufferMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSourceBufferUpdating(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSourceBufferBuffered(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSourceBufferTimestampOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSourceBufferTimestampOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsSourceBufferAudioTracks(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsSourceBufferVideoTracks(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsSourceBufferTextTracks(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsSourceBufferAppendWindowStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSourceBufferAppendWindowStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSourceBufferAppendWindowEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSourceBufferAppendWindowEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSourceBufferOnupdatestart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSourceBufferOnupdatestart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSourceBufferOnupdate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSourceBufferOnupdate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSourceBufferOnupdateend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSourceBufferOnupdateend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSourceBufferOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSourceBufferOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSourceBufferOnabort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSourceBufferOnabort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSourceBufferPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSourceBufferPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSourceBufferPrototype* ptr = new (NotNull, JSC::allocateCell<JSSourceBufferPrototype>(vm.heap)) JSSourceBufferPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSourceBufferPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSourceBufferPrototype, JSSourceBufferPrototype::Base);

using JSSourceBufferConstructor = JSDOMConstructorNotConstructable<JSSourceBuffer>;

template<> JSValue JSSourceBufferConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSSourceBufferConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSourceBuffer::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SourceBuffer"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSourceBufferConstructor::s_info = { "SourceBuffer", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSourceBufferConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSourceBufferPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferConstructor) } },
    { "mode", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferMode) } },
    { "updating", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferUpdating), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "buffered", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferBuffered), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "timestampOffset", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferTimestampOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferTimestampOffset) } },
#if ENABLE(VIDEO_TRACK)
    { "audioTracks", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferAudioTracks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "videoTracks", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferVideoTracks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "textTracks", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferTextTracks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "appendWindowStart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferAppendWindowStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferAppendWindowStart) } },
    { "appendWindowEnd", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferAppendWindowEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferAppendWindowEnd) } },
    { "onupdatestart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferOnupdatestart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferOnupdatestart) } },
    { "onupdate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferOnupdate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferOnupdate) } },
    { "onupdateend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferOnupdateend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferOnupdateend) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferOnerror) } },
    { "onabort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferOnabort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSourceBufferOnabort) } },
    { "appendBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSourceBufferPrototypeFunctionAppendBuffer), (intptr_t) (1) } },
    { "abort", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSourceBufferPrototypeFunctionAbort), (intptr_t) (0) } },
    { "remove", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSourceBufferPrototypeFunctionRemove), (intptr_t) (2) } },
    { "changeType", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSourceBufferPrototypeFunctionChangeType), (intptr_t) (1) } },
};

const ClassInfo JSSourceBufferPrototype::s_info = { "SourceBufferPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSourceBufferPrototype) };

void JSSourceBufferPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSourceBuffer::info(), JSSourceBufferPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().sourceBufferChangeTypeEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("changeType"), strlen("changeType"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSSourceBuffer::s_info = { "SourceBuffer", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSourceBuffer) };

JSSourceBuffer::JSSourceBuffer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SourceBuffer>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSSourceBuffer::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, SourceBuffer>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSSourceBuffer::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSourceBufferPrototype::create(vm, &globalObject, JSSourceBufferPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSSourceBuffer::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSourceBuffer>(vm, globalObject);
}

JSValue JSSourceBuffer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSourceBufferConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSourceBuffer* IDLAttribute<JSSourceBuffer>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSourceBuffer*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSSourceBuffer* IDLOperation<JSSourceBuffer>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSSourceBuffer*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsSourceBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSourceBufferPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSourceBuffer::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSourceBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSourceBufferPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSourceBufferModeGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<SourceBuffer::AppendMode>>(lexicalGlobalObject, throwScope, impl.mode());
    return result;
}

EncodedJSValue jsSourceBufferMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "mode");
}

static inline bool setJSSourceBufferModeSetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<SourceBuffer::AppendMode>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMode(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSourceBufferMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSourceBuffer>::set<setJSSourceBufferModeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "mode");
}

static inline JSValue jsSourceBufferUpdatingGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.updating());
    return result;
}

EncodedJSValue jsSourceBufferUpdating(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferUpdatingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "updating");
}

static inline JSValue jsSourceBufferBufferedGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TimeRanges>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.buffered());
    return result;
}

EncodedJSValue jsSourceBufferBuffered(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferBufferedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "buffered");
}

static inline JSValue jsSourceBufferTimestampOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.timestampOffset());
    return result;
}

EncodedJSValue jsSourceBufferTimestampOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferTimestampOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "timestampOffset");
}

static inline bool setJSSourceBufferTimestampOffsetSetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTimestampOffset(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSourceBufferTimestampOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSourceBuffer>::set<setJSSourceBufferTimestampOffsetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "timestampOffset");
}

#if ENABLE(VIDEO_TRACK)
static inline JSValue jsSourceBufferAudioTracksGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioTrackList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.audioTracks());
    return result;
}

EncodedJSValue jsSourceBufferAudioTracks(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferAudioTracksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "audioTracks");
}

#endif

#if ENABLE(VIDEO_TRACK)
static inline JSValue jsSourceBufferVideoTracksGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<VideoTrackList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.videoTracks());
    return result;
}

EncodedJSValue jsSourceBufferVideoTracks(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferVideoTracksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "videoTracks");
}

#endif

#if ENABLE(VIDEO_TRACK)
static inline JSValue jsSourceBufferTextTracksGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TextTrackList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.textTracks());
    return result;
}

EncodedJSValue jsSourceBufferTextTracks(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferTextTracksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "textTracks");
}

#endif

static inline JSValue jsSourceBufferAppendWindowStartGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.appendWindowStart());
    return result;
}

EncodedJSValue jsSourceBufferAppendWindowStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferAppendWindowStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "appendWindowStart");
}

static inline bool setJSSourceBufferAppendWindowStartSetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAppendWindowStart(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSourceBufferAppendWindowStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSourceBuffer>::set<setJSSourceBufferAppendWindowStartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "appendWindowStart");
}

static inline JSValue jsSourceBufferAppendWindowEndGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.appendWindowEnd());
    return result;
}

EncodedJSValue jsSourceBufferAppendWindowEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferAppendWindowEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "appendWindowEnd");
}

static inline bool setJSSourceBufferAppendWindowEndSetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAppendWindowEnd(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSourceBufferAppendWindowEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSourceBuffer>::set<setJSSourceBufferAppendWindowEndSetter>(*lexicalGlobalObject, thisValue, encodedValue, "appendWindowEnd");
}

static inline JSValue jsSourceBufferOnupdatestartGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().updatestartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsSourceBufferOnupdatestart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferOnupdatestartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onupdatestart");
}

static inline bool setJSSourceBufferOnupdatestartSetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().updatestartEvent, value);
    return true;
}

bool setJSSourceBufferOnupdatestart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSourceBuffer>::set<setJSSourceBufferOnupdatestartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onupdatestart");
}

static inline JSValue jsSourceBufferOnupdateGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().updateEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsSourceBufferOnupdate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferOnupdateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onupdate");
}

static inline bool setJSSourceBufferOnupdateSetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().updateEvent, value);
    return true;
}

bool setJSSourceBufferOnupdate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSourceBuffer>::set<setJSSourceBufferOnupdateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onupdate");
}

static inline JSValue jsSourceBufferOnupdateendGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().updateendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsSourceBufferOnupdateend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferOnupdateendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onupdateend");
}

static inline bool setJSSourceBufferOnupdateendSetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().updateendEvent, value);
    return true;
}

bool setJSSourceBufferOnupdateend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSourceBuffer>::set<setJSSourceBufferOnupdateendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onupdateend");
}

static inline JSValue jsSourceBufferOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsSourceBufferOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSSourceBufferOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSSourceBufferOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSourceBuffer>::set<setJSSourceBufferOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSValue jsSourceBufferOnabortGetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().abortEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsSourceBufferOnabort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSourceBuffer>::get<jsSourceBufferOnabortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onabort");
}

static inline bool setJSSourceBufferOnabortSetter(JSGlobalObject& lexicalGlobalObject, JSSourceBuffer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().abortEvent, value);
    return true;
}

bool setJSSourceBufferOnabort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSourceBuffer>::set<setJSSourceBufferOnabortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onabort");
}

static inline JSC::EncodedJSValue jsSourceBufferPrototypeFunctionAppendBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSourceBuffer>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto data = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.appendBuffer(WTFMove(data)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionAppendBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSourceBuffer>::call<jsSourceBufferPrototypeFunctionAppendBufferBody>(*lexicalGlobalObject, *callFrame, "appendBuffer");
}

static inline JSC::EncodedJSValue jsSourceBufferPrototypeFunctionAbortBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSourceBuffer>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.abort());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionAbort(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSourceBuffer>::call<jsSourceBufferPrototypeFunctionAbortBody>(*lexicalGlobalObject, *callFrame, "abort");
}

static inline JSC::EncodedJSValue jsSourceBufferPrototypeFunctionRemoveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSourceBuffer>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto start = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto end = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.remove(WTFMove(start), WTFMove(end)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionRemove(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSourceBuffer>::call<jsSourceBufferPrototypeFunctionRemoveBody>(*lexicalGlobalObject, *callFrame, "remove");
}

static inline JSC::EncodedJSValue jsSourceBufferPrototypeFunctionChangeTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSourceBuffer>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.changeType(WTFMove(type)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionChangeType(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSourceBuffer>::call<jsSourceBufferPrototypeFunctionChangeTypeBody>(*lexicalGlobalObject, *callFrame, "changeType");
}

void JSSourceBuffer::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSourceBuffer*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSourceBufferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsSourceBuffer = jsCast<JSSourceBuffer*>(handle.slot()->asCell());
    if (jsSourceBuffer->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsSourceBuffer->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSourceBufferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSourceBuffer = static_cast<JSSourceBuffer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSourceBuffer->wrapped(), jsSourceBuffer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SourceBuffer@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12SourceBufferE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SourceBuffer>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7SourceBuffer@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12SourceBufferE[2];
#endif

    // If this fails SourceBuffer does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<SourceBuffer>::value, "SourceBuffer is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // SourceBuffer has subclasses. If SourceBuffer has subclasses that get passed
    // to toJS() we currently require SourceBuffer you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<SourceBuffer>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SourceBuffer& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SourceBuffer* JSSourceBuffer::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSourceBuffer*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_SOURCE)
