/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(MEDIA_SOURCE)

#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "JSEventTarget.h"
#include "SourceBuffer.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class WEBCORE_EXPORT JSSourceBuffer : public JSEventTarget {
public:
    using Base = JSEventTarget;
    using DOMWrapped = SourceBuffer;
    static JSSourceBuffer* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<SourceBuffer>&& impl)
    {
        JSSourceBuffer* ptr = new (NotNull, JSC::allocateCell<JSSourceBuffer>(globalObject->vm().heap)) JSSourceBuffer(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static SourceBuffer* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    SourceBuffer& wrapped() const
    {
        return static_cast<SourceBuffer&>(Base::wrapped());
    }
protected:
    JSSourceBuffer(JSC::Structure*, JSDOMGlobalObject&, Ref<SourceBuffer>&&);

    void finishCreation(JSC::VM&);
};

class JSSourceBufferOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, SourceBuffer*)
{
    static NeverDestroyed<JSSourceBufferOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(SourceBuffer* wrappableObject)
{
    return wrappableObject;
}

WEBCORE_EXPORT JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, SourceBuffer&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SourceBuffer* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<SourceBuffer>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<SourceBuffer>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<SourceBuffer> {
    using WrapperClass = JSSourceBuffer;
    using ToWrappedReturnType = SourceBuffer*;
};
#if ENABLE(MEDIA_SOURCE)

String convertEnumerationToString(SourceBuffer::AppendMode);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, SourceBuffer::AppendMode);

template<> Optional<SourceBuffer::AppendMode> parseEnumeration<SourceBuffer::AppendMode>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<SourceBuffer::AppendMode>();

#endif


} // namespace WebCore

#endif // ENABLE(MEDIA_SOURCE)
