/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStyleMedia.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsStyleMediaPrototypeFunctionMatchMedium(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsStyleMediaType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSStyleMediaPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSStyleMediaPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStyleMediaPrototype* ptr = new (NotNull, JSC::allocateCell<JSStyleMediaPrototype>(vm.heap)) JSStyleMediaPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStyleMediaPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStyleMediaPrototype, JSStyleMediaPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSStyleMediaPrototypeTableValues[] =
{
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleMediaType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "matchMedium", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsStyleMediaPrototypeFunctionMatchMedium), (intptr_t) (0) } },
};

const ClassInfo JSStyleMediaPrototype::s_info = { "StyleMediaPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStyleMediaPrototype) };

void JSStyleMediaPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStyleMedia::info(), JSStyleMediaPrototypeTableValues, *this);
}

const ClassInfo JSStyleMedia::s_info = { "StyleMedia", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStyleMedia) };

JSStyleMedia::JSStyleMedia(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StyleMedia>&& impl)
    : JSDOMWrapper<StyleMedia>(structure, globalObject, WTFMove(impl))
{
}

void JSStyleMedia::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, StyleMedia>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSStyleMedia::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSStyleMediaPrototype::create(vm, &globalObject, JSStyleMediaPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSStyleMedia::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSStyleMedia>(vm, globalObject);
}

void JSStyleMedia::destroy(JSC::JSCell* cell)
{
    JSStyleMedia* thisObject = static_cast<JSStyleMedia*>(cell);
    thisObject->JSStyleMedia::~JSStyleMedia();
}

template<> inline JSStyleMedia* IDLAttribute<JSStyleMedia>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSStyleMedia*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSStyleMedia* IDLOperation<JSStyleMedia>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSStyleMedia*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSValue jsStyleMediaTypeGetter(JSGlobalObject& lexicalGlobalObject, JSStyleMedia& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsStyleMediaType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSStyleMedia>::get<jsStyleMediaTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSC::EncodedJSValue jsStyleMediaPrototypeFunctionMatchMediumBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSStyleMedia>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto mediaquery = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.matchMedium(WTFMove(mediaquery))));
}

EncodedJSValue JSC_HOST_CALL jsStyleMediaPrototypeFunctionMatchMedium(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSStyleMedia>::call<jsStyleMediaPrototypeFunctionMatchMediumBody>(*lexicalGlobalObject, *callFrame, "matchMedium");
}

void JSStyleMedia::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSStyleMedia*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSStyleMediaOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsStyleMedia = jsCast<JSStyleMedia*>(handle.slot()->asCell());
    auto* root = WTF::getPtr(jsStyleMedia->wrapped().window());
    if (!root)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Window";
    return visitor.containsOpaqueRoot(root);
}

void JSStyleMediaOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsStyleMedia = static_cast<JSStyleMedia*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsStyleMedia->wrapped(), jsStyleMedia);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<StyleMedia>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to StyleMedia.
    static_assert(!std::is_polymorphic<StyleMedia>::value, "StyleMedia is polymorphic but the IDL claims it is not");
    return createWrapper<StyleMedia>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, StyleMedia& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

StyleMedia* JSStyleMedia::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSStyleMedia*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
