/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTextMetrics.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsTextMetricsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTextMetricsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTextMetricsWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextMetricsActualBoundingBoxLeft(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextMetricsActualBoundingBoxRight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextMetricsFontBoundingBoxAscent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextMetricsFontBoundingBoxDescent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextMetricsActualBoundingBoxAscent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextMetricsActualBoundingBoxDescent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextMetricsEmHeightAscent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextMetricsEmHeightDescent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextMetricsHangingBaseline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextMetricsAlphabeticBaseline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextMetricsIdeographicBaseline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSTextMetricsPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTextMetricsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextMetricsPrototype* ptr = new (NotNull, JSC::allocateCell<JSTextMetricsPrototype>(vm.heap)) JSTextMetricsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextMetricsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextMetricsPrototype, JSTextMetricsPrototype::Base);

using JSTextMetricsConstructor = JSDOMConstructorNotConstructable<JSTextMetrics>;

template<> JSValue JSTextMetricsConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTextMetricsConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTextMetrics::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("TextMetrics"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSTextMetricsConstructor::s_info = { "TextMetrics", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextMetricsConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTextMetricsPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextMetricsConstructor) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "actualBoundingBoxLeft", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsActualBoundingBoxLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "actualBoundingBoxRight", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsActualBoundingBoxRight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "fontBoundingBoxAscent", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsFontBoundingBoxAscent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "fontBoundingBoxDescent", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsFontBoundingBoxDescent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "actualBoundingBoxAscent", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsActualBoundingBoxAscent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "actualBoundingBoxDescent", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsActualBoundingBoxDescent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "emHeightAscent", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsEmHeightAscent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "emHeightDescent", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsEmHeightDescent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "hangingBaseline", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsHangingBaseline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "alphabeticBaseline", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsAlphabeticBaseline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ideographicBaseline", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsIdeographicBaseline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSTextMetricsPrototype::s_info = { "TextMetricsPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextMetricsPrototype) };

void JSTextMetricsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTextMetrics::info(), JSTextMetricsPrototypeTableValues, *this);
}

const ClassInfo JSTextMetrics::s_info = { "TextMetrics", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextMetrics) };

JSTextMetrics::JSTextMetrics(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TextMetrics>&& impl)
    : JSDOMWrapper<TextMetrics>(structure, globalObject, WTFMove(impl))
{
}

void JSTextMetrics::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, TextMetrics>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTextMetrics::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTextMetricsPrototype::create(vm, &globalObject, JSTextMetricsPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSTextMetrics::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTextMetrics>(vm, globalObject);
}

JSValue JSTextMetrics::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextMetricsConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSTextMetrics::destroy(JSC::JSCell* cell)
{
    JSTextMetrics* thisObject = static_cast<JSTextMetrics*>(cell);
    thisObject->JSTextMetrics::~JSTextMetrics();
}

template<> inline JSTextMetrics* IDLAttribute<JSTextMetrics>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSTextMetrics*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsTextMetricsConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTextMetricsPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTextMetrics::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSTextMetricsConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTextMetricsPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsTextMetricsWidthGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.width());
    return result;
}

EncodedJSValue jsTextMetricsWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetricsWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline JSValue jsTextMetricsActualBoundingBoxLeftGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.actualBoundingBoxLeft());
    return result;
}

EncodedJSValue jsTextMetricsActualBoundingBoxLeft(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetricsActualBoundingBoxLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "actualBoundingBoxLeft");
}

static inline JSValue jsTextMetricsActualBoundingBoxRightGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.actualBoundingBoxRight());
    return result;
}

EncodedJSValue jsTextMetricsActualBoundingBoxRight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetricsActualBoundingBoxRightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "actualBoundingBoxRight");
}

static inline JSValue jsTextMetricsFontBoundingBoxAscentGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.fontBoundingBoxAscent());
    return result;
}

EncodedJSValue jsTextMetricsFontBoundingBoxAscent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetricsFontBoundingBoxAscentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "fontBoundingBoxAscent");
}

static inline JSValue jsTextMetricsFontBoundingBoxDescentGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.fontBoundingBoxDescent());
    return result;
}

EncodedJSValue jsTextMetricsFontBoundingBoxDescent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetricsFontBoundingBoxDescentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "fontBoundingBoxDescent");
}

static inline JSValue jsTextMetricsActualBoundingBoxAscentGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.actualBoundingBoxAscent());
    return result;
}

EncodedJSValue jsTextMetricsActualBoundingBoxAscent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetricsActualBoundingBoxAscentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "actualBoundingBoxAscent");
}

static inline JSValue jsTextMetricsActualBoundingBoxDescentGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.actualBoundingBoxDescent());
    return result;
}

EncodedJSValue jsTextMetricsActualBoundingBoxDescent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetricsActualBoundingBoxDescentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "actualBoundingBoxDescent");
}

static inline JSValue jsTextMetricsEmHeightAscentGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.emHeightAscent());
    return result;
}

EncodedJSValue jsTextMetricsEmHeightAscent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetricsEmHeightAscentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "emHeightAscent");
}

static inline JSValue jsTextMetricsEmHeightDescentGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.emHeightDescent());
    return result;
}

EncodedJSValue jsTextMetricsEmHeightDescent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetricsEmHeightDescentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "emHeightDescent");
}

static inline JSValue jsTextMetricsHangingBaselineGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.hangingBaseline());
    return result;
}

EncodedJSValue jsTextMetricsHangingBaseline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetricsHangingBaselineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "hangingBaseline");
}

static inline JSValue jsTextMetricsAlphabeticBaselineGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.alphabeticBaseline());
    return result;
}

EncodedJSValue jsTextMetricsAlphabeticBaseline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetricsAlphabeticBaselineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "alphabeticBaseline");
}

static inline JSValue jsTextMetricsIdeographicBaselineGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.ideographicBaseline());
    return result;
}

EncodedJSValue jsTextMetricsIdeographicBaseline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetricsIdeographicBaselineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ideographicBaseline");
}

void JSTextMetrics::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTextMetrics*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSTextMetricsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSTextMetricsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTextMetrics = static_cast<JSTextMetrics*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTextMetrics->wrapped(), jsTextMetrics);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TextMetrics>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TextMetrics.
    static_assert(!std::is_polymorphic<TextMetrics>::value, "TextMetrics is polymorphic but the IDL claims it is not");
    return createWrapper<TextMetrics>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TextMetrics& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

TextMetrics* JSTextMetrics::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTextMetrics*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
