/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSTextTrackCueGeneric.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSTextTrackCueGenericPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTextTrackCueGenericPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextTrackCueGenericPrototype* ptr = new (NotNull, JSC::allocateCell<JSTextTrackCueGenericPrototype>(vm.heap)) JSTextTrackCueGenericPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextTrackCueGenericPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextTrackCueGenericPrototype, JSTextTrackCueGenericPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSTextTrackCueGenericPrototype::s_info = { "TextTrackCueGenericPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextTrackCueGenericPrototype) };

const ClassInfo JSTextTrackCueGeneric::s_info = { "TextTrackCueGeneric", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextTrackCueGeneric) };

JSTextTrackCueGeneric::JSTextTrackCueGeneric(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TextTrackCueGeneric>&& impl)
    : JSVTTCue(structure, globalObject, WTFMove(impl))
{
}

void JSTextTrackCueGeneric::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, TextTrackCueGeneric>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTextTrackCueGeneric::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTextTrackCueGenericPrototype::create(vm, &globalObject, JSTextTrackCueGenericPrototype::createStructure(vm, &globalObject, JSVTTCue::prototype(vm, globalObject)));
}

JSObject* JSTextTrackCueGeneric::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTextTrackCueGeneric>(vm, globalObject);
}

void JSTextTrackCueGeneric::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTextTrackCueGeneric*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TextTrackCueGeneric@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19TextTrackCueGenericE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TextTrackCueGeneric>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7TextTrackCueGeneric@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore19TextTrackCueGenericE[2];
#endif

    // If this fails TextTrackCueGeneric does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<TextTrackCueGeneric>::value, "TextTrackCueGeneric is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // TextTrackCueGeneric has subclasses. If TextTrackCueGeneric has subclasses that get passed
    // to toJS() we currently require TextTrackCueGeneric you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<TextTrackCueGeneric>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TextTrackCueGeneric& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

TextTrackCueGeneric* JSTextTrackCueGeneric::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTextTrackCueGeneric*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO_TRACK)
