/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(TOUCH_EVENTS)

#include "JSTouch.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSEventTarget.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsTouchConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTouchConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTouchClientX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchClientY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchScreenX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchScreenY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchPageX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchPageY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchTarget(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchIdentifier(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchWebkitRadiusX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchWebkitRadiusY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchWebkitRotationAngle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchWebkitForce(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSTouchPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTouchPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTouchPrototype* ptr = new (NotNull, JSC::allocateCell<JSTouchPrototype>(vm.heap)) JSTouchPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTouchPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTouchPrototype, JSTouchPrototype::Base);

using JSTouchConstructor = JSDOMConstructorNotConstructable<JSTouch>;

template<> JSValue JSTouchConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTouchConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTouch::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Touch"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSTouchConstructor::s_info = { "Touch", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTouchConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTouchPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTouchConstructor) } },
    { "clientX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchClientX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clientY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchClientY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "screenX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchScreenX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "screenY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchScreenY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pageX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchPageX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pageY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchPageY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "target", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "identifier", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchIdentifier), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitRadiusX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchWebkitRadiusX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitRadiusY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchWebkitRadiusY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitRotationAngle", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchWebkitRotationAngle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitForce", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchWebkitForce), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSTouchPrototype::s_info = { "TouchPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTouchPrototype) };

void JSTouchPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTouch::info(), JSTouchPrototypeTableValues, *this);
}

const ClassInfo JSTouch::s_info = { "Touch", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTouch) };

JSTouch::JSTouch(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Touch>&& impl)
    : JSDOMWrapper<Touch>(structure, globalObject, WTFMove(impl))
{
}

void JSTouch::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, Touch>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTouch::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTouchPrototype::create(vm, &globalObject, JSTouchPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSTouch::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTouch>(vm, globalObject);
}

JSValue JSTouch::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTouchConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSTouch::destroy(JSC::JSCell* cell)
{
    JSTouch* thisObject = static_cast<JSTouch*>(cell);
    thisObject->JSTouch::~JSTouch();
}

template<> inline JSTouch* IDLAttribute<JSTouch>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSTouch*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsTouchConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTouchPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTouch::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSTouchConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTouchPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsTouchClientXGetter(JSGlobalObject& lexicalGlobalObject, JSTouch& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.clientX());
    return result;
}

EncodedJSValue jsTouchClientX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouch>::get<jsTouchClientXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "clientX");
}

static inline JSValue jsTouchClientYGetter(JSGlobalObject& lexicalGlobalObject, JSTouch& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.clientY());
    return result;
}

EncodedJSValue jsTouchClientY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouch>::get<jsTouchClientYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "clientY");
}

static inline JSValue jsTouchScreenXGetter(JSGlobalObject& lexicalGlobalObject, JSTouch& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.screenX());
    return result;
}

EncodedJSValue jsTouchScreenX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouch>::get<jsTouchScreenXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "screenX");
}

static inline JSValue jsTouchScreenYGetter(JSGlobalObject& lexicalGlobalObject, JSTouch& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.screenY());
    return result;
}

EncodedJSValue jsTouchScreenY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouch>::get<jsTouchScreenYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "screenY");
}

static inline JSValue jsTouchPageXGetter(JSGlobalObject& lexicalGlobalObject, JSTouch& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.pageX());
    return result;
}

EncodedJSValue jsTouchPageX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouch>::get<jsTouchPageXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pageX");
}

static inline JSValue jsTouchPageYGetter(JSGlobalObject& lexicalGlobalObject, JSTouch& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.pageY());
    return result;
}

EncodedJSValue jsTouchPageY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouch>::get<jsTouchPageYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pageY");
}

static inline JSValue jsTouchTargetGetter(JSGlobalObject& lexicalGlobalObject, JSTouch& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<EventTarget>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.target());
    return result;
}

EncodedJSValue jsTouchTarget(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouch>::get<jsTouchTargetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "target");
}

static inline JSValue jsTouchIdentifierGetter(JSGlobalObject& lexicalGlobalObject, JSTouch& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.identifier());
    return result;
}

EncodedJSValue jsTouchIdentifier(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouch>::get<jsTouchIdentifierGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "identifier");
}

static inline JSValue jsTouchWebkitRadiusXGetter(JSGlobalObject& lexicalGlobalObject, JSTouch& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.webkitRadiusX());
    return result;
}

EncodedJSValue jsTouchWebkitRadiusX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouch>::get<jsTouchWebkitRadiusXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitRadiusX");
}

static inline JSValue jsTouchWebkitRadiusYGetter(JSGlobalObject& lexicalGlobalObject, JSTouch& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.webkitRadiusY());
    return result;
}

EncodedJSValue jsTouchWebkitRadiusY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouch>::get<jsTouchWebkitRadiusYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitRadiusY");
}

static inline JSValue jsTouchWebkitRotationAngleGetter(JSGlobalObject& lexicalGlobalObject, JSTouch& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.webkitRotationAngle());
    return result;
}

EncodedJSValue jsTouchWebkitRotationAngle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouch>::get<jsTouchWebkitRotationAngleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitRotationAngle");
}

static inline JSValue jsTouchWebkitForceGetter(JSGlobalObject& lexicalGlobalObject, JSTouch& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.webkitForce());
    return result;
}

EncodedJSValue jsTouchWebkitForce(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouch>::get<jsTouchWebkitForceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitForce");
}

void JSTouch::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTouch*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSTouchOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSTouchOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTouch = static_cast<JSTouch*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTouch->wrapped(), jsTouch);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Touch>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Touch.
    static_assert(!std::is_polymorphic<Touch>::value, "Touch is polymorphic but the IDL claims it is not");
    return createWrapper<Touch>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Touch& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Touch* JSTouch::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTouch*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(TOUCH_EVENTS)
