/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTypeConversions.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

template<> TypeConversions::OtherDictionary convertDictionary<TypeConversions::OtherDictionary>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    TypeConversions::OtherDictionary result;
    JSValue longValueValue;
    if (isNullOrUndefined)
        longValueValue = jsUndefined();
    else {
        longValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "longValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!longValueValue.isUndefined()) {
        result.longValue = convert<IDLLong>(lexicalGlobalObject, longValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.longValue = 0;
    JSValue stringValueValue;
    if (isNullOrUndefined)
        stringValueValue = jsUndefined();
    else {
        stringValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stringValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stringValueValue.isUndefined()) {
        result.stringValue = convert<IDLDOMString>(lexicalGlobalObject, stringValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stringValue = emptyString();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const TypeConversions::OtherDictionary& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto longValueValue = toJS<IDLLong>(dictionary.longValue);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "longValue"), longValueValue);
    auto stringValueValue = toJS<IDLDOMString>(lexicalGlobalObject, dictionary.stringValue);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "stringValue"), stringValueValue);
    return result;
}

template<> TypeConversions::Dictionary convertDictionary<TypeConversions::Dictionary>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    TypeConversions::Dictionary result;
    JSValue clampLongValueValue;
    if (isNullOrUndefined)
        clampLongValueValue = jsUndefined();
    else {
        clampLongValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clampLongValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clampLongValueValue.isUndefined()) {
        result.clampLongValue = convert<IDLClampAdaptor<IDLLong>>(lexicalGlobalObject, clampLongValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.clampLongValue = 0;
    JSValue enforceRangeLongValueValue;
    if (isNullOrUndefined)
        enforceRangeLongValueValue = jsUndefined();
    else {
        enforceRangeLongValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "enforceRangeLongValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!enforceRangeLongValueValue.isUndefined()) {
        result.enforceRangeLongValue = convert<IDLEnforceRangeAdaptor<IDLLong>>(lexicalGlobalObject, enforceRangeLongValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.enforceRangeLongValue = 0;
    JSValue longValueValue;
    if (isNullOrUndefined)
        longValueValue = jsUndefined();
    else {
        longValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "longValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!longValueValue.isUndefined()) {
        result.longValue = convert<IDLLong>(lexicalGlobalObject, longValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.longValue = 0;
    JSValue sequenceValueValue;
    if (isNullOrUndefined)
        sequenceValueValue = jsUndefined();
    else {
        sequenceValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sequenceValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sequenceValueValue.isUndefined()) {
        result.sequenceValue = convert<IDLSequence<IDLDOMString>>(lexicalGlobalObject, sequenceValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sequenceValue = Converter<IDLSequence<IDLDOMString>>::ReturnType{ };
    JSValue stringValueValue;
    if (isNullOrUndefined)
        stringValueValue = jsUndefined();
    else {
        stringValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stringValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stringValueValue.isUndefined()) {
        result.stringValue = convert<IDLDOMString>(lexicalGlobalObject, stringValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stringValue = emptyString();
    JSValue treatNullAsEmptyStringValueValue;
    if (isNullOrUndefined)
        treatNullAsEmptyStringValueValue = jsUndefined();
    else {
        treatNullAsEmptyStringValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "treatNullAsEmptyStringValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!treatNullAsEmptyStringValueValue.isUndefined()) {
        result.treatNullAsEmptyStringValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, treatNullAsEmptyStringValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.treatNullAsEmptyStringValue = emptyString();
    JSValue unionValueValue;
    if (isNullOrUndefined)
        unionValueValue = jsUndefined();
    else {
        unionValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "unionValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!unionValueValue.isUndefined()) {
        result.unionValue = convert<IDLUnion<IDLInterface<Node>, IDLSequence<IDLDOMString>, IDLDictionary<TypeConversions::OtherDictionary>>>(lexicalGlobalObject, unionValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.unionValue = convert<IDLUnion<IDLInterface<Node>, IDLSequence<IDLDOMString>, IDLDictionary<TypeConversions::OtherDictionary>>>(lexicalGlobalObject, jsNull());;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const TypeConversions::Dictionary& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto clampLongValueValue = toJS<IDLClampAdaptor<IDLLong>>(dictionary.clampLongValue);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "clampLongValue"), clampLongValueValue);
    auto enforceRangeLongValueValue = toJS<IDLEnforceRangeAdaptor<IDLLong>>(dictionary.enforceRangeLongValue);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "enforceRangeLongValue"), enforceRangeLongValueValue);
    auto longValueValue = toJS<IDLLong>(dictionary.longValue);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "longValue"), longValueValue);
    auto sequenceValueValue = toJS<IDLSequence<IDLDOMString>>(lexicalGlobalObject, globalObject, dictionary.sequenceValue);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "sequenceValue"), sequenceValueValue);
    auto stringValueValue = toJS<IDLDOMString>(lexicalGlobalObject, dictionary.stringValue);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "stringValue"), stringValueValue);
    auto treatNullAsEmptyStringValueValue = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, dictionary.treatNullAsEmptyStringValue);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "treatNullAsEmptyStringValue"), treatNullAsEmptyStringValueValue);
    auto unionValueValue = toJS<IDLUnion<IDLInterface<Node>, IDLSequence<IDLDOMString>, IDLDictionary<TypeConversions::OtherDictionary>>>(lexicalGlobalObject, globalObject, dictionary.unionValue);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "unionValue"), unionValueValue);
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTypeConversionsPrototypeFunctionSetTestLongRecord(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsTypeConversionsPrototypeFunctionTestLongRecord(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsTypeConversionsPrototypeFunctionSetTestNodeRecord(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsTypeConversionsPrototypeFunctionTestNodeRecord(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsTypeConversionsPrototypeFunctionSetTestSequenceRecord(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsTypeConversionsPrototypeFunctionTestSequenceRecord(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsTypeConversionsTestByte(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestByte(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestEnforceRangeByte(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestEnforceRangeByte(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestClampByte(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestClampByte(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestOctet(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestOctet(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestEnforceRangeOctet(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestEnforceRangeOctet(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestClampOctet(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestClampOctet(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestEnforceRangeShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestEnforceRangeShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestClampShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestClampShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestUnsignedShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestUnsignedShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestEnforceRangeUnsignedShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestEnforceRangeUnsignedShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestClampUnsignedShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestClampUnsignedShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestEnforceRangeLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestEnforceRangeLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestClampLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestClampLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestUnsignedLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestUnsignedLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestEnforceRangeUnsignedLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestEnforceRangeUnsignedLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestClampUnsignedLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestClampUnsignedLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestLongLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestLongLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestEnforceRangeLongLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestEnforceRangeLongLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestClampLongLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestClampLongLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestUnsignedLongLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestUnsignedLongLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestEnforceRangeUnsignedLongLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestEnforceRangeUnsignedLongLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestClampUnsignedLongLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestClampUnsignedLongLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestImpureNaNUnrestrictedDouble(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTypeConversionsTestImpureNaN2UnrestrictedDouble(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTypeConversionsTestQuietNaNUnrestrictedDouble(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTypeConversionsTestPureNaNUnrestrictedDouble(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTypeConversionsTestString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestByteString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestByteString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestUSVString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestUSVString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestTreatNullAsEmptyString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestTreatNullAsEmptyString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestUnion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestUnion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestDictionary(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestDictionary(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestClampUnion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestClampUnion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestEnforceRangeUnion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestEnforceRangeUnion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypeConversionsTestTreatNullAsEmptyStringUnion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypeConversionsTestTreatNullAsEmptyStringUnion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTypeConversionsPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTypeConversionsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTypeConversionsPrototype* ptr = new (NotNull, JSC::allocateCell<JSTypeConversionsPrototype>(vm.heap)) JSTypeConversionsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTypeConversionsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTypeConversionsPrototype, JSTypeConversionsPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSTypeConversionsPrototypeTableValues[] =
{
    { "testByte", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestByte), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestByte) } },
    { "testEnforceRangeByte", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeByte), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestEnforceRangeByte) } },
    { "testClampByte", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestClampByte), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestClampByte) } },
    { "testOctet", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestOctet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestOctet) } },
    { "testEnforceRangeOctet", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeOctet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestEnforceRangeOctet) } },
    { "testClampOctet", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestClampOctet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestClampOctet) } },
    { "testShort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestShort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestShort) } },
    { "testEnforceRangeShort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeShort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestEnforceRangeShort) } },
    { "testClampShort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestClampShort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestClampShort) } },
    { "testUnsignedShort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestUnsignedShort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestUnsignedShort) } },
    { "testEnforceRangeUnsignedShort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeUnsignedShort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestEnforceRangeUnsignedShort) } },
    { "testClampUnsignedShort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestClampUnsignedShort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestClampUnsignedShort) } },
    { "testLong", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestLong) } },
    { "testEnforceRangeLong", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestEnforceRangeLong) } },
    { "testClampLong", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestClampLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestClampLong) } },
    { "testUnsignedLong", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestUnsignedLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestUnsignedLong) } },
    { "testEnforceRangeUnsignedLong", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeUnsignedLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestEnforceRangeUnsignedLong) } },
    { "testClampUnsignedLong", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestClampUnsignedLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestClampUnsignedLong) } },
    { "testLongLong", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestLongLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestLongLong) } },
    { "testEnforceRangeLongLong", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeLongLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestEnforceRangeLongLong) } },
    { "testClampLongLong", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestClampLongLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestClampLongLong) } },
    { "testUnsignedLongLong", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestUnsignedLongLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestUnsignedLongLong) } },
    { "testEnforceRangeUnsignedLongLong", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeUnsignedLongLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestEnforceRangeUnsignedLongLong) } },
    { "testClampUnsignedLongLong", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestClampUnsignedLongLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestClampUnsignedLongLong) } },
    { "testImpureNaNUnrestrictedDouble", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestImpureNaNUnrestrictedDouble), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "testImpureNaN2UnrestrictedDouble", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestImpureNaN2UnrestrictedDouble), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "testQuietNaNUnrestrictedDouble", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestQuietNaNUnrestrictedDouble), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "testPureNaNUnrestrictedDouble", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestPureNaNUnrestrictedDouble), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "testString", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestString) } },
    { "testByteString", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestByteString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestByteString) } },
    { "testUSVString", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestUSVString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestUSVString) } },
    { "testTreatNullAsEmptyString", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestTreatNullAsEmptyString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestTreatNullAsEmptyString) } },
    { "testUnion", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestUnion), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestUnion) } },
    { "testDictionary", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestDictionary), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestDictionary) } },
    { "testClampUnion", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestClampUnion), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestClampUnion) } },
    { "testEnforceRangeUnion", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeUnion), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestEnforceRangeUnion) } },
    { "testTreatNullAsEmptyStringUnion", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestTreatNullAsEmptyStringUnion), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypeConversionsTestTreatNullAsEmptyStringUnion) } },
    { "setTestLongRecord", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsTypeConversionsPrototypeFunctionSetTestLongRecord), (intptr_t) (1) } },
    { "testLongRecord", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsTypeConversionsPrototypeFunctionTestLongRecord), (intptr_t) (0) } },
    { "setTestNodeRecord", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsTypeConversionsPrototypeFunctionSetTestNodeRecord), (intptr_t) (1) } },
    { "testNodeRecord", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsTypeConversionsPrototypeFunctionTestNodeRecord), (intptr_t) (0) } },
    { "setTestSequenceRecord", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsTypeConversionsPrototypeFunctionSetTestSequenceRecord), (intptr_t) (1) } },
    { "testSequenceRecord", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsTypeConversionsPrototypeFunctionTestSequenceRecord), (intptr_t) (0) } },
};

const ClassInfo JSTypeConversionsPrototype::s_info = { "TypeConversionsPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypeConversionsPrototype) };

void JSTypeConversionsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTypeConversions::info(), JSTypeConversionsPrototypeTableValues, *this);
}

const ClassInfo JSTypeConversions::s_info = { "TypeConversions", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypeConversions) };

JSTypeConversions::JSTypeConversions(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TypeConversions>&& impl)
    : JSDOMWrapper<TypeConversions>(structure, globalObject, WTFMove(impl))
{
}

void JSTypeConversions::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, TypeConversions>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTypeConversions::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTypeConversionsPrototype::create(vm, &globalObject, JSTypeConversionsPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSTypeConversions::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTypeConversions>(vm, globalObject);
}

void JSTypeConversions::destroy(JSC::JSCell* cell)
{
    JSTypeConversions* thisObject = static_cast<JSTypeConversions*>(cell);
    thisObject->JSTypeConversions::~JSTypeConversions();
}

template<> inline JSTypeConversions* IDLAttribute<JSTypeConversions>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSTypeConversions*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSTypeConversions* IDLOperation<JSTypeConversions>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSTypeConversions*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSValue jsTypeConversionsTestByteGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLByte>(lexicalGlobalObject, throwScope, impl.testByte());
    return result;
}

EncodedJSValue jsTypeConversionsTestByte(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestByteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testByte");
}

static inline bool setJSTypeConversionsTestByteSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLByte>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestByte(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestByte(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestByteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testByte");
}

static inline JSValue jsTypeConversionsTestEnforceRangeByteGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnforceRangeAdaptor<IDLByte>>(lexicalGlobalObject, throwScope, impl.testEnforceRangeByte());
    return result;
}

EncodedJSValue jsTypeConversionsTestEnforceRangeByte(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestEnforceRangeByteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testEnforceRangeByte");
}

static inline bool setJSTypeConversionsTestEnforceRangeByteSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLEnforceRangeAdaptor<IDLByte>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestEnforceRangeByte(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestEnforceRangeByte(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestEnforceRangeByteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testEnforceRangeByte");
}

static inline JSValue jsTypeConversionsTestClampByteGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLClampAdaptor<IDLByte>>(lexicalGlobalObject, throwScope, impl.testClampByte());
    return result;
}

EncodedJSValue jsTypeConversionsTestClampByte(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestClampByteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testClampByte");
}

static inline bool setJSTypeConversionsTestClampByteSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLClampAdaptor<IDLByte>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestClampByte(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestClampByte(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestClampByteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testClampByte");
}

static inline JSValue jsTypeConversionsTestOctetGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLOctet>(lexicalGlobalObject, throwScope, impl.testOctet());
    return result;
}

EncodedJSValue jsTypeConversionsTestOctet(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestOctetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testOctet");
}

static inline bool setJSTypeConversionsTestOctetSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLOctet>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestOctet(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestOctet(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestOctetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testOctet");
}

static inline JSValue jsTypeConversionsTestEnforceRangeOctetGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnforceRangeAdaptor<IDLOctet>>(lexicalGlobalObject, throwScope, impl.testEnforceRangeOctet());
    return result;
}

EncodedJSValue jsTypeConversionsTestEnforceRangeOctet(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestEnforceRangeOctetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testEnforceRangeOctet");
}

static inline bool setJSTypeConversionsTestEnforceRangeOctetSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLEnforceRangeAdaptor<IDLOctet>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestEnforceRangeOctet(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestEnforceRangeOctet(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestEnforceRangeOctetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testEnforceRangeOctet");
}

static inline JSValue jsTypeConversionsTestClampOctetGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLClampAdaptor<IDLOctet>>(lexicalGlobalObject, throwScope, impl.testClampOctet());
    return result;
}

EncodedJSValue jsTypeConversionsTestClampOctet(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestClampOctetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testClampOctet");
}

static inline bool setJSTypeConversionsTestClampOctetSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLClampAdaptor<IDLOctet>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestClampOctet(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestClampOctet(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestClampOctetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testClampOctet");
}

static inline JSValue jsTypeConversionsTestShortGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLShort>(lexicalGlobalObject, throwScope, impl.testShort());
    return result;
}

EncodedJSValue jsTypeConversionsTestShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestShortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testShort");
}

static inline bool setJSTypeConversionsTestShortSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLShort>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestShort(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestShortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testShort");
}

static inline JSValue jsTypeConversionsTestEnforceRangeShortGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnforceRangeAdaptor<IDLShort>>(lexicalGlobalObject, throwScope, impl.testEnforceRangeShort());
    return result;
}

EncodedJSValue jsTypeConversionsTestEnforceRangeShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestEnforceRangeShortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testEnforceRangeShort");
}

static inline bool setJSTypeConversionsTestEnforceRangeShortSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLEnforceRangeAdaptor<IDLShort>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestEnforceRangeShort(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestEnforceRangeShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestEnforceRangeShortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testEnforceRangeShort");
}

static inline JSValue jsTypeConversionsTestClampShortGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLClampAdaptor<IDLShort>>(lexicalGlobalObject, throwScope, impl.testClampShort());
    return result;
}

EncodedJSValue jsTypeConversionsTestClampShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestClampShortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testClampShort");
}

static inline bool setJSTypeConversionsTestClampShortSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLClampAdaptor<IDLShort>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestClampShort(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestClampShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestClampShortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testClampShort");
}

static inline JSValue jsTypeConversionsTestUnsignedShortGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.testUnsignedShort());
    return result;
}

EncodedJSValue jsTypeConversionsTestUnsignedShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestUnsignedShortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testUnsignedShort");
}

static inline bool setJSTypeConversionsTestUnsignedShortSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedShort>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestUnsignedShort(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestUnsignedShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestUnsignedShortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testUnsignedShort");
}

static inline JSValue jsTypeConversionsTestEnforceRangeUnsignedShortGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnforceRangeAdaptor<IDLUnsignedShort>>(lexicalGlobalObject, throwScope, impl.testEnforceRangeUnsignedShort());
    return result;
}

EncodedJSValue jsTypeConversionsTestEnforceRangeUnsignedShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestEnforceRangeUnsignedShortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testEnforceRangeUnsignedShort");
}

static inline bool setJSTypeConversionsTestEnforceRangeUnsignedShortSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLEnforceRangeAdaptor<IDLUnsignedShort>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestEnforceRangeUnsignedShort(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestEnforceRangeUnsignedShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestEnforceRangeUnsignedShortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testEnforceRangeUnsignedShort");
}

static inline JSValue jsTypeConversionsTestClampUnsignedShortGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLClampAdaptor<IDLUnsignedShort>>(lexicalGlobalObject, throwScope, impl.testClampUnsignedShort());
    return result;
}

EncodedJSValue jsTypeConversionsTestClampUnsignedShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestClampUnsignedShortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testClampUnsignedShort");
}

static inline bool setJSTypeConversionsTestClampUnsignedShortSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLClampAdaptor<IDLUnsignedShort>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestClampUnsignedShort(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestClampUnsignedShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestClampUnsignedShortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testClampUnsignedShort");
}

static inline JSValue jsTypeConversionsTestLongGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.testLong());
    return result;
}

EncodedJSValue jsTypeConversionsTestLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testLong");
}

static inline bool setJSTypeConversionsTestLongSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestLong(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestLongSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testLong");
}

static inline JSValue jsTypeConversionsTestEnforceRangeLongGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnforceRangeAdaptor<IDLLong>>(lexicalGlobalObject, throwScope, impl.testEnforceRangeLong());
    return result;
}

EncodedJSValue jsTypeConversionsTestEnforceRangeLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestEnforceRangeLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testEnforceRangeLong");
}

static inline bool setJSTypeConversionsTestEnforceRangeLongSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLEnforceRangeAdaptor<IDLLong>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestEnforceRangeLong(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestEnforceRangeLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestEnforceRangeLongSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testEnforceRangeLong");
}

static inline JSValue jsTypeConversionsTestClampLongGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLClampAdaptor<IDLLong>>(lexicalGlobalObject, throwScope, impl.testClampLong());
    return result;
}

EncodedJSValue jsTypeConversionsTestClampLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestClampLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testClampLong");
}

static inline bool setJSTypeConversionsTestClampLongSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLClampAdaptor<IDLLong>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestClampLong(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestClampLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestClampLongSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testClampLong");
}

static inline JSValue jsTypeConversionsTestUnsignedLongGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.testUnsignedLong());
    return result;
}

EncodedJSValue jsTypeConversionsTestUnsignedLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestUnsignedLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testUnsignedLong");
}

static inline bool setJSTypeConversionsTestUnsignedLongSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestUnsignedLong(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestUnsignedLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestUnsignedLongSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testUnsignedLong");
}

static inline JSValue jsTypeConversionsTestEnforceRangeUnsignedLongGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, impl.testEnforceRangeUnsignedLong());
    return result;
}

EncodedJSValue jsTypeConversionsTestEnforceRangeUnsignedLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestEnforceRangeUnsignedLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testEnforceRangeUnsignedLong");
}

static inline bool setJSTypeConversionsTestEnforceRangeUnsignedLongSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestEnforceRangeUnsignedLong(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestEnforceRangeUnsignedLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestEnforceRangeUnsignedLongSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testEnforceRangeUnsignedLong");
}

static inline JSValue jsTypeConversionsTestClampUnsignedLongGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLClampAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, impl.testClampUnsignedLong());
    return result;
}

EncodedJSValue jsTypeConversionsTestClampUnsignedLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestClampUnsignedLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testClampUnsignedLong");
}

static inline bool setJSTypeConversionsTestClampUnsignedLongSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLClampAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestClampUnsignedLong(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestClampUnsignedLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestClampUnsignedLongSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testClampUnsignedLong");
}

static inline JSValue jsTypeConversionsTestLongLongGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLongLong>(lexicalGlobalObject, throwScope, impl.testLongLong());
    return result;
}

EncodedJSValue jsTypeConversionsTestLongLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestLongLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testLongLong");
}

static inline bool setJSTypeConversionsTestLongLongSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLongLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestLongLong(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestLongLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestLongLongSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testLongLong");
}

static inline JSValue jsTypeConversionsTestEnforceRangeLongLongGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnforceRangeAdaptor<IDLLongLong>>(lexicalGlobalObject, throwScope, impl.testEnforceRangeLongLong());
    return result;
}

EncodedJSValue jsTypeConversionsTestEnforceRangeLongLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestEnforceRangeLongLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testEnforceRangeLongLong");
}

static inline bool setJSTypeConversionsTestEnforceRangeLongLongSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLEnforceRangeAdaptor<IDLLongLong>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestEnforceRangeLongLong(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestEnforceRangeLongLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestEnforceRangeLongLongSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testEnforceRangeLongLong");
}

static inline JSValue jsTypeConversionsTestClampLongLongGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLClampAdaptor<IDLLongLong>>(lexicalGlobalObject, throwScope, impl.testClampLongLong());
    return result;
}

EncodedJSValue jsTypeConversionsTestClampLongLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestClampLongLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testClampLongLong");
}

static inline bool setJSTypeConversionsTestClampLongLongSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLClampAdaptor<IDLLongLong>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestClampLongLong(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestClampLongLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestClampLongLongSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testClampLongLong");
}

static inline JSValue jsTypeConversionsTestUnsignedLongLongGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.testUnsignedLongLong());
    return result;
}

EncodedJSValue jsTypeConversionsTestUnsignedLongLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestUnsignedLongLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testUnsignedLongLong");
}

static inline bool setJSTypeConversionsTestUnsignedLongLongSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLongLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestUnsignedLongLong(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestUnsignedLongLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestUnsignedLongLongSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testUnsignedLongLong");
}

static inline JSValue jsTypeConversionsTestEnforceRangeUnsignedLongLongGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, impl.testEnforceRangeUnsignedLongLong());
    return result;
}

EncodedJSValue jsTypeConversionsTestEnforceRangeUnsignedLongLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestEnforceRangeUnsignedLongLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testEnforceRangeUnsignedLongLong");
}

static inline bool setJSTypeConversionsTestEnforceRangeUnsignedLongLongSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestEnforceRangeUnsignedLongLong(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestEnforceRangeUnsignedLongLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestEnforceRangeUnsignedLongLongSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testEnforceRangeUnsignedLongLong");
}

static inline JSValue jsTypeConversionsTestClampUnsignedLongLongGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLClampAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, impl.testClampUnsignedLongLong());
    return result;
}

EncodedJSValue jsTypeConversionsTestClampUnsignedLongLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestClampUnsignedLongLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testClampUnsignedLongLong");
}

static inline bool setJSTypeConversionsTestClampUnsignedLongLongSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLClampAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestClampUnsignedLongLong(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestClampUnsignedLongLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestClampUnsignedLongLongSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testClampUnsignedLongLong");
}

static inline JSValue jsTypeConversionsTestImpureNaNUnrestrictedDoubleGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.testImpureNaNUnrestrictedDouble());
    return result;
}

EncodedJSValue jsTypeConversionsTestImpureNaNUnrestrictedDouble(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestImpureNaNUnrestrictedDoubleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testImpureNaNUnrestrictedDouble");
}

static inline JSValue jsTypeConversionsTestImpureNaN2UnrestrictedDoubleGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.testImpureNaN2UnrestrictedDouble());
    return result;
}

EncodedJSValue jsTypeConversionsTestImpureNaN2UnrestrictedDouble(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestImpureNaN2UnrestrictedDoubleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testImpureNaN2UnrestrictedDouble");
}

static inline JSValue jsTypeConversionsTestQuietNaNUnrestrictedDoubleGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.testQuietNaNUnrestrictedDouble());
    return result;
}

EncodedJSValue jsTypeConversionsTestQuietNaNUnrestrictedDouble(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestQuietNaNUnrestrictedDoubleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testQuietNaNUnrestrictedDouble");
}

static inline JSValue jsTypeConversionsTestPureNaNUnrestrictedDoubleGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.testPureNaNUnrestrictedDouble());
    return result;
}

EncodedJSValue jsTypeConversionsTestPureNaNUnrestrictedDouble(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestPureNaNUnrestrictedDoubleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testPureNaNUnrestrictedDouble");
}

static inline JSValue jsTypeConversionsTestStringGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.testString());
    return result;
}

EncodedJSValue jsTypeConversionsTestString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testString");
}

static inline bool setJSTypeConversionsTestStringSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestString(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestStringSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testString");
}

static inline JSValue jsTypeConversionsTestByteStringGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLByteString>(lexicalGlobalObject, throwScope, impl.testByteString());
    return result;
}

EncodedJSValue jsTypeConversionsTestByteString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestByteStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testByteString");
}

static inline bool setJSTypeConversionsTestByteStringSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLByteString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestByteString(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestByteString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestByteStringSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testByteString");
}

static inline JSValue jsTypeConversionsTestUSVStringGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.testUSVString());
    return result;
}

EncodedJSValue jsTypeConversionsTestUSVString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestUSVStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testUSVString");
}

static inline bool setJSTypeConversionsTestUSVStringSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestUSVString(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestUSVString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestUSVStringSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testUSVString");
}

static inline JSValue jsTypeConversionsTestTreatNullAsEmptyStringGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.testTreatNullAsEmptyString());
    return result;
}

EncodedJSValue jsTypeConversionsTestTreatNullAsEmptyString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestTreatNullAsEmptyStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testTreatNullAsEmptyString");
}

static inline bool setJSTypeConversionsTestTreatNullAsEmptyStringSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestTreatNullAsEmptyString(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestTreatNullAsEmptyString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestTreatNullAsEmptyStringSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testTreatNullAsEmptyString");
}

static inline JSValue jsTypeConversionsTestUnionGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnion<IDLDOMString, IDLLong, IDLBoolean, IDLInterface<Node>, IDLSequence<IDLLong>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.testUnion());
    return result;
}

EncodedJSValue jsTypeConversionsTestUnion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestUnionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testUnion");
}

static inline bool setJSTypeConversionsTestUnionSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDOMString, IDLLong, IDLBoolean, IDLInterface<Node>, IDLSequence<IDLLong>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestUnion(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestUnion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestUnionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testUnion");
}

static inline JSValue jsTypeConversionsTestDictionaryGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDictionary<TypeConversions::Dictionary>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.testDictionary());
    return result;
}

EncodedJSValue jsTypeConversionsTestDictionary(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestDictionaryGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testDictionary");
}

static inline bool setJSTypeConversionsTestDictionarySetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDictionary<TypeConversions::Dictionary>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestDictionary(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestDictionary(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestDictionarySetter>(*lexicalGlobalObject, thisValue, encodedValue, "testDictionary");
}

static inline JSValue jsTypeConversionsTestClampUnionGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnion<IDLDOMString, IDLClampAdaptor<IDLLong>, IDLSequence<IDLClampAdaptor<IDLLong>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.testClampUnion());
    return result;
}

EncodedJSValue jsTypeConversionsTestClampUnion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestClampUnionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testClampUnion");
}

static inline bool setJSTypeConversionsTestClampUnionSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDOMString, IDLClampAdaptor<IDLLong>, IDLSequence<IDLClampAdaptor<IDLLong>>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestClampUnion(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestClampUnion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestClampUnionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testClampUnion");
}

static inline JSValue jsTypeConversionsTestEnforceRangeUnionGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnion<IDLDOMString, IDLEnforceRangeAdaptor<IDLLong>, IDLSequence<IDLEnforceRangeAdaptor<IDLLong>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.testEnforceRangeUnion());
    return result;
}

EncodedJSValue jsTypeConversionsTestEnforceRangeUnion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestEnforceRangeUnionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testEnforceRangeUnion");
}

static inline bool setJSTypeConversionsTestEnforceRangeUnionSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDOMString, IDLEnforceRangeAdaptor<IDLLong>, IDLSequence<IDLEnforceRangeAdaptor<IDLLong>>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestEnforceRangeUnion(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestEnforceRangeUnion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestEnforceRangeUnionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testEnforceRangeUnion");
}

static inline JSValue jsTypeConversionsTestTreatNullAsEmptyStringUnionGetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnion<IDLTreatNullAsEmptyAdaptor<IDLDOMString>, IDLLong, IDLSequence<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.testTreatNullAsEmptyStringUnion());
    return result;
}

EncodedJSValue jsTypeConversionsTestTreatNullAsEmptyStringUnion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypeConversions>::get<jsTypeConversionsTestTreatNullAsEmptyStringUnionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "testTreatNullAsEmptyStringUnion");
}

static inline bool setJSTypeConversionsTestTreatNullAsEmptyStringUnionSetter(JSGlobalObject& lexicalGlobalObject, JSTypeConversions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLTreatNullAsEmptyAdaptor<IDLDOMString>, IDLLong, IDLSequence<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTestTreatNullAsEmptyStringUnion(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypeConversionsTestTreatNullAsEmptyStringUnion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypeConversions>::set<setJSTypeConversionsTestTreatNullAsEmptyStringUnionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "testTreatNullAsEmptyStringUnion");
}

static inline JSC::EncodedJSValue jsTypeConversionsPrototypeFunctionSetTestLongRecordBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTypeConversions>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto record = convert<IDLRecord<IDLDOMString, IDLLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setTestLongRecord(WTFMove(record));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTypeConversionsPrototypeFunctionSetTestLongRecord(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSTypeConversions>::call<jsTypeConversionsPrototypeFunctionSetTestLongRecordBody>(*lexicalGlobalObject, *callFrame, "setTestLongRecord");
}

static inline JSC::EncodedJSValue jsTypeConversionsPrototypeFunctionTestLongRecordBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTypeConversions>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLRecord<IDLDOMString, IDLLong>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.testLongRecord()));
}

EncodedJSValue JSC_HOST_CALL jsTypeConversionsPrototypeFunctionTestLongRecord(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSTypeConversions>::call<jsTypeConversionsPrototypeFunctionTestLongRecordBody>(*lexicalGlobalObject, *callFrame, "testLongRecord");
}

static inline JSC::EncodedJSValue jsTypeConversionsPrototypeFunctionSetTestNodeRecordBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTypeConversions>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto record = convert<IDLRecord<IDLUSVString, IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setTestNodeRecord(WTFMove(record));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTypeConversionsPrototypeFunctionSetTestNodeRecord(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSTypeConversions>::call<jsTypeConversionsPrototypeFunctionSetTestNodeRecordBody>(*lexicalGlobalObject, *callFrame, "setTestNodeRecord");
}

static inline JSC::EncodedJSValue jsTypeConversionsPrototypeFunctionTestNodeRecordBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTypeConversions>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLRecord<IDLUSVString, IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.testNodeRecord()));
}

EncodedJSValue JSC_HOST_CALL jsTypeConversionsPrototypeFunctionTestNodeRecord(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSTypeConversions>::call<jsTypeConversionsPrototypeFunctionTestNodeRecordBody>(*lexicalGlobalObject, *callFrame, "testNodeRecord");
}

static inline JSC::EncodedJSValue jsTypeConversionsPrototypeFunctionSetTestSequenceRecordBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTypeConversions>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto record = convert<IDLRecord<IDLByteString, IDLSequence<IDLDOMString>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setTestSequenceRecord(WTFMove(record));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTypeConversionsPrototypeFunctionSetTestSequenceRecord(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSTypeConversions>::call<jsTypeConversionsPrototypeFunctionSetTestSequenceRecordBody>(*lexicalGlobalObject, *callFrame, "setTestSequenceRecord");
}

static inline JSC::EncodedJSValue jsTypeConversionsPrototypeFunctionTestSequenceRecordBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTypeConversions>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLRecord<IDLByteString, IDLSequence<IDLDOMString>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.testSequenceRecord()));
}

EncodedJSValue JSC_HOST_CALL jsTypeConversionsPrototypeFunctionTestSequenceRecord(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSTypeConversions>::call<jsTypeConversionsPrototypeFunctionTestSequenceRecordBody>(*lexicalGlobalObject, *callFrame, "testSequenceRecord");
}

void JSTypeConversions::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTypeConversions*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSTypeConversionsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSTypeConversionsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTypeConversions = static_cast<JSTypeConversions*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTypeConversions->wrapped(), jsTypeConversions);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TypeConversions>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TypeConversions.
    static_assert(!std::is_polymorphic<TypeConversions>::value, "TypeConversions is polymorphic but the IDL claims it is not");
    return createWrapper<TypeConversions>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TypeConversions& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

TypeConversions* JSTypeConversions::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTypeConversions*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
