/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CSS_TYPED_OM)

#include "JSTypedOMCSSNumericValue.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsTypedOMCSSNumericValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypedOMCSSNumericValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTypedOMCSSNumericValuePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTypedOMCSSNumericValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTypedOMCSSNumericValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSTypedOMCSSNumericValuePrototype>(vm.heap)) JSTypedOMCSSNumericValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTypedOMCSSNumericValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTypedOMCSSNumericValuePrototype, JSTypedOMCSSNumericValuePrototype::Base);

using JSTypedOMCSSNumericValueConstructor = JSDOMConstructorNotConstructable<JSTypedOMCSSNumericValue>;

template<> JSValue JSTypedOMCSSNumericValueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSTypedOMCSSStyleValue::getConstructor(vm, &globalObject);
}

template<> void JSTypedOMCSSNumericValueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTypedOMCSSNumericValue::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CSSNumericValue"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSTypedOMCSSNumericValueConstructor::s_info = { "CSSNumericValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSNumericValueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTypedOMCSSNumericValuePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypedOMCSSNumericValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypedOMCSSNumericValueConstructor) } },
};

const ClassInfo JSTypedOMCSSNumericValuePrototype::s_info = { "CSSNumericValuePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSNumericValuePrototype) };

void JSTypedOMCSSNumericValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTypedOMCSSNumericValue::info(), JSTypedOMCSSNumericValuePrototypeTableValues, *this);
}

const ClassInfo JSTypedOMCSSNumericValue::s_info = { "CSSNumericValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSNumericValue) };

JSTypedOMCSSNumericValue::JSTypedOMCSSNumericValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TypedOMCSSNumericValue>&& impl)
    : JSTypedOMCSSStyleValue(structure, globalObject, WTFMove(impl))
{
}

void JSTypedOMCSSNumericValue::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, TypedOMCSSNumericValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTypedOMCSSNumericValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTypedOMCSSNumericValuePrototype::create(vm, &globalObject, JSTypedOMCSSNumericValuePrototype::createStructure(vm, &globalObject, JSTypedOMCSSStyleValue::prototype(vm, globalObject)));
}

JSObject* JSTypedOMCSSNumericValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTypedOMCSSNumericValue>(vm, globalObject);
}

JSValue JSTypedOMCSSNumericValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTypedOMCSSNumericValueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue jsTypedOMCSSNumericValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTypedOMCSSNumericValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTypedOMCSSNumericValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSTypedOMCSSNumericValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTypedOMCSSNumericValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSTypedOMCSSNumericValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTypedOMCSSNumericValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}

#endif // ENABLE(CSS_TYPED_OM)
