/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CSS_TYPED_OM)

#include "JSTypedOMCSSUnitValue.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsTypedOMCSSUnitValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypedOMCSSUnitValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypedOMCSSUnitValueValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypedOMCSSUnitValueValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTypedOMCSSUnitValueUnit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSTypedOMCSSUnitValuePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTypedOMCSSUnitValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTypedOMCSSUnitValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSTypedOMCSSUnitValuePrototype>(vm.heap)) JSTypedOMCSSUnitValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTypedOMCSSUnitValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTypedOMCSSUnitValuePrototype, JSTypedOMCSSUnitValuePrototype::Base);

using JSTypedOMCSSUnitValueConstructor = JSDOMConstructor<JSTypedOMCSSUnitValue>;

template<> EncodedJSValue JSC_HOST_CALL JSTypedOMCSSUnitValueConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSTypedOMCSSUnitValueConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto value = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto unit = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = TypedOMCSSUnitValue::create(WTFMove(value), WTFMove(unit));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<TypedOMCSSUnitValue>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSTypedOMCSSUnitValueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSTypedOMCSSNumericValue::getConstructor(vm, &globalObject);
}

template<> void JSTypedOMCSSUnitValueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTypedOMCSSUnitValue::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CSSUnitValue"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSTypedOMCSSUnitValueConstructor::s_info = { "CSSUnitValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSUnitValueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTypedOMCSSUnitValuePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypedOMCSSUnitValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypedOMCSSUnitValueConstructor) } },
    { "value", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypedOMCSSUnitValueValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypedOMCSSUnitValueValue) } },
    { "unit", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypedOMCSSUnitValueUnit), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSTypedOMCSSUnitValuePrototype::s_info = { "CSSUnitValuePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSUnitValuePrototype) };

void JSTypedOMCSSUnitValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTypedOMCSSUnitValue::info(), JSTypedOMCSSUnitValuePrototypeTableValues, *this);
}

const ClassInfo JSTypedOMCSSUnitValue::s_info = { "CSSUnitValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSUnitValue) };

JSTypedOMCSSUnitValue::JSTypedOMCSSUnitValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TypedOMCSSUnitValue>&& impl)
    : JSTypedOMCSSNumericValue(structure, globalObject, WTFMove(impl))
{
}

void JSTypedOMCSSUnitValue::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, TypedOMCSSUnitValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTypedOMCSSUnitValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTypedOMCSSUnitValuePrototype::create(vm, &globalObject, JSTypedOMCSSUnitValuePrototype::createStructure(vm, &globalObject, JSTypedOMCSSNumericValue::prototype(vm, globalObject)));
}

JSObject* JSTypedOMCSSUnitValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTypedOMCSSUnitValue>(vm, globalObject);
}

JSValue JSTypedOMCSSUnitValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTypedOMCSSUnitValueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSTypedOMCSSUnitValue* IDLAttribute<JSTypedOMCSSUnitValue>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSTypedOMCSSUnitValue*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsTypedOMCSSUnitValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTypedOMCSSUnitValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTypedOMCSSUnitValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSTypedOMCSSUnitValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTypedOMCSSUnitValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsTypedOMCSSUnitValueValueGetter(JSGlobalObject& lexicalGlobalObject, JSTypedOMCSSUnitValue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.value());
    return result;
}

EncodedJSValue jsTypedOMCSSUnitValueValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypedOMCSSUnitValue>::get<jsTypedOMCSSUnitValueValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "value");
}

static inline bool setJSTypedOMCSSUnitValueValueSetter(JSGlobalObject& lexicalGlobalObject, JSTypedOMCSSUnitValue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setValue(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTypedOMCSSUnitValueValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTypedOMCSSUnitValue>::set<setJSTypedOMCSSUnitValueValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, "value");
}

static inline JSValue jsTypedOMCSSUnitValueUnitGetter(JSGlobalObject& lexicalGlobalObject, JSTypedOMCSSUnitValue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.unit());
    return result;
}

EncodedJSValue jsTypedOMCSSUnitValueUnit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTypedOMCSSUnitValue>::get<jsTypedOMCSSUnitValueUnitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "unit");
}

void JSTypedOMCSSUnitValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTypedOMCSSUnitValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TypedOMCSSUnitValue@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19TypedOMCSSUnitValueE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TypedOMCSSUnitValue>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7TypedOMCSSUnitValue@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore19TypedOMCSSUnitValueE[2];
#endif

    // If this fails TypedOMCSSUnitValue does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<TypedOMCSSUnitValue>::value, "TypedOMCSSUnitValue is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // TypedOMCSSUnitValue has subclasses. If TypedOMCSSUnitValue has subclasses that get passed
    // to toJS() we currently require TypedOMCSSUnitValue you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<TypedOMCSSUnitValue>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TypedOMCSSUnitValue& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(CSS_TYPED_OM)
