/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSUndoManager.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSUndoItem.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsUndoManagerPrototypeFunctionAddItem(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsUndoManagerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSUndoManagerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSUndoManagerPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSUndoManagerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSUndoManagerPrototype* ptr = new (NotNull, JSC::allocateCell<JSUndoManagerPrototype>(vm.heap)) JSUndoManagerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSUndoManagerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSUndoManagerPrototype, JSUndoManagerPrototype::Base);

using JSUndoManagerConstructor = JSDOMConstructorNotConstructable<JSUndoManager>;

template<> JSValue JSUndoManagerConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSUndoManagerConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSUndoManager::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("UndoManager"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSUndoManagerConstructor::s_info = { "UndoManager", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUndoManagerConstructor) };

/* Hash table for prototype */

static const HashTableValue JSUndoManagerPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUndoManagerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSUndoManagerConstructor) } },
    { "addItem", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsUndoManagerPrototypeFunctionAddItem), (intptr_t) (1) } },
};

const ClassInfo JSUndoManagerPrototype::s_info = { "UndoManagerPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUndoManagerPrototype) };

void JSUndoManagerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSUndoManager::info(), JSUndoManagerPrototypeTableValues, *this);
}

const ClassInfo JSUndoManager::s_info = { "UndoManager", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUndoManager) };

JSUndoManager::JSUndoManager(Structure* structure, JSDOMGlobalObject& globalObject, Ref<UndoManager>&& impl)
    : JSDOMWrapper<UndoManager>(structure, globalObject, WTFMove(impl))
{
}

void JSUndoManager::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, UndoManager>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSUndoManager::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSUndoManagerPrototype::create(vm, &globalObject, JSUndoManagerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSUndoManager::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSUndoManager>(vm, globalObject);
}

JSValue JSUndoManager::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUndoManagerConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSUndoManager::destroy(JSC::JSCell* cell)
{
    JSUndoManager* thisObject = static_cast<JSUndoManager*>(cell);
    thisObject->JSUndoManager::~JSUndoManager();
}

template<> inline JSUndoManager* IDLOperation<JSUndoManager>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSUndoManager*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsUndoManagerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSUndoManagerPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSUndoManager::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSUndoManagerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSUndoManagerPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsUndoManagerPrototypeFunctionAddItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSUndoManager>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto item = convert<IDLInterface<UndoItem>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "item", "UndoManager", "addItem", "UndoItem"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.addItem(*item));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsUndoManagerPrototypeFunctionAddItem(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSUndoManager>::call<jsUndoManagerPrototypeFunctionAddItemBody>(*lexicalGlobalObject, *callFrame, "addItem");
}

void JSUndoManager::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSUndoManager*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSUndoManagerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsUndoManager = jsCast<JSUndoManager*>(handle.slot()->asCell());
    Document* root = WTF::getPtr(jsUndoManager->wrapped().document());
    if (!root)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Document";
    return visitor.containsOpaqueRoot(root);
}

void JSUndoManagerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsUndoManager = static_cast<JSUndoManager*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsUndoManager->wrapped(), jsUndoManager);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<UndoManager>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to UndoManager.
    static_assert(!std::is_polymorphic<UndoManager>::value, "UndoManager is polymorphic but the IDL claims it is not");
    return createWrapper<UndoManager>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, UndoManager& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

UndoManager* JSUndoManager::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSUndoManager*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
