/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(USER_MESSAGE_HANDLERS)

#include "JSUserMessageHandler.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertSerializedScriptValue.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "SerializedScriptValue.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsUserMessageHandlerPrototypeFunctionPostMessage(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsUserMessageHandlerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSUserMessageHandlerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSUserMessageHandlerPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSUserMessageHandlerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSUserMessageHandlerPrototype* ptr = new (NotNull, JSC::allocateCell<JSUserMessageHandlerPrototype>(vm.heap)) JSUserMessageHandlerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSUserMessageHandlerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSUserMessageHandlerPrototype, JSUserMessageHandlerPrototype::Base);

using JSUserMessageHandlerConstructor = JSDOMConstructorNotConstructable<JSUserMessageHandler>;

template<> JSValue JSUserMessageHandlerConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSUserMessageHandlerConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSUserMessageHandler::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("UserMessageHandler"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSUserMessageHandlerConstructor::s_info = { "UserMessageHandler", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUserMessageHandlerConstructor) };

/* Hash table for prototype */

static const HashTableValue JSUserMessageHandlerPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUserMessageHandlerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSUserMessageHandlerConstructor) } },
    { "postMessage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsUserMessageHandlerPrototypeFunctionPostMessage), (intptr_t) (1) } },
};

const ClassInfo JSUserMessageHandlerPrototype::s_info = { "UserMessageHandlerPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUserMessageHandlerPrototype) };

void JSUserMessageHandlerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSUserMessageHandler::info(), JSUserMessageHandlerPrototypeTableValues, *this);
}

const ClassInfo JSUserMessageHandler::s_info = { "UserMessageHandler", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUserMessageHandler) };

JSUserMessageHandler::JSUserMessageHandler(Structure* structure, JSDOMGlobalObject& globalObject, Ref<UserMessageHandler>&& impl)
    : JSDOMWrapper<UserMessageHandler>(structure, globalObject, WTFMove(impl))
{
}

void JSUserMessageHandler::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, UserMessageHandler>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSUserMessageHandler::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSUserMessageHandlerPrototype::create(vm, &globalObject, JSUserMessageHandlerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSUserMessageHandler::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSUserMessageHandler>(vm, globalObject);
}

JSValue JSUserMessageHandler::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUserMessageHandlerConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSUserMessageHandler::destroy(JSC::JSCell* cell)
{
    JSUserMessageHandler* thisObject = static_cast<JSUserMessageHandler*>(cell);
    thisObject->JSUserMessageHandler::~JSUserMessageHandler();
}

template<> inline JSUserMessageHandler* IDLOperation<JSUserMessageHandler>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSUserMessageHandler*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsUserMessageHandlerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSUserMessageHandlerPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSUserMessageHandler::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSUserMessageHandlerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSUserMessageHandlerPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsUserMessageHandlerPrototypeFunctionPostMessageBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSUserMessageHandler>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto message = convert<IDLSerializedScriptValue<SerializedScriptValue>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.postMessage(WTFMove(message)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsUserMessageHandlerPrototypeFunctionPostMessage(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSUserMessageHandler>::call<jsUserMessageHandlerPrototypeFunctionPostMessageBody>(*lexicalGlobalObject, *callFrame, "postMessage");
}

void JSUserMessageHandler::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSUserMessageHandler*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSUserMessageHandlerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSUserMessageHandlerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsUserMessageHandler = static_cast<JSUserMessageHandler*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsUserMessageHandler->wrapped(), jsUserMessageHandler);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7UserMessageHandler@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18UserMessageHandlerE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<UserMessageHandler>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7UserMessageHandler@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore18UserMessageHandlerE[2];
#endif

    // If this fails UserMessageHandler does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<UserMessageHandler>::value, "UserMessageHandler is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // UserMessageHandler has subclasses. If UserMessageHandler has subclasses that get passed
    // to toJS() we currently require UserMessageHandler you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<UserMessageHandler>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, UserMessageHandler& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

UserMessageHandler* JSUserMessageHandler::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSUserMessageHandler*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(USER_MESSAGE_HANDLERS)
