/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(USER_MESSAGE_HANDLERS)

#include "JSUserMessageHandlersNamespace.h"

#include "ActiveDOMObject.h"
#include "JSDOMAbstractOperations.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSUserMessageHandler.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsUserMessageHandlersNamespaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSUserMessageHandlersNamespaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSUserMessageHandlersNamespacePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSUserMessageHandlersNamespacePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSUserMessageHandlersNamespacePrototype* ptr = new (NotNull, JSC::allocateCell<JSUserMessageHandlersNamespacePrototype>(vm.heap)) JSUserMessageHandlersNamespacePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSUserMessageHandlersNamespacePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSUserMessageHandlersNamespacePrototype, JSUserMessageHandlersNamespacePrototype::Base);

using JSUserMessageHandlersNamespaceConstructor = JSDOMConstructorNotConstructable<JSUserMessageHandlersNamespace>;

template<> JSValue JSUserMessageHandlersNamespaceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSUserMessageHandlersNamespaceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSUserMessageHandlersNamespace::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("UserMessageHandlersNamespace"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSUserMessageHandlersNamespaceConstructor::s_info = { "UserMessageHandlersNamespace", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUserMessageHandlersNamespaceConstructor) };

/* Hash table for prototype */

static const HashTableValue JSUserMessageHandlersNamespacePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUserMessageHandlersNamespaceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSUserMessageHandlersNamespaceConstructor) } },
};

const ClassInfo JSUserMessageHandlersNamespacePrototype::s_info = { "UserMessageHandlersNamespacePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUserMessageHandlersNamespacePrototype) };

void JSUserMessageHandlersNamespacePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSUserMessageHandlersNamespace::info(), JSUserMessageHandlersNamespacePrototypeTableValues, *this);
}

const ClassInfo JSUserMessageHandlersNamespace::s_info = { "UserMessageHandlersNamespace", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUserMessageHandlersNamespace) };

JSUserMessageHandlersNamespace::JSUserMessageHandlersNamespace(Structure* structure, JSDOMGlobalObject& globalObject, Ref<UserMessageHandlersNamespace>&& impl)
    : JSDOMWrapper<UserMessageHandlersNamespace>(structure, globalObject, WTFMove(impl))
{
}

void JSUserMessageHandlersNamespace::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, UserMessageHandlersNamespace>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSUserMessageHandlersNamespace::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSUserMessageHandlersNamespacePrototype::create(vm, &globalObject, JSUserMessageHandlersNamespacePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSUserMessageHandlersNamespace::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSUserMessageHandlersNamespace>(vm, globalObject);
}

JSValue JSUserMessageHandlersNamespace::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUserMessageHandlersNamespaceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSUserMessageHandlersNamespace::destroy(JSC::JSCell* cell)
{
    JSUserMessageHandlersNamespace* thisObject = static_cast<JSUserMessageHandlersNamespace*>(cell);
    thisObject->JSUserMessageHandlersNamespace::~JSUserMessageHandlersNamespace();
}

bool JSUserMessageHandlersNamespace::getOwnPropertySlot(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSUserMessageHandlersNamespace*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    using GetterIDLType = IDLInterface<UserMessageHandler>;
    auto getterFunctor = [] (auto& thisObject, auto propertyName) -> Optional<typename GetterIDLType::ImplementationType> {
        auto result = thisObject.wrapped().namedItem(worldForDOMObject(thisObject), propertyNameToAtomString(propertyName));
        if (!GetterIDLType::isNullValue(result))
            return typename GetterIDLType::ImplementationType { GetterIDLType::extractValueFromNullable(result) };
        return WTF::nullopt;
    };
    if (auto namedProperty = accessVisibleNamedProperty<OverrideBuiltins::No>(*lexicalGlobalObject, *thisObject, propertyName, getterFunctor)) {
        auto value = toJS<IDLInterface<UserMessageHandler>>(*lexicalGlobalObject, *thisObject->globalObject(), WTFMove(namedProperty.value()));
        slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
        return true;
    }
    return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
}

bool JSUserMessageHandlersNamespace::getOwnPropertySlotByIndex(JSObject* object, JSGlobalObject* lexicalGlobalObject, unsigned index, PropertySlot& slot)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSUserMessageHandlersNamespace*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    auto propertyName = Identifier::from(vm, index);
    using GetterIDLType = IDLInterface<UserMessageHandler>;
    auto getterFunctor = [] (auto& thisObject, auto propertyName) -> Optional<typename GetterIDLType::ImplementationType> {
        auto result = thisObject.wrapped().namedItem(worldForDOMObject(thisObject), propertyNameToAtomString(propertyName));
        if (!GetterIDLType::isNullValue(result))
            return typename GetterIDLType::ImplementationType { GetterIDLType::extractValueFromNullable(result) };
        return WTF::nullopt;
    };
    if (auto namedProperty = accessVisibleNamedProperty<OverrideBuiltins::No>(*lexicalGlobalObject, *thisObject, propertyName, getterFunctor)) {
        auto value = toJS<IDLInterface<UserMessageHandler>>(*lexicalGlobalObject, *thisObject->globalObject(), WTFMove(namedProperty.value()));
        slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
        return true;
    }
    return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
}

void JSUserMessageHandlersNamespace::getOwnPropertyNames(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSUserMessageHandlersNamespace*>(object);
    ASSERT_GC_OBJECT_INHERITS(object, info());
    for (auto& propertyName : thisObject->wrapped().supportedPropertyNames())
        propertyNames.add(Identifier::fromString(vm, propertyName));
    JSObject::getOwnPropertyNames(object, lexicalGlobalObject, propertyNames, mode);
}

EncodedJSValue jsUserMessageHandlersNamespaceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSUserMessageHandlersNamespacePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSUserMessageHandlersNamespace::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSUserMessageHandlersNamespaceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSUserMessageHandlersNamespacePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSUserMessageHandlersNamespace::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSUserMessageHandlersNamespace*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSUserMessageHandlersNamespaceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSUserMessageHandlersNamespaceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsUserMessageHandlersNamespace = static_cast<JSUserMessageHandlersNamespace*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsUserMessageHandlersNamespace->wrapped(), jsUserMessageHandlersNamespace);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7UserMessageHandlersNamespace@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore28UserMessageHandlersNamespaceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<UserMessageHandlersNamespace>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7UserMessageHandlersNamespace@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore28UserMessageHandlersNamespaceE[2];
#endif

    // If this fails UserMessageHandlersNamespace does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<UserMessageHandlersNamespace>::value, "UserMessageHandlersNamespace is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // UserMessageHandlersNamespace has subclasses. If UserMessageHandlersNamespace has subclasses that get passed
    // to toJS() we currently require UserMessageHandlersNamespace you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<UserMessageHandlersNamespace>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, UserMessageHandlersNamespace& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

UserMessageHandlersNamespace* JSUserMessageHandlersNamespace::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSUserMessageHandlersNamespace*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(USER_MESSAGE_HANDLERS)
