/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSVTTRegion.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSTextTrack.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsVTTRegionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTRegionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionTrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVTTRegionId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTRegionId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTRegionWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionLines(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTRegionLines(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionRegionAnchorX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTRegionRegionAnchorX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionRegionAnchorY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTRegionRegionAnchorY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionViewportAnchorX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTRegionViewportAnchorX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionViewportAnchorY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTRegionViewportAnchorY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionScroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTRegionScroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSVTTRegionPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSVTTRegionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVTTRegionPrototype* ptr = new (NotNull, JSC::allocateCell<JSVTTRegionPrototype>(vm.heap)) JSVTTRegionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVTTRegionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVTTRegionPrototype, JSVTTRegionPrototype::Base);

using JSVTTRegionConstructor = JSDOMConstructor<JSVTTRegion>;

template<> EncodedJSValue JSC_HOST_CALL JSVTTRegionConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSVTTRegionConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "VTTRegion");
    auto object = VTTRegion::create(*context);
    return JSValue::encode(toJSNewlyCreated<IDLInterface<VTTRegion>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSVTTRegionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSVTTRegionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSVTTRegion::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("VTTRegion"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSVTTRegionConstructor::s_info = { "VTTRegion", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVTTRegionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSVTTRegionPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionConstructor) } },
    { "track", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionTrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "id", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionId) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionWidth) } },
    { "lines", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionLines), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionLines) } },
    { "regionAnchorX", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionRegionAnchorX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionRegionAnchorX) } },
    { "regionAnchorY", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionRegionAnchorY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionRegionAnchorY) } },
    { "viewportAnchorX", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionViewportAnchorX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionViewportAnchorX) } },
    { "viewportAnchorY", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionViewportAnchorY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionViewportAnchorY) } },
    { "scroll", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionScroll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionScroll) } },
};

const ClassInfo JSVTTRegionPrototype::s_info = { "VTTRegionPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVTTRegionPrototype) };

void JSVTTRegionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVTTRegion::info(), JSVTTRegionPrototypeTableValues, *this);
}

const ClassInfo JSVTTRegion::s_info = { "VTTRegion", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVTTRegion) };

JSVTTRegion::JSVTTRegion(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VTTRegion>&& impl)
    : JSDOMWrapper<VTTRegion>(structure, globalObject, WTFMove(impl))
{
}

void JSVTTRegion::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, VTTRegion>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSVTTRegion::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSVTTRegionPrototype::create(vm, &globalObject, JSVTTRegionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSVTTRegion::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSVTTRegion>(vm, globalObject);
}

JSValue JSVTTRegion::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVTTRegionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSVTTRegion::destroy(JSC::JSCell* cell)
{
    JSVTTRegion* thisObject = static_cast<JSVTTRegion*>(cell);
    thisObject->JSVTTRegion::~JSVTTRegion();
}

template<> inline JSVTTRegion* IDLAttribute<JSVTTRegion>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSVTTRegion*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsVTTRegionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVTTRegionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSVTTRegion::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSVTTRegionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVTTRegionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsVTTRegionTrackGetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TextTrack>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.track());
    return result;
}

EncodedJSValue jsVTTRegionTrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTRegion>::get<jsVTTRegionTrackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "track");
}

static inline JSValue jsVTTRegionIdGetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id());
    return result;
}

EncodedJSValue jsVTTRegionId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTRegion>::get<jsVTTRegionIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "id");
}

static inline bool setJSVTTRegionIdSetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setId(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTRegionId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTRegion>::set<setJSVTTRegionIdSetter>(*lexicalGlobalObject, thisValue, encodedValue, "id");
}

static inline JSValue jsVTTRegionWidthGetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.width());
    return result;
}

EncodedJSValue jsVTTRegionWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTRegion>::get<jsVTTRegionWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline bool setJSVTTRegionWidthSetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setWidth(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTRegionWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTRegion>::set<setJSVTTRegionWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "width");
}

static inline JSValue jsVTTRegionLinesGetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.lines());
    return result;
}

EncodedJSValue jsVTTRegionLines(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTRegion>::get<jsVTTRegionLinesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lines");
}

static inline bool setJSVTTRegionLinesSetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLines(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTRegionLines(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTRegion>::set<setJSVTTRegionLinesSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lines");
}

static inline JSValue jsVTTRegionRegionAnchorXGetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.regionAnchorX());
    return result;
}

EncodedJSValue jsVTTRegionRegionAnchorX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTRegion>::get<jsVTTRegionRegionAnchorXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "regionAnchorX");
}

static inline bool setJSVTTRegionRegionAnchorXSetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setRegionAnchorX(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTRegionRegionAnchorX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTRegion>::set<setJSVTTRegionRegionAnchorXSetter>(*lexicalGlobalObject, thisValue, encodedValue, "regionAnchorX");
}

static inline JSValue jsVTTRegionRegionAnchorYGetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.regionAnchorY());
    return result;
}

EncodedJSValue jsVTTRegionRegionAnchorY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTRegion>::get<jsVTTRegionRegionAnchorYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "regionAnchorY");
}

static inline bool setJSVTTRegionRegionAnchorYSetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setRegionAnchorY(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTRegionRegionAnchorY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTRegion>::set<setJSVTTRegionRegionAnchorYSetter>(*lexicalGlobalObject, thisValue, encodedValue, "regionAnchorY");
}

static inline JSValue jsVTTRegionViewportAnchorXGetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.viewportAnchorX());
    return result;
}

EncodedJSValue jsVTTRegionViewportAnchorX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTRegion>::get<jsVTTRegionViewportAnchorXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "viewportAnchorX");
}

static inline bool setJSVTTRegionViewportAnchorXSetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setViewportAnchorX(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTRegionViewportAnchorX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTRegion>::set<setJSVTTRegionViewportAnchorXSetter>(*lexicalGlobalObject, thisValue, encodedValue, "viewportAnchorX");
}

static inline JSValue jsVTTRegionViewportAnchorYGetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.viewportAnchorY());
    return result;
}

EncodedJSValue jsVTTRegionViewportAnchorY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTRegion>::get<jsVTTRegionViewportAnchorYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "viewportAnchorY");
}

static inline bool setJSVTTRegionViewportAnchorYSetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setViewportAnchorY(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTRegionViewportAnchorY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTRegion>::set<setJSVTTRegionViewportAnchorYSetter>(*lexicalGlobalObject, thisValue, encodedValue, "viewportAnchorY");
}

static inline JSValue jsVTTRegionScrollGetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.scroll());
    return result;
}

EncodedJSValue jsVTTRegionScroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTRegion>::get<jsVTTRegionScrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scroll");
}

static inline bool setJSVTTRegionScrollSetter(JSGlobalObject& lexicalGlobalObject, JSVTTRegion& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setScroll(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTRegionScroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTRegion>::set<setJSVTTRegionScrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, "scroll");
}

void JSVTTRegion::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSVTTRegion*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSVTTRegionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSVTTRegionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVTTRegion = static_cast<JSVTTRegion*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsVTTRegion->wrapped(), jsVTTRegion);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VTTRegion@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9VTTRegionE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<VTTRegion>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7VTTRegion@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore9VTTRegionE[2];
#endif

    // If this fails VTTRegion does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<VTTRegion>::value, "VTTRegion is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // VTTRegion has subclasses. If VTTRegion has subclasses that get passed
    // to toJS() we currently require VTTRegion you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<VTTRegion>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VTTRegion& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

VTTRegion* JSVTTRegion::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVTTRegion*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO_TRACK)
