/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSValidityState.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsValidityStateConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSValidityStateConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsValidityStateValueMissing(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateTypeMismatch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStatePatternMismatch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateTooShort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateTooLong(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateRangeUnderflow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateRangeOverflow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateStepMismatch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateBadInput(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateCustomError(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateValid(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSValidityStatePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSValidityStatePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSValidityStatePrototype* ptr = new (NotNull, JSC::allocateCell<JSValidityStatePrototype>(vm.heap)) JSValidityStatePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSValidityStatePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSValidityStatePrototype, JSValidityStatePrototype::Base);

using JSValidityStateConstructor = JSDOMConstructorNotConstructable<JSValidityState>;

template<> JSValue JSValidityStateConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSValidityStateConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSValidityState::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ValidityState"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSValidityStateConstructor::s_info = { "ValidityState", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSValidityStateConstructor) };

/* Hash table for prototype */

static const HashTableValue JSValidityStatePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSValidityStateConstructor) } },
    { "valueMissing", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateValueMissing), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "typeMismatch", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateTypeMismatch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "patternMismatch", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStatePatternMismatch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "tooShort", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateTooShort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "tooLong", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateTooLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rangeUnderflow", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateRangeUnderflow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rangeOverflow", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateRangeOverflow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "stepMismatch", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateStepMismatch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "badInput", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateBadInput), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "customError", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateCustomError), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "valid", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateValid), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSValidityStatePrototype::s_info = { "ValidityStatePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSValidityStatePrototype) };

void JSValidityStatePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSValidityState::info(), JSValidityStatePrototypeTableValues, *this);
}

const ClassInfo JSValidityState::s_info = { "ValidityState", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSValidityState) };

JSValidityState::JSValidityState(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ValidityState>&& impl)
    : JSDOMWrapper<ValidityState>(structure, globalObject, WTFMove(impl))
{
}

void JSValidityState::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ValidityState>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSValidityState::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSValidityStatePrototype::create(vm, &globalObject, JSValidityStatePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSValidityState::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSValidityState>(vm, globalObject);
}

JSValue JSValidityState::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSValidityStateConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSValidityState::destroy(JSC::JSCell* cell)
{
    JSValidityState* thisObject = static_cast<JSValidityState*>(cell);
    thisObject->JSValidityState::~JSValidityState();
}

template<> inline JSValidityState* IDLAttribute<JSValidityState>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSValidityState*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsValidityStateConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSValidityStatePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSValidityState::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSValidityStateConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSValidityStatePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsValidityStateValueMissingGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.valueMissing());
    return result;
}

EncodedJSValue jsValidityStateValueMissing(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSValidityState>::get<jsValidityStateValueMissingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "valueMissing");
}

static inline JSValue jsValidityStateTypeMismatchGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.typeMismatch());
    return result;
}

EncodedJSValue jsValidityStateTypeMismatch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSValidityState>::get<jsValidityStateTypeMismatchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "typeMismatch");
}

static inline JSValue jsValidityStatePatternMismatchGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.patternMismatch());
    return result;
}

EncodedJSValue jsValidityStatePatternMismatch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSValidityState>::get<jsValidityStatePatternMismatchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "patternMismatch");
}

static inline JSValue jsValidityStateTooShortGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.tooShort());
    return result;
}

EncodedJSValue jsValidityStateTooShort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSValidityState>::get<jsValidityStateTooShortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "tooShort");
}

static inline JSValue jsValidityStateTooLongGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.tooLong());
    return result;
}

EncodedJSValue jsValidityStateTooLong(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSValidityState>::get<jsValidityStateTooLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "tooLong");
}

static inline JSValue jsValidityStateRangeUnderflowGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.rangeUnderflow());
    return result;
}

EncodedJSValue jsValidityStateRangeUnderflow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSValidityState>::get<jsValidityStateRangeUnderflowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rangeUnderflow");
}

static inline JSValue jsValidityStateRangeOverflowGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.rangeOverflow());
    return result;
}

EncodedJSValue jsValidityStateRangeOverflow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSValidityState>::get<jsValidityStateRangeOverflowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rangeOverflow");
}

static inline JSValue jsValidityStateStepMismatchGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.stepMismatch());
    return result;
}

EncodedJSValue jsValidityStateStepMismatch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSValidityState>::get<jsValidityStateStepMismatchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "stepMismatch");
}

static inline JSValue jsValidityStateBadInputGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.badInput());
    return result;
}

EncodedJSValue jsValidityStateBadInput(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSValidityState>::get<jsValidityStateBadInputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "badInput");
}

static inline JSValue jsValidityStateCustomErrorGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.customError());
    return result;
}

EncodedJSValue jsValidityStateCustomError(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSValidityState>::get<jsValidityStateCustomErrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "customError");
}

static inline JSValue jsValidityStateValidGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isValid());
    return result;
}

EncodedJSValue jsValidityStateValid(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSValidityState>::get<jsValidityStateValidGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "valid");
}

void JSValidityState::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSValidityState*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSValidityStateOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSValidityStateOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsValidityState = static_cast<JSValidityState*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsValidityState->wrapped(), jsValidityState);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ValidityState>&& impl)
{
    return createWrapper<ValidityState>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ValidityState& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ValidityState* JSValidityState::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSValidityState*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
