/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSVideoTrack.h"

#include "ActiveDOMObject.h"
#include "Element.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "JSNodeCustom.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsVideoTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVideoTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVideoTrackId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoTrackKind(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(MEDIA_SOURCE)
bool setJSVideoTrackKind(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsVideoTrackLabel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoTrackLanguage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(MEDIA_SOURCE)
bool setJSVideoTrackLanguage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsVideoTrackSelected(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVideoTrackSelected(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSVideoTrackPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSVideoTrackPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVideoTrackPrototype* ptr = new (NotNull, JSC::allocateCell<JSVideoTrackPrototype>(vm.heap)) JSVideoTrackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVideoTrackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVideoTrackPrototype, JSVideoTrackPrototype::Base);

using JSVideoTrackConstructor = JSDOMConstructorNotConstructable<JSVideoTrack>;

template<> JSValue JSVideoTrackConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSVideoTrackConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSVideoTrack::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("VideoTrack"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSVideoTrackConstructor::s_info = { "VideoTrack", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoTrackConstructor) };

/* Hash table for prototype */

static const HashTableValue JSVideoTrackPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVideoTrackConstructor) } },
    { "id", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(MEDIA_SOURCE)
    { "kind", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackKind), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVideoTrackKind) } },
#else
    { "kind", JSC::PropertyAttribute::ReadOnly | static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackKind), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#endif
    { "label", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackLabel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(MEDIA_SOURCE)
    { "language", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackLanguage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVideoTrackLanguage) } },
#else
    { "language", JSC::PropertyAttribute::ReadOnly | static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackLanguage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#endif
    { "selected", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackSelected), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVideoTrackSelected) } },
};

const ClassInfo JSVideoTrackPrototype::s_info = { "VideoTrackPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoTrackPrototype) };

void JSVideoTrackPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVideoTrack::info(), JSVideoTrackPrototypeTableValues, *this);
}

const ClassInfo JSVideoTrack::s_info = { "VideoTrack", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoTrack) };

JSVideoTrack::JSVideoTrack(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VideoTrack>&& impl)
    : JSDOMWrapper<VideoTrack>(structure, globalObject, WTFMove(impl))
{
}

void JSVideoTrack::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, VideoTrack>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSVideoTrack::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSVideoTrackPrototype::create(vm, &globalObject, JSVideoTrackPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSVideoTrack::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSVideoTrack>(vm, globalObject);
}

JSValue JSVideoTrack::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVideoTrackConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSVideoTrack::destroy(JSC::JSCell* cell)
{
    JSVideoTrack* thisObject = static_cast<JSVideoTrack*>(cell);
    thisObject->JSVideoTrack::~JSVideoTrack();
}

template<> inline JSVideoTrack* IDLAttribute<JSVideoTrack>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSVideoTrack*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsVideoTrackConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVideoTrackPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSVideoTrack::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSVideoTrackConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVideoTrackPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsVideoTrackIdGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id());
    return result;
}

EncodedJSValue jsVideoTrackId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVideoTrack>::get<jsVideoTrackIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "id");
}

static inline JSValue jsVideoTrackKindGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.kind());
    return result;
}

EncodedJSValue jsVideoTrackKind(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVideoTrack>::get<jsVideoTrackKindGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "kind");
}

#if ENABLE(MEDIA_SOURCE)
static inline bool setJSVideoTrackKindSetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setKind(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVideoTrackKind(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVideoTrack>::set<setJSVideoTrackKindSetter>(*lexicalGlobalObject, thisValue, encodedValue, "kind");
}

#endif

static inline JSValue jsVideoTrackLabelGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.label());
    return result;
}

EncodedJSValue jsVideoTrackLabel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVideoTrack>::get<jsVideoTrackLabelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "label");
}

static inline JSValue jsVideoTrackLanguageGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.language());
    return result;
}

EncodedJSValue jsVideoTrackLanguage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVideoTrack>::get<jsVideoTrackLanguageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "language");
}

#if ENABLE(MEDIA_SOURCE)
static inline bool setJSVideoTrackLanguageSetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLanguage(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVideoTrackLanguage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVideoTrack>::set<setJSVideoTrackLanguageSetter>(*lexicalGlobalObject, thisValue, encodedValue, "language");
}

#endif

static inline JSValue jsVideoTrackSelectedGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.selected());
    return result;
}

EncodedJSValue jsVideoTrackSelected(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVideoTrack>::get<jsVideoTrackSelectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "selected");
}

static inline bool setJSVideoTrackSelectedSetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSelected(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVideoTrackSelected(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVideoTrack>::set<setJSVideoTrackSelectedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "selected");
}

void JSVideoTrack::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSVideoTrack*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSVideoTrack::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSVideoTrack*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSVideoTrack::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSVideoTrack*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSVideoTrackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsVideoTrack = jsCast<JSVideoTrack*>(handle.slot()->asCell());
    Element* element = WTF::getPtr(jsVideoTrack->wrapped().element());
    if (!element)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from VideoTrackOwner";
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSVideoTrackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVideoTrack = static_cast<JSVideoTrack*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsVideoTrack->wrapped(), jsVideoTrack);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VideoTrack@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10VideoTrackE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<VideoTrack>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7VideoTrack@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10VideoTrackE[2];
#endif

    // If this fails VideoTrack does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<VideoTrack>::value, "VideoTrack is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // VideoTrack has subclasses. If VideoTrack has subclasses that get passed
    // to toJS() we currently require VideoTrack you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<VideoTrack>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VideoTrack& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

VideoTrack* JSVideoTrack::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVideoTrack*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO_TRACK)
