/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLCompressedTextureASTC.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGLCompressedTextureASTCPrototypeFunctionGetSupportedProfiles(JSC::JSGlobalObject*, JSC::CallFrame*);

class JSWebGLCompressedTextureASTCPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLCompressedTextureASTCPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLCompressedTextureASTCPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLCompressedTextureASTCPrototype>(vm.heap)) JSWebGLCompressedTextureASTCPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLCompressedTextureASTCPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureASTCPrototype, JSWebGLCompressedTextureASTCPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLCompressedTextureASTCPrototypeTableValues[] =
{
    { "getSupportedProfiles", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGLCompressedTextureASTCPrototypeFunctionGetSupportedProfiles), (intptr_t) (0) } },
    { "COMPRESSED_RGBA_ASTC_4x4_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93B0) } },
    { "COMPRESSED_RGBA_ASTC_5x4_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93B1) } },
    { "COMPRESSED_RGBA_ASTC_5x5_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93B2) } },
    { "COMPRESSED_RGBA_ASTC_6x5_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93B3) } },
    { "COMPRESSED_RGBA_ASTC_6x6_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93B4) } },
    { "COMPRESSED_RGBA_ASTC_8x5_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93B5) } },
    { "COMPRESSED_RGBA_ASTC_8x6_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93B6) } },
    { "COMPRESSED_RGBA_ASTC_8x8_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93B7) } },
    { "COMPRESSED_RGBA_ASTC_10x5_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93B8) } },
    { "COMPRESSED_RGBA_ASTC_10x6_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93B9) } },
    { "COMPRESSED_RGBA_ASTC_10x8_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93BA) } },
    { "COMPRESSED_RGBA_ASTC_10x10_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93BB) } },
    { "COMPRESSED_RGBA_ASTC_12x10_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93BC) } },
    { "COMPRESSED_RGBA_ASTC_12x12_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93BD) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93D0) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93D1) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93D2) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93D3) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93D4) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93D5) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93D6) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93D7) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93D8) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93D9) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93DA) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93DB) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93DC) } },
    { "COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x93DD) } },
};

const ClassInfo JSWebGLCompressedTextureASTCPrototype::s_info = { "WebGLCompressedTextureASTCPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureASTCPrototype) };

void JSWebGLCompressedTextureASTCPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLCompressedTextureASTC::info(), JSWebGLCompressedTextureASTCPrototypeTableValues, *this);
}

const ClassInfo JSWebGLCompressedTextureASTC::s_info = { "WebGLCompressedTextureASTC", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureASTC) };

JSWebGLCompressedTextureASTC::JSWebGLCompressedTextureASTC(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLCompressedTextureASTC>&& impl)
    : JSDOMWrapper<WebGLCompressedTextureASTC>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLCompressedTextureASTC::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLCompressedTextureASTC>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLCompressedTextureASTC::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLCompressedTextureASTCPrototype::create(vm, &globalObject, JSWebGLCompressedTextureASTCPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLCompressedTextureASTC::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLCompressedTextureASTC>(vm, globalObject);
}

void JSWebGLCompressedTextureASTC::destroy(JSC::JSCell* cell)
{
    JSWebGLCompressedTextureASTC* thisObject = static_cast<JSWebGLCompressedTextureASTC*>(cell);
    thisObject->JSWebGLCompressedTextureASTC::~JSWebGLCompressedTextureASTC();
}

template<> inline JSWebGLCompressedTextureASTC* IDLOperation<JSWebGLCompressedTextureASTC>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebGLCompressedTextureASTC*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSC::EncodedJSValue jsWebGLCompressedTextureASTCPrototypeFunctionGetSupportedProfilesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLCompressedTextureASTC>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getSupportedProfiles()));
}

EncodedJSValue JSC_HOST_CALL jsWebGLCompressedTextureASTCPrototypeFunctionGetSupportedProfiles(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGLCompressedTextureASTC>::call<jsWebGLCompressedTextureASTCPrototypeFunctionGetSupportedProfilesBody>(*lexicalGlobalObject, *callFrame, "getSupportedProfiles");
}

void JSWebGLCompressedTextureASTC::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLCompressedTextureASTC*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLCompressedTextureASTCOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLCompressedTextureASTC = jsCast<JSWebGLCompressedTextureASTC*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLCompressedTextureASTC->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLCompressedTextureASTC";
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLCompressedTextureASTCOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLCompressedTextureASTC = static_cast<JSWebGLCompressedTextureASTC*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLCompressedTextureASTC->wrapped(), jsWebGLCompressedTextureASTC);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLCompressedTextureASTC@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore26WebGLCompressedTextureASTCE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLCompressedTextureASTC>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGLCompressedTextureASTC@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore26WebGLCompressedTextureASTCE[2];
#endif

    // If this fails WebGLCompressedTextureASTC does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGLCompressedTextureASTC>::value, "WebGLCompressedTextureASTC is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGLCompressedTextureASTC has subclasses. If WebGLCompressedTextureASTC has subclasses that get passed
    // to toJS() we currently require WebGLCompressedTextureASTC you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGLCompressedTextureASTC>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLCompressedTextureASTC& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLCompressedTextureASTC* JSWebGLCompressedTextureASTC::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLCompressedTextureASTC*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
