/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLCompressedTextureATC.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSWebGLCompressedTextureATCPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLCompressedTextureATCPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLCompressedTextureATCPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLCompressedTextureATCPrototype>(vm.heap)) JSWebGLCompressedTextureATCPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLCompressedTextureATCPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureATCPrototype, JSWebGLCompressedTextureATCPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLCompressedTextureATCPrototypeTableValues[] =
{
    { "COMPRESSED_RGB_ATC_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C92) } },
    { "COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C93) } },
    { "COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x87EE) } },
};

const ClassInfo JSWebGLCompressedTextureATCPrototype::s_info = { "WebGLCompressedTextureATCPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureATCPrototype) };

void JSWebGLCompressedTextureATCPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLCompressedTextureATC::info(), JSWebGLCompressedTextureATCPrototypeTableValues, *this);
}

const ClassInfo JSWebGLCompressedTextureATC::s_info = { "WebGLCompressedTextureATC", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureATC) };

JSWebGLCompressedTextureATC::JSWebGLCompressedTextureATC(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLCompressedTextureATC>&& impl)
    : JSDOMWrapper<WebGLCompressedTextureATC>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLCompressedTextureATC::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLCompressedTextureATC>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLCompressedTextureATC::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLCompressedTextureATCPrototype::create(vm, &globalObject, JSWebGLCompressedTextureATCPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLCompressedTextureATC::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLCompressedTextureATC>(vm, globalObject);
}

void JSWebGLCompressedTextureATC::destroy(JSC::JSCell* cell)
{
    JSWebGLCompressedTextureATC* thisObject = static_cast<JSWebGLCompressedTextureATC*>(cell);
    thisObject->JSWebGLCompressedTextureATC::~JSWebGLCompressedTextureATC();
}

void JSWebGLCompressedTextureATC::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLCompressedTextureATC*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLCompressedTextureATCOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLCompressedTextureATC = jsCast<JSWebGLCompressedTextureATC*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLCompressedTextureATC->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLCompressedTextureATC";
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLCompressedTextureATCOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLCompressedTextureATC = static_cast<JSWebGLCompressedTextureATC*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLCompressedTextureATC->wrapped(), jsWebGLCompressedTextureATC);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLCompressedTextureATC@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25WebGLCompressedTextureATCE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLCompressedTextureATC>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGLCompressedTextureATC@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore25WebGLCompressedTextureATCE[2];
#endif

    // If this fails WebGLCompressedTextureATC does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGLCompressedTextureATC>::value, "WebGLCompressedTextureATC is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGLCompressedTextureATC has subclasses. If WebGLCompressedTextureATC has subclasses that get passed
    // to toJS() we currently require WebGLCompressedTextureATC you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGLCompressedTextureATC>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLCompressedTextureATC& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLCompressedTextureATC* JSWebGLCompressedTextureATC::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLCompressedTextureATC*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
