/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLCompressedTextureETC.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSWebGLCompressedTextureETCPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLCompressedTextureETCPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLCompressedTextureETCPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLCompressedTextureETCPrototype>(vm.heap)) JSWebGLCompressedTextureETCPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLCompressedTextureETCPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureETCPrototype, JSWebGLCompressedTextureETCPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLCompressedTextureETCPrototypeTableValues[] =
{
    { "COMPRESSED_R11_EAC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9270) } },
    { "COMPRESSED_SIGNED_R11_EAC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9271) } },
    { "COMPRESSED_RG11_EAC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9272) } },
    { "COMPRESSED_SIGNED_RG11_EAC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9273) } },
    { "COMPRESSED_RGB8_ETC2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9274) } },
    { "COMPRESSED_SRGB8_ETC2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9275) } },
    { "COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9276) } },
    { "COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9277) } },
    { "COMPRESSED_RGBA8_ETC2_EAC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9278) } },
    { "COMPRESSED_SRGB8_ALPHA8_ETC2_EAC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9279) } },
};

const ClassInfo JSWebGLCompressedTextureETCPrototype::s_info = { "WebGLCompressedTextureETCPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureETCPrototype) };

void JSWebGLCompressedTextureETCPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLCompressedTextureETC::info(), JSWebGLCompressedTextureETCPrototypeTableValues, *this);
}

const ClassInfo JSWebGLCompressedTextureETC::s_info = { "WebGLCompressedTextureETC", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureETC) };

JSWebGLCompressedTextureETC::JSWebGLCompressedTextureETC(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLCompressedTextureETC>&& impl)
    : JSDOMWrapper<WebGLCompressedTextureETC>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLCompressedTextureETC::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLCompressedTextureETC>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLCompressedTextureETC::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLCompressedTextureETCPrototype::create(vm, &globalObject, JSWebGLCompressedTextureETCPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLCompressedTextureETC::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLCompressedTextureETC>(vm, globalObject);
}

void JSWebGLCompressedTextureETC::destroy(JSC::JSCell* cell)
{
    JSWebGLCompressedTextureETC* thisObject = static_cast<JSWebGLCompressedTextureETC*>(cell);
    thisObject->JSWebGLCompressedTextureETC::~JSWebGLCompressedTextureETC();
}

void JSWebGLCompressedTextureETC::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLCompressedTextureETC*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLCompressedTextureETCOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLCompressedTextureETC = jsCast<JSWebGLCompressedTextureETC*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLCompressedTextureETC->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLCompressedTextureETC";
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLCompressedTextureETCOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLCompressedTextureETC = static_cast<JSWebGLCompressedTextureETC*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLCompressedTextureETC->wrapped(), jsWebGLCompressedTextureETC);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLCompressedTextureETC@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25WebGLCompressedTextureETCE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLCompressedTextureETC>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGLCompressedTextureETC@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore25WebGLCompressedTextureETCE[2];
#endif

    // If this fails WebGLCompressedTextureETC does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGLCompressedTextureETC>::value, "WebGLCompressedTextureETC is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGLCompressedTextureETC has subclasses. If WebGLCompressedTextureETC has subclasses that get passed
    // to toJS() we currently require WebGLCompressedTextureETC you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGLCompressedTextureETC>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLCompressedTextureETC& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLCompressedTextureETC* JSWebGLCompressedTextureETC::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLCompressedTextureETC*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
