/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLCompressedTextureETC1.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSWebGLCompressedTextureETC1Prototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLCompressedTextureETC1Prototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLCompressedTextureETC1Prototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLCompressedTextureETC1Prototype>(vm.heap)) JSWebGLCompressedTextureETC1Prototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLCompressedTextureETC1Prototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureETC1Prototype, JSWebGLCompressedTextureETC1Prototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLCompressedTextureETC1PrototypeTableValues[] =
{
    { "COMPRESSED_RGB_ETC1_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D64) } },
};

const ClassInfo JSWebGLCompressedTextureETC1Prototype::s_info = { "WebGLCompressedTextureETC1Prototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureETC1Prototype) };

void JSWebGLCompressedTextureETC1Prototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLCompressedTextureETC1::info(), JSWebGLCompressedTextureETC1PrototypeTableValues, *this);
}

const ClassInfo JSWebGLCompressedTextureETC1::s_info = { "WebGLCompressedTextureETC1", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureETC1) };

JSWebGLCompressedTextureETC1::JSWebGLCompressedTextureETC1(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLCompressedTextureETC1>&& impl)
    : JSDOMWrapper<WebGLCompressedTextureETC1>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLCompressedTextureETC1::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLCompressedTextureETC1>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLCompressedTextureETC1::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLCompressedTextureETC1Prototype::create(vm, &globalObject, JSWebGLCompressedTextureETC1Prototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLCompressedTextureETC1::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLCompressedTextureETC1>(vm, globalObject);
}

void JSWebGLCompressedTextureETC1::destroy(JSC::JSCell* cell)
{
    JSWebGLCompressedTextureETC1* thisObject = static_cast<JSWebGLCompressedTextureETC1*>(cell);
    thisObject->JSWebGLCompressedTextureETC1::~JSWebGLCompressedTextureETC1();
}

void JSWebGLCompressedTextureETC1::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLCompressedTextureETC1*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLCompressedTextureETC1Owner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLCompressedTextureETC1 = jsCast<JSWebGLCompressedTextureETC1*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLCompressedTextureETC1->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLCompressedTextureETC1";
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLCompressedTextureETC1Owner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLCompressedTextureETC1 = static_cast<JSWebGLCompressedTextureETC1*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLCompressedTextureETC1->wrapped(), jsWebGLCompressedTextureETC1);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLCompressedTextureETC1@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore26WebGLCompressedTextureETC1E[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLCompressedTextureETC1>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGLCompressedTextureETC1@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore26WebGLCompressedTextureETC1E[2];
#endif

    // If this fails WebGLCompressedTextureETC1 does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGLCompressedTextureETC1>::value, "WebGLCompressedTextureETC1 is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGLCompressedTextureETC1 has subclasses. If WebGLCompressedTextureETC1 has subclasses that get passed
    // to toJS() we currently require WebGLCompressedTextureETC1 you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGLCompressedTextureETC1>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLCompressedTextureETC1& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLCompressedTextureETC1* JSWebGLCompressedTextureETC1::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLCompressedTextureETC1*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
