/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLDepthTexture.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSWebGLDepthTexturePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLDepthTexturePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLDepthTexturePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLDepthTexturePrototype>(vm.heap)) JSWebGLDepthTexturePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLDepthTexturePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLDepthTexturePrototype, JSWebGLDepthTexturePrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLDepthTexturePrototypeTableValues[] =
{
    { "UNSIGNED_INT_24_8_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84FA) } },
};

const ClassInfo JSWebGLDepthTexturePrototype::s_info = { "WebGLDepthTexturePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLDepthTexturePrototype) };

void JSWebGLDepthTexturePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLDepthTexture::info(), JSWebGLDepthTexturePrototypeTableValues, *this);
}

const ClassInfo JSWebGLDepthTexture::s_info = { "WebGLDepthTexture", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLDepthTexture) };

JSWebGLDepthTexture::JSWebGLDepthTexture(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLDepthTexture>&& impl)
    : JSDOMWrapper<WebGLDepthTexture>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLDepthTexture::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLDepthTexture>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLDepthTexture::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLDepthTexturePrototype::create(vm, &globalObject, JSWebGLDepthTexturePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLDepthTexture::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLDepthTexture>(vm, globalObject);
}

void JSWebGLDepthTexture::destroy(JSC::JSCell* cell)
{
    JSWebGLDepthTexture* thisObject = static_cast<JSWebGLDepthTexture*>(cell);
    thisObject->JSWebGLDepthTexture::~JSWebGLDepthTexture();
}

void JSWebGLDepthTexture::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLDepthTexture*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLDepthTextureOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLDepthTexture = jsCast<JSWebGLDepthTexture*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLDepthTexture->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLDepthTexture";
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLDepthTextureOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLDepthTexture = static_cast<JSWebGLDepthTexture*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLDepthTexture->wrapped(), jsWebGLDepthTexture);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLDepthTexture@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17WebGLDepthTextureE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLDepthTexture>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGLDepthTexture@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17WebGLDepthTextureE[2];
#endif

    // If this fails WebGLDepthTexture does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGLDepthTexture>::value, "WebGLDepthTexture is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGLDepthTexture has subclasses. If WebGLDepthTexture has subclasses that get passed
    // to toJS() we currently require WebGLDepthTexture you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGLDepthTexture>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLDepthTexture& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLDepthTexture* JSWebGLDepthTexture::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLDepthTexture*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
