/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLDrawBuffers.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGLDrawBuffersPrototypeFunctionDrawBuffersWEBGL(JSC::JSGlobalObject*, JSC::CallFrame*);

class JSWebGLDrawBuffersPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLDrawBuffersPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLDrawBuffersPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLDrawBuffersPrototype>(vm.heap)) JSWebGLDrawBuffersPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLDrawBuffersPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLDrawBuffersPrototype, JSWebGLDrawBuffersPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLDrawBuffersPrototypeTableValues[] =
{
    { "drawBuffersWEBGL", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGLDrawBuffersPrototypeFunctionDrawBuffersWEBGL), (intptr_t) (1) } },
    { "COLOR_ATTACHMENT0_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE0) } },
    { "COLOR_ATTACHMENT1_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE1) } },
    { "COLOR_ATTACHMENT2_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE2) } },
    { "COLOR_ATTACHMENT3_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE3) } },
    { "COLOR_ATTACHMENT4_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE4) } },
    { "COLOR_ATTACHMENT5_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE5) } },
    { "COLOR_ATTACHMENT6_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE6) } },
    { "COLOR_ATTACHMENT7_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE7) } },
    { "COLOR_ATTACHMENT8_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE8) } },
    { "COLOR_ATTACHMENT9_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE9) } },
    { "COLOR_ATTACHMENT10_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEA) } },
    { "COLOR_ATTACHMENT11_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEB) } },
    { "COLOR_ATTACHMENT12_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEC) } },
    { "COLOR_ATTACHMENT13_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CED) } },
    { "COLOR_ATTACHMENT14_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEE) } },
    { "COLOR_ATTACHMENT15_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEF) } },
    { "DRAW_BUFFER0_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8825) } },
    { "DRAW_BUFFER1_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8826) } },
    { "DRAW_BUFFER2_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8827) } },
    { "DRAW_BUFFER3_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8828) } },
    { "DRAW_BUFFER4_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8829) } },
    { "DRAW_BUFFER5_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882A) } },
    { "DRAW_BUFFER6_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882B) } },
    { "DRAW_BUFFER7_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882C) } },
    { "DRAW_BUFFER8_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882D) } },
    { "DRAW_BUFFER9_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882E) } },
    { "DRAW_BUFFER10_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882F) } },
    { "DRAW_BUFFER11_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8830) } },
    { "DRAW_BUFFER12_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8831) } },
    { "DRAW_BUFFER13_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8832) } },
    { "DRAW_BUFFER14_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8833) } },
    { "DRAW_BUFFER15_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8834) } },
    { "MAX_COLOR_ATTACHMENTS_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CDF) } },
    { "MAX_DRAW_BUFFERS_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8824) } },
};

const ClassInfo JSWebGLDrawBuffersPrototype::s_info = { "WebGLDrawBuffersPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLDrawBuffersPrototype) };

void JSWebGLDrawBuffersPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLDrawBuffers::info(), JSWebGLDrawBuffersPrototypeTableValues, *this);
}

const ClassInfo JSWebGLDrawBuffers::s_info = { "WebGLDrawBuffers", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLDrawBuffers) };

JSWebGLDrawBuffers::JSWebGLDrawBuffers(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLDrawBuffers>&& impl)
    : JSDOMWrapper<WebGLDrawBuffers>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLDrawBuffers::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLDrawBuffers>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLDrawBuffers::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLDrawBuffersPrototype::create(vm, &globalObject, JSWebGLDrawBuffersPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLDrawBuffers::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLDrawBuffers>(vm, globalObject);
}

void JSWebGLDrawBuffers::destroy(JSC::JSCell* cell)
{
    JSWebGLDrawBuffers* thisObject = static_cast<JSWebGLDrawBuffers*>(cell);
    thisObject->JSWebGLDrawBuffers::~JSWebGLDrawBuffers();
}

template<> inline JSWebGLDrawBuffers* IDLOperation<JSWebGLDrawBuffers>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebGLDrawBuffers*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSC::EncodedJSValue jsWebGLDrawBuffersPrototypeFunctionDrawBuffersWEBGLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLDrawBuffers>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffers = convert<IDLSequence<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.drawBuffersWEBGL(WTFMove(buffers));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGLDrawBuffersPrototypeFunctionDrawBuffersWEBGL(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGLDrawBuffers>::call<jsWebGLDrawBuffersPrototypeFunctionDrawBuffersWEBGLBody>(*lexicalGlobalObject, *callFrame, "drawBuffersWEBGL");
}

void JSWebGLDrawBuffers::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLDrawBuffers*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLDrawBuffersOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLDrawBuffers = jsCast<JSWebGLDrawBuffers*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLDrawBuffers->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLDrawBuffers";
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLDrawBuffersOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLDrawBuffers = static_cast<JSWebGLDrawBuffers*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLDrawBuffers->wrapped(), jsWebGLDrawBuffers);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLDrawBuffers@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16WebGLDrawBuffersE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLDrawBuffers>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGLDrawBuffers@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16WebGLDrawBuffersE[2];
#endif

    // If this fails WebGLDrawBuffers does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGLDrawBuffers>::value, "WebGLDrawBuffers is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGLDrawBuffers has subclasses. If WebGLDrawBuffers has subclasses that get passed
    // to toJS() we currently require WebGLDrawBuffers you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGLDrawBuffers>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLDrawBuffers& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLDrawBuffers* JSWebGLDrawBuffers::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLDrawBuffers*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
