/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLShaderPrecisionFormat.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsWebGLShaderPrecisionFormatConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGLShaderPrecisionFormatConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebGLShaderPrecisionFormatRangeMin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebGLShaderPrecisionFormatRangeMax(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebGLShaderPrecisionFormatPrecision(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSWebGLShaderPrecisionFormatPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLShaderPrecisionFormatPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLShaderPrecisionFormatPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLShaderPrecisionFormatPrototype>(vm.heap)) JSWebGLShaderPrecisionFormatPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLShaderPrecisionFormatPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLShaderPrecisionFormatPrototype, JSWebGLShaderPrecisionFormatPrototype::Base);

using JSWebGLShaderPrecisionFormatConstructor = JSDOMConstructorNotConstructable<JSWebGLShaderPrecisionFormat>;

template<> JSValue JSWebGLShaderPrecisionFormatConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLShaderPrecisionFormatConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLShaderPrecisionFormat::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("WebGLShaderPrecisionFormat"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGLShaderPrecisionFormatConstructor::s_info = { "WebGLShaderPrecisionFormat", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLShaderPrecisionFormatConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLShaderPrecisionFormatPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderPrecisionFormatConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLShaderPrecisionFormatConstructor) } },
    { "rangeMin", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderPrecisionFormatRangeMin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rangeMax", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderPrecisionFormatRangeMax), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "precision", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderPrecisionFormatPrecision), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSWebGLShaderPrecisionFormatPrototype::s_info = { "WebGLShaderPrecisionFormatPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLShaderPrecisionFormatPrototype) };

void JSWebGLShaderPrecisionFormatPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLShaderPrecisionFormat::info(), JSWebGLShaderPrecisionFormatPrototypeTableValues, *this);
}

const ClassInfo JSWebGLShaderPrecisionFormat::s_info = { "WebGLShaderPrecisionFormat", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLShaderPrecisionFormat) };

JSWebGLShaderPrecisionFormat::JSWebGLShaderPrecisionFormat(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLShaderPrecisionFormat>&& impl)
    : JSDOMWrapper<WebGLShaderPrecisionFormat>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLShaderPrecisionFormat::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLShaderPrecisionFormat>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLShaderPrecisionFormat::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLShaderPrecisionFormatPrototype::create(vm, &globalObject, JSWebGLShaderPrecisionFormatPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLShaderPrecisionFormat::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLShaderPrecisionFormat>(vm, globalObject);
}

JSValue JSWebGLShaderPrecisionFormat::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLShaderPrecisionFormatConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGLShaderPrecisionFormat::destroy(JSC::JSCell* cell)
{
    JSWebGLShaderPrecisionFormat* thisObject = static_cast<JSWebGLShaderPrecisionFormat*>(cell);
    thisObject->JSWebGLShaderPrecisionFormat::~JSWebGLShaderPrecisionFormat();
}

template<> inline JSWebGLShaderPrecisionFormat* IDLAttribute<JSWebGLShaderPrecisionFormat>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSWebGLShaderPrecisionFormat*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsWebGLShaderPrecisionFormatConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLShaderPrecisionFormatPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGLShaderPrecisionFormat::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGLShaderPrecisionFormatConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLShaderPrecisionFormatPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsWebGLShaderPrecisionFormatRangeMinGetter(JSGlobalObject& lexicalGlobalObject, JSWebGLShaderPrecisionFormat& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.rangeMin());
    return result;
}

EncodedJSValue jsWebGLShaderPrecisionFormatRangeMin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebGLShaderPrecisionFormat>::get<jsWebGLShaderPrecisionFormatRangeMinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rangeMin");
}

static inline JSValue jsWebGLShaderPrecisionFormatRangeMaxGetter(JSGlobalObject& lexicalGlobalObject, JSWebGLShaderPrecisionFormat& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.rangeMax());
    return result;
}

EncodedJSValue jsWebGLShaderPrecisionFormatRangeMax(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebGLShaderPrecisionFormat>::get<jsWebGLShaderPrecisionFormatRangeMaxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rangeMax");
}

static inline JSValue jsWebGLShaderPrecisionFormatPrecisionGetter(JSGlobalObject& lexicalGlobalObject, JSWebGLShaderPrecisionFormat& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.precision());
    return result;
}

EncodedJSValue jsWebGLShaderPrecisionFormatPrecision(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebGLShaderPrecisionFormat>::get<jsWebGLShaderPrecisionFormatPrecisionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "precision");
}

void JSWebGLShaderPrecisionFormat::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLShaderPrecisionFormat*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLShaderPrecisionFormatOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGLShaderPrecisionFormatOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLShaderPrecisionFormat = static_cast<JSWebGLShaderPrecisionFormat*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLShaderPrecisionFormat->wrapped(), jsWebGLShaderPrecisionFormat);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLShaderPrecisionFormat>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to WebGLShaderPrecisionFormat.
    static_assert(!std::is_polymorphic<WebGLShaderPrecisionFormat>::value, "WebGLShaderPrecisionFormat is polymorphic but the IDL claims it is not");
    return createWrapper<WebGLShaderPrecisionFormat>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLShaderPrecisionFormat& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLShaderPrecisionFormat* JSWebGLShaderPrecisionFormat::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLShaderPrecisionFormat*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
