/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPUBindGroupDescriptor.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSWebGPUBindGroupBinding.h"
#include "JSWebGPUBindGroupLayout.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> WebGPUBindGroupDescriptor convertDictionary<WebGPUBindGroupDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebGPUBindGroupDescriptor result;
    JSValue bindingsValue;
    if (isNullOrUndefined)
        bindingsValue = jsUndefined();
    else {
        bindingsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bindings"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bindingsValue.isUndefined()) {
        result.bindings = convert<IDLSequence<IDLDictionary<WebGPUBindGroupBinding>>>(lexicalGlobalObject, bindingsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "bindings", "WebGPUBindGroupDescriptor", "sequence");
        return { };
    }
    JSValue layoutValue;
    if (isNullOrUndefined)
        layoutValue = jsUndefined();
    else {
        layoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "layout"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!layoutValue.isUndefined()) {
        result.layout = convert<IDLInterface<WebGPUBindGroupLayout>>(lexicalGlobalObject, layoutValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "layout", "WebGPUBindGroupDescriptor", "WebGPUBindGroupLayout");
        return { };
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEBGPU)
