/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(WEBGPU)

#include "JSDOMWrapper.h"
#include "WebGPUBuffer.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSWebGPUBuffer : public JSDOMWrapper<WebGPUBuffer> {
public:
    using Base = JSDOMWrapper<WebGPUBuffer>;
    static JSWebGPUBuffer* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<WebGPUBuffer>&& impl)
    {
        JSWebGPUBuffer* ptr = new (NotNull, JSC::allocateCell<JSWebGPUBuffer>(globalObject->vm().heap)) JSWebGPUBuffer(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static WebGPUBuffer* toWrapped(JSC::VM&, JSC::JSValue);
    static void destroy(JSC::JSCell*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
protected:
    JSWebGPUBuffer(JSC::Structure*, JSDOMGlobalObject&, Ref<WebGPUBuffer>&&);

    void finishCreation(JSC::VM&);
};

class JSWebGPUBufferOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, WebGPUBuffer*)
{
    static NeverDestroyed<JSWebGPUBufferOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(WebGPUBuffer* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, WebGPUBuffer&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGPUBuffer* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<WebGPUBuffer>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<WebGPUBuffer>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<WebGPUBuffer> {
    using WrapperClass = JSWebGPUBuffer;
    using ToWrappedReturnType = WebGPUBuffer*;
};

} // namespace WebCore

#endif // ENABLE(WEBGPU)
