/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPUCommandBuffer.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsWebGPUCommandBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGPUCommandBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGPUCommandBufferPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGPUCommandBufferPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGPUCommandBufferPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGPUCommandBufferPrototype>(vm.heap)) JSWebGPUCommandBufferPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGPUCommandBufferPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGPUCommandBufferPrototype, JSWebGPUCommandBufferPrototype::Base);

using JSWebGPUCommandBufferConstructor = JSDOMConstructorNotConstructable<JSWebGPUCommandBuffer>;

template<> JSValue JSWebGPUCommandBufferConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGPUCommandBufferConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGPUCommandBuffer::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GPUCommandBuffer"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGPUCommandBufferConstructor::s_info = { "GPUCommandBuffer", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUCommandBufferConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGPUCommandBufferPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGPUCommandBufferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGPUCommandBufferConstructor) } },
};

const ClassInfo JSWebGPUCommandBufferPrototype::s_info = { "GPUCommandBufferPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUCommandBufferPrototype) };

void JSWebGPUCommandBufferPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGPUCommandBuffer::info(), JSWebGPUCommandBufferPrototypeTableValues, *this);
}

const ClassInfo JSWebGPUCommandBuffer::s_info = { "GPUCommandBuffer", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUCommandBuffer) };

JSWebGPUCommandBuffer::JSWebGPUCommandBuffer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGPUCommandBuffer>&& impl)
    : JSDOMWrapper<WebGPUCommandBuffer>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGPUCommandBuffer::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGPUCommandBuffer>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGPUCommandBuffer::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGPUCommandBufferPrototype::create(vm, &globalObject, JSWebGPUCommandBufferPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGPUCommandBuffer::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGPUCommandBuffer>(vm, globalObject);
}

JSValue JSWebGPUCommandBuffer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGPUCommandBufferConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGPUCommandBuffer::destroy(JSC::JSCell* cell)
{
    JSWebGPUCommandBuffer* thisObject = static_cast<JSWebGPUCommandBuffer*>(cell);
    thisObject->JSWebGPUCommandBuffer::~JSWebGPUCommandBuffer();
}

EncodedJSValue jsWebGPUCommandBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUCommandBufferPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGPUCommandBuffer::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGPUCommandBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUCommandBufferPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSWebGPUCommandBuffer::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGPUCommandBuffer*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGPUCommandBufferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGPUCommandBufferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGPUCommandBuffer = static_cast<JSWebGPUCommandBuffer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGPUCommandBuffer->wrapped(), jsWebGPUCommandBuffer);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGPUCommandBuffer>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to WebGPUCommandBuffer.
    static_assert(!std::is_polymorphic<WebGPUCommandBuffer>::value, "WebGPUCommandBuffer is polymorphic but the IDL claims it is not");
    return createWrapper<WebGPUCommandBuffer>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGPUCommandBuffer& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGPUCommandBuffer* JSWebGPUCommandBuffer::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGPUCommandBuffer*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGPU)
