/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPUCommandEncoder.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUExtent3D.h"
#include "JSGPUOrigin3D.h"
#include "JSWebGPUBuffer.h"
#include "JSWebGPUCommandBuffer.h"
#include "JSWebGPUComputePassEncoder.h"
#include "JSWebGPURenderPassDescriptor.h"
#include "JSWebGPURenderPassEncoder.h"
#include "JSWebGPUTexture.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> WebGPUBufferCopyView convertDictionary<WebGPUBufferCopyView>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebGPUBufferCopyView result;
    JSValue bufferValue;
    if (isNullOrUndefined)
        bufferValue = jsUndefined();
    else {
        bufferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buffer"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bufferValue.isUndefined()) {
        result.buffer = convert<IDLInterface<WebGPUBuffer>>(lexicalGlobalObject, bufferValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "buffer", "GPUBufferCopyView", "WebGPUBuffer");
        return { };
    }
    JSValue imageHeightValue;
    if (isNullOrUndefined)
        imageHeightValue = jsUndefined();
    else {
        imageHeightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "imageHeight"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!imageHeightValue.isUndefined()) {
        result.imageHeight = convert<IDLUnsignedLong>(lexicalGlobalObject, imageHeightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "imageHeight", "GPUBufferCopyView", "unsigned long");
        return { };
    }
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!offsetValue.isUndefined()) {
        result.offset = convert<IDLUnsignedLongLong>(lexicalGlobalObject, offsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.offset = 0;
    JSValue rowPitchValue;
    if (isNullOrUndefined)
        rowPitchValue = jsUndefined();
    else {
        rowPitchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rowPitch"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rowPitchValue.isUndefined()) {
        result.rowPitch = convert<IDLUnsignedLong>(lexicalGlobalObject, rowPitchValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "rowPitch", "GPUBufferCopyView", "unsigned long");
        return { };
    }
    return result;
}

#endif

#if ENABLE(WEBGPU)

template<> WebGPUTextureCopyView convertDictionary<WebGPUTextureCopyView>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebGPUTextureCopyView result;
    JSValue arrayLayerValue;
    if (isNullOrUndefined)
        arrayLayerValue = jsUndefined();
    else {
        arrayLayerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "arrayLayer"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!arrayLayerValue.isUndefined()) {
        result.arrayLayer = convert<IDLUnsignedLong>(lexicalGlobalObject, arrayLayerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.arrayLayer = 0;
    JSValue mipLevelValue;
    if (isNullOrUndefined)
        mipLevelValue = jsUndefined();
    else {
        mipLevelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mipLevel"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mipLevelValue.isUndefined()) {
        result.mipLevel = convert<IDLUnsignedLong>(lexicalGlobalObject, mipLevelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.mipLevel = 0;
    JSValue originValue;
    if (isNullOrUndefined)
        originValue = jsUndefined();
    else {
        originValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "origin"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!originValue.isUndefined()) {
        result.origin = convert<IDLDictionary<GPUOrigin3D>>(lexicalGlobalObject, originValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue textureValue;
    if (isNullOrUndefined)
        textureValue = jsUndefined();
    else {
        textureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "texture"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!textureValue.isUndefined()) {
        result.texture = convert<IDLInterface<WebGPUTexture>>(lexicalGlobalObject, textureValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "texture", "GPUTextureCopyView", "WebGPUTexture");
        return { };
    }
    return result;
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionBeginRenderPass(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionBeginComputePass(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionCopyBufferToBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionCopyBufferToTexture(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionCopyTextureToBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionCopyTextureToTexture(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionFinish(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsWebGPUCommandEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGPUCommandEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGPUCommandEncoderPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGPUCommandEncoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGPUCommandEncoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGPUCommandEncoderPrototype>(vm.heap)) JSWebGPUCommandEncoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGPUCommandEncoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGPUCommandEncoderPrototype, JSWebGPUCommandEncoderPrototype::Base);

using JSWebGPUCommandEncoderConstructor = JSDOMConstructorNotConstructable<JSWebGPUCommandEncoder>;

template<> JSValue JSWebGPUCommandEncoderConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGPUCommandEncoderConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGPUCommandEncoder::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GPUCommandEncoder"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGPUCommandEncoderConstructor::s_info = { "GPUCommandEncoder", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUCommandEncoderConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGPUCommandEncoderPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGPUCommandEncoderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGPUCommandEncoderConstructor) } },
    { "beginRenderPass", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUCommandEncoderPrototypeFunctionBeginRenderPass), (intptr_t) (1) } },
    { "beginComputePass", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUCommandEncoderPrototypeFunctionBeginComputePass), (intptr_t) (0) } },
    { "copyBufferToBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUCommandEncoderPrototypeFunctionCopyBufferToBuffer), (intptr_t) (5) } },
    { "copyBufferToTexture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUCommandEncoderPrototypeFunctionCopyBufferToTexture), (intptr_t) (3) } },
    { "copyTextureToBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUCommandEncoderPrototypeFunctionCopyTextureToBuffer), (intptr_t) (3) } },
    { "copyTextureToTexture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUCommandEncoderPrototypeFunctionCopyTextureToTexture), (intptr_t) (3) } },
    { "finish", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUCommandEncoderPrototypeFunctionFinish), (intptr_t) (0) } },
};

const ClassInfo JSWebGPUCommandEncoderPrototype::s_info = { "GPUCommandEncoderPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUCommandEncoderPrototype) };

void JSWebGPUCommandEncoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGPUCommandEncoder::info(), JSWebGPUCommandEncoderPrototypeTableValues, *this);
}

const ClassInfo JSWebGPUCommandEncoder::s_info = { "GPUCommandEncoder", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUCommandEncoder) };

JSWebGPUCommandEncoder::JSWebGPUCommandEncoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGPUCommandEncoder>&& impl)
    : JSDOMWrapper<WebGPUCommandEncoder>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGPUCommandEncoder::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGPUCommandEncoder>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGPUCommandEncoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGPUCommandEncoderPrototype::create(vm, &globalObject, JSWebGPUCommandEncoderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGPUCommandEncoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGPUCommandEncoder>(vm, globalObject);
}

JSValue JSWebGPUCommandEncoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGPUCommandEncoderConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGPUCommandEncoder::destroy(JSC::JSCell* cell)
{
    JSWebGPUCommandEncoder* thisObject = static_cast<JSWebGPUCommandEncoder*>(cell);
    thisObject->JSWebGPUCommandEncoder::~JSWebGPUCommandEncoder();
}

template<> inline JSWebGPUCommandEncoder* IDLOperation<JSWebGPUCommandEncoder>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebGPUCommandEncoder*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsWebGPUCommandEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUCommandEncoderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGPUCommandEncoder::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGPUCommandEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUCommandEncoderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsWebGPUCommandEncoderPrototypeFunctionBeginRenderPassBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUCommandEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptor = convert<IDLDictionary<WebGPURenderPassDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebGPURenderPassEncoder>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.beginRenderPass(WTFMove(descriptor))));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionBeginRenderPass(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUCommandEncoder>::call<jsWebGPUCommandEncoderPrototypeFunctionBeginRenderPassBody>(*lexicalGlobalObject, *callFrame, "beginRenderPass");
}

static inline JSC::EncodedJSValue jsWebGPUCommandEncoderPrototypeFunctionBeginComputePassBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUCommandEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<WebGPUComputePassEncoder>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.beginComputePass()));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionBeginComputePass(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUCommandEncoder>::call<jsWebGPUCommandEncoderPrototypeFunctionBeginComputePassBody>(*lexicalGlobalObject, *callFrame, "beginComputePass");
}

static inline JSC::EncodedJSValue jsWebGPUCommandEncoderPrototypeFunctionCopyBufferToBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUCommandEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto src = convert<IDLInterface<WebGPUBuffer>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "src", "GPUCommandEncoder", "copyBufferToBuffer", "WebGPUBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dst = convert<IDLInterface<WebGPUBuffer>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "dst", "GPUCommandEncoder", "copyBufferToBuffer", "WebGPUBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dstOffset = convert<IDLUnsignedLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto size = convert<IDLUnsignedLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.copyBufferToBuffer(*src, WTFMove(srcOffset), *dst, WTFMove(dstOffset), WTFMove(size));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionCopyBufferToBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUCommandEncoder>::call<jsWebGPUCommandEncoderPrototypeFunctionCopyBufferToBufferBody>(*lexicalGlobalObject, *callFrame, "copyBufferToBuffer");
}

static inline JSC::EncodedJSValue jsWebGPUCommandEncoderPrototypeFunctionCopyBufferToTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUCommandEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto source = convert<IDLDictionary<WebGPUBufferCopyView>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto destination = convert<IDLDictionary<WebGPUTextureCopyView>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto copySize = convert<IDLDictionary<GPUExtent3D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.copyBufferToTexture(WTFMove(source), WTFMove(destination), WTFMove(copySize));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionCopyBufferToTexture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUCommandEncoder>::call<jsWebGPUCommandEncoderPrototypeFunctionCopyBufferToTextureBody>(*lexicalGlobalObject, *callFrame, "copyBufferToTexture");
}

static inline JSC::EncodedJSValue jsWebGPUCommandEncoderPrototypeFunctionCopyTextureToBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUCommandEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto source = convert<IDLDictionary<WebGPUTextureCopyView>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto destination = convert<IDLDictionary<WebGPUBufferCopyView>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto copySize = convert<IDLDictionary<GPUExtent3D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.copyTextureToBuffer(WTFMove(source), WTFMove(destination), WTFMove(copySize));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionCopyTextureToBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUCommandEncoder>::call<jsWebGPUCommandEncoderPrototypeFunctionCopyTextureToBufferBody>(*lexicalGlobalObject, *callFrame, "copyTextureToBuffer");
}

static inline JSC::EncodedJSValue jsWebGPUCommandEncoderPrototypeFunctionCopyTextureToTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUCommandEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto source = convert<IDLDictionary<WebGPUTextureCopyView>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto destination = convert<IDLDictionary<WebGPUTextureCopyView>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto copySize = convert<IDLDictionary<GPUExtent3D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.copyTextureToTexture(WTFMove(source), WTFMove(destination), WTFMove(copySize));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionCopyTextureToTexture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUCommandEncoder>::call<jsWebGPUCommandEncoderPrototypeFunctionCopyTextureToTextureBody>(*lexicalGlobalObject, *callFrame, "copyTextureToTexture");
}

static inline JSC::EncodedJSValue jsWebGPUCommandEncoderPrototypeFunctionFinishBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUCommandEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<WebGPUCommandBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.finish()));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUCommandEncoderPrototypeFunctionFinish(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUCommandEncoder>::call<jsWebGPUCommandEncoderPrototypeFunctionFinishBody>(*lexicalGlobalObject, *callFrame, "finish");
}

void JSWebGPUCommandEncoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGPUCommandEncoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGPUCommandEncoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGPUCommandEncoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGPUCommandEncoder = static_cast<JSWebGPUCommandEncoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGPUCommandEncoder->wrapped(), jsWebGPUCommandEncoder);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGPUCommandEncoder>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to WebGPUCommandEncoder.
    static_assert(!std::is_polymorphic<WebGPUCommandEncoder>::value, "WebGPUCommandEncoder is polymorphic but the IDL claims it is not");
    return createWrapper<WebGPUCommandEncoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGPUCommandEncoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGPUCommandEncoder* JSWebGPUCommandEncoder::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGPUCommandEncoder*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGPU)
