/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPUComputePassEncoder.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebGPUComputePipeline.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUComputePassEncoderPrototypeFunctionSetPipeline(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUComputePassEncoderPrototypeFunctionDispatch(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsWebGPUComputePassEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGPUComputePassEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGPUComputePassEncoderPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGPUComputePassEncoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGPUComputePassEncoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGPUComputePassEncoderPrototype>(vm.heap)) JSWebGPUComputePassEncoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGPUComputePassEncoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGPUComputePassEncoderPrototype, JSWebGPUComputePassEncoderPrototype::Base);

using JSWebGPUComputePassEncoderConstructor = JSDOMConstructorNotConstructable<JSWebGPUComputePassEncoder>;

template<> JSValue JSWebGPUComputePassEncoderConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSWebGPUProgrammablePassEncoder::getConstructor(vm, &globalObject);
}

template<> void JSWebGPUComputePassEncoderConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGPUComputePassEncoder::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GPUComputePassEncoder"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGPUComputePassEncoderConstructor::s_info = { "GPUComputePassEncoder", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUComputePassEncoderConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGPUComputePassEncoderPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGPUComputePassEncoderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGPUComputePassEncoderConstructor) } },
    { "setPipeline", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUComputePassEncoderPrototypeFunctionSetPipeline), (intptr_t) (1) } },
    { "dispatch", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUComputePassEncoderPrototypeFunctionDispatch), (intptr_t) (3) } },
};

const ClassInfo JSWebGPUComputePassEncoderPrototype::s_info = { "GPUComputePassEncoderPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUComputePassEncoderPrototype) };

void JSWebGPUComputePassEncoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGPUComputePassEncoder::info(), JSWebGPUComputePassEncoderPrototypeTableValues, *this);
}

const ClassInfo JSWebGPUComputePassEncoder::s_info = { "GPUComputePassEncoder", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUComputePassEncoder) };

JSWebGPUComputePassEncoder::JSWebGPUComputePassEncoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGPUComputePassEncoder>&& impl)
    : JSWebGPUProgrammablePassEncoder(structure, globalObject, WTFMove(impl))
{
}

void JSWebGPUComputePassEncoder::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGPUComputePassEncoder>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGPUComputePassEncoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGPUComputePassEncoderPrototype::create(vm, &globalObject, JSWebGPUComputePassEncoderPrototype::createStructure(vm, &globalObject, JSWebGPUProgrammablePassEncoder::prototype(vm, globalObject)));
}

JSObject* JSWebGPUComputePassEncoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGPUComputePassEncoder>(vm, globalObject);
}

JSValue JSWebGPUComputePassEncoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGPUComputePassEncoderConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSWebGPUComputePassEncoder* IDLOperation<JSWebGPUComputePassEncoder>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebGPUComputePassEncoder*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsWebGPUComputePassEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUComputePassEncoderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGPUComputePassEncoder::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGPUComputePassEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUComputePassEncoderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsWebGPUComputePassEncoderPrototypeFunctionSetPipelineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUComputePassEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto pipeline = convert<IDLInterface<WebGPUComputePipeline>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "pipeline", "GPUComputePassEncoder", "setPipeline", "WebGPUComputePipeline"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPipeline(*pipeline);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUComputePassEncoderPrototypeFunctionSetPipeline(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUComputePassEncoder>::call<jsWebGPUComputePassEncoderPrototypeFunctionSetPipelineBody>(*lexicalGlobalObject, *callFrame, "setPipeline");
}

static inline JSC::EncodedJSValue jsWebGPUComputePassEncoderPrototypeFunctionDispatchBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUComputePassEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.dispatch(WTFMove(x), WTFMove(y), WTFMove(z));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUComputePassEncoderPrototypeFunctionDispatch(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUComputePassEncoder>::call<jsWebGPUComputePassEncoderPrototypeFunctionDispatchBody>(*lexicalGlobalObject, *callFrame, "dispatch");
}

void JSWebGPUComputePassEncoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGPUComputePassEncoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGPUComputePassEncoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24WebGPUComputePassEncoderE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGPUComputePassEncoder>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGPUComputePassEncoder@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore24WebGPUComputePassEncoderE[2];
#endif

    // If this fails WebGPUComputePassEncoder does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGPUComputePassEncoder>::value, "WebGPUComputePassEncoder is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGPUComputePassEncoder has subclasses. If WebGPUComputePassEncoder has subclasses that get passed
    // to toJS() we currently require WebGPUComputePassEncoder you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGPUComputePassEncoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGPUComputePassEncoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEBGPU)
