/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPUProgrammablePassEncoder.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebGPUBindGroup.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUProgrammablePassEncoderPrototypeFunctionEndPass(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUProgrammablePassEncoderPrototypeFunctionSetBindGroup(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsWebGPUProgrammablePassEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGPUProgrammablePassEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGPUProgrammablePassEncoderPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGPUProgrammablePassEncoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGPUProgrammablePassEncoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGPUProgrammablePassEncoderPrototype>(vm.heap)) JSWebGPUProgrammablePassEncoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGPUProgrammablePassEncoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGPUProgrammablePassEncoderPrototype, JSWebGPUProgrammablePassEncoderPrototype::Base);

using JSWebGPUProgrammablePassEncoderConstructor = JSDOMConstructorNotConstructable<JSWebGPUProgrammablePassEncoder>;

template<> JSValue JSWebGPUProgrammablePassEncoderConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGPUProgrammablePassEncoderConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGPUProgrammablePassEncoder::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GPUProgrammablePassEncoder"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGPUProgrammablePassEncoderConstructor::s_info = { "GPUProgrammablePassEncoder", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUProgrammablePassEncoderConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGPUProgrammablePassEncoderPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGPUProgrammablePassEncoderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGPUProgrammablePassEncoderConstructor) } },
    { "endPass", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUProgrammablePassEncoderPrototypeFunctionEndPass), (intptr_t) (0) } },
    { "setBindGroup", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUProgrammablePassEncoderPrototypeFunctionSetBindGroup), (intptr_t) (2) } },
};

const ClassInfo JSWebGPUProgrammablePassEncoderPrototype::s_info = { "GPUProgrammablePassEncoderPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUProgrammablePassEncoderPrototype) };

void JSWebGPUProgrammablePassEncoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGPUProgrammablePassEncoder::info(), JSWebGPUProgrammablePassEncoderPrototypeTableValues, *this);
}

const ClassInfo JSWebGPUProgrammablePassEncoder::s_info = { "GPUProgrammablePassEncoder", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUProgrammablePassEncoder) };

JSWebGPUProgrammablePassEncoder::JSWebGPUProgrammablePassEncoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGPUProgrammablePassEncoder>&& impl)
    : JSDOMWrapper<WebGPUProgrammablePassEncoder>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGPUProgrammablePassEncoder::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGPUProgrammablePassEncoder>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGPUProgrammablePassEncoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGPUProgrammablePassEncoderPrototype::create(vm, &globalObject, JSWebGPUProgrammablePassEncoderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGPUProgrammablePassEncoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGPUProgrammablePassEncoder>(vm, globalObject);
}

JSValue JSWebGPUProgrammablePassEncoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGPUProgrammablePassEncoderConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGPUProgrammablePassEncoder::destroy(JSC::JSCell* cell)
{
    JSWebGPUProgrammablePassEncoder* thisObject = static_cast<JSWebGPUProgrammablePassEncoder*>(cell);
    thisObject->JSWebGPUProgrammablePassEncoder::~JSWebGPUProgrammablePassEncoder();
}

template<> inline JSWebGPUProgrammablePassEncoder* IDLOperation<JSWebGPUProgrammablePassEncoder>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebGPUProgrammablePassEncoder*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsWebGPUProgrammablePassEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUProgrammablePassEncoderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGPUProgrammablePassEncoder::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGPUProgrammablePassEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUProgrammablePassEncoderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsWebGPUProgrammablePassEncoderPrototypeFunctionEndPassBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUProgrammablePassEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.endPass();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUProgrammablePassEncoderPrototypeFunctionEndPass(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUProgrammablePassEncoder>::call<jsWebGPUProgrammablePassEncoderPrototypeFunctionEndPassBody>(*lexicalGlobalObject, *callFrame, "endPass");
}

static inline JSC::EncodedJSValue jsWebGPUProgrammablePassEncoderPrototypeFunctionSetBindGroupBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUProgrammablePassEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto bindGroup = convert<IDLInterface<WebGPUBindGroup>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "bindGroup", "GPUProgrammablePassEncoder", "setBindGroup", "WebGPUBindGroup"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setBindGroup(WTFMove(index), *bindGroup);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUProgrammablePassEncoderPrototypeFunctionSetBindGroup(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUProgrammablePassEncoder>::call<jsWebGPUProgrammablePassEncoderPrototypeFunctionSetBindGroupBody>(*lexicalGlobalObject, *callFrame, "setBindGroup");
}

void JSWebGPUProgrammablePassEncoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGPUProgrammablePassEncoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGPUProgrammablePassEncoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGPUProgrammablePassEncoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGPUProgrammablePassEncoder = static_cast<JSWebGPUProgrammablePassEncoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGPUProgrammablePassEncoder->wrapped(), jsWebGPUProgrammablePassEncoder);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGPUProgrammablePassEncoder>&& impl)
{
    return createWrapper<WebGPUProgrammablePassEncoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGPUProgrammablePassEncoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGPUProgrammablePassEncoder* JSWebGPUProgrammablePassEncoder::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGPUProgrammablePassEncoder*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGPU)
