/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPURenderPassDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSGPUColor.h"
#include "JSGPULoadOp.h"
#include "JSGPUStoreOp.h"
#include "JSWebGPUTextureView.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> WebGPURenderPassDescriptor convertDictionary<WebGPURenderPassDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebGPURenderPassDescriptor result;
    JSValue colorAttachmentsValue;
    if (isNullOrUndefined)
        colorAttachmentsValue = jsUndefined();
    else {
        colorAttachmentsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorAttachments"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!colorAttachmentsValue.isUndefined()) {
        result.colorAttachments = convert<IDLSequence<IDLDictionary<WebGPURenderPassColorAttachmentDescriptor>>>(lexicalGlobalObject, colorAttachmentsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "colorAttachments", "WebGPURenderPassDescriptor", "sequence");
        return { };
    }
    JSValue depthStencilAttachmentValue;
    if (isNullOrUndefined)
        depthStencilAttachmentValue = jsUndefined();
    else {
        depthStencilAttachmentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthStencilAttachment"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthStencilAttachmentValue.isUndefined()) {
        result.depthStencilAttachment = convert<IDLNullable<IDLDictionary<WebGPURenderPassDepthStencilAttachmentDescriptor>>>(lexicalGlobalObject, depthStencilAttachmentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.depthStencilAttachment = WTF::nullopt;
    return result;
}

#endif

#if ENABLE(WEBGPU)

template<> WebGPURenderPassColorAttachmentDescriptor convertDictionary<WebGPURenderPassColorAttachmentDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebGPURenderPassColorAttachmentDescriptor result;
    JSValue attachmentValue;
    if (isNullOrUndefined)
        attachmentValue = jsUndefined();
    else {
        attachmentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attachment"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!attachmentValue.isUndefined()) {
        result.attachment = convert<IDLInterface<WebGPUTextureView>>(lexicalGlobalObject, attachmentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "attachment", "GPURenderPassColorAttachmentDescriptor", "WebGPUTextureView");
        return { };
    }
    JSValue clearColorValue;
    if (isNullOrUndefined)
        clearColorValue = jsUndefined();
    else {
        clearColorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clearColor"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clearColorValue.isUndefined()) {
        result.clearColor = convert<IDLDictionary<GPUColor>>(lexicalGlobalObject, clearColorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue loadOpValue;
    if (isNullOrUndefined)
        loadOpValue = jsUndefined();
    else {
        loadOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "loadOp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!loadOpValue.isUndefined()) {
        result.loadOp = convert<IDLEnumeration<GPULoadOp>>(lexicalGlobalObject, loadOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "loadOp", "GPURenderPassColorAttachmentDescriptor", "GPULoadOp");
        return { };
    }
    JSValue storeOpValue;
    if (isNullOrUndefined)
        storeOpValue = jsUndefined();
    else {
        storeOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "storeOp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!storeOpValue.isUndefined()) {
        result.storeOp = convert<IDLEnumeration<GPUStoreOp>>(lexicalGlobalObject, storeOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "storeOp", "GPURenderPassColorAttachmentDescriptor", "GPUStoreOp");
        return { };
    }
    return result;
}

#endif

#if ENABLE(WEBGPU)

template<> WebGPURenderPassDepthStencilAttachmentDescriptor convertDictionary<WebGPURenderPassDepthStencilAttachmentDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebGPURenderPassDepthStencilAttachmentDescriptor result;
    JSValue attachmentValue;
    if (isNullOrUndefined)
        attachmentValue = jsUndefined();
    else {
        attachmentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attachment"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!attachmentValue.isUndefined()) {
        result.attachment = convert<IDLInterface<WebGPUTextureView>>(lexicalGlobalObject, attachmentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "attachment", "GPURenderPassDepthStencilAttachmentDescriptor", "WebGPUTextureView");
        return { };
    }
    JSValue clearDepthValue;
    if (isNullOrUndefined)
        clearDepthValue = jsUndefined();
    else {
        clearDepthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clearDepth"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clearDepthValue.isUndefined()) {
        result.clearDepth = convert<IDLFloat>(lexicalGlobalObject, clearDepthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "clearDepth", "GPURenderPassDepthStencilAttachmentDescriptor", "float");
        return { };
    }
    JSValue depthLoadOpValue;
    if (isNullOrUndefined)
        depthLoadOpValue = jsUndefined();
    else {
        depthLoadOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthLoadOp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthLoadOpValue.isUndefined()) {
        result.depthLoadOp = convert<IDLEnumeration<GPULoadOp>>(lexicalGlobalObject, depthLoadOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "depthLoadOp", "GPURenderPassDepthStencilAttachmentDescriptor", "GPULoadOp");
        return { };
    }
    JSValue depthStoreOpValue;
    if (isNullOrUndefined)
        depthStoreOpValue = jsUndefined();
    else {
        depthStoreOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthStoreOp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthStoreOpValue.isUndefined()) {
        result.depthStoreOp = convert<IDLEnumeration<GPUStoreOp>>(lexicalGlobalObject, depthStoreOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "depthStoreOp", "GPURenderPassDepthStencilAttachmentDescriptor", "GPUStoreOp");
        return { };
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEBGPU)
