/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPURenderPassEncoder.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUColor.h"
#include "JSWebGPUBuffer.h"
#include "JSWebGPURenderPipeline.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionSetPipeline(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionSetBlendColor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionSetViewport(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionSetScissorRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionSetIndexBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionSetVertexBuffers(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionDraw(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionDrawIndexed(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsWebGPURenderPassEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGPURenderPassEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGPURenderPassEncoderPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGPURenderPassEncoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGPURenderPassEncoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGPURenderPassEncoderPrototype>(vm.heap)) JSWebGPURenderPassEncoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGPURenderPassEncoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGPURenderPassEncoderPrototype, JSWebGPURenderPassEncoderPrototype::Base);

using JSWebGPURenderPassEncoderConstructor = JSDOMConstructorNotConstructable<JSWebGPURenderPassEncoder>;

template<> JSValue JSWebGPURenderPassEncoderConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSWebGPUProgrammablePassEncoder::getConstructor(vm, &globalObject);
}

template<> void JSWebGPURenderPassEncoderConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGPURenderPassEncoder::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GPURenderPassEncoder"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGPURenderPassEncoderConstructor::s_info = { "GPURenderPassEncoder", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPURenderPassEncoderConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGPURenderPassEncoderPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGPURenderPassEncoderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGPURenderPassEncoderConstructor) } },
    { "setPipeline", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPURenderPassEncoderPrototypeFunctionSetPipeline), (intptr_t) (1) } },
    { "setBlendColor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPURenderPassEncoderPrototypeFunctionSetBlendColor), (intptr_t) (1) } },
    { "setViewport", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPURenderPassEncoderPrototypeFunctionSetViewport), (intptr_t) (6) } },
    { "setScissorRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPURenderPassEncoderPrototypeFunctionSetScissorRect), (intptr_t) (4) } },
    { "setIndexBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPURenderPassEncoderPrototypeFunctionSetIndexBuffer), (intptr_t) (2) } },
    { "setVertexBuffers", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPURenderPassEncoderPrototypeFunctionSetVertexBuffers), (intptr_t) (3) } },
    { "draw", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPURenderPassEncoderPrototypeFunctionDraw), (intptr_t) (4) } },
    { "drawIndexed", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPURenderPassEncoderPrototypeFunctionDrawIndexed), (intptr_t) (5) } },
};

const ClassInfo JSWebGPURenderPassEncoderPrototype::s_info = { "GPURenderPassEncoderPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPURenderPassEncoderPrototype) };

void JSWebGPURenderPassEncoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGPURenderPassEncoder::info(), JSWebGPURenderPassEncoderPrototypeTableValues, *this);
}

const ClassInfo JSWebGPURenderPassEncoder::s_info = { "GPURenderPassEncoder", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPURenderPassEncoder) };

JSWebGPURenderPassEncoder::JSWebGPURenderPassEncoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGPURenderPassEncoder>&& impl)
    : JSWebGPUProgrammablePassEncoder(structure, globalObject, WTFMove(impl))
{
}

void JSWebGPURenderPassEncoder::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGPURenderPassEncoder>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGPURenderPassEncoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGPURenderPassEncoderPrototype::create(vm, &globalObject, JSWebGPURenderPassEncoderPrototype::createStructure(vm, &globalObject, JSWebGPUProgrammablePassEncoder::prototype(vm, globalObject)));
}

JSObject* JSWebGPURenderPassEncoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGPURenderPassEncoder>(vm, globalObject);
}

JSValue JSWebGPURenderPassEncoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGPURenderPassEncoderConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSWebGPURenderPassEncoder* IDLOperation<JSWebGPURenderPassEncoder>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebGPURenderPassEncoder*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsWebGPURenderPassEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPURenderPassEncoderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGPURenderPassEncoder::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGPURenderPassEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPURenderPassEncoderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsWebGPURenderPassEncoderPrototypeFunctionSetPipelineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPURenderPassEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto pipeline = convert<IDLInterface<WebGPURenderPipeline>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "pipeline", "GPURenderPassEncoder", "setPipeline", "WebGPURenderPipeline"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPipeline(*pipeline);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionSetPipeline(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPURenderPassEncoder>::call<jsWebGPURenderPassEncoderPrototypeFunctionSetPipelineBody>(*lexicalGlobalObject, *callFrame, "setPipeline");
}

static inline JSC::EncodedJSValue jsWebGPURenderPassEncoderPrototypeFunctionSetBlendColorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPURenderPassEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto color = convert<IDLDictionary<GPUColor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setBlendColor(WTFMove(color));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionSetBlendColor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPURenderPassEncoder>::call<jsWebGPURenderPassEncoderPrototypeFunctionSetBlendColorBody>(*lexicalGlobalObject, *callFrame, "setBlendColor");
}

static inline JSC::EncodedJSValue jsWebGPURenderPassEncoderPrototypeFunctionSetViewportBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPURenderPassEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto minDepth = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto maxDepth = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setViewport(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height), WTFMove(minDepth), WTFMove(maxDepth));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionSetViewport(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPURenderPassEncoder>::call<jsWebGPURenderPassEncoderPrototypeFunctionSetViewportBody>(*lexicalGlobalObject, *callFrame, "setViewport");
}

static inline JSC::EncodedJSValue jsWebGPURenderPassEncoderPrototypeFunctionSetScissorRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPURenderPassEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setScissorRect(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionSetScissorRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPURenderPassEncoder>::call<jsWebGPURenderPassEncoderPrototypeFunctionSetScissorRectBody>(*lexicalGlobalObject, *callFrame, "setScissorRect");
}

static inline JSC::EncodedJSValue jsWebGPURenderPassEncoderPrototypeFunctionSetIndexBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPURenderPassEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLInterface<WebGPUBuffer>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "GPURenderPassEncoder", "setIndexBuffer", "WebGPUBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLUnsignedLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setIndexBuffer(*buffer, WTFMove(offset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionSetIndexBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPURenderPassEncoder>::call<jsWebGPURenderPassEncoderPrototypeFunctionSetIndexBufferBody>(*lexicalGlobalObject, *callFrame, "setIndexBuffer");
}

static inline JSC::EncodedJSValue jsWebGPURenderPassEncoderPrototypeFunctionSetVertexBuffersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPURenderPassEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto startSlot = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto buffers = convert<IDLSequence<IDLInterface<WebGPUBuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offsets = convert<IDLSequence<IDLUnsignedLongLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setVertexBuffers(WTFMove(startSlot), WTFMove(buffers), WTFMove(offsets));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionSetVertexBuffers(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPURenderPassEncoder>::call<jsWebGPURenderPassEncoderPrototypeFunctionSetVertexBuffersBody>(*lexicalGlobalObject, *callFrame, "setVertexBuffers");
}

static inline JSC::EncodedJSValue jsWebGPURenderPassEncoderPrototypeFunctionDrawBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPURenderPassEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto vertexCount = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto instanceCount = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto firstVertex = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto firstInstance = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.draw(WTFMove(vertexCount), WTFMove(instanceCount), WTFMove(firstVertex), WTFMove(firstInstance));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionDraw(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPURenderPassEncoder>::call<jsWebGPURenderPassEncoderPrototypeFunctionDrawBody>(*lexicalGlobalObject, *callFrame, "draw");
}

static inline JSC::EncodedJSValue jsWebGPURenderPassEncoderPrototypeFunctionDrawIndexedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPURenderPassEncoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto indexCount = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto instanceCount = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto firstIndex = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto baseVertex = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto firstInstance = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.drawIndexed(WTFMove(indexCount), WTFMove(instanceCount), WTFMove(firstIndex), WTFMove(baseVertex), WTFMove(firstInstance));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPURenderPassEncoderPrototypeFunctionDrawIndexed(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPURenderPassEncoder>::call<jsWebGPURenderPassEncoderPrototypeFunctionDrawIndexedBody>(*lexicalGlobalObject, *callFrame, "drawIndexed");
}

void JSWebGPURenderPassEncoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGPURenderPassEncoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGPURenderPassEncoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore23WebGPURenderPassEncoderE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGPURenderPassEncoder>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGPURenderPassEncoder@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore23WebGPURenderPassEncoderE[2];
#endif

    // If this fails WebGPURenderPassEncoder does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGPURenderPassEncoder>::value, "WebGPURenderPassEncoder is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGPURenderPassEncoder has subclasses. If WebGPURenderPassEncoder has subclasses that get passed
    // to toJS() we currently require WebGPURenderPassEncoder you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGPURenderPassEncoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGPURenderPassEncoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEBGPU)
