/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPURenderPipelineDescriptor.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertSequences.h"
#include "JSGPUColorStateDescriptor.h"
#include "JSGPUDepthStencilStateDescriptor.h"
#include "JSGPUVertexInputDescriptor.h"
#include "JSWebGPUPipelineLayout.h"
#include "JSWebGPUProgrammableStageDescriptor.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> WebGPURenderPipelineDescriptor convertDictionary<WebGPURenderPipelineDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebGPURenderPipelineDescriptor result;
    JSValue layoutValue;
    if (isNullOrUndefined)
        layoutValue = jsUndefined();
    else {
        layoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "layout"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!layoutValue.isUndefined()) {
        result.layout = convert<IDLNullable<IDLInterface<WebGPUPipelineLayout>>>(lexicalGlobalObject, layoutValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.layout = nullptr;
    JSValue colorStatesValue;
    if (isNullOrUndefined)
        colorStatesValue = jsUndefined();
    else {
        colorStatesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorStates"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!colorStatesValue.isUndefined()) {
        result.colorStates = convert<IDLSequence<IDLDictionary<GPUColorStateDescriptor>>>(lexicalGlobalObject, colorStatesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "colorStates", "WebGPURenderPipelineDescriptor", "sequence");
        return { };
    }
    JSValue depthStencilStateValue;
    if (isNullOrUndefined)
        depthStencilStateValue = jsUndefined();
    else {
        depthStencilStateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthStencilState"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthStencilStateValue.isUndefined()) {
        result.depthStencilState = convert<IDLNullable<IDLDictionary<GPUDepthStencilStateDescriptor>>>(lexicalGlobalObject, depthStencilStateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.depthStencilState = WTF::nullopt;
    JSValue fragmentStageValue;
    if (isNullOrUndefined)
        fragmentStageValue = jsUndefined();
    else {
        fragmentStageValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fragmentStage"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fragmentStageValue.isUndefined()) {
        result.fragmentStage = convert<IDLNullable<IDLDictionary<WebGPUProgrammableStageDescriptor>>>(lexicalGlobalObject, fragmentStageValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.fragmentStage = WTF::nullopt;
    JSValue primitiveTopologyValue;
    if (isNullOrUndefined)
        primitiveTopologyValue = jsUndefined();
    else {
        primitiveTopologyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "primitiveTopology"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!primitiveTopologyValue.isUndefined()) {
        result.primitiveTopology = convert<IDLEnumeration<GPUPrimitiveTopology>>(lexicalGlobalObject, primitiveTopologyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "primitiveTopology", "WebGPURenderPipelineDescriptor", "GPUPrimitiveTopology");
        return { };
    }
    JSValue vertexInputValue;
    if (isNullOrUndefined)
        vertexInputValue = jsUndefined();
    else {
        vertexInputValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "vertexInput"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!vertexInputValue.isUndefined()) {
        result.vertexInput = convert<IDLDictionary<GPUVertexInputDescriptor>>(lexicalGlobalObject, vertexInputValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "vertexInput", "WebGPURenderPipelineDescriptor", "GPUVertexInputDescriptor");
        return { };
    }
    JSValue vertexStageValue;
    if (isNullOrUndefined)
        vertexStageValue = jsUndefined();
    else {
        vertexStageValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "vertexStage"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!vertexStageValue.isUndefined()) {
        result.vertexStage = convert<IDLDictionary<WebGPUProgrammableStageDescriptor>>(lexicalGlobalObject, vertexStageValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "vertexStage", "WebGPURenderPipelineDescriptor", "WebGPUProgrammableStageDescriptor");
        return { };
    }
    return result;
}

#endif

String convertEnumerationToString(GPUPrimitiveTopology enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("point-list"),
        MAKE_STATIC_STRING_IMPL("line-list"),
        MAKE_STATIC_STRING_IMPL("line-strip"),
        MAKE_STATIC_STRING_IMPL("triangle-list"),
        MAKE_STATIC_STRING_IMPL("triangle-strip"),
    };
    static_assert(static_cast<size_t>(GPUPrimitiveTopology::PointList) == 0, "GPUPrimitiveTopology::PointList is not 0 as expected");
    static_assert(static_cast<size_t>(GPUPrimitiveTopology::LineList) == 1, "GPUPrimitiveTopology::LineList is not 1 as expected");
    static_assert(static_cast<size_t>(GPUPrimitiveTopology::LineStrip) == 2, "GPUPrimitiveTopology::LineStrip is not 2 as expected");
    static_assert(static_cast<size_t>(GPUPrimitiveTopology::TriangleList) == 3, "GPUPrimitiveTopology::TriangleList is not 3 as expected");
    static_assert(static_cast<size_t>(GPUPrimitiveTopology::TriangleStrip) == 4, "GPUPrimitiveTopology::TriangleStrip is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUPrimitiveTopology enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUPrimitiveTopology> parseEnumeration<GPUPrimitiveTopology>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "point-list")
        return GPUPrimitiveTopology::PointList;
    if (stringValue == "line-list")
        return GPUPrimitiveTopology::LineList;
    if (stringValue == "line-strip")
        return GPUPrimitiveTopology::LineStrip;
    if (stringValue == "triangle-list")
        return GPUPrimitiveTopology::TriangleList;
    if (stringValue == "triangle-strip")
        return GPUPrimitiveTopology::TriangleStrip;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUPrimitiveTopology>()
{
    return "\"point-list\", \"line-list\", \"line-strip\", \"triangle-list\", \"triangle-strip\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGPU)
