/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWheelEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventTarget.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> WheelEvent::Init convertDictionary<WheelEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WheelEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detailValue.isUndefined()) {
        result.detail = convert<IDLLong>(lexicalGlobalObject, detailValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.detail = 0;
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewValue.isUndefined()) {
        result.view = convert<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.view = nullptr;
    JSValue altKeyValue;
    if (isNullOrUndefined)
        altKeyValue = jsUndefined();
    else {
        altKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "altKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!altKeyValue.isUndefined()) {
        result.altKey = convert<IDLBoolean>(lexicalGlobalObject, altKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.altKey = false;
    JSValue ctrlKeyValue;
    if (isNullOrUndefined)
        ctrlKeyValue = jsUndefined();
    else {
        ctrlKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ctrlKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ctrlKeyValue.isUndefined()) {
        result.ctrlKey = convert<IDLBoolean>(lexicalGlobalObject, ctrlKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.ctrlKey = false;
    JSValue metaKeyValue;
    if (isNullOrUndefined)
        metaKeyValue = jsUndefined();
    else {
        metaKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "metaKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!metaKeyValue.isUndefined()) {
        result.metaKey = convert<IDLBoolean>(lexicalGlobalObject, metaKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.metaKey = false;
    JSValue modifierAltGraphValue;
    if (isNullOrUndefined)
        modifierAltGraphValue = jsUndefined();
    else {
        modifierAltGraphValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierAltGraph"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modifierAltGraphValue.isUndefined()) {
        result.modifierAltGraph = convert<IDLBoolean>(lexicalGlobalObject, modifierAltGraphValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.modifierAltGraph = false;
    JSValue modifierCapsLockValue;
    if (isNullOrUndefined)
        modifierCapsLockValue = jsUndefined();
    else {
        modifierCapsLockValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierCapsLock"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modifierCapsLockValue.isUndefined()) {
        result.modifierCapsLock = convert<IDLBoolean>(lexicalGlobalObject, modifierCapsLockValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.modifierCapsLock = false;
    JSValue shiftKeyValue;
    if (isNullOrUndefined)
        shiftKeyValue = jsUndefined();
    else {
        shiftKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shiftKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!shiftKeyValue.isUndefined()) {
        result.shiftKey = convert<IDLBoolean>(lexicalGlobalObject, shiftKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.shiftKey = false;
    JSValue buttonValue;
    if (isNullOrUndefined)
        buttonValue = jsUndefined();
    else {
        buttonValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "button"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!buttonValue.isUndefined()) {
        result.button = convert<IDLShort>(lexicalGlobalObject, buttonValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.button = 0;
    JSValue buttonsValue;
    if (isNullOrUndefined)
        buttonsValue = jsUndefined();
    else {
        buttonsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buttons"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!buttonsValue.isUndefined()) {
        result.buttons = convert<IDLUnsignedShort>(lexicalGlobalObject, buttonsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.buttons = 0;
    JSValue clientXValue;
    if (isNullOrUndefined)
        clientXValue = jsUndefined();
    else {
        clientXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientX"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clientXValue.isUndefined()) {
        result.clientX = convert<IDLLong>(lexicalGlobalObject, clientXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.clientX = 0;
    JSValue clientYValue;
    if (isNullOrUndefined)
        clientYValue = jsUndefined();
    else {
        clientYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientY"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clientYValue.isUndefined()) {
        result.clientY = convert<IDLLong>(lexicalGlobalObject, clientYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.clientY = 0;
    JSValue relatedTargetValue;
    if (isNullOrUndefined)
        relatedTargetValue = jsUndefined();
    else {
        relatedTargetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "relatedTarget"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!relatedTargetValue.isUndefined()) {
        result.relatedTarget = convert<IDLNullable<IDLInterface<EventTarget>>>(lexicalGlobalObject, relatedTargetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.relatedTarget = nullptr;
    JSValue screenXValue;
    if (isNullOrUndefined)
        screenXValue = jsUndefined();
    else {
        screenXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenX"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!screenXValue.isUndefined()) {
        result.screenX = convert<IDLLong>(lexicalGlobalObject, screenXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.screenX = 0;
    JSValue screenYValue;
    if (isNullOrUndefined)
        screenYValue = jsUndefined();
    else {
        screenYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenY"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!screenYValue.isUndefined()) {
        result.screenY = convert<IDLLong>(lexicalGlobalObject, screenYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.screenY = 0;
    JSValue deltaModeValue;
    if (isNullOrUndefined)
        deltaModeValue = jsUndefined();
    else {
        deltaModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deltaMode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deltaModeValue.isUndefined()) {
        result.deltaMode = convert<IDLUnsignedLong>(lexicalGlobalObject, deltaModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.deltaMode = 0;
    JSValue deltaXValue;
    if (isNullOrUndefined)
        deltaXValue = jsUndefined();
    else {
        deltaXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deltaX"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deltaXValue.isUndefined()) {
        result.deltaX = convert<IDLDouble>(lexicalGlobalObject, deltaXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.deltaX = 0.0;
    JSValue deltaYValue;
    if (isNullOrUndefined)
        deltaYValue = jsUndefined();
    else {
        deltaYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deltaY"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deltaYValue.isUndefined()) {
        result.deltaY = convert<IDLDouble>(lexicalGlobalObject, deltaYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.deltaY = 0.0;
    JSValue deltaZValue;
    if (isNullOrUndefined)
        deltaZValue = jsUndefined();
    else {
        deltaZValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deltaZ"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deltaZValue.isUndefined()) {
        result.deltaZ = convert<IDLDouble>(lexicalGlobalObject, deltaZValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.deltaZ = 0.0;
    JSValue wheelDeltaXValue;
    if (isNullOrUndefined)
        wheelDeltaXValue = jsUndefined();
    else {
        wheelDeltaXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "wheelDeltaX"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!wheelDeltaXValue.isUndefined()) {
        result.wheelDeltaX = convert<IDLLong>(lexicalGlobalObject, wheelDeltaXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.wheelDeltaX = 0;
    JSValue wheelDeltaYValue;
    if (isNullOrUndefined)
        wheelDeltaYValue = jsUndefined();
    else {
        wheelDeltaYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "wheelDeltaY"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!wheelDeltaYValue.isUndefined()) {
        result.wheelDeltaY = convert<IDLLong>(lexicalGlobalObject, wheelDeltaYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.wheelDeltaY = 0;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWheelEventPrototypeFunctionInitWebKitWheelEvent(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsWheelEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWheelEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWheelEventDeltaX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventDeltaY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventDeltaZ(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventDeltaMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventWheelDeltaX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventWheelDeltaY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventWheelDelta(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventWebkitDirectionInvertedFromDevice(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSWheelEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWheelEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWheelEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSWheelEventPrototype>(vm.heap)) JSWheelEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWheelEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWheelEventPrototype, JSWheelEventPrototype::Base);

using JSWheelEventConstructor = JSDOMConstructor<JSWheelEvent>;

/* Hash table for constructor */

static const HashTableValue JSWheelEventConstructorTableValues[] =
{
    { "DOM_DELTA_PIXEL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x00) } },
    { "DOM_DELTA_LINE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x01) } },
    { "DOM_DELTA_PAGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x02) } },
};

static_assert(WheelEvent::DOM_DELTA_PIXEL == 0x00, "DOM_DELTA_PIXEL in WheelEvent does not match value from IDL");
static_assert(WheelEvent::DOM_DELTA_LINE == 0x01, "DOM_DELTA_LINE in WheelEvent does not match value from IDL");
static_assert(WheelEvent::DOM_DELTA_PAGE == 0x02, "DOM_DELTA_PAGE in WheelEvent does not match value from IDL");

template<> EncodedJSValue JSC_HOST_CALL JSWheelEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSWheelEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<WheelEvent::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = WheelEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<WheelEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSWheelEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSMouseEvent::getConstructor(vm, &globalObject);
}

template<> void JSWheelEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWheelEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("WheelEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSWheelEvent::info(), JSWheelEventConstructorTableValues, *this);
}

template<> const ClassInfo JSWheelEventConstructor::s_info = { "WheelEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWheelEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWheelEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWheelEventConstructor) } },
    { "deltaX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDeltaX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "deltaY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDeltaY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "deltaZ", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDeltaZ), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "deltaMode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDeltaMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "wheelDeltaX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWheelDeltaX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "wheelDeltaY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWheelDeltaY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "wheelDelta", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWheelDelta), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitDirectionInvertedFromDevice", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWebkitDirectionInvertedFromDevice), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "initWebKitWheelEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWheelEventPrototypeFunctionInitWebKitWheelEvent), (intptr_t) (0) } },
    { "DOM_DELTA_PIXEL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x00) } },
    { "DOM_DELTA_LINE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x01) } },
    { "DOM_DELTA_PAGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x02) } },
};

const ClassInfo JSWheelEventPrototype::s_info = { "WheelEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWheelEventPrototype) };

void JSWheelEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWheelEvent::info(), JSWheelEventPrototypeTableValues, *this);
}

const ClassInfo JSWheelEvent::s_info = { "WheelEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWheelEvent) };

JSWheelEvent::JSWheelEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WheelEvent>&& impl)
    : JSMouseEvent(structure, globalObject, WTFMove(impl))
{
}

void JSWheelEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WheelEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWheelEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWheelEventPrototype::create(vm, &globalObject, JSWheelEventPrototype::createStructure(vm, &globalObject, JSMouseEvent::prototype(vm, globalObject)));
}

JSObject* JSWheelEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWheelEvent>(vm, globalObject);
}

JSValue JSWheelEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWheelEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSWheelEvent* IDLAttribute<JSWheelEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSWheelEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSWheelEvent* IDLOperation<JSWheelEvent>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWheelEvent*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsWheelEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWheelEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWheelEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWheelEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWheelEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsWheelEventDeltaXGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.deltaX());
    return result;
}

EncodedJSValue jsWheelEventDeltaX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEventDeltaXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "deltaX");
}

static inline JSValue jsWheelEventDeltaYGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.deltaY());
    return result;
}

EncodedJSValue jsWheelEventDeltaY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEventDeltaYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "deltaY");
}

static inline JSValue jsWheelEventDeltaZGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.deltaZ());
    return result;
}

EncodedJSValue jsWheelEventDeltaZ(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEventDeltaZGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "deltaZ");
}

static inline JSValue jsWheelEventDeltaModeGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.deltaMode());
    return result;
}

EncodedJSValue jsWheelEventDeltaMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEventDeltaModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "deltaMode");
}

static inline JSValue jsWheelEventWheelDeltaXGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.wheelDeltaX());
    return result;
}

EncodedJSValue jsWheelEventWheelDeltaX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEventWheelDeltaXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "wheelDeltaX");
}

static inline JSValue jsWheelEventWheelDeltaYGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.wheelDeltaY());
    return result;
}

EncodedJSValue jsWheelEventWheelDeltaY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEventWheelDeltaYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "wheelDeltaY");
}

static inline JSValue jsWheelEventWheelDeltaGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.wheelDelta());
    return result;
}

EncodedJSValue jsWheelEventWheelDelta(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEventWheelDeltaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "wheelDelta");
}

static inline JSValue jsWheelEventWebkitDirectionInvertedFromDeviceGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitDirectionInvertedFromDevice());
    return result;
}

EncodedJSValue jsWheelEventWebkitDirectionInvertedFromDevice(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEventWebkitDirectionInvertedFromDeviceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitDirectionInvertedFromDevice");
}

static inline JSC::EncodedJSValue jsWheelEventPrototypeFunctionInitWebKitWheelEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWheelEvent>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto wheelDeltaX = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto wheelDeltaY = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto view = convert<IDLNullable<IDLInterface<WindowProxy>>>(*lexicalGlobalObject, callFrame->argument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "view", "WheelEvent", "initWebKitWheelEvent", "WindowProxy"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto screenX = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto screenY = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto clientX = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto clientY = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto ctrlKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto altKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto shiftKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto metaKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(10));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.initWebKitWheelEvent(WTFMove(wheelDeltaX), WTFMove(wheelDeltaY), WTFMove(view), WTFMove(screenX), WTFMove(screenY), WTFMove(clientX), WTFMove(clientY), WTFMove(ctrlKey), WTFMove(altKey), WTFMove(shiftKey), WTFMove(metaKey));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWheelEventPrototypeFunctionInitWebKitWheelEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWheelEvent>::call<jsWheelEventPrototypeFunctionInitWebKitWheelEventBody>(*lexicalGlobalObject, *callFrame, "initWebKitWheelEvent");
}

void JSWheelEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWheelEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WheelEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10WheelEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WheelEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WheelEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10WheelEventE[2];
#endif

    // If this fails WheelEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WheelEvent>::value, "WheelEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WheelEvent has subclasses. If WheelEvent has subclasses that get passed
    // to toJS() we currently require WheelEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WheelEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WheelEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
