/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequest.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMFormData.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDocument.h"
#include "JSEventListener.h"
#include "JSXMLHttpRequestUpload.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(XMLHttpRequest::ResponseType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        emptyString(),
        MAKE_STATIC_STRING_IMPL("arraybuffer"),
        MAKE_STATIC_STRING_IMPL("blob"),
        MAKE_STATIC_STRING_IMPL("document"),
        MAKE_STATIC_STRING_IMPL("json"),
        MAKE_STATIC_STRING_IMPL("text"),
    };
    static_assert(static_cast<size_t>(XMLHttpRequest::ResponseType::EmptyString) == 0, "XMLHttpRequest::ResponseType::EmptyString is not 0 as expected");
    static_assert(static_cast<size_t>(XMLHttpRequest::ResponseType::Arraybuffer) == 1, "XMLHttpRequest::ResponseType::Arraybuffer is not 1 as expected");
    static_assert(static_cast<size_t>(XMLHttpRequest::ResponseType::Blob) == 2, "XMLHttpRequest::ResponseType::Blob is not 2 as expected");
    static_assert(static_cast<size_t>(XMLHttpRequest::ResponseType::Document) == 3, "XMLHttpRequest::ResponseType::Document is not 3 as expected");
    static_assert(static_cast<size_t>(XMLHttpRequest::ResponseType::Json) == 4, "XMLHttpRequest::ResponseType::Json is not 4 as expected");
    static_assert(static_cast<size_t>(XMLHttpRequest::ResponseType::Text) == 5, "XMLHttpRequest::ResponseType::Text is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, XMLHttpRequest::ResponseType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<XMLHttpRequest::ResponseType> parseEnumeration<XMLHttpRequest::ResponseType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue.isEmpty())
        return XMLHttpRequest::ResponseType::EmptyString;
    if (stringValue == "arraybuffer")
        return XMLHttpRequest::ResponseType::Arraybuffer;
    if (stringValue == "blob")
        return XMLHttpRequest::ResponseType::Blob;
    if (stringValue == "document")
        return XMLHttpRequest::ResponseType::Document;
    if (stringValue == "json")
        return XMLHttpRequest::ResponseType::Json;
    if (stringValue == "text")
        return XMLHttpRequest::ResponseType::Text;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<XMLHttpRequest::ResponseType>()
{
    return "\"\", \"arraybuffer\", \"blob\", \"document\", \"json\", \"text\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionOpen(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionSetRequestHeader(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionSend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionAbort(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionGetResponseHeader(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionGetAllResponseHeaders(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionOverrideMimeType(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsXMLHttpRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestOnreadystatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestOnreadystatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestReadyState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestTimeout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestTimeout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestWithCredentials(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestWithCredentials(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestUpload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestResponseURL(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestStatus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestStatusText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestResponseType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestResponseType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestResponse(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestResponseText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestResponseXML(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSXMLHttpRequestPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXMLHttpRequestPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLHttpRequestPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLHttpRequestPrototype>(vm.heap)) JSXMLHttpRequestPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLHttpRequestPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLHttpRequestPrototype, JSXMLHttpRequestPrototype::Base);

using JSXMLHttpRequestConstructor = JSDOMConstructor<JSXMLHttpRequest>;

/* Hash table for constructor */

static const HashTableValue JSXMLHttpRequestConstructorTableValues[] =
{
    { "UNSENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "OPENED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "HEADERS_RECEIVED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "LOADING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "DONE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
};

static_assert(XMLHttpRequest::UNSENT == 0, "UNSENT in XMLHttpRequest does not match value from IDL");
static_assert(XMLHttpRequest::OPENED == 1, "OPENED in XMLHttpRequest does not match value from IDL");
static_assert(XMLHttpRequest::HEADERS_RECEIVED == 2, "HEADERS_RECEIVED in XMLHttpRequest does not match value from IDL");
static_assert(XMLHttpRequest::LOADING == 3, "LOADING in XMLHttpRequest does not match value from IDL");
static_assert(XMLHttpRequest::DONE == 4, "DONE in XMLHttpRequest does not match value from IDL");

template<> EncodedJSValue JSC_HOST_CALL JSXMLHttpRequestConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSXMLHttpRequestConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "XMLHttpRequest");
    auto object = XMLHttpRequest::create(*context);
    return JSValue::encode(toJSNewlyCreated<IDLInterface<XMLHttpRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSXMLHttpRequestConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSXMLHttpRequestEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSXMLHttpRequestConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXMLHttpRequest::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("XMLHttpRequest"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSXMLHttpRequest::info(), JSXMLHttpRequestConstructorTableValues, *this);
}

template<> const ClassInfo JSXMLHttpRequestConstructor::s_info = { "XMLHttpRequest", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestConstructor) } },
    { "onreadystatechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestOnreadystatechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestOnreadystatechange) } },
    { "readyState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "timeout", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestTimeout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestTimeout) } },
    { "withCredentials", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestWithCredentials), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestWithCredentials) } },
    { "upload", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUpload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseURL", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestResponseURL), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "status", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestStatus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "statusText", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestStatusText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseType", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestResponseType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestResponseType) } },
    { "response", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestResponse), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseText", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestResponseText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseXML", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestResponseXML), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "open", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXMLHttpRequestPrototypeFunctionOpen), (intptr_t) (2) } },
    { "setRequestHeader", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXMLHttpRequestPrototypeFunctionSetRequestHeader), (intptr_t) (2) } },
    { "send", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXMLHttpRequestPrototypeFunctionSend), (intptr_t) (0) } },
    { "abort", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXMLHttpRequestPrototypeFunctionAbort), (intptr_t) (0) } },
    { "getResponseHeader", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXMLHttpRequestPrototypeFunctionGetResponseHeader), (intptr_t) (1) } },
    { "getAllResponseHeaders", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXMLHttpRequestPrototypeFunctionGetAllResponseHeaders), (intptr_t) (0) } },
    { "overrideMimeType", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXMLHttpRequestPrototypeFunctionOverrideMimeType), (intptr_t) (1) } },
    { "UNSENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "OPENED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "HEADERS_RECEIVED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "LOADING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "DONE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
};

const ClassInfo JSXMLHttpRequestPrototype::s_info = { "XMLHttpRequestPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestPrototype) };

void JSXMLHttpRequestPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLHttpRequest::info(), JSXMLHttpRequestPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isDocument()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("responseXML"), strlen("responseXML"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSXMLHttpRequest::s_info = { "XMLHttpRequest", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequest) };

JSXMLHttpRequest::JSXMLHttpRequest(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLHttpRequest>&& impl)
    : JSXMLHttpRequestEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSXMLHttpRequest::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, XMLHttpRequest>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSXMLHttpRequest::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSXMLHttpRequestPrototype::create(vm, &globalObject, JSXMLHttpRequestPrototype::createStructure(vm, &globalObject, JSXMLHttpRequestEventTarget::prototype(vm, globalObject)));
}

JSObject* JSXMLHttpRequest::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXMLHttpRequest>(vm, globalObject);
}

JSValue JSXMLHttpRequest::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSXMLHttpRequest* IDLAttribute<JSXMLHttpRequest>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSXMLHttpRequest*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSXMLHttpRequest* IDLOperation<JSXMLHttpRequest>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSXMLHttpRequest*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsXMLHttpRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXMLHttpRequestPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXMLHttpRequest::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSXMLHttpRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXMLHttpRequestPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsXMLHttpRequestOnreadystatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().readystatechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsXMLHttpRequestOnreadystatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequestOnreadystatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onreadystatechange");
}

static inline bool setJSXMLHttpRequestOnreadystatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().readystatechangeEvent, value);
    return true;
}

bool setJSXMLHttpRequestOnreadystatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSXMLHttpRequest>::set<setJSXMLHttpRequestOnreadystatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onreadystatechange");
}

static inline JSValue jsXMLHttpRequestReadyStateGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.readyState());
    return result;
}

EncodedJSValue jsXMLHttpRequestReadyState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequestReadyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "readyState");
}

static inline JSValue jsXMLHttpRequestTimeoutGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.timeout());
    return result;
}

EncodedJSValue jsXMLHttpRequestTimeout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequestTimeoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "timeout");
}

static inline bool setJSXMLHttpRequestTimeoutSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTimeout(WTFMove(nativeValue));
    });
    return true;
}

bool setJSXMLHttpRequestTimeout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSXMLHttpRequest>::set<setJSXMLHttpRequestTimeoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "timeout");
}

static inline JSValue jsXMLHttpRequestWithCredentialsGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.withCredentials());
    return result;
}

EncodedJSValue jsXMLHttpRequestWithCredentials(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequestWithCredentialsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "withCredentials");
}

static inline bool setJSXMLHttpRequestWithCredentialsSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setWithCredentials(WTFMove(nativeValue));
    });
    return true;
}

bool setJSXMLHttpRequestWithCredentials(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSXMLHttpRequest>::set<setJSXMLHttpRequestWithCredentialsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "withCredentials");
}

static inline JSValue jsXMLHttpRequestUploadGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<XMLHttpRequestUpload>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.upload());
    return result;
}

EncodedJSValue jsXMLHttpRequestUpload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequestUploadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "upload");
}

static inline JSValue jsXMLHttpRequestResponseURLGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.responseURL());
    return result;
}

EncodedJSValue jsXMLHttpRequestResponseURL(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequestResponseURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "responseURL");
}

static inline JSValue jsXMLHttpRequestStatusGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.status());
    return result;
}

EncodedJSValue jsXMLHttpRequestStatus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequestStatusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "status");
}

static inline JSValue jsXMLHttpRequestStatusTextGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLByteString>(lexicalGlobalObject, throwScope, impl.statusText());
    return result;
}

EncodedJSValue jsXMLHttpRequestStatusText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequestStatusTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "statusText");
}

static inline JSValue jsXMLHttpRequestResponseTypeGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<XMLHttpRequest::ResponseType>>(lexicalGlobalObject, throwScope, impl.responseType());
    return result;
}

EncodedJSValue jsXMLHttpRequestResponseType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequestResponseTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "responseType");
}

static inline bool setJSXMLHttpRequestResponseTypeSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<XMLHttpRequest::ResponseType>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setResponseType(WTFMove(nativeValue));
    });
    return true;
}

bool setJSXMLHttpRequestResponseType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSXMLHttpRequest>::set<setJSXMLHttpRequestResponseTypeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "responseType");
}

static inline JSValue jsXMLHttpRequestResponseGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.response(lexicalGlobalObject);
}

EncodedJSValue jsXMLHttpRequestResponse(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequestResponseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "response");
}

static inline JSValue jsXMLHttpRequestResponseTextGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.responseText());
    return result;
}

EncodedJSValue jsXMLHttpRequestResponseText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequestResponseTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "responseText");
}

static inline JSValue jsXMLHttpRequestResponseXMLGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Document>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.responseXML());
    return result;
}

EncodedJSValue jsXMLHttpRequestResponseXML(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequestResponseXMLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "responseXML");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunctionOpen1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto method = convert<IDLByteString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto url = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.open(WTFMove(method), WTFMove(url)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunctionOpen2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto method = convert<IDLByteString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto url = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto async = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto user = callFrame->argument(3).isUndefined() ? String() : convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto password = callFrame->argument(4).isUndefined() ? String() : convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.open(WTFMove(method), WTFMove(url), WTFMove(async), WTFMove(user), WTFMove(password)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunctionOpenOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 2) {
        return jsXMLHttpRequestPrototypeFunctionOpen1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 3) {
        return jsXMLHttpRequestPrototypeFunctionOpen2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsXMLHttpRequestPrototypeFunctionOpen2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 5) {
        return jsXMLHttpRequestPrototypeFunctionOpen2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionOpen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunctionOpenOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "open");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunctionSetRequestHeaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto header = convert<IDLByteString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto value = convert<IDLByteString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setRequestHeader(WTFMove(header), WTFMove(value)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionSetRequestHeader(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunctionSetRequestHeaderBody>(*lexicalGlobalObject, *callFrame, "setRequestHeader");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunctionSendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto body = callFrame->argument(0).isUndefined() ? WTF::nullopt : convert<IDLNullable<IDLUnion<IDLInterface<Document>, IDLInterface<Blob>, IDLArrayBufferView, IDLArrayBuffer, IDLInterface<DOMFormData>, IDLUSVString>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.send(WTFMove(body)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionSend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunctionSendBody>(*lexicalGlobalObject, *callFrame, "send");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunctionAbortBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.abort();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionAbort(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunctionAbortBody>(*lexicalGlobalObject, *callFrame, "abort");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunctionGetResponseHeaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto name = convert<IDLByteString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLByteString>>(*lexicalGlobalObject, impl.getResponseHeader(WTFMove(name))));
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionGetResponseHeader(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunctionGetResponseHeaderBody>(*lexicalGlobalObject, *callFrame, "getResponseHeader");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunctionGetAllResponseHeadersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLByteString>(*lexicalGlobalObject, impl.getAllResponseHeaders()));
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionGetAllResponseHeaders(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunctionGetAllResponseHeadersBody>(*lexicalGlobalObject, *callFrame, "getAllResponseHeaders");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunctionOverrideMimeTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mime = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.overrideMimeType(WTFMove(mime)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionOverrideMimeType(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunctionOverrideMimeTypeBody>(*lexicalGlobalObject, *callFrame, "overrideMimeType");
}

void JSXMLHttpRequest::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSXMLHttpRequest*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
    visitor.reportExtraMemoryVisited(thisObject->wrapped().memoryCost());
    visitor.append(thisObject->m_response);
}

void JSXMLHttpRequest::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSXMLHttpRequest*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

size_t JSXMLHttpRequest::estimatedSize(JSCell* cell, VM& vm)
{
    auto* thisObject = jsCast<JSXMLHttpRequest*>(cell);
    return Base::estimatedSize(thisObject, vm) + thisObject->wrapped().memoryCost();
}

void JSXMLHttpRequest::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXMLHttpRequest*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSXMLHttpRequestOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsXMLHttpRequest = jsCast<JSXMLHttpRequest*>(handle.slot()->asCell());
    if (jsXMLHttpRequest->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsXMLHttpRequest->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSXMLHttpRequestOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXMLHttpRequest = static_cast<JSXMLHttpRequest*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXMLHttpRequest->wrapped(), jsXMLHttpRequest);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7XMLHttpRequest@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14XMLHttpRequestE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<XMLHttpRequest>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7XMLHttpRequest@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14XMLHttpRequestE[2];
#endif

    // If this fails XMLHttpRequest does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<XMLHttpRequest>::value, "XMLHttpRequest is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // XMLHttpRequest has subclasses. If XMLHttpRequest has subclasses that get passed
    // to toJS() we currently require XMLHttpRequest you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    globalObject->vm().heap.reportExtraMemoryAllocated(impl->memoryCost());
    return createWrapper<XMLHttpRequest>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XMLHttpRequest& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

XMLHttpRequest* JSXMLHttpRequest::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXMLHttpRequest*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
