/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "JSXMLHttpRequestEventTarget.h"
#include "XMLHttpRequest.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class WEBCORE_EXPORT JSXMLHttpRequest : public JSXMLHttpRequestEventTarget {
public:
    using Base = JSXMLHttpRequestEventTarget;
    using DOMWrapped = XMLHttpRequest;
    static JSXMLHttpRequest* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<XMLHttpRequest>&& impl)
    {
        JSXMLHttpRequest* ptr = new (NotNull, JSC::allocateCell<JSXMLHttpRequest>(globalObject->vm().heap)) JSXMLHttpRequest(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static XMLHttpRequest* toWrapped(JSC::VM&, JSC::JSValue);
    static size_t estimatedSize(JSCell*, JSC::VM&);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    mutable JSC::WriteBarrier<JSC::Unknown> m_response;
    static void visitChildren(JSCell*, JSC::SlotVisitor&);
    void visitAdditionalChildren(JSC::SlotVisitor&);

    static void visitOutputConstraints(JSCell*, JSC::SlotVisitor&);
    template<typename, JSC::SubspaceAccess> static JSC::CompleteSubspace* subspaceFor(JSC::VM& vm) { return outputConstraintSubspaceFor(vm); }
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);

    // Custom attributes
    JSC::JSValue response(JSC::JSGlobalObject&) const;
    XMLHttpRequest& wrapped() const
    {
        return static_cast<XMLHttpRequest&>(Base::wrapped());
    }
protected:
    JSXMLHttpRequest(JSC::Structure*, JSDOMGlobalObject&, Ref<XMLHttpRequest>&&);

    void finishCreation(JSC::VM&);
};

class JSXMLHttpRequestOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, XMLHttpRequest*)
{
    static NeverDestroyed<JSXMLHttpRequestOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(XMLHttpRequest* wrappableObject)
{
    return wrappableObject;
}

WEBCORE_EXPORT JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, XMLHttpRequest&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XMLHttpRequest* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<XMLHttpRequest>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<XMLHttpRequest>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<XMLHttpRequest> {
    using WrapperClass = JSXMLHttpRequest;
    using ToWrappedReturnType = XMLHttpRequest*;
};
String convertEnumerationToString(XMLHttpRequest::ResponseType);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, XMLHttpRequest::ResponseType);

template<> Optional<XMLHttpRequest::ResponseType> parseEnumeration<XMLHttpRequest::ResponseType>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<XMLHttpRequest::ResponseType>();


} // namespace WebCore
