/*
 * Copyright (c) 2015, 2016 Ericsson AB. All rights reserved.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "RTCPeerConnectionInternalsBuiltins.h"

#if ENABLE(WEB_RTC)

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapInlines.h>
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSCJSValueInlines.h>
#include <JavaScriptCore/JSCellInlines.h>
#include <JavaScriptCore/StructureInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_rtcPeerConnectionInternalsEnqueueOperationCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_rtcPeerConnectionInternalsEnqueueOperationCodeConstructorKind = JSC::ConstructorKind::None;
const int s_rtcPeerConnectionInternalsEnqueueOperationCodeLength = 511;
static const JSC::Intrinsic s_rtcPeerConnectionInternalsEnqueueOperationCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_rtcPeerConnectionInternalsEnqueueOperationCode =
    "(function (peerConnection, operation)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const operations = @getByIdDirectPrivate(peerConnection, \"operations\");\n" \
    "\n" \
    "    function runNext() {\n" \
    "        operations.@shift();\n" \
    "        if (operations.length)\n" \
    "            operations[0]();\n" \
    "    };\n" \
    "\n" \
    "    return new @Promise(function (resolve, reject) {\n" \
    "        operations.@push(function() {\n" \
    "            operation().@then(resolve, reject).@then(runNext, runNext);\n" \
    "        });\n" \
    "\n" \
    "        if (operations.length === 1)\n" \
    "            operations[0]();\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_rtcPeerConnectionInternalsObjectOverloadCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_rtcPeerConnectionInternalsObjectOverloadCodeConstructorKind = JSC::ConstructorKind::None;
const int s_rtcPeerConnectionInternalsObjectOverloadCodeLength = 813;
static const JSC::Intrinsic s_rtcPeerConnectionInternalsObjectOverloadCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_rtcPeerConnectionInternalsObjectOverloadCode =
    "(function (objectArg, functionName, objectInfo, promiseMode)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    let objectArgOk = false;\n" \
    "\n" \
    "    const hasMatchingType = objectArg instanceof objectInfo.constructor;\n" \
    "    if (hasMatchingType)\n" \
    "        objectArgOk = true;\n" \
    "    else if (objectArg == null && objectInfo.defaultsToNull) {\n" \
    "        objectArgOk = true;\n" \
    "        objectArg = null;\n" \
    "    } else if (objectInfo.maybeDictionary) {\n" \
    "        try {\n" \
    "            objectArg = new objectInfo.constructor(objectArg);\n" \
    "            objectArgOk = true;\n" \
    "        } catch (e) {\n" \
    "            objectArgOk = false;\n" \
    "        }\n" \
    "    }\n" \
    "\n" \
    "    if (!objectArgOk)\n" \
    "        return @Promise.@reject(@makeTypeError(`Argument 1 ('${objectInfo.argName}') to RTCPeerConnection.${functionName} must be an instance of ${objectInfo.argType}`));\n" \
    "\n" \
    "    return promiseMode(objectArg);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_rtcPeerConnectionInternalsIsRTCPeerConnectionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_rtcPeerConnectionInternalsIsRTCPeerConnectionCodeConstructorKind = JSC::ConstructorKind::None;
const int s_rtcPeerConnectionInternalsIsRTCPeerConnectionCodeLength = 134;
static const JSC::Intrinsic s_rtcPeerConnectionInternalsIsRTCPeerConnectionCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_rtcPeerConnectionInternalsIsRTCPeerConnectionCode =
    "(function (connection)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return @isObject(connection) && !!@getByIdDirectPrivate(connection, \"operations\");\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().rtcPeerConnectionInternalsBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().rtcPeerConnectionInternalsBuiltins().codeName##Source(), WTF::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_RTCPEERCONNECTIONINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(WEB_RTC)
