/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "ReadableStreamBuiltins.h"

#if ENABLE(STREAMS_API)

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapInlines.h>
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSCJSValueInlines.h>
#include <JavaScriptCore/JSCellInlines.h>
#include <JavaScriptCore/StructureInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_readableStreamInitializeReadableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInitializeReadableStreamCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInitializeReadableStreamCodeLength = 1915;
static const JSC::Intrinsic s_readableStreamInitializeReadableStreamCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInitializeReadableStreamCode =
    "(function (underlyingSource, strategy)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "     if (underlyingSource === @undefined)\n" \
    "         underlyingSource = { };\n" \
    "     if (strategy === @undefined)\n" \
    "         strategy = { };\n" \
    "\n" \
    "    if (!@isObject(underlyingSource))\n" \
    "        @throwTypeError(\"ReadableStream constructor takes an object as first argument\");\n" \
    "\n" \
    "    if (strategy !== @undefined && !@isObject(strategy))\n" \
    "        @throwTypeError(\"ReadableStream constructor takes an object as second argument, if any\");\n" \
    "\n" \
    "    @putByIdDirectPrivate(this, \"state\", @streamReadable);\n" \
    "    @putByIdDirectPrivate(this, \"reader\", @undefined);\n" \
    "    @putByIdDirectPrivate(this, \"storedError\", @undefined);\n" \
    "    @putByIdDirectPrivate(this, \"disturbed\", false);\n" \
    "    //\n" \
    "    @putByIdDirectPrivate(this, \"readableStreamController\", null);\n" \
    "\n" \
    "    const type = underlyingSource.type;\n" \
    "    const typeString = @toString(type);\n" \
    "\n" \
    "    if (typeString === \"bytes\") {\n" \
    "        if (!@readableByteStreamAPIEnabled())\n" \
    "            @throwTypeError(\"ReadableByteStreamController is not implemented\");\n" \
    "\n" \
    "        if (strategy.highWaterMark === @undefined)\n" \
    "            strategy.highWaterMark = 0;\n" \
    "        if (strategy.size !== @undefined)\n" \
    "            @throwRangeError(\"Strategy for a ReadableByteStreamController cannot have a size\");\n" \
    "\n" \
    "        let readableByteStreamControllerConstructor = @ReadableByteStreamController;\n" \
    "        @putByIdDirectPrivate(this, \"readableStreamController\", new @ReadableByteStreamController(this, underlyingSource, strategy.highWaterMark, @isReadableStream));\n" \
    "    } else if (type === @undefined) {\n" \
    "        if (strategy.highWaterMark === @undefined)\n" \
    "            strategy.highWaterMark = 1;\n" \
    "        @putByIdDirectPrivate(this, \"readableStreamController\", new @ReadableStreamDefaultController(this, underlyingSource, strategy.size, strategy.highWaterMark, @isReadableStream));\n" \
    "    } else\n" \
    "        @throwRangeError(\"Invalid type for underlying source\");\n" \
    "\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamCancelCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamCancelCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamCancelCodeLength = 324;
static const JSC::Intrinsic s_readableStreamCancelCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamCancelCode =
    "(function (reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableStream(this))\n" \
    "        return @Promise.@reject(@makeThisTypeError(\"ReadableStream\", \"cancel\"));\n" \
    "\n" \
    "    if (@isReadableStreamLocked(this))\n" \
    "        return @Promise.@reject(@makeTypeError(\"ReadableStream is locked\"));\n" \
    "\n" \
    "    return @readableStreamCancel(this, reason);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamGetReaderCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamGetReaderCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamGetReaderCodeLength = 437;
static const JSC::Intrinsic s_readableStreamGetReaderCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamGetReaderCode =
    "(function (options)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableStream(this))\n" \
    "        throw @makeThisTypeError(\"ReadableStream\", \"getReader\");\n" \
    "\n" \
    "    if (options === @undefined)\n" \
    "         options = { };\n" \
    "\n" \
    "    if (options.mode === @undefined)\n" \
    "        return new @ReadableStreamDefaultReader(this);\n" \
    "\n" \
    "    //\n" \
    "    if (options.mode == 'byob')\n" \
    "        return new @ReadableStreamBYOBReader(this);\n" \
    "\n" \
    "    @throwRangeError(\"Invalid mode is specified\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamPipeThroughCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamPipeThroughCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamPipeThroughCodeLength = 376;
static const JSC::Intrinsic s_readableStreamPipeThroughCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamPipeThroughCode =
    "(function (streams, options)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const writable = streams.writable;\n" \
    "    const readable = streams.readable;\n" \
    "    const promise = this.pipeTo(writable, options);\n" \
    "    if (@isPromise(promise))\n" \
    "        @putPromiseInternalField(promise, @promiseFieldFlags, @getPromiseInternalField(promise, @promiseFieldFlags) | @promiseFlagsIsHandled);\n" \
    "    return readable;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamPipeToCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamPipeToCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamPipeToCodeLength = 2645;
static const JSC::Intrinsic s_readableStreamPipeToCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamPipeToCode =
    "(function (destination)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    const options = arguments[1];\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "\n" \
    "    const preventClose = @isObject(options) && !!options.preventClose;\n" \
    "    const preventAbort = @isObject(options) && !!options.preventAbort;\n" \
    "    const preventCancel = @isObject(options) && !!options.preventCancel;\n" \
    "\n" \
    "    const source = this;\n" \
    "\n" \
    "    let reader;\n" \
    "    let lastRead;\n" \
    "    let lastWrite;\n" \
    "    let closedPurposefully = false;\n" \
    "    let promiseCapability;\n" \
    "\n" \
    "    function doPipe() {\n" \
    "        lastRead = reader.read();\n" \
    "        @Promise.prototype.@then.@call(@Promise.all([lastRead, destination.ready]), function([{ value, done }]) {\n" \
    "            if (done)\n" \
    "                closeDestination();\n" \
    "            else if (destination.state === \"writable\") {\n" \
    "                lastWrite = destination.write(value);\n" \
    "                doPipe();\n" \
    "            }\n" \
    "        }, function(e) {\n" \
    "            throw e;\n" \
    "        });\n" \
    "    }\n" \
    "\n" \
    "    function cancelSource(reason) {\n" \
    "        if (!preventCancel) {\n" \
    "            reader.cancel(reason);\n" \
    "            reader.releaseLock();\n" \
    "            promiseCapability.@reject.@call(@undefined, reason);\n" \
    "        } else {\n" \
    "            @Promise.prototype.@then.@call(lastRead, function() {\n" \
    "                reader.releaseLock();\n" \
    "                promiseCapability.@reject.@call(@undefined, reason);\n" \
    "            });\n" \
    "        }\n" \
    "    }\n" \
    "\n" \
    "    function closeDestination() {\n" \
    "        reader.releaseLock();\n" \
    "\n" \
    "        const destinationState = destination.state;\n" \
    "        if (!preventClose && (destinationState === \"waiting\" || destinationState === \"writable\")) {\n" \
    "            closedPurposefully = true;\n" \
    "            @Promise.prototype.@then.@call(destination.close(), promiseCapability.@resolve, promiseCapability.@reject);\n" \
    "        } else if (lastWrite !== @undefined)\n" \
    "            @Promise.prototype.@then.@call(lastWrite, promiseCapability.@resolve, promiseCapability.@reject);\n" \
    "        else\n" \
    "            promiseCapability.@resolve.@call();\n" \
    "\n" \
    "    }\n" \
    "\n" \
    "    function abortDestination(reason) {\n" \
    "        reader.releaseLock();\n" \
    "\n" \
    "        if (!preventAbort)\n" \
    "            destination.abort(reason);\n" \
    "        promiseCapability.@reject.@call(@undefined, reason);\n" \
    "    }\n" \
    "\n" \
    "    promiseCapability = @newPromiseCapability(@Promise);\n" \
    "\n" \
    "    reader = source.getReader();\n" \
    "\n" \
    "    @Promise.prototype.@then.@call(reader.closed, @undefined, abortDestination);\n" \
    "    @Promise.prototype.@then.@call(destination.closed,\n" \
    "        function() {\n" \
    "            if (!closedPurposefully)\n" \
    "                cancelSource(@makeTypeError('destination is closing or closed and cannot be piped to anymore'));\n" \
    "        },\n" \
    "        cancelSource\n" \
    "    );\n" \
    "\n" \
    "    doPipe();\n" \
    "\n" \
    "    return promiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamTeeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamTeeCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamTeeCodeLength = 175;
static const JSC::Intrinsic s_readableStreamTeeCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamTeeCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableStream(this))\n" \
    "        throw @makeThisTypeError(\"ReadableStream\", \"tee\");\n" \
    "\n" \
    "    return @readableStreamTee(this, false);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamLockedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamLockedCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamLockedCodeLength = 178;
static const JSC::Intrinsic s_readableStreamLockedCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamLockedCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableStream(this))\n" \
    "        throw @makeGetterTypeError(\"ReadableStream\", \"locked\");\n" \
    "\n" \
    "    return @isReadableStreamLocked(this);\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().readableStreamBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().readableStreamBuiltins().codeName##Source(), WTF::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_READABLESTREAM_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(STREAMS_API)
