/*
 * Copyright (c) 2015 Canon Inc. All rights reserved.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "ReadableStreamInternalsBuiltins.h"

#if ENABLE(STREAMS_API)

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapInlines.h>
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSCJSValueInlines.h>
#include <JavaScriptCore/JSCellInlines.h>
#include <JavaScriptCore/StructureInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeLength = 756;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamReaderGenericInitializeCode =
    "(function (reader, stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @putByIdDirectPrivate(reader, \"ownerReadableStream\", stream);\n" \
    "    @putByIdDirectPrivate(stream, \"reader\", reader);\n" \
    "    if (@getByIdDirectPrivate(stream, \"state\") === @streamReadable)\n" \
    "        @putByIdDirectPrivate(reader, \"closedPromiseCapability\", @newPromiseCapability(@Promise));\n" \
    "    else if (@getByIdDirectPrivate(stream, \"state\") === @streamClosed)\n" \
    "        @putByIdDirectPrivate(reader, \"closedPromiseCapability\", { @promise: @Promise.@resolve() });\n" \
    "    else {\n" \
    "        @assert(@getByIdDirectPrivate(stream, \"state\") === @streamErrored);\n" \
    "        @putByIdDirectPrivate(reader, \"closedPromiseCapability\", { @promise: @newHandledRejectedPromise(@getByIdDirectPrivate(stream, \"storedError\")) });\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeLength = 1513;
static const JSC::Intrinsic s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCode =
    "(function (stream, underlyingSource, size, highWaterMark)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableStream(stream))\n" \
    "        @throwTypeError(\"ReadableStreamDefaultController needs a ReadableStream\");\n" \
    "\n" \
    "    //\n" \
    "    if (@getByIdDirectPrivate(stream, \"readableStreamController\") !== null)\n" \
    "        @throwTypeError(\"ReadableStream already has a controller\");\n" \
    "\n" \
    "    @putByIdDirectPrivate(this, \"controlledReadableStream\", stream);\n" \
    "    @putByIdDirectPrivate(this, \"underlyingSource\", underlyingSource);\n" \
    "    @putByIdDirectPrivate(this, \"queue\", @newQueue());\n" \
    "    @putByIdDirectPrivate(this, \"started\", false);\n" \
    "    @putByIdDirectPrivate(this, \"closeRequested\", false);\n" \
    "    @putByIdDirectPrivate(this, \"pullAgain\", false);\n" \
    "    @putByIdDirectPrivate(this, \"pulling\", false);\n" \
    "    @putByIdDirectPrivate(this, \"strategy\", @validateAndNormalizeQueuingStrategy(size, highWaterMark));\n" \
    "\n" \
    "    const controller = this;\n" \
    "    @promiseInvokeOrNoopNoCatch(underlyingSource, \"start\", [this]).@then(() => {\n" \
    "        @putByIdDirectPrivate(controller, \"started\", true);\n" \
    "        @assert(!@getByIdDirectPrivate(controller, \"pulling\"));\n" \
    "        @assert(!@getByIdDirectPrivate(controller, \"pullAgain\"));\n" \
    "        @readableStreamDefaultControllerCallPullIfNeeded(controller);\n" \
    "    }, (error) => {\n" \
    "        @readableStreamDefaultControllerError(controller, error);\n" \
    "    });\n" \
    "\n" \
    "    @putByIdDirectPrivate(this, \"cancel\", @readableStreamDefaultControllerCancel);\n" \
    "\n" \
    "    @putByIdDirectPrivate(this, \"pull\", @readableStreamDefaultControllerPull);\n" \
    "\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeLength = 322;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerErrorCode =
    "(function (controller, error)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "    if (@getByIdDirectPrivate(stream, \"state\") !== @streamReadable)\n" \
    "        return;\n" \
    "    @putByIdDirectPrivate(controller, \"queue\", @newQueue());\n" \
    "    @readableStreamError(stream, error);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamPipeToCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamPipeToCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamPipeToCodeLength = 778;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamPipeToCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamPipeToCode =
    "(function (stream, sink)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "\n" \
    "    const reader = new @ReadableStreamDefaultReader(stream);\n" \
    "\n" \
    "    @getByIdDirectPrivate(reader, \"closedPromiseCapability\").@promise.@then(() => { }, (e) => { sink.error(e); });\n" \
    "\n" \
    "    function doPipe() {\n" \
    "        @readableStreamDefaultReaderRead(reader).@then(function(result) {\n" \
    "            if (result.done) {\n" \
    "                sink.close();\n" \
    "                return;\n" \
    "            }\n" \
    "            try {\n" \
    "                sink.enqueue(result.value);\n" \
    "            } catch (e) {\n" \
    "                sink.error(\"ReadableStream chunk enqueueing in the sink failed\");\n" \
    "                return;\n" \
    "            }\n" \
    "            doPipe();\n" \
    "        }, function(e) {\n" \
    "            sink.error(e);\n" \
    "        });\n" \
    "    }\n" \
    "    doPipe();\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeeCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamTeeCodeLength = 1346;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamTeeCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamTeeCode =
    "(function (stream, shouldClone)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "    @assert(typeof(shouldClone) === \"boolean\");\n" \
    "\n" \
    "    const reader = new @ReadableStreamDefaultReader(stream);\n" \
    "\n" \
    "    const teeState = {\n" \
    "        closedOrErrored: false,\n" \
    "        canceled1: false,\n" \
    "        canceled2: false,\n" \
    "        reason1: @undefined,\n" \
    "        reason2: @undefined,\n" \
    "    };\n" \
    "\n" \
    "    teeState.cancelPromiseCapability = @newPromiseCapability(@InternalPromise);\n" \
    "\n" \
    "    const pullFunction = @readableStreamTeePullFunction(teeState, reader, shouldClone);\n" \
    "\n" \
    "    const branch1 = new @ReadableStream({\n" \
    "        \"pull\": pullFunction,\n" \
    "        \"cancel\": @readableStreamTeeBranch1CancelFunction(teeState, stream)\n" \
    "    });\n" \
    "    const branch2 = new @ReadableStream({\n" \
    "        \"pull\": pullFunction,\n" \
    "        \"cancel\": @readableStreamTeeBranch2CancelFunction(teeState, stream)\n" \
    "    });\n" \
    "\n" \
    "    @getByIdDirectPrivate(reader, \"closedPromiseCapability\").@promise.@then(@undefined, function(e) {\n" \
    "        if (teeState.closedOrErrored)\n" \
    "            return;\n" \
    "        @readableStreamDefaultControllerError(branch1.@readableStreamController, e);\n" \
    "        @readableStreamDefaultControllerError(branch2.@readableStreamController, e);\n" \
    "        teeState.closedOrErrored = true;\n" \
    "    });\n" \
    "\n" \
    "    //\n" \
    "    teeState.branch1 = branch1;\n" \
    "    teeState.branch2 = branch2;\n" \
    "\n" \
    "    return [branch1, branch2];\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsDoStructuredCloneCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsDoStructuredCloneCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsDoStructuredCloneCodeLength = 317;
static const JSC::Intrinsic s_readableStreamInternalsDoStructuredCloneCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsDoStructuredCloneCode =
    "(function (object)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "\n" \
    "    if (object instanceof @ArrayBuffer)\n" \
    "        return @structuredCloneArrayBuffer(object);\n" \
    "\n" \
    "    if (@ArrayBuffer.@isView(object))\n" \
    "        return @structuredCloneArrayBufferView(object);\n" \
    "\n" \
    "    @throwTypeError(\"structuredClone not implemented for: \" + object);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeePullFunctionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeePullFunctionCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamTeePullFunctionCodeLength = 1133;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamTeePullFunctionCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamTeePullFunctionCode =
    "(function (teeState, reader, shouldClone)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return function() {\n" \
    "        @Promise.prototype.@then.@call(@readableStreamDefaultReaderRead(reader), function(result) {\n" \
    "            @assert(@isObject(result));\n" \
    "            @assert(typeof result.done === \"boolean\");\n" \
    "            if (result.done && !teeState.closedOrErrored) {\n" \
    "                if (!teeState.canceled1)\n" \
    "                    @readableStreamDefaultControllerClose(teeState.branch1.@readableStreamController);\n" \
    "                if (!teeState.canceled2)\n" \
    "                    @readableStreamDefaultControllerClose(teeState.branch2.@readableStreamController);\n" \
    "                teeState.closedOrErrored = true;\n" \
    "            }\n" \
    "            if (teeState.closedOrErrored)\n" \
    "                return;\n" \
    "            if (!teeState.canceled1)\n" \
    "                @readableStreamDefaultControllerEnqueue(teeState.branch1.@readableStreamController, result.value);\n" \
    "            if (!teeState.canceled2)\n" \
    "                @readableStreamDefaultControllerEnqueue(teeState.branch2.@readableStreamController, shouldClone ? @doStructuredClone(result.value) : result.value);\n" \
    "        });\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeLength = 456;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCode =
    "(function (teeState, stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return function(r) {\n" \
    "        teeState.canceled1 = true;\n" \
    "        teeState.reason1 = r;\n" \
    "        if (teeState.canceled2) {\n" \
    "            @readableStreamCancel(stream, [teeState.reason1, teeState.reason2]).@then(\n" \
    "                teeState.cancelPromiseCapability.@resolve,\n" \
    "                teeState.cancelPromiseCapability.@reject);\n" \
    "        }\n" \
    "        return teeState.cancelPromiseCapability.@promise;\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeLength = 456;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCode =
    "(function (teeState, stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return function(r) {\n" \
    "        teeState.canceled2 = true;\n" \
    "        teeState.reason2 = r;\n" \
    "        if (teeState.canceled1) {\n" \
    "            @readableStreamCancel(stream, [teeState.reason1, teeState.reason2]).@then(\n" \
    "                teeState.cancelPromiseCapability.@resolve,\n" \
    "                teeState.cancelPromiseCapability.@reject);\n" \
    "        }\n" \
    "        return teeState.cancelPromiseCapability.@promise;\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsIsReadableStreamCodeLength = 170;
static const JSC::Intrinsic s_readableStreamInternalsIsReadableStreamCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsIsReadableStreamCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    return @isObject(stream) && @getByIdDirectPrivate(stream, \"readableStreamController\") !== @undefined;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDefaultReaderCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamDefaultReaderCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsIsReadableStreamDefaultReaderCodeLength = 145;
static const JSC::Intrinsic s_readableStreamInternalsIsReadableStreamDefaultReaderCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsIsReadableStreamDefaultReaderCode =
    "(function (reader)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    return @isObject(reader) && !!@getByIdDirectPrivate(reader, \"readRequests\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDefaultControllerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamDefaultControllerCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsIsReadableStreamDefaultControllerCodeLength = 168;
static const JSC::Intrinsic s_readableStreamInternalsIsReadableStreamDefaultControllerCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsIsReadableStreamDefaultControllerCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    return @isObject(controller) && !!@getByIdDirectPrivate(controller, \"underlyingSource\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamErrorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamErrorCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamErrorCodeLength = 1406;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamErrorCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamErrorCode =
    "(function (stream, error)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === @streamReadable);\n" \
    "    @putByIdDirectPrivate(stream, \"state\", @streamErrored);\n" \
    "    @putByIdDirectPrivate(stream, \"storedError\", error);\n" \
    "\n" \
    "    if (!@getByIdDirectPrivate(stream, \"reader\"))\n" \
    "        return;\n" \
    "\n" \
    "    const reader = @getByIdDirectPrivate(stream, \"reader\");\n" \
    "\n" \
    "    if (@isReadableStreamDefaultReader(reader)) {\n" \
    "        const requests = @getByIdDirectPrivate(reader, \"readRequests\");\n" \
    "        for (let index = 0, length = requests.length; index < length; ++index)\n" \
    "            requests[index].@reject.@call(@undefined, error);\n" \
    "        @putByIdDirectPrivate(reader, \"readRequests\", []);\n" \
    "    } else {\n" \
    "        @assert(@isReadableStreamBYOBReader(reader));\n" \
    "        const requests = @getByIdDirectPrivate(reader, \"readIntoRequests\");\n" \
    "        for (let index = 0, length = requests.length; index < length; ++index)\n" \
    "            requests[index].@reject.@call(@undefined, error);\n" \
    "        @putByIdDirectPrivate(reader, \"readIntoRequests\", []);\n" \
    "    }\n" \
    "\n" \
    "    @getByIdDirectPrivate(reader, \"closedPromiseCapability\").@reject.@call(@undefined, error);\n" \
    "    const promise = @getByIdDirectPrivate(reader, \"closedPromiseCapability\").@promise;\n" \
    "    @putPromiseInternalField(promise, @promiseFieldFlags, @getPromiseInternalField(promise, @promiseFieldFlags) | @promiseFlagsIsHandled);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeLength = 1261;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "\n" \
    "    if (!@readableStreamDefaultControllerCanCloseOrEnqueue(controller))\n" \
    "        return;\n" \
    "    if (!@getByIdDirectPrivate(controller, \"started\"))\n" \
    "        return;\n" \
    "    if ((!@isReadableStreamLocked(stream) || !@getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readRequests\").length) && @readableStreamDefaultControllerGetDesiredSize(controller) <= 0)\n" \
    "        return;\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(controller, \"pulling\")) {\n" \
    "        @putByIdDirectPrivate(controller, \"pullAgain\", true);\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    @assert(!@getByIdDirectPrivate(controller, \"pullAgain\"));\n" \
    "    @putByIdDirectPrivate(controller, \"pulling\", true);\n" \
    "\n" \
    "    @promiseInvokeOrNoop(@getByIdDirectPrivate(controller, \"underlyingSource\"), \"pull\", [controller]).@then(function() {\n" \
    "        @putByIdDirectPrivate(controller, \"pulling\", false);\n" \
    "        if (@getByIdDirectPrivate(controller, \"pullAgain\")) {\n" \
    "            @putByIdDirectPrivate(controller, \"pullAgain\", false);\n" \
    "            @readableStreamDefaultControllerCallPullIfNeeded(controller);\n" \
    "        }\n" \
    "    }, function(error) {\n" \
    "        @readableStreamDefaultControllerError(controller, error);\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamLockedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamLockedCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsIsReadableStreamLockedCodeLength = 136;
static const JSC::Intrinsic s_readableStreamInternalsIsReadableStreamLockedCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsIsReadableStreamLockedCode =
    "(function (stream)\n" \
    "{\n" \
    "   \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "    return !!@getByIdDirectPrivate(stream, \"reader\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeLength = 416;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCode =
    "(function (controller)\n" \
    "{\n" \
    "   \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "\n" \
    "    if (state === @streamErrored)\n" \
    "        return null;\n" \
    "    if (state === @streamClosed)\n" \
    "        return 0;\n" \
    "\n" \
    "    return @getByIdDirectPrivate(controller, \"strategy\").highWaterMark - @getByIdDirectPrivate(controller, \"queue\").size;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamReaderGenericCancelCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamReaderGenericCancelCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamReaderGenericCancelCodeLength = 197;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamReaderGenericCancelCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamReaderGenericCancelCode =
    "(function (reader, reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(reader, \"ownerReadableStream\");\n" \
    "    @assert(!!stream);\n" \
    "    return @readableStreamCancel(stream, reason);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamCancelCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamCancelCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamCancelCodeLength = 547;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamCancelCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamCancelCode =
    "(function (stream, reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"disturbed\", true);\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    if (state === @streamClosed)\n" \
    "        return @Promise.@resolve();\n" \
    "    if (state === @streamErrored)\n" \
    "        return @Promise.@reject(@getByIdDirectPrivate(stream, \"storedError\"));\n" \
    "    @readableStreamClose(stream);\n" \
    "    return @getByIdDirectPrivate(stream, \"readableStreamController\").@cancel(@getByIdDirectPrivate(stream, \"readableStreamController\"), reason).@then(function() {  });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeLength = 224;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerCancelCode =
    "(function (controller, reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @putByIdDirectPrivate(controller, \"queue\", @newQueue());\n" \
    "    return @promiseInvokeOrNoop(@getByIdDirectPrivate(controller, \"underlyingSource\"), \"cancel\", [reason]);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerPullCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerPullCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerPullCodeLength = 768;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerPullCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerPullCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "    if (@getByIdDirectPrivate(controller, \"queue\").content.length) {\n" \
    "        const chunk = @dequeueValue(@getByIdDirectPrivate(controller, \"queue\"));\n" \
    "        if (@getByIdDirectPrivate(controller, \"closeRequested\") && @getByIdDirectPrivate(controller, \"queue\").content.length === 0)\n" \
    "            @readableStreamClose(stream);\n" \
    "        else\n" \
    "            @readableStreamDefaultControllerCallPullIfNeeded(controller);\n" \
    "        return @Promise.@resolve({value: chunk, done: false});\n" \
    "    }\n" \
    "    const pendingPromise = @readableStreamAddReadRequest(stream);\n" \
    "    @readableStreamDefaultControllerCallPullIfNeeded(controller);\n" \
    "    return pendingPromise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeLength = 352;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerCloseCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@readableStreamDefaultControllerCanCloseOrEnqueue(controller));\n" \
    "    @putByIdDirectPrivate(controller, \"closeRequested\", true);\n" \
    "    if (@getByIdDirectPrivate(controller, \"queue\").content.length === 0)\n" \
    "        @readableStreamClose(@getByIdDirectPrivate(controller, \"controlledReadableStream\"));\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamCloseCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamCloseCodeLength = 704;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamCloseCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamCloseCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === @streamReadable);\n" \
    "    @putByIdDirectPrivate(stream, \"state\", @streamClosed);\n" \
    "    const reader = @getByIdDirectPrivate(stream, \"reader\");\n" \
    "\n" \
    "    if (!reader)\n" \
    "        return;\n" \
    "\n" \
    "    if (@isReadableStreamDefaultReader(reader)) {\n" \
    "        const requests = @getByIdDirectPrivate(reader, \"readRequests\");\n" \
    "        for (let index = 0, length = requests.length; index < length; ++index)\n" \
    "            requests[index].@resolve.@call(@undefined, {value:@undefined, done: true});\n" \
    "        @putByIdDirectPrivate(reader, \"readRequests\", []);\n" \
    "    }\n" \
    "\n" \
    "    @getByIdDirectPrivate(reader, \"closedPromiseCapability\").@resolve.@call();\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamFulfillReadRequestCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamFulfillReadRequestCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamFulfillReadRequestCodeLength = 204;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamFulfillReadRequestCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamFulfillReadRequestCode =
    "(function (stream, chunk, done)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readRequests\").@shift().@resolve.@call(@undefined, {value: chunk, done: done});\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeLength = 979;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCode =
    "(function (controller, chunk)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "    @assert(@readableStreamDefaultControllerCanCloseOrEnqueue(controller));\n" \
    "\n" \
    "    if (@isReadableStreamLocked(stream) && @getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readRequests\").length) {\n" \
    "        @readableStreamFulfillReadRequest(stream, chunk, false);\n" \
    "        @readableStreamDefaultControllerCallPullIfNeeded(controller);\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    try {\n" \
    "        let chunkSize = 1;\n" \
    "        if (@getByIdDirectPrivate(controller, \"strategy\").size !== @undefined)\n" \
    "            chunkSize = @getByIdDirectPrivate(controller, \"strategy\").size(chunk);\n" \
    "        @enqueueValueWithSize(@getByIdDirectPrivate(controller, \"queue\"), chunk, chunkSize);\n" \
    "    }\n" \
    "    catch(error) {\n" \
    "        @readableStreamDefaultControllerError(controller, error);\n" \
    "        throw error;\n" \
    "    }\n" \
    "    @readableStreamDefaultControllerCallPullIfNeeded(controller);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderReadCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderReadCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamDefaultReaderReadCodeLength = 641;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultReaderReadCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultReaderReadCode =
    "(function (reader)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(reader, \"ownerReadableStream\");\n" \
    "    @assert(!!stream);\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"disturbed\", true);\n" \
    "    if (state === @streamClosed)\n" \
    "        return @Promise.@resolve({value: @undefined, done: true});\n" \
    "    if (state === @streamErrored)\n" \
    "        return @Promise.@reject(@getByIdDirectPrivate(stream, \"storedError\"));\n" \
    "    @assert(state === @streamReadable);\n" \
    "\n" \
    "    return @getByIdDirectPrivate(stream, \"readableStreamController\").@pull(@getByIdDirectPrivate(stream, \"readableStreamController\"));\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamAddReadRequestCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamAddReadRequestCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamAddReadRequestCodeLength = 396;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamAddReadRequestCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamAddReadRequestCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStreamDefaultReader(@getByIdDirectPrivate(stream, \"reader\")));\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") == @streamReadable);\n" \
    "\n" \
    "    const readRequest = @newPromiseCapability(@Promise);\n" \
    "    @getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readRequests\").@push(readRequest);\n" \
    "\n" \
    "    return readRequest.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDisturbedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamDisturbedCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsIsReadableStreamDisturbedCodeLength = 138;
static const JSC::Intrinsic s_readableStreamInternalsIsReadableStreamDisturbedCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsIsReadableStreamDisturbedCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "    return @getByIdDirectPrivate(stream, \"disturbed\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeLength = 1071;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamReaderGenericReleaseCode =
    "(function (reader)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(!!@getByIdDirectPrivate(reader, \"ownerReadableStream\"));\n" \
    "    @assert(@getByIdDirectPrivate(@getByIdDirectPrivate(reader, \"ownerReadableStream\"), \"reader\") === reader);\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(@getByIdDirectPrivate(reader, \"ownerReadableStream\"), \"state\") === @streamReadable)\n" \
    "        @getByIdDirectPrivate(reader, \"closedPromiseCapability\").@reject.@call(@undefined, @makeTypeError(\"releasing lock of reader whose stream is still in readable state\"));\n" \
    "    else\n" \
    "        @putByIdDirectPrivate(reader, \"closedPromiseCapability\", { @promise: @newHandledRejectedPromise(@makeTypeError(\"reader released lock\")) });\n" \
    "\n" \
    "    const promise = @getByIdDirectPrivate(reader, \"closedPromiseCapability\").@promise;\n" \
    "    @putPromiseInternalField(promise, @promiseFieldFlags, @getPromiseInternalField(promise, @promiseFieldFlags) | @promiseFlagsIsHandled);\n" \
    "    @putByIdDirectPrivate(@getByIdDirectPrivate(reader, \"ownerReadableStream\"), \"reader\", @undefined);\n" \
    "    @putByIdDirectPrivate(reader, \"ownerReadableStream\", @undefined);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeLength = 229;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return !@getByIdDirectPrivate(controller, \"closeRequested\") && @getByIdDirectPrivate(@getByIdDirectPrivate(controller, \"controlledReadableStream\"), \"state\") === @streamReadable;\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().readableStreamInternalsBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().readableStreamInternalsBuiltins().codeName##Source(), WTF::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(STREAMS_API)
