/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "StreamInternalsBuiltins.h"

#if ENABLE(STREAMS_API)

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapInlines.h>
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSCJSValueInlines.h>
#include <JavaScriptCore/JSCellInlines.h>
#include <JavaScriptCore/StructureInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_streamInternalsShieldingPromiseResolveCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_streamInternalsShieldingPromiseResolveCodeConstructorKind = JSC::ConstructorKind::None;
const int s_streamInternalsShieldingPromiseResolveCodeLength = 179;
static const JSC::Intrinsic s_streamInternalsShieldingPromiseResolveCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_streamInternalsShieldingPromiseResolveCode =
    "(function (result)\n" \
    "{\n" \
    "    const promise = @Promise.@resolve(result);\n" \
    "    if (promise.@then === @undefined)\n" \
    "        promise.@then = @Promise.prototype.@then;\n" \
    "    return promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrNoopNoCatchCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrNoopNoCatchCodeConstructorKind = JSC::ConstructorKind::None;
const int s_streamInternalsPromiseInvokeOrNoopNoCatchCodeLength = 219;
static const JSC::Intrinsic s_streamInternalsPromiseInvokeOrNoopNoCatchCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_streamInternalsPromiseInvokeOrNoopNoCatchCode =
    "(function (object, key, args)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const method = object[key];\n" \
    "    if (method === @undefined)\n" \
    "        return @Promise.@resolve();\n" \
    "    return @shieldingPromiseResolve(method.@apply(object, args));\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrNoopCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrNoopCodeConstructorKind = JSC::ConstructorKind::None;
const int s_streamInternalsPromiseInvokeOrNoopCodeLength = 199;
static const JSC::Intrinsic s_streamInternalsPromiseInvokeOrNoopCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_streamInternalsPromiseInvokeOrNoopCode =
    "(function (object, key, args)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    try {\n" \
    "        return @promiseInvokeOrNoopNoCatch(object, key, args);\n" \
    "    }\n" \
    "    catch(error) {\n" \
    "        return @Promise.@reject(error);\n" \
    "    }\n" \
    "\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeConstructorKind = JSC::ConstructorKind::None;
const int s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeLength = 362;
static const JSC::Intrinsic s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_streamInternalsPromiseInvokeOrFallbackOrNoopCode =
    "(function (object, key1, args1, key2, args2)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    try {\n" \
    "        const method = object[key1];\n" \
    "        if (method === @undefined)\n" \
    "            return @promiseInvokeOrNoopNoCatch(object, key2, args2);\n" \
    "        return @shieldingPromiseResolve(method.@apply(object, args1));\n" \
    "    }\n" \
    "    catch(error) {\n" \
    "        return @Promise.@reject(error);\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsValidateAndNormalizeQueuingStrategyCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_streamInternalsValidateAndNormalizeQueuingStrategyCodeConstructorKind = JSC::ConstructorKind::None;
const int s_streamInternalsValidateAndNormalizeQueuingStrategyCodeLength = 486;
static const JSC::Intrinsic s_streamInternalsValidateAndNormalizeQueuingStrategyCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_streamInternalsValidateAndNormalizeQueuingStrategyCode =
    "(function (size, highWaterMark)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (size !== @undefined && typeof size !== \"function\")\n" \
    "        @throwTypeError(\"size parameter must be a function\");\n" \
    "\n" \
    "    const normalizedStrategy = {\n" \
    "        size: size,\n" \
    "        highWaterMark: @toNumber(highWaterMark)\n" \
    "    };\n" \
    "\n" \
    "    if (@isNaN(normalizedStrategy.highWaterMark) || normalizedStrategy.highWaterMark < 0)\n" \
    "        @throwRangeError(\"highWaterMark value is negative or not a number\");\n" \
    "\n" \
    "    return normalizedStrategy;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsNewQueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_streamInternalsNewQueueCodeConstructorKind = JSC::ConstructorKind::None;
const int s_streamInternalsNewQueueCodeLength = 74;
static const JSC::Intrinsic s_streamInternalsNewQueueCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_streamInternalsNewQueueCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return { content: [], size: 0 };\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsDequeueValueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_streamInternalsDequeueValueCodeConstructorKind = JSC::ConstructorKind::None;
const int s_streamInternalsDequeueValueCodeLength = 196;
static const JSC::Intrinsic s_streamInternalsDequeueValueCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_streamInternalsDequeueValueCode =
    "(function (queue)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const record = queue.content.@shift();\n" \
    "    queue.size -= record.size;\n" \
    "    //\n" \
    "    if (queue.size < 0)\n" \
    "        queue.size = 0;\n" \
    "    return record.value;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsEnqueueValueWithSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_streamInternalsEnqueueValueWithSizeCodeConstructorKind = JSC::ConstructorKind::None;
const int s_streamInternalsEnqueueValueWithSizeCodeLength = 257;
static const JSC::Intrinsic s_streamInternalsEnqueueValueWithSizeCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_streamInternalsEnqueueValueWithSizeCode =
    "(function (queue, value, size)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    size = @toNumber(size);\n" \
    "    if (!@isFinite(size) || size < 0)\n" \
    "        @throwRangeError(\"size has an incorrect value\");\n" \
    "    queue.content.@push({ value: value, size: size });\n" \
    "    queue.size += size;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsPeekQueueValueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_streamInternalsPeekQueueValueCodeConstructorKind = JSC::ConstructorKind::None;
const int s_streamInternalsPeekQueueValueCodeLength = 117;
static const JSC::Intrinsic s_streamInternalsPeekQueueValueCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_streamInternalsPeekQueueValueCode =
    "(function (queue)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(queue.content.length > 0);\n" \
    "\n" \
    "    return queue.content[0].value;\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().streamInternalsBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().streamInternalsBuiltins().codeName##Source(), WTF::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(STREAMS_API)
