/* This file is automatically generated from CSSProperties.json by makeprop, do not edit */

#include "config.h"
#include "StyleBuilderGenerated.h"

#include "CSSPrimitiveValueMappings.h"
#include "CSSProperty.h"
#include "RenderStyle.h"
#include "StyleBuilderState.h"
#include "StyleBuilderConverter.h"
#include "StyleBuilderCustom.h"
#include "StylePropertyShorthand.h"

namespace WebCore {
namespace Style {

class BuilderFunctions {
public:
    static void applyInitialColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setColor(RenderStyle::initialColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkColor(RenderStyle::initialColor());
    }
    static void applyInheritColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkColor(color);
    }
    static void applyValueColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (primitiveValue.valueID() == CSSValueCurrentcolor) {
            applyInheritColor(builderState);
            return;
        }
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialDirection(BuilderState& builderState)
    {
        builderState.style().setDirection(RenderStyle::initialDirection());
    }
    static void applyInheritDirection(BuilderState& builderState)
    {
        builderState.style().setDirection(forwardInheritedValue(builderState.parentStyle().direction()));
    }
    static void applyInitialDisplay(BuilderState& builderState)
    {
        builderState.style().setDisplay(RenderStyle::initialDisplay());
    }
    static void applyValueFontFeatureSettings(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFeatureSettings(BuilderConverter::convertFontFeatureSettings(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontOpticalSizing(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setOpticalSizing(FontCascadeDescription::initialOpticalSizing());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontOpticalSizing(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setOpticalSizing(builderState.parentFontDescription().opticalSizing());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontOpticalSizing(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setOpticalSizing(downcast<CSSPrimitiveValue>(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontStretch(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setStretch(FontCascadeDescription::initialStretch());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontStretch(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setStretch(builderState.parentFontDescription().stretch());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontStretch(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setStretch(BuilderConverter::convertFontStretch(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontSynthesis(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesis(FontCascadeDescription::initialFontSynthesis());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontSynthesis(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesis(builderState.parentFontDescription().fontSynthesis());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontSynthesis(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesis(BuilderConverter::convertFontSynthesis(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontVariantAlternates(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantAlternates(FontCascadeDescription::initialVariantAlternates());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontVariantAlternates(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantAlternates(builderState.parentFontDescription().variantAlternates());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontVariantAlternates(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantAlternates(downcast<CSSPrimitiveValue>(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontVariantCaps(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantCaps(FontCascadeDescription::initialVariantCaps());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontVariantCaps(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantCaps(builderState.parentFontDescription().variantCaps());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontVariantCaps(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantCaps(downcast<CSSPrimitiveValue>(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontVariantPosition(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantPosition(FontCascadeDescription::initialVariantPosition());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontVariantPosition(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantPosition(builderState.parentFontDescription().variantPosition());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontVariantPosition(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantPosition(downcast<CSSPrimitiveValue>(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontVariationSettings(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariationSettings(BuilderConverter::convertFontVariationSettings(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontWeight(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setWeight(FontCascadeDescription::initialWeight());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontWeight(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setWeight(builderState.parentFontDescription().weight());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontWeight(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setWeight(BuilderConverter::convertFontWeight(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialTextRendering(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextRenderingMode(FontCascadeDescription::initialTextRenderingMode());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritTextRendering(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextRenderingMode(builderState.parentFontDescription().textRenderingMode());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueTextRendering(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextRenderingMode(downcast<CSSPrimitiveValue>(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialWritingMode(BuilderState& builderState)
    {
        builderState.style().setWritingMode(RenderStyle::initialWritingMode());
    }
    static void applyInheritWritingMode(BuilderState& builderState)
    {
        builderState.style().setWritingMode(forwardInheritedValue(builderState.parentStyle().writingMode()));
    }
    static void applyInitialWebkitFontKerning(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setKerning(FontCascadeDescription::initialKerning());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritWebkitFontKerning(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setKerning(builderState.parentFontDescription().kerning());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueWebkitFontKerning(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setKerning(downcast<CSSPrimitiveValue>(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialWebkitFontSmoothing(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSmoothing(FontCascadeDescription::initialFontSmoothing());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritWebkitFontSmoothing(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSmoothing(builderState.parentFontDescription().fontSmoothing());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueWebkitFontSmoothing(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSmoothing(downcast<CSSPrimitiveValue>(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialWebkitLocale(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setLocale(FontCascadeDescription::initialLocale());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritWebkitLocale(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setLocale(builderState.parentFontDescription().locale());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialWebkitTextOrientation(BuilderState& builderState)
    {
        builderState.style().setTextOrientation(RenderStyle::initialTextOrientation());
    }
    static void applyInheritWebkitTextOrientation(BuilderState& builderState)
    {
        builderState.style().setTextOrientation(forwardInheritedValue(builderState.parentStyle().textOrientation()));
    }
    static void applyInitialWebkitTextZoom(BuilderState& builderState)
    {
        builderState.style().setTextZoom(RenderStyle::initialTextZoom());
    }
    static void applyInheritWebkitTextZoom(BuilderState& builderState)
    {
        builderState.style().setTextZoom(forwardInheritedValue(builderState.parentStyle().textZoom()));
    }
    static void applyInitialAlignContent(BuilderState& builderState)
    {
        builderState.style().setAlignContent(RenderStyle::initialContentAlignment());
    }
    static void applyInheritAlignContent(BuilderState& builderState)
    {
        builderState.style().setAlignContent(forwardInheritedValue(builderState.parentStyle().alignContent()));
    }
    static void applyValueAlignContent(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAlignContent(BuilderConverter::convertContentAlignmentData(builderState, value));
    }
    static void applyInitialAlignItems(BuilderState& builderState)
    {
        builderState.style().setAlignItems(RenderStyle::initialDefaultAlignment());
    }
    static void applyInheritAlignItems(BuilderState& builderState)
    {
        builderState.style().setAlignItems(forwardInheritedValue(builderState.parentStyle().alignItems()));
    }
    static void applyValueAlignItems(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAlignItems(BuilderConverter::convertSelfOrDefaultAlignmentData(builderState, value));
    }
    static void applyInitialAlignSelf(BuilderState& builderState)
    {
        builderState.style().setAlignSelf(RenderStyle::initialSelfAlignment());
    }
    static void applyInheritAlignSelf(BuilderState& builderState)
    {
        builderState.style().setAlignSelf(forwardInheritedValue(builderState.parentStyle().alignSelf()));
    }
    static void applyValueAlignSelf(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAlignSelf(BuilderConverter::convertSelfOrDefaultAlignmentData(builderState, value));
    }
    static void applyInitialAlignmentBaseline(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setAlignmentBaseline(SVGRenderStyle::initialAlignmentBaseline());
    }
    static void applyInheritAlignmentBaseline(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setAlignmentBaseline(forwardInheritedValue(builderState.parentStyle().svgStyle().alignmentBaseline()));
    }
    static void applyValueAlignmentBaseline(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setAlignmentBaseline(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialAlt(BuilderState& builderState)
    {
        builderState.style().setContentAltText(RenderStyle::initialContentAltText());
    }
    static void applyInheritAlt(BuilderState& builderState)
    {
        builderState.style().setContentAltText(forwardInheritedValue(builderState.parentStyle().contentAltText()));
    }
    static void applyInitialAnimationDelay(BuilderState& builderState)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDelay(Animation::initialDelay());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyInheritAnimationDelay(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDelaySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDelay(parentList->animation(i).delay());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyValueAnimationDelay(BuilderState& builderState, CSSValue& value)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDelay(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDelay(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDelay();
        }
    }
    static void applyInitialAnimationDirection(BuilderState& builderState)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDirection(Animation::initialDirection());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDirection();
    }
    static void applyInheritAnimationDirection(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDirectionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDirection(parentList->animation(i).direction());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDirection();
    }
    static void applyValueAnimationDirection(BuilderState& builderState, CSSValue& value)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDirection(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDirection(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDirection();
        }
    }
    static void applyInitialAnimationDuration(BuilderState& builderState)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDuration(Animation::initialDuration());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyInheritAnimationDuration(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDurationSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDuration(parentList->animation(i).duration());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyValueAnimationDuration(BuilderState& builderState, CSSValue& value)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDuration(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDuration(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDuration();
        }
    }
    static void applyInitialAnimationFillMode(BuilderState& builderState)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setFillMode(Animation::initialFillMode());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearFillMode();
    }
    static void applyInheritAnimationFillMode(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isFillModeSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setFillMode(parentList->animation(i).fillMode());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearFillMode();
    }
    static void applyValueAnimationFillMode(BuilderState& builderState, CSSValue& value)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationFillMode(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationFillMode(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearFillMode();
        }
    }
    static void applyInitialAnimationIterationCount(BuilderState& builderState)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setIterationCount(Animation::initialIterationCount());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearIterationCount();
    }
    static void applyInheritAnimationIterationCount(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isIterationCountSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setIterationCount(parentList->animation(i).iterationCount());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearIterationCount();
    }
    static void applyValueAnimationIterationCount(BuilderState& builderState, CSSValue& value)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationIterationCount(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationIterationCount(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearIterationCount();
        }
    }
    static void applyInitialAnimationName(BuilderState& builderState)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setName(Animation::initialName());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearName();
    }
    static void applyInheritAnimationName(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isNameSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setName(parentList->animation(i).name());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearName();
    }
    static void applyValueAnimationName(BuilderState& builderState, CSSValue& value)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationName(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationName(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearName();
        }
    }
    static void applyInitialAnimationPlayState(BuilderState& builderState)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setPlayState(Animation::initialPlayState());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearPlayState();
    }
    static void applyInheritAnimationPlayState(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isPlayStateSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setPlayState(parentList->animation(i).playState());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearPlayState();
    }
    static void applyValueAnimationPlayState(BuilderState& builderState, CSSValue& value)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationPlayState(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationPlayState(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearPlayState();
        }
    }
    static void applyInitialAnimationTimingFunction(BuilderState& builderState)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setTimingFunction(Animation::initialTimingFunction());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyInheritAnimationTimingFunction(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isTimingFunctionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setTimingFunction(parentList->animation(i).timingFunction());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyValueAnimationTimingFunction(BuilderState& builderState, CSSValue& value)
    {
        AnimationList& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationTimingFunction(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationTimingFunction(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearTimingFunction();
        }
    }
    static void applyInitialBackgroundAttachment(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isAttachmentSet() || layers.attachment() == FillLayer::initialFillAttachment(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setAttachment(FillLayer::initialFillAttachment(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearAttachment();
    }
    static void applyInheritBackgroundAttachment(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isAttachmentSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setAttachment(parent->attachment());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearAttachment();
    }
    static void applyValueBackgroundAttachment(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillAttachment(CSSPropertyBackgroundAttachment, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillAttachment(CSSPropertyBackgroundAttachment, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearAttachment();
    }
    static void applyInitialBackgroundBlendMode(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isBlendModeSet() || layers.blendMode() == FillLayer::initialFillBlendMode(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setBlendMode(FillLayer::initialFillBlendMode(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearBlendMode();
    }
    static void applyInheritBackgroundBlendMode(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isBlendModeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setBlendMode(parent->blendMode());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearBlendMode();
    }
    static void applyValueBackgroundBlendMode(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillBlendMode(CSSPropertyBackgroundBlendMode, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillBlendMode(CSSPropertyBackgroundBlendMode, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearBlendMode();
    }
    static void applyInitialBackgroundClip(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isClipSet() || layers.clip() == FillLayer::initialFillClip(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setClip(FillLayer::initialFillClip(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearClip();
    }
    static void applyInheritBackgroundClip(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isClipSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setClip(parent->clip());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyValueBackgroundClip(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillClip(CSSPropertyBackgroundClip, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillClip(CSSPropertyBackgroundClip, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyInitialBackgroundColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBackgroundColor(RenderStyle::initialBackgroundColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBackgroundColor(RenderStyle::initialBackgroundColor());
    }
    static void applyInheritBackgroundColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().backgroundColor();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBackgroundColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBackgroundColor(color);
    }
    static void applyValueBackgroundColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBackgroundColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBackgroundColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialBackgroundImage(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isImageSet() || layers.image() == FillLayer::initialFillImage(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setImage(FillLayer::initialFillImage(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearImage();
    }
    static void applyInheritBackgroundImage(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isImageSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setImage(parent->image());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyValueBackgroundImage(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillImage(CSSPropertyBackgroundImage, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillImage(CSSPropertyBackgroundImage, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyInitialBackgroundOrigin(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isOriginSet() || layers.origin() == FillLayer::initialFillOrigin(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setOrigin(FillLayer::initialFillOrigin(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearOrigin();
    }
    static void applyInheritBackgroundOrigin(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isOriginSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setOrigin(parent->origin());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyValueBackgroundOrigin(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillOrigin(CSSPropertyBackgroundOrigin, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillOrigin(CSSPropertyBackgroundOrigin, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyInitialBackgroundPositionX(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isXPositionSet() || layers.xPosition() == FillLayer::initialFillXPosition(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setXPosition(FillLayer::initialFillXPosition(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearXPosition();
    }
    static void applyInheritBackgroundPositionX(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isXPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setXPosition(parent->xPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyValueBackgroundPositionX(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillXPosition(CSSPropertyBackgroundPositionX, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillXPosition(CSSPropertyBackgroundPositionX, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyInitialBackgroundPositionY(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isYPositionSet() || layers.yPosition() == FillLayer::initialFillYPosition(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setYPosition(FillLayer::initialFillYPosition(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearYPosition();
    }
    static void applyInheritBackgroundPositionY(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isYPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setYPosition(parent->yPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyValueBackgroundPositionY(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillYPosition(CSSPropertyBackgroundPositionY, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillYPosition(CSSPropertyBackgroundPositionY, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyInitialBackgroundRepeatX(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isRepeatXSet() || layers.repeatX() == FillLayer::initialFillRepeatX(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setRepeatX(FillLayer::initialFillRepeatX(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearRepeatX();
    }
    static void applyInheritBackgroundRepeatX(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isRepeatXSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setRepeatX(parent->repeatX());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearRepeatX();
    }
    static void applyValueBackgroundRepeatX(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillRepeatX(CSSPropertyBackgroundRepeatX, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillRepeatX(CSSPropertyBackgroundRepeatX, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearRepeatX();
    }
    static void applyInitialBackgroundRepeatY(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isRepeatYSet() || layers.repeatY() == FillLayer::initialFillRepeatY(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setRepeatY(FillLayer::initialFillRepeatY(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearRepeatY();
    }
    static void applyInheritBackgroundRepeatY(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isRepeatYSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setRepeatY(parent->repeatY());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearRepeatY();
    }
    static void applyValueBackgroundRepeatY(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillRepeatY(CSSPropertyBackgroundRepeatY, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillRepeatY(CSSPropertyBackgroundRepeatY, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearRepeatY();
    }
    static void applyInitialBackgroundSize(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isSizeSet() || layers.size() == FillLayer::initialFillSize(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setSize(FillLayer::initialFillSize(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearSize();
    }
    static void applyInheritBackgroundSize(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isSizeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setSize(parent->size());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyValueBackgroundSize(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillSize(CSSPropertyBackgroundSize, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillSize(CSSPropertyBackgroundSize, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyInitialBaselineShift(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setBaselineShift(SVGRenderStyle::initialBaselineShift());
    }
    static void applyInheritBaselineShift(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setBaselineShift(forwardInheritedValue(builderState.parentStyle().svgStyle().baselineShift()));
    }
    static void applyInitialBorderBottomColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderBottomColor(RenderStyle::invalidColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderBottomColor(RenderStyle::invalidColor());
    }
    static void applyInheritBorderBottomColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().borderBottomColor();
        if (!color.isValid())
            color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderBottomColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderBottomColor(color);
    }
    static void applyValueBorderBottomColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderBottomColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderBottomColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialBorderBottomLeftRadius(BuilderState& builderState)
    {
        builderState.style().setBorderBottomLeftRadius(RenderStyle::initialBorderRadius());
    }
    static void applyInheritBorderBottomLeftRadius(BuilderState& builderState)
    {
        builderState.style().setBorderBottomLeftRadius(forwardInheritedValue(builderState.parentStyle().borderBottomLeftRadius()));
    }
    static void applyValueBorderBottomLeftRadius(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderBottomLeftRadius(BuilderConverter::convertRadius(builderState, value));
    }
    static void applyInitialBorderBottomRightRadius(BuilderState& builderState)
    {
        builderState.style().setBorderBottomRightRadius(RenderStyle::initialBorderRadius());
    }
    static void applyInheritBorderBottomRightRadius(BuilderState& builderState)
    {
        builderState.style().setBorderBottomRightRadius(forwardInheritedValue(builderState.parentStyle().borderBottomRightRadius()));
    }
    static void applyValueBorderBottomRightRadius(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderBottomRightRadius(BuilderConverter::convertRadius(builderState, value));
    }
    static void applyInitialBorderBottomStyle(BuilderState& builderState)
    {
        builderState.style().setBorderBottomStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderBottomStyle(BuilderState& builderState)
    {
        builderState.style().setBorderBottomStyle(forwardInheritedValue(builderState.parentStyle().borderBottomStyle()));
    }
    static void applyValueBorderBottomStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderBottomStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBorderBottomWidth(BuilderState& builderState)
    {
        builderState.style().setBorderBottomWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderBottomWidth(BuilderState& builderState)
    {
        builderState.style().setBorderBottomWidth(forwardInheritedValue(builderState.parentStyle().borderBottomWidth()));
    }
    static void applyValueBorderBottomWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderBottomWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialBorderCollapse(BuilderState& builderState)
    {
        builderState.style().setBorderCollapse(RenderStyle::initialBorderCollapse());
    }
    static void applyInheritBorderCollapse(BuilderState& builderState)
    {
        builderState.style().setBorderCollapse(forwardInheritedValue(builderState.parentStyle().borderCollapse()));
    }
    static void applyValueBorderCollapse(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderCollapse(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBorderImageSource(BuilderState& builderState)
    {
        builderState.style().setBorderImageSource(RenderStyle::initialBorderImageSource());
    }
    static void applyInheritBorderImageSource(BuilderState& builderState)
    {
        builderState.style().setBorderImageSource(forwardInheritedValue(builderState.parentStyle().borderImageSource()));
    }
    static void applyValueBorderImageSource(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderImageSource(BuilderConverter::convertStyleImage<CSSPropertyBorderImageSource>(builderState, value));
    }
    static void applyInitialBorderLeftColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderLeftColor(RenderStyle::invalidColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderLeftColor(RenderStyle::invalidColor());
    }
    static void applyInheritBorderLeftColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().borderLeftColor();
        if (!color.isValid())
            color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderLeftColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderLeftColor(color);
    }
    static void applyValueBorderLeftColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderLeftColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderLeftColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialBorderLeftStyle(BuilderState& builderState)
    {
        builderState.style().setBorderLeftStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderLeftStyle(BuilderState& builderState)
    {
        builderState.style().setBorderLeftStyle(forwardInheritedValue(builderState.parentStyle().borderLeftStyle()));
    }
    static void applyValueBorderLeftStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderLeftStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBorderLeftWidth(BuilderState& builderState)
    {
        builderState.style().setBorderLeftWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderLeftWidth(BuilderState& builderState)
    {
        builderState.style().setBorderLeftWidth(forwardInheritedValue(builderState.parentStyle().borderLeftWidth()));
    }
    static void applyValueBorderLeftWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderLeftWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialBorderRightColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderRightColor(RenderStyle::invalidColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderRightColor(RenderStyle::invalidColor());
    }
    static void applyInheritBorderRightColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().borderRightColor();
        if (!color.isValid())
            color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderRightColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderRightColor(color);
    }
    static void applyValueBorderRightColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderRightColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderRightColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialBorderRightStyle(BuilderState& builderState)
    {
        builderState.style().setBorderRightStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderRightStyle(BuilderState& builderState)
    {
        builderState.style().setBorderRightStyle(forwardInheritedValue(builderState.parentStyle().borderRightStyle()));
    }
    static void applyValueBorderRightStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderRightStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBorderRightWidth(BuilderState& builderState)
    {
        builderState.style().setBorderRightWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderRightWidth(BuilderState& builderState)
    {
        builderState.style().setBorderRightWidth(forwardInheritedValue(builderState.parentStyle().borderRightWidth()));
    }
    static void applyValueBorderRightWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderRightWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialBorderTopColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderTopColor(RenderStyle::invalidColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderTopColor(RenderStyle::invalidColor());
    }
    static void applyInheritBorderTopColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().borderTopColor();
        if (!color.isValid())
            color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderTopColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderTopColor(color);
    }
    static void applyValueBorderTopColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderTopColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderTopColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialBorderTopLeftRadius(BuilderState& builderState)
    {
        builderState.style().setBorderTopLeftRadius(RenderStyle::initialBorderRadius());
    }
    static void applyInheritBorderTopLeftRadius(BuilderState& builderState)
    {
        builderState.style().setBorderTopLeftRadius(forwardInheritedValue(builderState.parentStyle().borderTopLeftRadius()));
    }
    static void applyValueBorderTopLeftRadius(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderTopLeftRadius(BuilderConverter::convertRadius(builderState, value));
    }
    static void applyInitialBorderTopRightRadius(BuilderState& builderState)
    {
        builderState.style().setBorderTopRightRadius(RenderStyle::initialBorderRadius());
    }
    static void applyInheritBorderTopRightRadius(BuilderState& builderState)
    {
        builderState.style().setBorderTopRightRadius(forwardInheritedValue(builderState.parentStyle().borderTopRightRadius()));
    }
    static void applyValueBorderTopRightRadius(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderTopRightRadius(BuilderConverter::convertRadius(builderState, value));
    }
    static void applyInitialBorderTopStyle(BuilderState& builderState)
    {
        builderState.style().setBorderTopStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderTopStyle(BuilderState& builderState)
    {
        builderState.style().setBorderTopStyle(forwardInheritedValue(builderState.parentStyle().borderTopStyle()));
    }
    static void applyValueBorderTopStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderTopStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBorderTopWidth(BuilderState& builderState)
    {
        builderState.style().setBorderTopWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderTopWidth(BuilderState& builderState)
    {
        builderState.style().setBorderTopWidth(forwardInheritedValue(builderState.parentStyle().borderTopWidth()));
    }
    static void applyValueBorderTopWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderTopWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialBottom(BuilderState& builderState)
    {
        builderState.style().setBottom(RenderStyle::initialOffset());
    }
    static void applyInheritBottom(BuilderState& builderState)
    {
        builderState.style().setBottom(forwardInheritedValue(builderState.parentStyle().bottom()));
    }
    static void applyValueBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBottom(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialBoxSizing(BuilderState& builderState)
    {
        builderState.style().setBoxSizing(RenderStyle::initialBoxSizing());
    }
    static void applyInheritBoxSizing(BuilderState& builderState)
    {
        builderState.style().setBoxSizing(forwardInheritedValue(builderState.parentStyle().boxSizing()));
    }
    static void applyValueBoxSizing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxSizing(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBreakAfter(BuilderState& builderState)
    {
        builderState.style().setBreakAfter(RenderStyle::initialBreakBetween());
    }
    static void applyInheritBreakAfter(BuilderState& builderState)
    {
        builderState.style().setBreakAfter(forwardInheritedValue(builderState.parentStyle().breakAfter()));
    }
    static void applyValueBreakAfter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBreakAfter(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBreakBefore(BuilderState& builderState)
    {
        builderState.style().setBreakBefore(RenderStyle::initialBreakBetween());
    }
    static void applyInheritBreakBefore(BuilderState& builderState)
    {
        builderState.style().setBreakBefore(forwardInheritedValue(builderState.parentStyle().breakBefore()));
    }
    static void applyValueBreakBefore(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBreakBefore(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBreakInside(BuilderState& builderState)
    {
        builderState.style().setBreakInside(RenderStyle::initialBreakInside());
    }
    static void applyInheritBreakInside(BuilderState& builderState)
    {
        builderState.style().setBreakInside(forwardInheritedValue(builderState.parentStyle().breakInside()));
    }
    static void applyValueBreakInside(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBreakInside(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBufferedRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setBufferedRendering(SVGRenderStyle::initialBufferedRendering());
    }
    static void applyInheritBufferedRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setBufferedRendering(forwardInheritedValue(builderState.parentStyle().svgStyle().bufferedRendering()));
    }
    static void applyValueBufferedRendering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setBufferedRendering(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialCaptionSide(BuilderState& builderState)
    {
        builderState.style().setCaptionSide(RenderStyle::initialCaptionSide());
    }
    static void applyInheritCaptionSide(BuilderState& builderState)
    {
        builderState.style().setCaptionSide(forwardInheritedValue(builderState.parentStyle().captionSide()));
    }
    static void applyValueCaptionSide(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCaptionSide(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialCaretColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setCaretColor(RenderStyle::invalidColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkCaretColor(RenderStyle::invalidColor());
    }
    static void applyInheritCaretColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().caretColor();
        if (!color.isValid())
            color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setCaretColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkCaretColor(color);
    }
    static void applyValueCaretColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setCaretColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkCaretColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialClear(BuilderState& builderState)
    {
        builderState.style().setClear(RenderStyle::initialClear());
    }
    static void applyInheritClear(BuilderState& builderState)
    {
        builderState.style().setClear(forwardInheritedValue(builderState.parentStyle().clear()));
    }
    static void applyValueClear(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setClear(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialClipPath(BuilderState& builderState)
    {
        builderState.style().setClipPath(RenderStyle::initialClipPath());
    }
    static void applyInheritClipPath(BuilderState& builderState)
    {
        builderState.style().setClipPath(forwardInheritedValue(builderState.parentStyle().clipPath()));
    }
    static void applyValueClipPath(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setClipPath(BuilderConverter::convertClipPath(builderState, value));
    }
    static void applyInitialClipRule(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setClipRule(SVGRenderStyle::initialClipRule());
    }
    static void applyInheritClipRule(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setClipRule(forwardInheritedValue(builderState.parentStyle().svgStyle().clipRule()));
    }
    static void applyValueClipRule(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setClipRule(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColorInterpolation(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorInterpolation(SVGRenderStyle::initialColorInterpolation());
    }
    static void applyInheritColorInterpolation(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorInterpolation(forwardInheritedValue(builderState.parentStyle().svgStyle().colorInterpolation()));
    }
    static void applyValueColorInterpolation(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setColorInterpolation(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColorInterpolationFilters(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorInterpolationFilters(SVGRenderStyle::initialColorInterpolationFilters());
    }
    static void applyInheritColorInterpolationFilters(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorInterpolationFilters(forwardInheritedValue(builderState.parentStyle().svgStyle().colorInterpolationFilters()));
    }
    static void applyValueColorInterpolationFilters(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setColorInterpolationFilters(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColorRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorRendering(SVGRenderStyle::initialColorRendering());
    }
    static void applyInheritColorRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorRendering(forwardInheritedValue(builderState.parentStyle().svgStyle().colorRendering()));
    }
    static void applyValueColorRendering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setColorRendering(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColumnCount(BuilderState& builderState)
    {
        builderState.style().setHasAutoColumnCount();
    }
    static void applyInheritColumnCount(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoColumnCount()) {
            builderState.style().setHasAutoColumnCount();
            return;
        }
        builderState.style().setColumnCount(forwardInheritedValue(builderState.parentStyle().columnCount()));
    }
    static void applyValueColumnCount(BuilderState& builderState, CSSValue& value)
    {
        if (downcast<CSSPrimitiveValue>(value).valueID() == CSSValueAuto) {
            builderState.style().setHasAutoColumnCount();
            return;
        }
        builderState.style().setColumnCount(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColumnFill(BuilderState& builderState)
    {
        builderState.style().setColumnFill(RenderStyle::initialColumnFill());
    }
    static void applyInheritColumnFill(BuilderState& builderState)
    {
        builderState.style().setColumnFill(forwardInheritedValue(builderState.parentStyle().columnFill()));
    }
    static void applyValueColumnFill(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnFill(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColumnGap(BuilderState& builderState)
    {
        builderState.style().setColumnGap(RenderStyle::initialColumnGap());
    }
    static void applyInheritColumnGap(BuilderState& builderState)
    {
        builderState.style().setColumnGap(forwardInheritedValue(builderState.parentStyle().columnGap()));
    }
    static void applyValueColumnGap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnGap(BuilderConverter::convertGapLength(builderState, value));
    }
    static void applyInitialColumnRuleColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setColumnRuleColor(RenderStyle::invalidColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkColumnRuleColor(RenderStyle::invalidColor());
    }
    static void applyInheritColumnRuleColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().columnRuleColor();
        if (!color.isValid())
            color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setColumnRuleColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkColumnRuleColor(color);
    }
    static void applyValueColumnRuleColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setColumnRuleColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkColumnRuleColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialColumnRuleStyle(BuilderState& builderState)
    {
        builderState.style().setColumnRuleStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritColumnRuleStyle(BuilderState& builderState)
    {
        builderState.style().setColumnRuleStyle(forwardInheritedValue(builderState.parentStyle().columnRuleStyle()));
    }
    static void applyValueColumnRuleStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnRuleStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColumnRuleWidth(BuilderState& builderState)
    {
        builderState.style().setColumnRuleWidth(RenderStyle::initialColumnRuleWidth());
    }
    static void applyInheritColumnRuleWidth(BuilderState& builderState)
    {
        builderState.style().setColumnRuleWidth(forwardInheritedValue(builderState.parentStyle().columnRuleWidth()));
    }
    static void applyValueColumnRuleWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnRuleWidth(BuilderConverter::convertLineWidth<unsigned short>(builderState, value));
    }
    static void applyInitialColumnSpan(BuilderState& builderState)
    {
        builderState.style().setColumnSpan(RenderStyle::initialColumnSpan());
    }
    static void applyInheritColumnSpan(BuilderState& builderState)
    {
        builderState.style().setColumnSpan(forwardInheritedValue(builderState.parentStyle().columnSpan()));
    }
    static void applyValueColumnSpan(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnSpan(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColumnWidth(BuilderState& builderState)
    {
        builderState.style().setHasAutoColumnWidth();
    }
    static void applyInheritColumnWidth(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoColumnWidth()) {
            builderState.style().setHasAutoColumnWidth();
            return;
        }
        builderState.style().setColumnWidth(forwardInheritedValue(builderState.parentStyle().columnWidth()));
    }
    static void applyValueColumnWidth(BuilderState& builderState, CSSValue& value)
    {
        if (downcast<CSSPrimitiveValue>(value).valueID() == CSSValueAuto) {
            builderState.style().setHasAutoColumnWidth();
            return;
        }
        builderState.style().setColumnWidth(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialCx(BuilderState& builderState)
    {
        builderState.style().setCx(RenderStyle::initialZeroLength());
    }
    static void applyInheritCx(BuilderState& builderState)
    {
        builderState.style().setCx(forwardInheritedValue(builderState.parentStyle().cx()));
    }
    static void applyValueCx(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCx(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialCy(BuilderState& builderState)
    {
        builderState.style().setCy(RenderStyle::initialZeroLength());
    }
    static void applyInheritCy(BuilderState& builderState)
    {
        builderState.style().setCy(forwardInheritedValue(builderState.parentStyle().cy()));
    }
    static void applyValueCy(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCy(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialDominantBaseline(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setDominantBaseline(SVGRenderStyle::initialDominantBaseline());
    }
    static void applyInheritDominantBaseline(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setDominantBaseline(forwardInheritedValue(builderState.parentStyle().svgStyle().dominantBaseline()));
    }
    static void applyValueDominantBaseline(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setDominantBaseline(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialEmptyCells(BuilderState& builderState)
    {
        builderState.style().setEmptyCells(RenderStyle::initialEmptyCells());
    }
    static void applyInheritEmptyCells(BuilderState& builderState)
    {
        builderState.style().setEmptyCells(forwardInheritedValue(builderState.parentStyle().emptyCells()));
    }
    static void applyValueEmptyCells(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setEmptyCells(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFillOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFillOpacity(SVGRenderStyle::initialFillOpacity());
    }
    static void applyInheritFillOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFillOpacity(forwardInheritedValue(builderState.parentStyle().svgStyle().fillOpacity()));
    }
    static void applyValueFillOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setFillOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialFillRule(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFillRule(SVGRenderStyle::initialFillRule());
    }
    static void applyInheritFillRule(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFillRule(forwardInheritedValue(builderState.parentStyle().svgStyle().fillRule()));
    }
    static void applyValueFillRule(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setFillRule(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFilter(BuilderState& builderState)
    {
        builderState.style().setFilter(RenderStyle::initialFilter());
    }
    static void applyInheritFilter(BuilderState& builderState)
    {
        builderState.style().setFilter(forwardInheritedValue(builderState.parentStyle().filter()));
    }
    static void applyValueFilter(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertFilterOperations(builderState, value);
        if (convertedValue)
            builderState.style().setFilter(WTFMove(convertedValue.value()));
    }
    static void applyInitialFlexBasis(BuilderState& builderState)
    {
        builderState.style().setFlexBasis(RenderStyle::initialFlexBasis());
    }
    static void applyInheritFlexBasis(BuilderState& builderState)
    {
        builderState.style().setFlexBasis(forwardInheritedValue(builderState.parentStyle().flexBasis()));
    }
    static void applyValueFlexBasis(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexBasis(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialFlexDirection(BuilderState& builderState)
    {
        builderState.style().setFlexDirection(RenderStyle::initialFlexDirection());
    }
    static void applyInheritFlexDirection(BuilderState& builderState)
    {
        builderState.style().setFlexDirection(forwardInheritedValue(builderState.parentStyle().flexDirection()));
    }
    static void applyValueFlexDirection(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexDirection(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFlexGrow(BuilderState& builderState)
    {
        builderState.style().setFlexGrow(RenderStyle::initialFlexGrow());
    }
    static void applyInheritFlexGrow(BuilderState& builderState)
    {
        builderState.style().setFlexGrow(forwardInheritedValue(builderState.parentStyle().flexGrow()));
    }
    static void applyValueFlexGrow(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexGrow(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFlexShrink(BuilderState& builderState)
    {
        builderState.style().setFlexShrink(RenderStyle::initialFlexShrink());
    }
    static void applyInheritFlexShrink(BuilderState& builderState)
    {
        builderState.style().setFlexShrink(forwardInheritedValue(builderState.parentStyle().flexShrink()));
    }
    static void applyValueFlexShrink(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexShrink(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFlexWrap(BuilderState& builderState)
    {
        builderState.style().setFlexWrap(RenderStyle::initialFlexWrap());
    }
    static void applyInheritFlexWrap(BuilderState& builderState)
    {
        builderState.style().setFlexWrap(forwardInheritedValue(builderState.parentStyle().flexWrap()));
    }
    static void applyValueFlexWrap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexWrap(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFloat(BuilderState& builderState)
    {
        builderState.style().setFloating(RenderStyle::initialFloating());
    }
    static void applyInheritFloat(BuilderState& builderState)
    {
        builderState.style().setFloating(forwardInheritedValue(builderState.parentStyle().floating()));
    }
    static void applyValueFloat(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFloating(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFloodColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFloodColor(SVGRenderStyle::initialFloodColor());
    }
    static void applyInheritFloodColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFloodColor(forwardInheritedValue(builderState.parentStyle().svgStyle().floodColor()));
    }
    static void applyValueFloodColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setFloodColor(BuilderConverter::convertSVGColor(builderState, value));
    }
    static void applyInitialFloodOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFloodOpacity(SVGRenderStyle::initialFloodOpacity());
    }
    static void applyInheritFloodOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFloodOpacity(forwardInheritedValue(builderState.parentStyle().svgStyle().floodOpacity()));
    }
    static void applyValueFloodOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setFloodOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialGlyphOrientationHorizontal(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationHorizontal(SVGRenderStyle::initialGlyphOrientationHorizontal());
    }
    static void applyInheritGlyphOrientationHorizontal(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationHorizontal(forwardInheritedValue(builderState.parentStyle().svgStyle().glyphOrientationHorizontal()));
    }
    static void applyValueGlyphOrientationHorizontal(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationHorizontal(BuilderConverter::convertGlyphOrientation(builderState, value));
    }
    static void applyInitialGlyphOrientationVertical(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationVertical(SVGRenderStyle::initialGlyphOrientationVertical());
    }
    static void applyInheritGlyphOrientationVertical(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationVertical(forwardInheritedValue(builderState.parentStyle().svgStyle().glyphOrientationVertical()));
    }
    static void applyValueGlyphOrientationVertical(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationVertical(BuilderConverter::convertGlyphOrientationOrAuto(builderState, value));
    }
    static void applyInitialGridAutoColumns(BuilderState& builderState)
    {
        builderState.style().setGridAutoColumns(RenderStyle::initialGridAutoColumns());
    }
    static void applyInheritGridAutoColumns(BuilderState& builderState)
    {
        builderState.style().setGridAutoColumns(forwardInheritedValue(builderState.parentStyle().gridAutoColumns()));
    }
    static void applyValueGridAutoColumns(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setGridAutoColumns(BuilderConverter::convertGridTrackSizeList(builderState, value));
    }
    static void applyInitialGridAutoFlow(BuilderState& builderState)
    {
        builderState.style().setGridAutoFlow(RenderStyle::initialGridAutoFlow());
    }
    static void applyInheritGridAutoFlow(BuilderState& builderState)
    {
        builderState.style().setGridAutoFlow(forwardInheritedValue(builderState.parentStyle().gridAutoFlow()));
    }
    static void applyValueGridAutoFlow(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setGridAutoFlow(BuilderConverter::convertGridAutoFlow(builderState, value));
    }
    static void applyInitialGridAutoRows(BuilderState& builderState)
    {
        builderState.style().setGridAutoRows(RenderStyle::initialGridAutoRows());
    }
    static void applyInheritGridAutoRows(BuilderState& builderState)
    {
        builderState.style().setGridAutoRows(forwardInheritedValue(builderState.parentStyle().gridAutoRows()));
    }
    static void applyValueGridAutoRows(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setGridAutoRows(BuilderConverter::convertGridTrackSizeList(builderState, value));
    }
    static void applyInitialGridColumnEnd(BuilderState& builderState)
    {
        builderState.style().setGridItemColumnEnd(RenderStyle::initialGridItemColumnEnd());
    }
    static void applyInheritGridColumnEnd(BuilderState& builderState)
    {
        builderState.style().setGridItemColumnEnd(forwardInheritedValue(builderState.parentStyle().gridItemColumnEnd()));
    }
    static void applyValueGridColumnEnd(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertGridPosition(builderState, value);
        if (convertedValue)
            builderState.style().setGridItemColumnEnd(WTFMove(convertedValue.value()));
    }
    static void applyInitialGridColumnStart(BuilderState& builderState)
    {
        builderState.style().setGridItemColumnStart(RenderStyle::initialGridItemColumnStart());
    }
    static void applyInheritGridColumnStart(BuilderState& builderState)
    {
        builderState.style().setGridItemColumnStart(forwardInheritedValue(builderState.parentStyle().gridItemColumnStart()));
    }
    static void applyValueGridColumnStart(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertGridPosition(builderState, value);
        if (convertedValue)
            builderState.style().setGridItemColumnStart(WTFMove(convertedValue.value()));
    }
    static void applyInitialGridRowEnd(BuilderState& builderState)
    {
        builderState.style().setGridItemRowEnd(RenderStyle::initialGridItemRowEnd());
    }
    static void applyInheritGridRowEnd(BuilderState& builderState)
    {
        builderState.style().setGridItemRowEnd(forwardInheritedValue(builderState.parentStyle().gridItemRowEnd()));
    }
    static void applyValueGridRowEnd(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertGridPosition(builderState, value);
        if (convertedValue)
            builderState.style().setGridItemRowEnd(WTFMove(convertedValue.value()));
    }
    static void applyInitialGridRowStart(BuilderState& builderState)
    {
        builderState.style().setGridItemRowStart(RenderStyle::initialGridItemRowStart());
    }
    static void applyInheritGridRowStart(BuilderState& builderState)
    {
        builderState.style().setGridItemRowStart(forwardInheritedValue(builderState.parentStyle().gridItemRowStart()));
    }
    static void applyValueGridRowStart(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertGridPosition(builderState, value);
        if (convertedValue)
            builderState.style().setGridItemRowStart(WTFMove(convertedValue.value()));
    }
    static void applyInitialHangingPunctuation(BuilderState& builderState)
    {
        builderState.style().setHangingPunctuation(RenderStyle::initialHangingPunctuation());
    }
    static void applyInheritHangingPunctuation(BuilderState& builderState)
    {
        builderState.style().setHangingPunctuation(forwardInheritedValue(builderState.parentStyle().hangingPunctuation()));
    }
    static void applyValueHangingPunctuation(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHangingPunctuation(BuilderConverter::convertHangingPunctuation(builderState, value));
    }
    static void applyInitialHeight(BuilderState& builderState)
    {
        builderState.style().setHeight(RenderStyle::initialSize());
    }
    static void applyInheritHeight(BuilderState& builderState)
    {
        builderState.style().setHeight(forwardInheritedValue(builderState.parentStyle().height()));
    }
    static void applyValueHeight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHeight(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialImageOrientation(BuilderState& builderState)
    {
        builderState.style().setImageOrientation(RenderStyle::initialImageOrientation());
    }
    static void applyInheritImageOrientation(BuilderState& builderState)
    {
        builderState.style().setImageOrientation(forwardInheritedValue(builderState.parentStyle().imageOrientation()));
    }
    static void applyValueImageOrientation(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setImageOrientation(BuilderConverter::convertImageOrientation(builderState, value));
    }
    static void applyInitialImageRendering(BuilderState& builderState)
    {
        builderState.style().setImageRendering(RenderStyle::initialImageRendering());
    }
    static void applyInheritImageRendering(BuilderState& builderState)
    {
        builderState.style().setImageRendering(forwardInheritedValue(builderState.parentStyle().imageRendering()));
    }
    static void applyValueImageRendering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setImageRendering(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialIsolation(BuilderState& builderState)
    {
        builderState.style().setIsolation(RenderStyle::initialIsolation());
    }
    static void applyInheritIsolation(BuilderState& builderState)
    {
        builderState.style().setIsolation(forwardInheritedValue(builderState.parentStyle().isolation()));
    }
    static void applyValueIsolation(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setIsolation(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialJustifyContent(BuilderState& builderState)
    {
        builderState.style().setJustifyContent(RenderStyle::initialContentAlignment());
    }
    static void applyInheritJustifyContent(BuilderState& builderState)
    {
        builderState.style().setJustifyContent(forwardInheritedValue(builderState.parentStyle().justifyContent()));
    }
    static void applyValueJustifyContent(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setJustifyContent(BuilderConverter::convertContentAlignmentData(builderState, value));
    }
    static void applyInitialJustifyItems(BuilderState& builderState)
    {
        builderState.style().setJustifyItems(RenderStyle::initialJustifyItems());
    }
    static void applyInheritJustifyItems(BuilderState& builderState)
    {
        builderState.style().setJustifyItems(forwardInheritedValue(builderState.parentStyle().justifyItems()));
    }
    static void applyValueJustifyItems(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setJustifyItems(BuilderConverter::convertSelfOrDefaultAlignmentData(builderState, value));
    }
    static void applyInitialJustifySelf(BuilderState& builderState)
    {
        builderState.style().setJustifySelf(RenderStyle::initialSelfAlignment());
    }
    static void applyInheritJustifySelf(BuilderState& builderState)
    {
        builderState.style().setJustifySelf(forwardInheritedValue(builderState.parentStyle().justifySelf()));
    }
    static void applyValueJustifySelf(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setJustifySelf(BuilderConverter::convertSelfOrDefaultAlignmentData(builderState, value));
    }
    static void applyInitialKerning(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setKerning(SVGRenderStyle::initialKerning());
    }
    static void applyInheritKerning(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setKerning(forwardInheritedValue(builderState.parentStyle().svgStyle().kerning()));
    }
    static void applyValueKerning(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setKerning(BuilderConverter::convertSVGLengthValue(builderState, value));
    }
    static void applyInitialLeft(BuilderState& builderState)
    {
        builderState.style().setLeft(RenderStyle::initialOffset());
    }
    static void applyInheritLeft(BuilderState& builderState)
    {
        builderState.style().setLeft(forwardInheritedValue(builderState.parentStyle().left()));
    }
    static void applyValueLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLeft(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialLetterSpacing(BuilderState& builderState)
    {
        builderState.style().setLetterSpacing(RenderStyle::initialLetterSpacing());
    }
    static void applyInheritLetterSpacing(BuilderState& builderState)
    {
        builderState.style().setLetterSpacing(forwardInheritedValue(builderState.parentStyle().letterSpacing()));
    }
    static void applyValueLetterSpacing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLetterSpacing(BuilderConverter::convertSpacing(builderState, value));
    }
    static void applyInitialLightingColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setLightingColor(SVGRenderStyle::initialLightingColor());
    }
    static void applyInheritLightingColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setLightingColor(forwardInheritedValue(builderState.parentStyle().svgStyle().lightingColor()));
    }
    static void applyValueLightingColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setLightingColor(BuilderConverter::convertSVGColor(builderState, value));
    }
    static void applyInitialLineBreak(BuilderState& builderState)
    {
        builderState.style().setLineBreak(RenderStyle::initialLineBreak());
    }
    static void applyInheritLineBreak(BuilderState& builderState)
    {
        builderState.style().setLineBreak(forwardInheritedValue(builderState.parentStyle().lineBreak()));
    }
    static void applyValueLineBreak(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineBreak(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialLineHeight(BuilderState& builderState)
    {
        builderState.style().setLineHeight(RenderStyle::initialLineHeight());
    }
    static void applyInheritLineHeight(BuilderState& builderState)
    {
        builderState.style().setLineHeight(forwardInheritedValue(builderState.parentStyle().specifiedLineHeight()));
    }
    static void applyValueLineHeight(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertLineHeight(builderState, value);
        if (convertedValue)
            builderState.style().setLineHeight(WTFMove(convertedValue.value()));
    }
    static void applyInitialListStyleImage(BuilderState& builderState)
    {
        builderState.style().setListStyleImage(RenderStyle::initialListStyleImage());
    }
    static void applyInheritListStyleImage(BuilderState& builderState)
    {
        builderState.style().setListStyleImage(forwardInheritedValue(builderState.parentStyle().listStyleImage()));
    }
    static void applyValueListStyleImage(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setListStyleImage(BuilderConverter::convertStyleImage<CSSPropertyListStyleImage>(builderState, value));
    }
    static void applyInitialListStylePosition(BuilderState& builderState)
    {
        builderState.style().setListStylePosition(RenderStyle::initialListStylePosition());
    }
    static void applyInheritListStylePosition(BuilderState& builderState)
    {
        builderState.style().setListStylePosition(forwardInheritedValue(builderState.parentStyle().listStylePosition()));
    }
    static void applyValueListStylePosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setListStylePosition(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialListStyleType(BuilderState& builderState)
    {
        builderState.style().setListStyleType(RenderStyle::initialListStyleType());
    }
    static void applyInheritListStyleType(BuilderState& builderState)
    {
        builderState.style().setListStyleType(forwardInheritedValue(builderState.parentStyle().listStyleType()));
    }
    static void applyValueListStyleType(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setListStyleType(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialMarginBottom(BuilderState& builderState)
    {
        builderState.style().setMarginBottom(RenderStyle::initialMargin());
    }
    static void applyInheritMarginBottom(BuilderState& builderState)
    {
        builderState.style().setMarginBottom(forwardInheritedValue(builderState.parentStyle().marginBottom()));
    }
    static void applyValueMarginBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginBottom(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMarginLeft(BuilderState& builderState)
    {
        builderState.style().setMarginLeft(RenderStyle::initialMargin());
    }
    static void applyInheritMarginLeft(BuilderState& builderState)
    {
        builderState.style().setMarginLeft(forwardInheritedValue(builderState.parentStyle().marginLeft()));
    }
    static void applyValueMarginLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginLeft(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMarginRight(BuilderState& builderState)
    {
        builderState.style().setMarginRight(RenderStyle::initialMargin());
    }
    static void applyInheritMarginRight(BuilderState& builderState)
    {
        builderState.style().setMarginRight(forwardInheritedValue(builderState.parentStyle().marginRight()));
    }
    static void applyValueMarginRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginRight(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMarginTop(BuilderState& builderState)
    {
        builderState.style().setMarginTop(RenderStyle::initialMargin());
    }
    static void applyInheritMarginTop(BuilderState& builderState)
    {
        builderState.style().setMarginTop(forwardInheritedValue(builderState.parentStyle().marginTop()));
    }
    static void applyValueMarginTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginTop(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMarkerEnd(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerEndResource(SVGRenderStyle::initialMarkerEndResource());
    }
    static void applyInheritMarkerEnd(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerEndResource(forwardInheritedValue(builderState.parentStyle().svgStyle().markerEndResource()));
    }
    static void applyValueMarkerEnd(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMarkerEndResource(BuilderConverter::convertSVGURIReference(builderState, value));
    }
    static void applyInitialMarkerMid(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerMidResource(SVGRenderStyle::initialMarkerMidResource());
    }
    static void applyInheritMarkerMid(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerMidResource(forwardInheritedValue(builderState.parentStyle().svgStyle().markerMidResource()));
    }
    static void applyValueMarkerMid(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMarkerMidResource(BuilderConverter::convertSVGURIReference(builderState, value));
    }
    static void applyInitialMarkerStart(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerStartResource(SVGRenderStyle::initialMarkerStartResource());
    }
    static void applyInheritMarkerStart(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerStartResource(forwardInheritedValue(builderState.parentStyle().svgStyle().markerStartResource()));
    }
    static void applyValueMarkerStart(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMarkerStartResource(BuilderConverter::convertSVGURIReference(builderState, value));
    }
    static void applyInitialMask(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMaskerResource(SVGRenderStyle::initialMaskerResource());
    }
    static void applyInheritMask(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMaskerResource(forwardInheritedValue(builderState.parentStyle().svgStyle().maskerResource()));
    }
    static void applyValueMask(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMaskerResource(BuilderConverter::convertSVGURIReference(builderState, value));
    }
    static void applyInitialMaskType(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMaskType(SVGRenderStyle::initialMaskType());
    }
    static void applyInheritMaskType(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMaskType(forwardInheritedValue(builderState.parentStyle().svgStyle().maskType()));
    }
    static void applyValueMaskType(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMaskType(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialMaxHeight(BuilderState& builderState)
    {
        builderState.style().setMaxHeight(RenderStyle::initialMaxSize());
    }
    static void applyInheritMaxHeight(BuilderState& builderState)
    {
        builderState.style().setMaxHeight(forwardInheritedValue(builderState.parentStyle().maxHeight()));
    }
    static void applyValueMaxHeight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMaxHeight(BuilderConverter::convertLengthMaxSizing(builderState, value));
    }
    static void applyInitialMaxWidth(BuilderState& builderState)
    {
        builderState.style().setMaxWidth(RenderStyle::initialMaxSize());
    }
    static void applyInheritMaxWidth(BuilderState& builderState)
    {
        builderState.style().setMaxWidth(forwardInheritedValue(builderState.parentStyle().maxWidth()));
    }
    static void applyValueMaxWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMaxWidth(BuilderConverter::convertLengthMaxSizing(builderState, value));
    }
    static void applyInitialMinHeight(BuilderState& builderState)
    {
        builderState.style().setMinHeight(RenderStyle::initialMinSize());
    }
    static void applyInheritMinHeight(BuilderState& builderState)
    {
        builderState.style().setMinHeight(forwardInheritedValue(builderState.parentStyle().minHeight()));
    }
    static void applyValueMinHeight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMinHeight(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialMinWidth(BuilderState& builderState)
    {
        builderState.style().setMinWidth(RenderStyle::initialMinSize());
    }
    static void applyInheritMinWidth(BuilderState& builderState)
    {
        builderState.style().setMinWidth(forwardInheritedValue(builderState.parentStyle().minWidth()));
    }
    static void applyValueMinWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMinWidth(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialMixBlendMode(BuilderState& builderState)
    {
        builderState.style().setBlendMode(RenderStyle::initialBlendMode());
    }
    static void applyInheritMixBlendMode(BuilderState& builderState)
    {
        builderState.style().setBlendMode(forwardInheritedValue(builderState.parentStyle().blendMode()));
    }
    static void applyValueMixBlendMode(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBlendMode(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialObjectFit(BuilderState& builderState)
    {
        builderState.style().setObjectFit(RenderStyle::initialObjectFit());
    }
    static void applyInheritObjectFit(BuilderState& builderState)
    {
        builderState.style().setObjectFit(forwardInheritedValue(builderState.parentStyle().objectFit()));
    }
    static void applyValueObjectFit(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setObjectFit(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialObjectPosition(BuilderState& builderState)
    {
        builderState.style().setObjectPosition(RenderStyle::initialObjectPosition());
    }
    static void applyInheritObjectPosition(BuilderState& builderState)
    {
        builderState.style().setObjectPosition(forwardInheritedValue(builderState.parentStyle().objectPosition()));
    }
    static void applyValueObjectPosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setObjectPosition(BuilderConverter::convertObjectPosition(builderState, value));
    }
    static void applyInitialOpacity(BuilderState& builderState)
    {
        builderState.style().setOpacity(RenderStyle::initialOpacity());
    }
    static void applyInheritOpacity(BuilderState& builderState)
    {
        builderState.style().setOpacity(forwardInheritedValue(builderState.parentStyle().opacity()));
    }
    static void applyValueOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialOrder(BuilderState& builderState)
    {
        builderState.style().setOrder(RenderStyle::initialOrder());
    }
    static void applyInheritOrder(BuilderState& builderState)
    {
        builderState.style().setOrder(forwardInheritedValue(builderState.parentStyle().order()));
    }
    static void applyValueOrder(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOrder(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialOrphans(BuilderState& builderState)
    {
        builderState.style().setHasAutoOrphans();
    }
    static void applyInheritOrphans(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoOrphans()) {
            builderState.style().setHasAutoOrphans();
            return;
        }
        builderState.style().setOrphans(forwardInheritedValue(builderState.parentStyle().orphans()));
    }
    static void applyValueOrphans(BuilderState& builderState, CSSValue& value)
    {
        if (downcast<CSSPrimitiveValue>(value).valueID() == CSSValueAuto) {
            builderState.style().setHasAutoOrphans();
            return;
        }
        builderState.style().setOrphans(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialOutlineColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setOutlineColor(RenderStyle::invalidColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkOutlineColor(RenderStyle::invalidColor());
    }
    static void applyInheritOutlineColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().outlineColor();
        if (!color.isValid())
            color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setOutlineColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkOutlineColor(color);
    }
    static void applyValueOutlineColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setOutlineColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkOutlineColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialOutlineOffset(BuilderState& builderState)
    {
        builderState.style().setOutlineOffset(RenderStyle::initialOutlineOffset());
    }
    static void applyInheritOutlineOffset(BuilderState& builderState)
    {
        builderState.style().setOutlineOffset(forwardInheritedValue(builderState.parentStyle().outlineOffset()));
    }
    static void applyValueOutlineOffset(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOutlineOffset(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialOutlineWidth(BuilderState& builderState)
    {
        builderState.style().setOutlineWidth(RenderStyle::initialOutlineWidth());
    }
    static void applyInheritOutlineWidth(BuilderState& builderState)
    {
        builderState.style().setOutlineWidth(forwardInheritedValue(builderState.parentStyle().outlineWidth()));
    }
    static void applyValueOutlineWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOutlineWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialOverflowWrap(BuilderState& builderState)
    {
        builderState.style().setOverflowWrap(RenderStyle::initialOverflowWrap());
    }
    static void applyInheritOverflowWrap(BuilderState& builderState)
    {
        builderState.style().setOverflowWrap(forwardInheritedValue(builderState.parentStyle().overflowWrap()));
    }
    static void applyValueOverflowWrap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverflowWrap(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialOverflowX(BuilderState& builderState)
    {
        builderState.style().setOverflowX(RenderStyle::initialOverflowX());
    }
    static void applyInheritOverflowX(BuilderState& builderState)
    {
        builderState.style().setOverflowX(forwardInheritedValue(builderState.parentStyle().overflowX()));
    }
    static void applyValueOverflowX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverflowX(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialOverflowY(BuilderState& builderState)
    {
        builderState.style().setOverflowY(RenderStyle::initialOverflowY());
    }
    static void applyInheritOverflowY(BuilderState& builderState)
    {
        builderState.style().setOverflowY(forwardInheritedValue(builderState.parentStyle().overflowY()));
    }
    static void applyValueOverflowY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverflowY(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialPaddingBottom(BuilderState& builderState)
    {
        builderState.style().setPaddingBottom(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingBottom(BuilderState& builderState)
    {
        builderState.style().setPaddingBottom(forwardInheritedValue(builderState.parentStyle().paddingBottom()));
    }
    static void applyValuePaddingBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaddingBottom(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialPaddingLeft(BuilderState& builderState)
    {
        builderState.style().setPaddingLeft(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingLeft(BuilderState& builderState)
    {
        builderState.style().setPaddingLeft(forwardInheritedValue(builderState.parentStyle().paddingLeft()));
    }
    static void applyValuePaddingLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaddingLeft(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialPaddingRight(BuilderState& builderState)
    {
        builderState.style().setPaddingRight(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingRight(BuilderState& builderState)
    {
        builderState.style().setPaddingRight(forwardInheritedValue(builderState.parentStyle().paddingRight()));
    }
    static void applyValuePaddingRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaddingRight(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialPaddingTop(BuilderState& builderState)
    {
        builderState.style().setPaddingTop(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingTop(BuilderState& builderState)
    {
        builderState.style().setPaddingTop(forwardInheritedValue(builderState.parentStyle().paddingTop()));
    }
    static void applyValuePaddingTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaddingTop(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialPaintOrder(BuilderState& builderState)
    {
        builderState.style().setPaintOrder(RenderStyle::initialPaintOrder());
    }
    static void applyInheritPaintOrder(BuilderState& builderState)
    {
        builderState.style().setPaintOrder(forwardInheritedValue(builderState.parentStyle().paintOrder()));
    }
    static void applyValuePaintOrder(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaintOrder(BuilderConverter::convertPaintOrder(builderState, value));
    }
    static void applyInitialPerspective(BuilderState& builderState)
    {
        builderState.style().setPerspective(RenderStyle::initialPerspective());
    }
    static void applyInheritPerspective(BuilderState& builderState)
    {
        builderState.style().setPerspective(forwardInheritedValue(builderState.parentStyle().perspective()));
    }
    static void applyValuePerspective(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertPerspective(builderState, value);
        if (convertedValue)
            builderState.style().setPerspective(WTFMove(convertedValue.value()));
    }
    static void applyInitialPerspectiveOriginX(BuilderState& builderState)
    {
        builderState.style().setPerspectiveOriginX(RenderStyle::initialPerspectiveOriginX());
    }
    static void applyInheritPerspectiveOriginX(BuilderState& builderState)
    {
        builderState.style().setPerspectiveOriginX(forwardInheritedValue(builderState.parentStyle().perspectiveOriginX()));
    }
    static void applyValuePerspectiveOriginX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPerspectiveOriginX(BuilderConverter::convertPositionComponentX(builderState, value));
    }
    static void applyInitialPerspectiveOriginY(BuilderState& builderState)
    {
        builderState.style().setPerspectiveOriginY(RenderStyle::initialPerspectiveOriginY());
    }
    static void applyInheritPerspectiveOriginY(BuilderState& builderState)
    {
        builderState.style().setPerspectiveOriginY(forwardInheritedValue(builderState.parentStyle().perspectiveOriginY()));
    }
    static void applyValuePerspectiveOriginY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPerspectiveOriginY(BuilderConverter::convertPositionComponentY(builderState, value));
    }
    static void applyInitialPointerEvents(BuilderState& builderState)
    {
        builderState.style().setPointerEvents(RenderStyle::initialPointerEvents());
    }
    static void applyInheritPointerEvents(BuilderState& builderState)
    {
        builderState.style().setPointerEvents(forwardInheritedValue(builderState.parentStyle().pointerEvents()));
    }
    static void applyValuePointerEvents(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPointerEvents(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialPosition(BuilderState& builderState)
    {
        builderState.style().setPosition(RenderStyle::initialPosition());
    }
    static void applyInheritPosition(BuilderState& builderState)
    {
        builderState.style().setPosition(forwardInheritedValue(builderState.parentStyle().position()));
    }
    static void applyValuePosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPosition(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialQuotes(BuilderState& builderState)
    {
        builderState.style().setQuotes(RenderStyle::initialQuotes());
    }
    static void applyInheritQuotes(BuilderState& builderState)
    {
        builderState.style().setQuotes(forwardInheritedValue(builderState.parentStyle().quotes()));
    }
    static void applyValueQuotes(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setQuotes(BuilderConverter::convertQuotes(builderState, value));
    }
    static void applyInitialR(BuilderState& builderState)
    {
        builderState.style().setR(RenderStyle::initialZeroLength());
    }
    static void applyInheritR(BuilderState& builderState)
    {
        builderState.style().setR(forwardInheritedValue(builderState.parentStyle().r()));
    }
    static void applyValueR(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setR(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialResize(BuilderState& builderState)
    {
        builderState.style().setResize(RenderStyle::initialResize());
    }
    static void applyInheritResize(BuilderState& builderState)
    {
        builderState.style().setResize(forwardInheritedValue(builderState.parentStyle().resize()));
    }
    static void applyValueResize(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setResize(BuilderConverter::convertResize(builderState, value));
    }
    static void applyInitialRight(BuilderState& builderState)
    {
        builderState.style().setRight(RenderStyle::initialOffset());
    }
    static void applyInheritRight(BuilderState& builderState)
    {
        builderState.style().setRight(forwardInheritedValue(builderState.parentStyle().right()));
    }
    static void applyValueRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRight(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialRowGap(BuilderState& builderState)
    {
        builderState.style().setRowGap(RenderStyle::initialRowGap());
    }
    static void applyInheritRowGap(BuilderState& builderState)
    {
        builderState.style().setRowGap(forwardInheritedValue(builderState.parentStyle().rowGap()));
    }
    static void applyValueRowGap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRowGap(BuilderConverter::convertGapLength(builderState, value));
    }
    static void applyInitialRx(BuilderState& builderState)
    {
        builderState.style().setRx(RenderStyle::initialRadius());
    }
    static void applyInheritRx(BuilderState& builderState)
    {
        builderState.style().setRx(forwardInheritedValue(builderState.parentStyle().rx()));
    }
    static void applyValueRx(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRx(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialRy(BuilderState& builderState)
    {
        builderState.style().setRy(RenderStyle::initialRadius());
    }
    static void applyInheritRy(BuilderState& builderState)
    {
        builderState.style().setRy(forwardInheritedValue(builderState.parentStyle().ry()));
    }
    static void applyValueRy(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRy(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialScrollBehavior(BuilderState& builderState)
    {
        builderState.style().setUseSmoothScrolling(RenderStyle::initialUseSmoothScrolling());
    }
    static void applyInheritScrollBehavior(BuilderState& builderState)
    {
        builderState.style().setUseSmoothScrolling(forwardInheritedValue(builderState.parentStyle().useSmoothScrolling()));
    }
    static void applyValueScrollBehavior(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUseSmoothScrolling(BuilderConverter::convertSmoothScrolling(builderState, value));
    }
    static void applyInitialShapeImageThreshold(BuilderState& builderState)
    {
        builderState.style().setShapeImageThreshold(RenderStyle::initialShapeImageThreshold());
    }
    static void applyInheritShapeImageThreshold(BuilderState& builderState)
    {
        builderState.style().setShapeImageThreshold(forwardInheritedValue(builderState.parentStyle().shapeImageThreshold()));
    }
    static void applyValueShapeImageThreshold(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setShapeImageThreshold(BuilderConverter::convertNumberOrAuto<float>(builderState, value));
    }
    static void applyInitialShapeMargin(BuilderState& builderState)
    {
        builderState.style().setShapeMargin(RenderStyle::initialShapeMargin());
    }
    static void applyInheritShapeMargin(BuilderState& builderState)
    {
        builderState.style().setShapeMargin(forwardInheritedValue(builderState.parentStyle().shapeMargin()));
    }
    static void applyValueShapeMargin(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setShapeMargin(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialShapeOutside(BuilderState& builderState)
    {
        builderState.style().setShapeOutside(RenderStyle::initialShapeOutside());
    }
    static void applyInheritShapeOutside(BuilderState& builderState)
    {
        builderState.style().setShapeOutside(forwardInheritedValue(builderState.parentStyle().shapeOutside()));
    }
    static void applyValueShapeOutside(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setShapeOutside(BuilderConverter::convertShapeValue(builderState, value));
    }
    static void applyInitialShapeRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setShapeRendering(SVGRenderStyle::initialShapeRendering());
    }
    static void applyInheritShapeRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setShapeRendering(forwardInheritedValue(builderState.parentStyle().svgStyle().shapeRendering()));
    }
    static void applyValueShapeRendering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setShapeRendering(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialSpeakAs(BuilderState& builderState)
    {
        builderState.style().setSpeakAs(RenderStyle::initialSpeakAs());
    }
    static void applyInheritSpeakAs(BuilderState& builderState)
    {
        builderState.style().setSpeakAs(forwardInheritedValue(builderState.parentStyle().speakAs()));
    }
    static void applyValueSpeakAs(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setSpeakAs(BuilderConverter::convertSpeakAs(builderState, value));
    }
    static void applyInitialStopColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStopColor(SVGRenderStyle::initialStopColor());
    }
    static void applyInheritStopColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStopColor(forwardInheritedValue(builderState.parentStyle().svgStyle().stopColor()));
    }
    static void applyValueStopColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setStopColor(BuilderConverter::convertSVGColor(builderState, value));
    }
    static void applyInitialStopOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStopOpacity(SVGRenderStyle::initialStopOpacity());
    }
    static void applyInheritStopOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStopOpacity(forwardInheritedValue(builderState.parentStyle().svgStyle().stopOpacity()));
    }
    static void applyValueStopOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setStopOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialStrokeColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setStrokeColor(RenderStyle::invalidColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkStrokeColor(RenderStyle::invalidColor());
    }
    static void applyInheritStrokeColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().strokeColor();
        if (!color.isValid())
            color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setStrokeColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkStrokeColor(color);
    }
    static void applyInitialStrokeDasharray(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStrokeDashArray(SVGRenderStyle::initialStrokeDashArray());
    }
    static void applyInheritStrokeDasharray(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStrokeDashArray(forwardInheritedValue(builderState.parentStyle().svgStyle().strokeDashArray()));
    }
    static void applyValueStrokeDasharray(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setStrokeDashArray(BuilderConverter::convertStrokeDashArray(builderState, value));
    }
    static void applyInitialStrokeDashoffset(BuilderState& builderState)
    {
        builderState.style().setStrokeDashOffset(RenderStyle::initialZeroLength());
    }
    static void applyInheritStrokeDashoffset(BuilderState& builderState)
    {
        builderState.style().setStrokeDashOffset(forwardInheritedValue(builderState.parentStyle().strokeDashOffset()));
    }
    static void applyValueStrokeDashoffset(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setStrokeDashOffset(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialStrokeLinecap(BuilderState& builderState)
    {
        builderState.style().setCapStyle(RenderStyle::initialCapStyle());
    }
    static void applyInheritStrokeLinecap(BuilderState& builderState)
    {
        builderState.style().setCapStyle(forwardInheritedValue(builderState.parentStyle().capStyle()));
    }
    static void applyValueStrokeLinecap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCapStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialStrokeLinejoin(BuilderState& builderState)
    {
        builderState.style().setJoinStyle(RenderStyle::initialJoinStyle());
    }
    static void applyInheritStrokeLinejoin(BuilderState& builderState)
    {
        builderState.style().setJoinStyle(forwardInheritedValue(builderState.parentStyle().joinStyle()));
    }
    static void applyValueStrokeLinejoin(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setJoinStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialStrokeMiterlimit(BuilderState& builderState)
    {
        builderState.style().setStrokeMiterLimit(RenderStyle::initialStrokeMiterLimit());
    }
    static void applyInheritStrokeMiterlimit(BuilderState& builderState)
    {
        builderState.style().setStrokeMiterLimit(forwardInheritedValue(builderState.parentStyle().strokeMiterLimit()));
    }
    static void applyValueStrokeMiterlimit(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setStrokeMiterLimit(BuilderConverter::convertNumber<float>(builderState, value));
    }
    static void applyInitialStrokeOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStrokeOpacity(SVGRenderStyle::initialStrokeOpacity());
    }
    static void applyInheritStrokeOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStrokeOpacity(forwardInheritedValue(builderState.parentStyle().svgStyle().strokeOpacity()));
    }
    static void applyValueStrokeOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setStrokeOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialStrokeWidth(BuilderState& builderState)
    {
        builderState.style().setStrokeWidth(RenderStyle::initialOneLength());
    }
    static void applyInheritStrokeWidth(BuilderState& builderState)
    {
        builderState.style().setStrokeWidth(forwardInheritedValue(builderState.parentStyle().strokeWidth()));
    }
    static void applyInitialTabSize(BuilderState& builderState)
    {
        builderState.style().setTabSize(RenderStyle::initialTabSize());
    }
    static void applyInheritTabSize(BuilderState& builderState)
    {
        builderState.style().setTabSize(forwardInheritedValue(builderState.parentStyle().tabSize()));
    }
    static void applyValueTabSize(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTabSize(BuilderConverter::convertTabSize(builderState, value));
    }
    static void applyInitialTableLayout(BuilderState& builderState)
    {
        builderState.style().setTableLayout(RenderStyle::initialTableLayout());
    }
    static void applyInheritTableLayout(BuilderState& builderState)
    {
        builderState.style().setTableLayout(forwardInheritedValue(builderState.parentStyle().tableLayout()));
    }
    static void applyValueTableLayout(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTableLayout(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInheritTextAlign(BuilderState& builderState)
    {
        builderState.style().setTextAlign(forwardInheritedValue(builderState.parentStyle().textAlign()));
    }
    static void applyInitialTextAnchor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setTextAnchor(SVGRenderStyle::initialTextAnchor());
    }
    static void applyInheritTextAnchor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setTextAnchor(forwardInheritedValue(builderState.parentStyle().svgStyle().textAnchor()));
    }
    static void applyValueTextAnchor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setTextAnchor(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTextDecoration(BuilderState& builderState)
    {
        builderState.style().setTextDecoration(RenderStyle::initialTextDecoration());
    }
    static void applyInheritTextDecoration(BuilderState& builderState)
    {
        builderState.style().setTextDecoration(forwardInheritedValue(builderState.parentStyle().textDecoration()));
    }
    static void applyValueTextDecoration(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecoration(BuilderConverter::convertTextDecoration(builderState, value));
    }
    static void applyInitialTextDecorationColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextDecorationColor(RenderStyle::invalidColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextDecorationColor(RenderStyle::invalidColor());
    }
    static void applyInheritTextDecorationColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().textDecorationColor();
        if (!color.isValid())
            color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextDecorationColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextDecorationColor(color);
    }
    static void applyValueTextDecorationColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextDecorationColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextDecorationColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialTextDecorationLine(BuilderState& builderState)
    {
        builderState.style().setTextDecoration(RenderStyle::initialTextDecoration());
    }
    static void applyInheritTextDecorationLine(BuilderState& builderState)
    {
        builderState.style().setTextDecoration(forwardInheritedValue(builderState.parentStyle().textDecoration()));
    }
    static void applyValueTextDecorationLine(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecoration(BuilderConverter::convertTextDecoration(builderState, value));
    }
    static void applyInitialTextDecorationSkip(BuilderState& builderState)
    {
        builderState.style().setTextDecorationSkip(RenderStyle::initialTextDecorationSkip());
    }
    static void applyInheritTextDecorationSkip(BuilderState& builderState)
    {
        builderState.style().setTextDecorationSkip(forwardInheritedValue(builderState.parentStyle().textDecorationSkip()));
    }
    static void applyValueTextDecorationSkip(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecorationSkip(BuilderConverter::convertTextDecorationSkip(builderState, value));
    }
    static void applyInitialTextDecorationStyle(BuilderState& builderState)
    {
        builderState.style().setTextDecorationStyle(RenderStyle::initialTextDecorationStyle());
    }
    static void applyInheritTextDecorationStyle(BuilderState& builderState)
    {
        builderState.style().setTextDecorationStyle(forwardInheritedValue(builderState.parentStyle().textDecorationStyle()));
    }
    static void applyValueTextDecorationStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecorationStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTextDecorationThickness(BuilderState& builderState)
    {
        builderState.style().setTextDecorationThickness(RenderStyle::initialTextDecorationThickness());
    }
    static void applyInheritTextDecorationThickness(BuilderState& builderState)
    {
        builderState.style().setTextDecorationThickness(forwardInheritedValue(builderState.parentStyle().textDecorationThickness()));
    }
    static void applyValueTextDecorationThickness(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecorationThickness(BuilderConverter::convertTextDecorationThickness(builderState, value));
    }
    static void applyInitialTextOverflow(BuilderState& builderState)
    {
        builderState.style().setTextOverflow(RenderStyle::initialTextOverflow());
    }
    static void applyInheritTextOverflow(BuilderState& builderState)
    {
        builderState.style().setTextOverflow(forwardInheritedValue(builderState.parentStyle().textOverflow()));
    }
    static void applyValueTextOverflow(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextOverflow(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTextTransform(BuilderState& builderState)
    {
        builderState.style().setTextTransform(RenderStyle::initialTextTransform());
    }
    static void applyInheritTextTransform(BuilderState& builderState)
    {
        builderState.style().setTextTransform(forwardInheritedValue(builderState.parentStyle().textTransform()));
    }
    static void applyValueTextTransform(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextTransform(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTextUnderlineOffset(BuilderState& builderState)
    {
        builderState.style().setTextUnderlineOffset(RenderStyle::initialTextUnderlineOffset());
    }
    static void applyInheritTextUnderlineOffset(BuilderState& builderState)
    {
        builderState.style().setTextUnderlineOffset(forwardInheritedValue(builderState.parentStyle().textUnderlineOffset()));
    }
    static void applyValueTextUnderlineOffset(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextUnderlineOffset(BuilderConverter::convertTextUnderlineOffset(builderState, value));
    }
    static void applyInitialTextUnderlinePosition(BuilderState& builderState)
    {
        builderState.style().setTextUnderlinePosition(RenderStyle::initialTextUnderlinePosition());
    }
    static void applyInheritTextUnderlinePosition(BuilderState& builderState)
    {
        builderState.style().setTextUnderlinePosition(forwardInheritedValue(builderState.parentStyle().textUnderlinePosition()));
    }
    static void applyValueTextUnderlinePosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextUnderlinePosition(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTop(BuilderState& builderState)
    {
        builderState.style().setTop(RenderStyle::initialOffset());
    }
    static void applyInheritTop(BuilderState& builderState)
    {
        builderState.style().setTop(forwardInheritedValue(builderState.parentStyle().top()));
    }
    static void applyValueTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTop(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialTransform(BuilderState& builderState)
    {
        builderState.style().setTransform(RenderStyle::initialTransform());
    }
    static void applyInheritTransform(BuilderState& builderState)
    {
        builderState.style().setTransform(forwardInheritedValue(builderState.parentStyle().transform()));
    }
    static void applyValueTransform(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransform(BuilderConverter::convertTransform(builderState, value));
    }
    static void applyInitialTransformBox(BuilderState& builderState)
    {
        builderState.style().setTransformBox(RenderStyle::initialTransformBox());
    }
    static void applyInheritTransformBox(BuilderState& builderState)
    {
        builderState.style().setTransformBox(forwardInheritedValue(builderState.parentStyle().transformBox()));
    }
    static void applyValueTransformBox(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformBox(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTransformOriginX(BuilderState& builderState)
    {
        builderState.style().setTransformOriginX(RenderStyle::initialTransformOriginX());
    }
    static void applyInheritTransformOriginX(BuilderState& builderState)
    {
        builderState.style().setTransformOriginX(forwardInheritedValue(builderState.parentStyle().transformOriginX()));
    }
    static void applyValueTransformOriginX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformOriginX(BuilderConverter::convertPositionComponentX(builderState, value));
    }
    static void applyInitialTransformOriginY(BuilderState& builderState)
    {
        builderState.style().setTransformOriginY(RenderStyle::initialTransformOriginY());
    }
    static void applyInheritTransformOriginY(BuilderState& builderState)
    {
        builderState.style().setTransformOriginY(forwardInheritedValue(builderState.parentStyle().transformOriginY()));
    }
    static void applyValueTransformOriginY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformOriginY(BuilderConverter::convertPositionComponentY(builderState, value));
    }
    static void applyInitialTransformOriginZ(BuilderState& builderState)
    {
        builderState.style().setTransformOriginZ(RenderStyle::initialTransformOriginZ());
    }
    static void applyInheritTransformOriginZ(BuilderState& builderState)
    {
        builderState.style().setTransformOriginZ(forwardInheritedValue(builderState.parentStyle().transformOriginZ()));
    }
    static void applyValueTransformOriginZ(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformOriginZ(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialTransformStyle(BuilderState& builderState)
    {
        builderState.style().setTransformStyle3D(RenderStyle::initialTransformStyle3D());
    }
    static void applyInheritTransformStyle(BuilderState& builderState)
    {
        builderState.style().setTransformStyle3D(forwardInheritedValue(builderState.parentStyle().transformStyle3D()));
    }
    static void applyValueTransformStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformStyle3D(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTransitionDelay(BuilderState& builderState)
    {
        AnimationList& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDelay(Animation::initialDelay());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyInheritTransitionDelay(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDelaySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDelay(parentList->animation(i).delay());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyValueTransitionDelay(BuilderState& builderState, CSSValue& value)
    {
        AnimationList& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDelay(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDelay(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDelay();
        }
    }
    static void applyInitialTransitionDuration(BuilderState& builderState)
    {
        AnimationList& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDuration(Animation::initialDuration());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyInheritTransitionDuration(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDurationSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDuration(parentList->animation(i).duration());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyValueTransitionDuration(BuilderState& builderState, CSSValue& value)
    {
        AnimationList& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDuration(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDuration(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDuration();
        }
    }
    static void applyInitialTransitionProperty(BuilderState& builderState)
    {
        AnimationList& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setProperty(Animation::initialProperty());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearProperty();
    }
    static void applyInheritTransitionProperty(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isPropertySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setProperty(parentList->animation(i).property());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearProperty();
    }
    static void applyValueTransitionProperty(BuilderState& builderState, CSSValue& value)
    {
        AnimationList& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationProperty(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationProperty(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearProperty();
        }
    }
    static void applyInitialTransitionTimingFunction(BuilderState& builderState)
    {
        AnimationList& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setTimingFunction(Animation::initialTimingFunction());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyInheritTransitionTimingFunction(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isTimingFunctionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setTimingFunction(parentList->animation(i).timingFunction());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyValueTransitionTimingFunction(BuilderState& builderState, CSSValue& value)
    {
        AnimationList& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationTimingFunction(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationTimingFunction(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearTimingFunction();
        }
    }
    static void applyInitialUnicodeBidi(BuilderState& builderState)
    {
        builderState.style().setUnicodeBidi(RenderStyle::initialUnicodeBidi());
    }
    static void applyInheritUnicodeBidi(BuilderState& builderState)
    {
        builderState.style().setUnicodeBidi(forwardInheritedValue(builderState.parentStyle().unicodeBidi()));
    }
    static void applyValueUnicodeBidi(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUnicodeBidi(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialVectorEffect(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setVectorEffect(SVGRenderStyle::initialVectorEffect());
    }
    static void applyInheritVectorEffect(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setVectorEffect(forwardInheritedValue(builderState.parentStyle().svgStyle().vectorEffect()));
    }
    static void applyValueVectorEffect(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setVectorEffect(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialVerticalAlign(BuilderState& builderState)
    {
        builderState.style().setVerticalAlign(RenderStyle::initialVerticalAlign());
    }
    static void applyInheritVerticalAlign(BuilderState& builderState)
    {
        builderState.style().setVerticalAlign(forwardInheritedValue(builderState.parentStyle().verticalAlign()));
    }
    static void applyInitialVisibility(BuilderState& builderState)
    {
        builderState.style().setVisibility(RenderStyle::initialVisibility());
    }
    static void applyInheritVisibility(BuilderState& builderState)
    {
        builderState.style().setVisibility(forwardInheritedValue(builderState.parentStyle().visibility()));
    }
    static void applyValueVisibility(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setVisibility(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWhiteSpace(BuilderState& builderState)
    {
        builderState.style().setWhiteSpace(RenderStyle::initialWhiteSpace());
    }
    static void applyInheritWhiteSpace(BuilderState& builderState)
    {
        builderState.style().setWhiteSpace(forwardInheritedValue(builderState.parentStyle().whiteSpace()));
    }
    static void applyValueWhiteSpace(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWhiteSpace(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWidows(BuilderState& builderState)
    {
        builderState.style().setHasAutoWidows();
    }
    static void applyInheritWidows(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoWidows()) {
            builderState.style().setHasAutoWidows();
            return;
        }
        builderState.style().setWidows(forwardInheritedValue(builderState.parentStyle().widows()));
    }
    static void applyValueWidows(BuilderState& builderState, CSSValue& value)
    {
        if (downcast<CSSPrimitiveValue>(value).valueID() == CSSValueAuto) {
            builderState.style().setHasAutoWidows();
            return;
        }
        builderState.style().setWidows(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWidth(BuilderState& builderState)
    {
        builderState.style().setWidth(RenderStyle::initialSize());
    }
    static void applyInheritWidth(BuilderState& builderState)
    {
        builderState.style().setWidth(forwardInheritedValue(builderState.parentStyle().width()));
    }
    static void applyValueWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWidth(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialWillChange(BuilderState& builderState)
    {
        builderState.style().setWillChange(RenderStyle::initialWillChange());
    }
    static void applyInheritWillChange(BuilderState& builderState)
    {
        builderState.style().setWillChange(forwardInheritedValue(builderState.parentStyle().willChange()));
    }
    static void applyInitialWordBreak(BuilderState& builderState)
    {
        builderState.style().setWordBreak(RenderStyle::initialWordBreak());
    }
    static void applyInheritWordBreak(BuilderState& builderState)
    {
        builderState.style().setWordBreak(forwardInheritedValue(builderState.parentStyle().wordBreak()));
    }
    static void applyValueWordBreak(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWordBreak(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWordSpacing(BuilderState& builderState)
    {
        builderState.style().setWordSpacing(RenderStyle::initialWordSpacing());
    }
    static void applyInheritWordSpacing(BuilderState& builderState)
    {
        builderState.style().setWordSpacing(forwardInheritedValue(builderState.parentStyle().wordSpacing()));
    }
    static void applyValueWordSpacing(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertWordSpacing(builderState, value);
        if (convertedValue)
            builderState.style().setWordSpacing(WTFMove(convertedValue.value()));
    }
    static void applyInitialWordWrap(BuilderState& builderState)
    {
        builderState.style().setOverflowWrap(RenderStyle::initialOverflowWrap());
    }
    static void applyInheritWordWrap(BuilderState& builderState)
    {
        builderState.style().setOverflowWrap(forwardInheritedValue(builderState.parentStyle().overflowWrap()));
    }
    static void applyValueWordWrap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverflowWrap(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialX(BuilderState& builderState)
    {
        builderState.style().setX(RenderStyle::initialZeroLength());
    }
    static void applyInheritX(BuilderState& builderState)
    {
        builderState.style().setX(forwardInheritedValue(builderState.parentStyle().x()));
    }
    static void applyValueX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setX(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialY(BuilderState& builderState)
    {
        builderState.style().setY(RenderStyle::initialZeroLength());
    }
    static void applyInheritY(BuilderState& builderState)
    {
        builderState.style().setY(forwardInheritedValue(builderState.parentStyle().y()));
    }
    static void applyValueY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setY(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialZIndex(BuilderState& builderState)
    {
        builderState.style().setHasAutoSpecifiedZIndex();
    }
    static void applyInheritZIndex(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoSpecifiedZIndex()) {
            builderState.style().setHasAutoSpecifiedZIndex();
            return;
        }
        builderState.style().setSpecifiedZIndex(forwardInheritedValue(builderState.parentStyle().specifiedZIndex()));
    }
    static void applyValueZIndex(BuilderState& builderState, CSSValue& value)
    {
        if (downcast<CSSPrimitiveValue>(value).valueID() == CSSValueAuto) {
            builderState.style().setHasAutoSpecifiedZIndex();
            return;
        }
        builderState.style().setSpecifiedZIndex(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialAppleColorFilter(BuilderState& builderState)
    {
        builderState.style().setAppleColorFilter(RenderStyle::initialAppleColorFilter());
    }
    static void applyInheritAppleColorFilter(BuilderState& builderState)
    {
        builderState.style().setAppleColorFilter(forwardInheritedValue(builderState.parentStyle().appleColorFilter()));
    }
    static void applyValueAppleColorFilter(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertFilterOperations(builderState, value);
        if (convertedValue)
            builderState.style().setAppleColorFilter(WTFMove(convertedValue.value()));
    }
    static void applyInitialWebkitAppearance(BuilderState& builderState)
    {
        builderState.style().setAppearance(RenderStyle::initialAppearance());
    }
    static void applyInheritWebkitAppearance(BuilderState& builderState)
    {
        builderState.style().setAppearance(forwardInheritedValue(builderState.parentStyle().appearance()));
    }
    static void applyValueWebkitAppearance(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAppearance(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBackdropFilter(BuilderState& builderState)
    {
        builderState.style().setBackdropFilter(RenderStyle::initialBackdropFilter());
    }
    static void applyInheritWebkitBackdropFilter(BuilderState& builderState)
    {
        builderState.style().setBackdropFilter(forwardInheritedValue(builderState.parentStyle().backdropFilter()));
    }
    static void applyValueWebkitBackdropFilter(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertFilterOperations(builderState, value);
        if (convertedValue)
            builderState.style().setBackdropFilter(WTFMove(convertedValue.value()));
    }
    static void applyInitialWebkitBackfaceVisibility(BuilderState& builderState)
    {
        builderState.style().setBackfaceVisibility(RenderStyle::initialBackfaceVisibility());
    }
    static void applyInheritWebkitBackfaceVisibility(BuilderState& builderState)
    {
        builderState.style().setBackfaceVisibility(forwardInheritedValue(builderState.parentStyle().backfaceVisibility()));
    }
    static void applyValueWebkitBackfaceVisibility(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBackfaceVisibility(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBackgroundClip(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isClipSet() || layers.clip() == FillLayer::initialFillClip(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setClip(FillLayer::initialFillClip(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearClip();
    }
    static void applyInheritWebkitBackgroundClip(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isClipSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setClip(parent->clip());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyValueWebkitBackgroundClip(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillClip(CSSPropertyWebkitBackgroundClip, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillClip(CSSPropertyWebkitBackgroundClip, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyInitialWebkitBackgroundComposite(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isCompositeSet() || layers.composite() == FillLayer::initialFillComposite(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setComposite(FillLayer::initialFillComposite(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearComposite();
    }
    static void applyInheritWebkitBackgroundComposite(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isCompositeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setComposite(parent->composite());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyValueWebkitBackgroundComposite(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillComposite(CSSPropertyWebkitBackgroundComposite, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillComposite(CSSPropertyWebkitBackgroundComposite, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyInitialWebkitBackgroundOrigin(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isOriginSet() || layers.origin() == FillLayer::initialFillOrigin(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setOrigin(FillLayer::initialFillOrigin(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearOrigin();
    }
    static void applyInheritWebkitBackgroundOrigin(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isOriginSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setOrigin(parent->origin());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyValueWebkitBackgroundOrigin(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillOrigin(CSSPropertyWebkitBackgroundOrigin, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillOrigin(CSSPropertyWebkitBackgroundOrigin, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyInitialWebkitBackgroundSize(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isSizeSet() || layers.size() == FillLayer::initialFillSize(FillLayerType::Background)))
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setSize(FillLayer::initialFillSize(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearSize();
    }
    static void applyInheritWebkitBackgroundSize(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;

        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isSizeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setSize(parent->size());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyValueWebkitBackgroundSize(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillSize(CSSPropertyWebkitBackgroundSize, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillSize(CSSPropertyWebkitBackgroundSize, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyInitialWebkitBorderFit(BuilderState& builderState)
    {
        builderState.style().setBorderFit(RenderStyle::initialBorderFit());
    }
    static void applyInheritWebkitBorderFit(BuilderState& builderState)
    {
        builderState.style().setBorderFit(forwardInheritedValue(builderState.parentStyle().borderFit()));
    }
    static void applyValueWebkitBorderFit(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderFit(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBorderHorizontalSpacing(BuilderState& builderState)
    {
        builderState.style().setHorizontalBorderSpacing(RenderStyle::initialHorizontalBorderSpacing());
    }
    static void applyInheritWebkitBorderHorizontalSpacing(BuilderState& builderState)
    {
        builderState.style().setHorizontalBorderSpacing(forwardInheritedValue(builderState.parentStyle().horizontalBorderSpacing()));
    }
    static void applyValueWebkitBorderHorizontalSpacing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHorizontalBorderSpacing(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialWebkitBorderImage(BuilderState& builderState)
    {
        builderState.style().setBorderImage(RenderStyle::initialNinePieceImage());
    }
    static void applyInheritWebkitBorderImage(BuilderState& builderState)
    {
        builderState.style().setBorderImage(forwardInheritedValue(builderState.parentStyle().borderImage()));
    }
    static void applyValueWebkitBorderImage(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderImage(BuilderConverter::convertBorderImage<CSSPropertyWebkitBorderImage>(builderState, value));
    }
    static void applyInitialWebkitBorderVerticalSpacing(BuilderState& builderState)
    {
        builderState.style().setVerticalBorderSpacing(RenderStyle::initialVerticalBorderSpacing());
    }
    static void applyInheritWebkitBorderVerticalSpacing(BuilderState& builderState)
    {
        builderState.style().setVerticalBorderSpacing(forwardInheritedValue(builderState.parentStyle().verticalBorderSpacing()));
    }
    static void applyValueWebkitBorderVerticalSpacing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setVerticalBorderSpacing(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialWebkitBoxAlign(BuilderState& builderState)
    {
        builderState.style().setBoxAlign(RenderStyle::initialBoxAlign());
    }
    static void applyInheritWebkitBoxAlign(BuilderState& builderState)
    {
        builderState.style().setBoxAlign(forwardInheritedValue(builderState.parentStyle().boxAlign()));
    }
    static void applyValueWebkitBoxAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxAlign(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxDecorationBreak(BuilderState& builderState)
    {
        builderState.style().setBoxDecorationBreak(RenderStyle::initialBoxDecorationBreak());
    }
    static void applyInheritWebkitBoxDecorationBreak(BuilderState& builderState)
    {
        builderState.style().setBoxDecorationBreak(forwardInheritedValue(builderState.parentStyle().boxDecorationBreak()));
    }
    static void applyValueWebkitBoxDecorationBreak(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxDecorationBreak(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxDirection(BuilderState& builderState)
    {
        builderState.style().setBoxDirection(RenderStyle::initialBoxDirection());
    }
    static void applyInheritWebkitBoxDirection(BuilderState& builderState)
    {
        builderState.style().setBoxDirection(forwardInheritedValue(builderState.parentStyle().boxDirection()));
    }
    static void applyValueWebkitBoxDirection(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxDirection(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxFlex(BuilderState& builderState)
    {
        builderState.style().setBoxFlex(RenderStyle::initialBoxFlex());
    }
    static void applyInheritWebkitBoxFlex(BuilderState& builderState)
    {
        builderState.style().setBoxFlex(forwardInheritedValue(builderState.parentStyle().boxFlex()));
    }
    static void applyValueWebkitBoxFlex(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxFlex(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxFlexGroup(BuilderState& builderState)
    {
        builderState.style().setBoxFlexGroup(RenderStyle::initialBoxFlexGroup());
    }
    static void applyInheritWebkitBoxFlexGroup(BuilderState& builderState)
    {
        builderState.style().setBoxFlexGroup(forwardInheritedValue(builderState.parentStyle().boxFlexGroup()));
    }
    static void applyValueWebkitBoxFlexGroup(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxFlexGroup(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxLines(BuilderState& builderState)
    {
        builderState.style().setBoxLines(RenderStyle::initialBoxLines());
    }
    static void applyInheritWebkitBoxLines(BuilderState& builderState)
    {
        builderState.style().setBoxLines(forwardInheritedValue(builderState.parentStyle().boxLines()));
    }
    static void applyValueWebkitBoxLines(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxLines(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxOrdinalGroup(BuilderState& builderState)
    {
        builderState.style().setBoxOrdinalGroup(RenderStyle::initialBoxOrdinalGroup());
    }
    static void applyInheritWebkitBoxOrdinalGroup(BuilderState& builderState)
    {
        builderState.style().setBoxOrdinalGroup(forwardInheritedValue(builderState.parentStyle().boxOrdinalGroup()));
    }
    static void applyValueWebkitBoxOrdinalGroup(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxOrdinalGroup(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxOrient(BuilderState& builderState)
    {
        builderState.style().setBoxOrient(RenderStyle::initialBoxOrient());
    }
    static void applyInheritWebkitBoxOrient(BuilderState& builderState)
    {
        builderState.style().setBoxOrient(forwardInheritedValue(builderState.parentStyle().boxOrient()));
    }
    static void applyValueWebkitBoxOrient(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxOrient(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxPack(BuilderState& builderState)
    {
        builderState.style().setBoxPack(RenderStyle::initialBoxPack());
    }
    static void applyInheritWebkitBoxPack(BuilderState& builderState)
    {
        builderState.style().setBoxPack(forwardInheritedValue(builderState.parentStyle().boxPack()));
    }
    static void applyValueWebkitBoxPack(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxPack(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxReflect(BuilderState& builderState)
    {
        builderState.style().setBoxReflect(RenderStyle::initialBoxReflect());
    }
    static void applyInheritWebkitBoxReflect(BuilderState& builderState)
    {
        builderState.style().setBoxReflect(forwardInheritedValue(builderState.parentStyle().boxReflect()));
    }
    static void applyValueWebkitBoxReflect(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxReflect(BuilderConverter::convertReflection(builderState, value));
    }
    static void applyInitialWebkitColumnAxis(BuilderState& builderState)
    {
        builderState.style().setColumnAxis(RenderStyle::initialColumnAxis());
    }
    static void applyInheritWebkitColumnAxis(BuilderState& builderState)
    {
        builderState.style().setColumnAxis(forwardInheritedValue(builderState.parentStyle().columnAxis()));
    }
    static void applyValueWebkitColumnAxis(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnAxis(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitColumnProgression(BuilderState& builderState)
    {
        builderState.style().setColumnProgression(RenderStyle::initialColumnProgression());
    }
    static void applyInheritWebkitColumnProgression(BuilderState& builderState)
    {
        builderState.style().setColumnProgression(forwardInheritedValue(builderState.parentStyle().columnProgression()));
    }
    static void applyValueWebkitColumnProgression(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnProgression(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitCursorVisibility(BuilderState& builderState)
    {
#if ENABLE(CURSOR_VISIBILITY)
        builderState.style().setCursorVisibility(RenderStyle::initialCursorVisibility());
#endif
    }
    static void applyInheritWebkitCursorVisibility(BuilderState& builderState)
    {
#if ENABLE(CURSOR_VISIBILITY)
        builderState.style().setCursorVisibility(forwardInheritedValue(builderState.parentStyle().cursorVisibility()));
#endif
    }
    static void applyValueWebkitCursorVisibility(BuilderState& builderState, CSSValue& value)
    {
#if ENABLE(CURSOR_VISIBILITY)
        builderState.style().setCursorVisibility(downcast<CSSPrimitiveValue>(value));
#endif
    }
    static void applyInitialWebkitHyphenateCharacter(BuilderState& builderState)
    {
        builderState.style().setHyphenationString(RenderStyle::initialHyphenationString());
    }
    static void applyInheritWebkitHyphenateCharacter(BuilderState& builderState)
    {
        builderState.style().setHyphenationString(forwardInheritedValue(builderState.parentStyle().hyphenationString()));
    }
    static void applyValueWebkitHyphenateCharacter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphenationString(BuilderConverter::convertStringOrAuto(builderState, value));
    }
    static void applyInitialWebkitHyphenateLimitAfter(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitAfter(RenderStyle::initialHyphenationLimitAfter());
    }
    static void applyInheritWebkitHyphenateLimitAfter(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitAfter(forwardInheritedValue(builderState.parentStyle().hyphenationLimitAfter()));
    }
    static void applyValueWebkitHyphenateLimitAfter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphenationLimitAfter(BuilderConverter::convertNumberOrAuto<short>(builderState, value));
    }
    static void applyInitialWebkitHyphenateLimitBefore(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitBefore(RenderStyle::initialHyphenationLimitBefore());
    }
    static void applyInheritWebkitHyphenateLimitBefore(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitBefore(forwardInheritedValue(builderState.parentStyle().hyphenationLimitBefore()));
    }
    static void applyValueWebkitHyphenateLimitBefore(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphenationLimitBefore(BuilderConverter::convertNumberOrAuto<short>(builderState, value));
    }
    static void applyInitialWebkitHyphenateLimitLines(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitLines(RenderStyle::initialHyphenationLimitLines());
    }
    static void applyInheritWebkitHyphenateLimitLines(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitLines(forwardInheritedValue(builderState.parentStyle().hyphenationLimitLines()));
    }
    static void applyValueWebkitHyphenateLimitLines(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphenationLimitLines(BuilderConverter::convertWebkitHyphenateLimitLines(builderState, value));
    }
    static void applyInitialWebkitHyphens(BuilderState& builderState)
    {
        builderState.style().setHyphens(RenderStyle::initialHyphens());
    }
    static void applyInheritWebkitHyphens(BuilderState& builderState)
    {
        builderState.style().setHyphens(forwardInheritedValue(builderState.parentStyle().hyphens()));
    }
    static void applyValueWebkitHyphens(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphens(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitInitialLetter(BuilderState& builderState)
    {
        builderState.style().setInitialLetter(RenderStyle::initialInitialLetter());
    }
    static void applyInheritWebkitInitialLetter(BuilderState& builderState)
    {
        builderState.style().setInitialLetter(forwardInheritedValue(builderState.parentStyle().initialLetter()));
    }
    static void applyValueWebkitInitialLetter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setInitialLetter(BuilderConverter::convertInitialLetter(builderState, value));
    }
    static void applyInitialWebkitLineAlign(BuilderState& builderState)
    {
        builderState.style().setLineAlign(RenderStyle::initialLineAlign());
    }
    static void applyInheritWebkitLineAlign(BuilderState& builderState)
    {
        builderState.style().setLineAlign(forwardInheritedValue(builderState.parentStyle().lineAlign()));
    }
    static void applyValueWebkitLineAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineAlign(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitLineBoxContain(BuilderState& builderState)
    {
        builderState.style().setLineBoxContain(RenderStyle::initialLineBoxContain());
    }
    static void applyInheritWebkitLineBoxContain(BuilderState& builderState)
    {
        builderState.style().setLineBoxContain(forwardInheritedValue(builderState.parentStyle().lineBoxContain()));
    }
    static void applyValueWebkitLineBoxContain(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineBoxContain(BuilderConverter::convertLineBoxContain(builderState, value));
    }
    static void applyInitialWebkitLineClamp(BuilderState& builderState)
    {
        builderState.style().setLineClamp(RenderStyle::initialLineClamp());
    }
    static void applyInheritWebkitLineClamp(BuilderState& builderState)
    {
        builderState.style().setLineClamp(forwardInheritedValue(builderState.parentStyle().lineClamp()));
    }
    static void applyValueWebkitLineClamp(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineClamp(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitLineGrid(BuilderState& builderState)
    {
        builderState.style().setLineGrid(RenderStyle::initialLineGrid());
    }
    static void applyInheritWebkitLineGrid(BuilderState& builderState)
    {
        builderState.style().setLineGrid(forwardInheritedValue(builderState.parentStyle().lineGrid()));
    }
    static void applyValueWebkitLineGrid(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineGrid(BuilderConverter::convertStringOrNone(builderState, value));
    }
    static void applyInitialWebkitLineSnap(BuilderState& builderState)
    {
        builderState.style().setLineSnap(RenderStyle::initialLineSnap());
    }
    static void applyInheritWebkitLineSnap(BuilderState& builderState)
    {
        builderState.style().setLineSnap(forwardInheritedValue(builderState.parentStyle().lineSnap()));
    }
    static void applyValueWebkitLineSnap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineSnap(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMarginAfterCollapse(BuilderState& builderState)
    {
        builderState.style().setMarginAfterCollapse(RenderStyle::initialMarginAfterCollapse());
    }
    static void applyInheritWebkitMarginAfterCollapse(BuilderState& builderState)
    {
        builderState.style().setMarginAfterCollapse(forwardInheritedValue(builderState.parentStyle().marginAfterCollapse()));
    }
    static void applyValueWebkitMarginAfterCollapse(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginAfterCollapse(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMarginBeforeCollapse(BuilderState& builderState)
    {
        builderState.style().setMarginBeforeCollapse(RenderStyle::initialMarginBeforeCollapse());
    }
    static void applyInheritWebkitMarginBeforeCollapse(BuilderState& builderState)
    {
        builderState.style().setMarginBeforeCollapse(forwardInheritedValue(builderState.parentStyle().marginBeforeCollapse()));
    }
    static void applyValueWebkitMarginBeforeCollapse(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginBeforeCollapse(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMarginBottomCollapse(BuilderState& builderState)
    {
        builderState.style().setMarginAfterCollapse(RenderStyle::initialMarginAfterCollapse());
    }
    static void applyInheritWebkitMarginBottomCollapse(BuilderState& builderState)
    {
        builderState.style().setMarginAfterCollapse(forwardInheritedValue(builderState.parentStyle().marginAfterCollapse()));
    }
    static void applyValueWebkitMarginBottomCollapse(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginAfterCollapse(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMarginTopCollapse(BuilderState& builderState)
    {
        builderState.style().setMarginBeforeCollapse(RenderStyle::initialMarginBeforeCollapse());
    }
    static void applyInheritWebkitMarginTopCollapse(BuilderState& builderState)
    {
        builderState.style().setMarginBeforeCollapse(forwardInheritedValue(builderState.parentStyle().marginBeforeCollapse()));
    }
    static void applyValueWebkitMarginTopCollapse(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginBeforeCollapse(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMarqueeDirection(BuilderState& builderState)
    {
        builderState.style().setMarqueeDirection(RenderStyle::initialMarqueeDirection());
    }
    static void applyInheritWebkitMarqueeDirection(BuilderState& builderState)
    {
        builderState.style().setMarqueeDirection(forwardInheritedValue(builderState.parentStyle().marqueeDirection()));
    }
    static void applyValueWebkitMarqueeDirection(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarqueeDirection(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMarqueeIncrement(BuilderState& builderState)
    {
        builderState.style().setMarqueeIncrement(RenderStyle::initialMarqueeIncrement());
    }
    static void applyInheritWebkitMarqueeIncrement(BuilderState& builderState)
    {
        builderState.style().setMarqueeIncrement(forwardInheritedValue(builderState.parentStyle().marqueeIncrement()));
    }
    static void applyValueWebkitMarqueeIncrement(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertMarqueeIncrement(builderState, value);
        if (convertedValue)
            builderState.style().setMarqueeIncrement(WTFMove(convertedValue.value()));
    }
    static void applyInitialWebkitMarqueeRepetition(BuilderState& builderState)
    {
        builderState.style().setMarqueeLoopCount(RenderStyle::initialMarqueeLoopCount());
    }
    static void applyInheritWebkitMarqueeRepetition(BuilderState& builderState)
    {
        builderState.style().setMarqueeLoopCount(forwardInheritedValue(builderState.parentStyle().marqueeLoopCount()));
    }
    static void applyValueWebkitMarqueeRepetition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarqueeLoopCount(BuilderConverter::convertMarqueeRepetition(builderState, value));
    }
    static void applyInitialWebkitMarqueeSpeed(BuilderState& builderState)
    {
        builderState.style().setMarqueeSpeed(RenderStyle::initialMarqueeSpeed());
    }
    static void applyInheritWebkitMarqueeSpeed(BuilderState& builderState)
    {
        builderState.style().setMarqueeSpeed(forwardInheritedValue(builderState.parentStyle().marqueeSpeed()));
    }
    static void applyValueWebkitMarqueeSpeed(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarqueeSpeed(BuilderConverter::convertMarqueeSpeed(builderState, value));
    }
    static void applyInitialWebkitMarqueeStyle(BuilderState& builderState)
    {
        builderState.style().setMarqueeBehavior(RenderStyle::initialMarqueeBehavior());
    }
    static void applyInheritWebkitMarqueeStyle(BuilderState& builderState)
    {
        builderState.style().setMarqueeBehavior(forwardInheritedValue(builderState.parentStyle().marqueeBehavior()));
    }
    static void applyValueWebkitMarqueeStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarqueeBehavior(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMaskBoxImage(BuilderState& builderState)
    {
        builderState.style().setMaskBoxImage(RenderStyle::initialNinePieceImage());
    }
    static void applyInheritWebkitMaskBoxImage(BuilderState& builderState)
    {
        builderState.style().setMaskBoxImage(forwardInheritedValue(builderState.parentStyle().maskBoxImage()));
    }
    static void applyValueWebkitMaskBoxImage(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMaskBoxImage(BuilderConverter::convertBorderMask<CSSPropertyWebkitMaskBoxImage>(builderState, value));
    }
    static void applyInitialWebkitMaskBoxImageSource(BuilderState& builderState)
    {
        builderState.style().setMaskBoxImageSource(RenderStyle::initialMaskBoxImageSource());
    }
    static void applyInheritWebkitMaskBoxImageSource(BuilderState& builderState)
    {
        builderState.style().setMaskBoxImageSource(forwardInheritedValue(builderState.parentStyle().maskBoxImageSource()));
    }
    static void applyValueWebkitMaskBoxImageSource(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMaskBoxImageSource(BuilderConverter::convertStyleImage<CSSPropertyWebkitMaskBoxImageSource>(builderState, value));
    }
    static void applyInitialWebkitMaskClip(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isClipSet() || layers.clip() == FillLayer::initialFillClip(FillLayerType::Mask)))
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        child->setClip(FillLayer::initialFillClip(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearClip();
    }
    static void applyInheritWebkitMaskClip(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isClipSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setClip(parent->clip());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyValueWebkitMaskClip(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillClip(CSSPropertyWebkitMaskClip, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillClip(CSSPropertyWebkitMaskClip, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyInitialWebkitMaskComposite(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isCompositeSet() || layers.composite() == FillLayer::initialFillComposite(FillLayerType::Mask)))
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        child->setComposite(FillLayer::initialFillComposite(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearComposite();
    }
    static void applyInheritWebkitMaskComposite(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isCompositeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setComposite(parent->composite());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyValueWebkitMaskComposite(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillComposite(CSSPropertyWebkitMaskComposite, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillComposite(CSSPropertyWebkitMaskComposite, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyInitialWebkitMaskImage(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isImageSet() || layers.image() == FillLayer::initialFillImage(FillLayerType::Mask)))
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        child->setImage(FillLayer::initialFillImage(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearImage();
    }
    static void applyInheritWebkitMaskImage(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isImageSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setImage(parent->image());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyValueWebkitMaskImage(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillImage(CSSPropertyWebkitMaskImage, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillImage(CSSPropertyWebkitMaskImage, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyInitialWebkitMaskOrigin(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isOriginSet() || layers.origin() == FillLayer::initialFillOrigin(FillLayerType::Mask)))
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        child->setOrigin(FillLayer::initialFillOrigin(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearOrigin();
    }
    static void applyInheritWebkitMaskOrigin(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isOriginSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setOrigin(parent->origin());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyValueWebkitMaskOrigin(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillOrigin(CSSPropertyWebkitMaskOrigin, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillOrigin(CSSPropertyWebkitMaskOrigin, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyInitialWebkitMaskPositionX(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isXPositionSet() || layers.xPosition() == FillLayer::initialFillXPosition(FillLayerType::Mask)))
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        child->setXPosition(FillLayer::initialFillXPosition(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearXPosition();
    }
    static void applyInheritWebkitMaskPositionX(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isXPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setXPosition(parent->xPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyValueWebkitMaskPositionX(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillXPosition(CSSPropertyWebkitMaskPositionX, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillXPosition(CSSPropertyWebkitMaskPositionX, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyInitialWebkitMaskPositionY(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isYPositionSet() || layers.yPosition() == FillLayer::initialFillYPosition(FillLayerType::Mask)))
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        child->setYPosition(FillLayer::initialFillYPosition(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearYPosition();
    }
    static void applyInheritWebkitMaskPositionY(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isYPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setYPosition(parent->yPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyValueWebkitMaskPositionY(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillYPosition(CSSPropertyWebkitMaskPositionY, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillYPosition(CSSPropertyWebkitMaskPositionY, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyInitialWebkitMaskRepeatX(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isRepeatXSet() || layers.repeatX() == FillLayer::initialFillRepeatX(FillLayerType::Mask)))
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        child->setRepeatX(FillLayer::initialFillRepeatX(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearRepeatX();
    }
    static void applyInheritWebkitMaskRepeatX(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isRepeatXSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setRepeatX(parent->repeatX());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearRepeatX();
    }
    static void applyValueWebkitMaskRepeatX(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillRepeatX(CSSPropertyWebkitMaskRepeatX, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillRepeatX(CSSPropertyWebkitMaskRepeatX, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearRepeatX();
    }
    static void applyInitialWebkitMaskRepeatY(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isRepeatYSet() || layers.repeatY() == FillLayer::initialFillRepeatY(FillLayerType::Mask)))
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        child->setRepeatY(FillLayer::initialFillRepeatY(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearRepeatY();
    }
    static void applyInheritWebkitMaskRepeatY(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isRepeatYSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setRepeatY(parent->repeatY());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearRepeatY();
    }
    static void applyValueWebkitMaskRepeatY(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillRepeatY(CSSPropertyWebkitMaskRepeatY, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillRepeatY(CSSPropertyWebkitMaskRepeatY, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearRepeatY();
    }
    static void applyInitialWebkitMaskSize(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isSizeSet() || layers.size() == FillLayer::initialFillSize(FillLayerType::Mask)))
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        child->setSize(FillLayer::initialFillSize(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearSize();
    }
    static void applyInheritWebkitMaskSize(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isSizeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setSize(parent->size());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyValueWebkitMaskSize(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillSize(CSSPropertyWebkitMaskSize, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillSize(CSSPropertyWebkitMaskSize, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyInitialWebkitMaskSourceType(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isMaskSourceTypeSet() || layers.maskSourceType() == FillLayer::initialFillMaskSourceType(FillLayerType::Mask)))
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        child->setMaskSourceType(FillLayer::initialFillMaskSourceType(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearMaskSourceType();
    }
    static void applyInheritWebkitMaskSourceType(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;

        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isMaskSourceTypeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setMaskSourceType(parent->maskSourceType());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearMaskSourceType();
    }
    static void applyValueWebkitMaskSourceType(BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value) && !is<CSSImageSetValue>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(makeUnique<FillLayer>(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillMaskSourceType(CSSPropertyWebkitMaskSourceType, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillMaskSourceType(CSSPropertyWebkitMaskSourceType, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearMaskSourceType();
    }
    static void applyInitialWebkitNbspMode(BuilderState& builderState)
    {
        builderState.style().setNBSPMode(RenderStyle::initialNBSPMode());
    }
    static void applyInheritWebkitNbspMode(BuilderState& builderState)
    {
        builderState.style().setNBSPMode(forwardInheritedValue(builderState.parentStyle().nbspMode()));
    }
    static void applyValueWebkitNbspMode(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setNBSPMode(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitPrintColorAdjust(BuilderState& builderState)
    {
        builderState.style().setPrintColorAdjust(RenderStyle::initialPrintColorAdjust());
    }
    static void applyInheritWebkitPrintColorAdjust(BuilderState& builderState)
    {
        builderState.style().setPrintColorAdjust(forwardInheritedValue(builderState.parentStyle().printColorAdjust()));
    }
    static void applyValueWebkitPrintColorAdjust(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPrintColorAdjust(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitRtlOrdering(BuilderState& builderState)
    {
        builderState.style().setRTLOrdering(RenderStyle::initialRTLOrdering());
    }
    static void applyInheritWebkitRtlOrdering(BuilderState& builderState)
    {
        builderState.style().setRTLOrdering(forwardInheritedValue(builderState.parentStyle().rtlOrdering()));
    }
    static void applyValueWebkitRtlOrdering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRTLOrdering(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitRubyPosition(BuilderState& builderState)
    {
        builderState.style().setRubyPosition(RenderStyle::initialRubyPosition());
    }
    static void applyInheritWebkitRubyPosition(BuilderState& builderState)
    {
        builderState.style().setRubyPosition(forwardInheritedValue(builderState.parentStyle().rubyPosition()));
    }
    static void applyValueWebkitRubyPosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRubyPosition(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitTextCombine(BuilderState& builderState)
    {
        builderState.style().setTextCombine(RenderStyle::initialTextCombine());
    }
    static void applyInheritWebkitTextCombine(BuilderState& builderState)
    {
        builderState.style().setTextCombine(forwardInheritedValue(builderState.parentStyle().textCombine()));
    }
    static void applyValueWebkitTextCombine(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextCombine(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitTextEmphasisColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextEmphasisColor(RenderStyle::invalidColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextEmphasisColor(RenderStyle::invalidColor());
    }
    static void applyInheritWebkitTextEmphasisColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().textEmphasisColor();
        if (!color.isValid())
            color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextEmphasisColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextEmphasisColor(color);
    }
    static void applyValueWebkitTextEmphasisColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextEmphasisColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextEmphasisColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialWebkitTextEmphasisPosition(BuilderState& builderState)
    {
        builderState.style().setTextEmphasisPosition(RenderStyle::initialTextEmphasisPosition());
    }
    static void applyInheritWebkitTextEmphasisPosition(BuilderState& builderState)
    {
        builderState.style().setTextEmphasisPosition(forwardInheritedValue(builderState.parentStyle().textEmphasisPosition()));
    }
    static void applyValueWebkitTextEmphasisPosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextEmphasisPosition(BuilderConverter::convertTextEmphasisPosition(builderState, value));
    }
    static void applyInitialWebkitTextFillColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextFillColor(RenderStyle::invalidColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextFillColor(RenderStyle::invalidColor());
    }
    static void applyInheritWebkitTextFillColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().textFillColor();
        if (!color.isValid())
            color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextFillColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextFillColor(color);
    }
    static void applyValueWebkitTextFillColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextFillColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextFillColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialWebkitTextSecurity(BuilderState& builderState)
    {
        builderState.style().setTextSecurity(RenderStyle::initialTextSecurity());
    }
    static void applyInheritWebkitTextSecurity(BuilderState& builderState)
    {
        builderState.style().setTextSecurity(forwardInheritedValue(builderState.parentStyle().textSecurity()));
    }
    static void applyValueWebkitTextSecurity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextSecurity(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitTextStrokeColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextStrokeColor(RenderStyle::invalidColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextStrokeColor(RenderStyle::invalidColor());
    }
    static void applyInheritWebkitTextStrokeColor(BuilderState& builderState)
    {
        Color color = builderState.parentStyle().textStrokeColor();
        if (!color.isValid())
            color = builderState.parentStyle().color();
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextStrokeColor(color);
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextStrokeColor(color);
    }
    static void applyValueWebkitTextStrokeColor(BuilderState& builderState, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextStrokeColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextStrokeColor(builderState.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialWebkitTextStrokeWidth(BuilderState& builderState)
    {
        builderState.style().setTextStrokeWidth(RenderStyle::initialTextStrokeWidth());
    }
    static void applyInheritWebkitTextStrokeWidth(BuilderState& builderState)
    {
        builderState.style().setTextStrokeWidth(forwardInheritedValue(builderState.parentStyle().textStrokeWidth()));
    }
    static void applyValueWebkitTextStrokeWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextStrokeWidth(BuilderConverter::convertTextStrokeWidth(builderState, value));
    }
    static void applyInitialWebkitTransformStyle(BuilderState& builderState)
    {
        builderState.style().setTransformStyle3D(RenderStyle::initialTransformStyle3D());
    }
    static void applyInheritWebkitTransformStyle(BuilderState& builderState)
    {
        builderState.style().setTransformStyle3D(forwardInheritedValue(builderState.parentStyle().transformStyle3D()));
    }
    static void applyValueWebkitTransformStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformStyle3D(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitUserDrag(BuilderState& builderState)
    {
        builderState.style().setUserDrag(RenderStyle::initialUserDrag());
    }
    static void applyInheritWebkitUserDrag(BuilderState& builderState)
    {
        builderState.style().setUserDrag(forwardInheritedValue(builderState.parentStyle().userDrag()));
    }
    static void applyValueWebkitUserDrag(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUserDrag(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitUserModify(BuilderState& builderState)
    {
        builderState.style().setUserModify(RenderStyle::initialUserModify());
    }
    static void applyInheritWebkitUserModify(BuilderState& builderState)
    {
        builderState.style().setUserModify(forwardInheritedValue(builderState.parentStyle().userModify()));
    }
    static void applyValueWebkitUserModify(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUserModify(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitUserSelect(BuilderState& builderState)
    {
        builderState.style().setUserSelect(RenderStyle::initialUserSelect());
    }
    static void applyInheritWebkitUserSelect(BuilderState& builderState)
    {
        builderState.style().setUserSelect(forwardInheritedValue(builderState.parentStyle().userSelect()));
    }
    static void applyValueWebkitUserSelect(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUserSelect(downcast<CSSPrimitiveValue>(value));
    }
};

void BuilderGenerated::applyProperty(CSSPropertyID property, BuilderState& builderState, CSSValue& value, bool isInitial, bool isInherit, const CSSRegisteredCustomProperty* registered)
{
    switch (property) {
    case CSSPropertyInvalid:
        break;
    case CSSPropertyCustom: {
        auto& customProperty = downcast<CSSCustomPropertyValue>(value);
        if (isInitial)
            BuilderCustom::applyInitialCustomProperty(builderState, registered, customProperty.name());
        else if (isInherit)
            BuilderCustom::applyInheritCustomProperty(builderState, registered, customProperty.name());
        else
            BuilderCustom::applyValueCustomProperty(builderState, registered, customProperty);
        break;
    }
    case CSSPropertyColor:
        if (isInitial)
            BuilderFunctions::applyInitialColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColor(builderState);
        else
            BuilderFunctions::applyValueColor(builderState, value);
        break;
    case CSSPropertyDirection:
        if (isInitial)
            BuilderFunctions::applyInitialDirection(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritDirection(builderState);
        else
            BuilderCustom::applyValueDirection(builderState, value);
        break;
    case CSSPropertyDisplay:
        if (isInitial)
            BuilderFunctions::applyInitialDisplay(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritDisplay(builderState);
        else
            BuilderCustom::applyValueDisplay(builderState, value);
        break;
    case CSSPropertyFontFamily:
        if (isInitial)
            BuilderCustom::applyInitialFontFamily(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontFamily(builderState);
        else
            BuilderCustom::applyValueFontFamily(builderState, value);
        break;
    case CSSPropertyFontFeatureSettings:
        if (isInitial)
            BuilderCustom::applyInitialFontFeatureSettings(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontFeatureSettings(builderState);
        else
            BuilderFunctions::applyValueFontFeatureSettings(builderState, value);
        break;
    case CSSPropertyFontOpticalSizing:
        if (isInitial)
            BuilderFunctions::applyInitialFontOpticalSizing(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontOpticalSizing(builderState);
        else
            BuilderFunctions::applyValueFontOpticalSizing(builderState, value);
        break;
    case CSSPropertyFontSize:
        if (isInitial)
            BuilderCustom::applyInitialFontSize(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontSize(builderState);
        else
            BuilderCustom::applyValueFontSize(builderState, value);
        break;
    case CSSPropertyFontStretch:
        if (isInitial)
            BuilderFunctions::applyInitialFontStretch(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontStretch(builderState);
        else
            BuilderFunctions::applyValueFontStretch(builderState, value);
        break;
    case CSSPropertyFontStyle:
        if (isInitial)
            BuilderCustom::applyInitialFontStyle(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontStyle(builderState);
        else
            BuilderCustom::applyValueFontStyle(builderState, value);
        break;
    case CSSPropertyFontSynthesis:
        if (isInitial)
            BuilderFunctions::applyInitialFontSynthesis(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontSynthesis(builderState);
        else
            BuilderFunctions::applyValueFontSynthesis(builderState, value);
        break;
    case CSSPropertyFontVariantAlternates:
        if (isInitial)
            BuilderFunctions::applyInitialFontVariantAlternates(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontVariantAlternates(builderState);
        else
            BuilderFunctions::applyValueFontVariantAlternates(builderState, value);
        break;
    case CSSPropertyFontVariantCaps:
        if (isInitial)
            BuilderFunctions::applyInitialFontVariantCaps(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontVariantCaps(builderState);
        else
            BuilderFunctions::applyValueFontVariantCaps(builderState, value);
        break;
    case CSSPropertyFontVariantEastAsian:
        if (isInitial)
            BuilderCustom::applyInitialFontVariantEastAsian(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontVariantEastAsian(builderState);
        else
            BuilderCustom::applyValueFontVariantEastAsian(builderState, value);
        break;
    case CSSPropertyFontVariantLigatures:
        if (isInitial)
            BuilderCustom::applyInitialFontVariantLigatures(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontVariantLigatures(builderState);
        else
            BuilderCustom::applyValueFontVariantLigatures(builderState, value);
        break;
    case CSSPropertyFontVariantNumeric:
        if (isInitial)
            BuilderCustom::applyInitialFontVariantNumeric(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontVariantNumeric(builderState);
        else
            BuilderCustom::applyValueFontVariantNumeric(builderState, value);
        break;
    case CSSPropertyFontVariantPosition:
        if (isInitial)
            BuilderFunctions::applyInitialFontVariantPosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontVariantPosition(builderState);
        else
            BuilderFunctions::applyValueFontVariantPosition(builderState, value);
        break;
    case CSSPropertyFontVariationSettings:
        if (isInitial)
            BuilderCustom::applyInitialFontVariationSettings(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontVariationSettings(builderState);
        else
            BuilderFunctions::applyValueFontVariationSettings(builderState, value);
        break;
    case CSSPropertyFontWeight:
        if (isInitial)
            BuilderFunctions::applyInitialFontWeight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontWeight(builderState);
        else
            BuilderFunctions::applyValueFontWeight(builderState, value);
        break;
    case CSSPropertyTextRendering:
        if (isInitial)
            BuilderFunctions::applyInitialTextRendering(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextRendering(builderState);
        else
            BuilderFunctions::applyValueTextRendering(builderState, value);
        break;
    case CSSPropertyWritingMode:
        if (isInitial)
            BuilderFunctions::applyInitialWritingMode(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWritingMode(builderState);
        else
            BuilderCustom::applyValueWritingMode(builderState, value);
        break;
    case CSSPropertyZoom:
        if (isInitial)
            BuilderCustom::applyInitialZoom(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritZoom(builderState);
        else
            BuilderCustom::applyValueZoom(builderState, value);
        break;
    case CSSPropertyWebkitFontKerning:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitFontKerning(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitFontKerning(builderState);
        else
            BuilderFunctions::applyValueWebkitFontKerning(builderState, value);
        break;
    case CSSPropertyWebkitFontSmoothing:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitFontSmoothing(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitFontSmoothing(builderState);
        else
            BuilderFunctions::applyValueWebkitFontSmoothing(builderState, value);
        break;
    case CSSPropertyWebkitLocale:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitLocale(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitLocale(builderState);
        else
            BuilderCustom::applyValueWebkitLocale(builderState, value);
        break;
    case CSSPropertyWebkitTextOrientation:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextOrientation(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextOrientation(builderState);
        else
            BuilderCustom::applyValueWebkitTextOrientation(builderState, value);
        break;
    case CSSPropertyWebkitTextZoom:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextZoom(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextZoom(builderState);
        else
            BuilderCustom::applyValueWebkitTextZoom(builderState, value);
        break;
    case CSSPropertyAlignContent:
        if (isInitial)
            BuilderFunctions::applyInitialAlignContent(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAlignContent(builderState);
        else
            BuilderFunctions::applyValueAlignContent(builderState, value);
        break;
    case CSSPropertyAlignItems:
        if (isInitial)
            BuilderFunctions::applyInitialAlignItems(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAlignItems(builderState);
        else
            BuilderFunctions::applyValueAlignItems(builderState, value);
        break;
    case CSSPropertyAlignSelf:
        if (isInitial)
            BuilderFunctions::applyInitialAlignSelf(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAlignSelf(builderState);
        else
            BuilderFunctions::applyValueAlignSelf(builderState, value);
        break;
    case CSSPropertyAlignmentBaseline:
        if (isInitial)
            BuilderFunctions::applyInitialAlignmentBaseline(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAlignmentBaseline(builderState);
        else
            BuilderFunctions::applyValueAlignmentBaseline(builderState, value);
        break;
    case CSSPropertyAll:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyAlt:
        if (isInitial)
            BuilderFunctions::applyInitialAlt(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAlt(builderState);
        else
            BuilderCustom::applyValueAlt(builderState, value);
        break;
    case CSSPropertyAnimation:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyAnimationDelay:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationDelay(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationDelay(builderState);
        else
            BuilderFunctions::applyValueAnimationDelay(builderState, value);
        break;
    case CSSPropertyAnimationDirection:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationDirection(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationDirection(builderState);
        else
            BuilderFunctions::applyValueAnimationDirection(builderState, value);
        break;
    case CSSPropertyAnimationDuration:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationDuration(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationDuration(builderState);
        else
            BuilderFunctions::applyValueAnimationDuration(builderState, value);
        break;
    case CSSPropertyAnimationFillMode:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationFillMode(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationFillMode(builderState);
        else
            BuilderFunctions::applyValueAnimationFillMode(builderState, value);
        break;
    case CSSPropertyAnimationIterationCount:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationIterationCount(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationIterationCount(builderState);
        else
            BuilderFunctions::applyValueAnimationIterationCount(builderState, value);
        break;
    case CSSPropertyAnimationName:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationName(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationName(builderState);
        else
            BuilderFunctions::applyValueAnimationName(builderState, value);
        break;
    case CSSPropertyAnimationPlayState:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationPlayState(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationPlayState(builderState);
        else
            BuilderFunctions::applyValueAnimationPlayState(builderState, value);
        break;
    case CSSPropertyAnimationTimingFunction:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationTimingFunction(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationTimingFunction(builderState);
        else
            BuilderFunctions::applyValueAnimationTimingFunction(builderState, value);
        break;
    case CSSPropertyBackground:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBackgroundAttachment:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundAttachment(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundAttachment(builderState);
        else
            BuilderFunctions::applyValueBackgroundAttachment(builderState, value);
        break;
    case CSSPropertyBackgroundBlendMode:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundBlendMode(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundBlendMode(builderState);
        else
            BuilderFunctions::applyValueBackgroundBlendMode(builderState, value);
        break;
    case CSSPropertyBackgroundClip:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundClip(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundClip(builderState);
        else
            BuilderFunctions::applyValueBackgroundClip(builderState, value);
        break;
    case CSSPropertyBackgroundColor:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundColor(builderState);
        else
            BuilderFunctions::applyValueBackgroundColor(builderState, value);
        break;
    case CSSPropertyBackgroundImage:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundImage(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundImage(builderState);
        else
            BuilderFunctions::applyValueBackgroundImage(builderState, value);
        break;
    case CSSPropertyBackgroundOrigin:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundOrigin(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundOrigin(builderState);
        else
            BuilderFunctions::applyValueBackgroundOrigin(builderState, value);
        break;
    case CSSPropertyBackgroundPosition:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBackgroundPositionX:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundPositionX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundPositionX(builderState);
        else
            BuilderFunctions::applyValueBackgroundPositionX(builderState, value);
        break;
    case CSSPropertyBackgroundPositionY:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundPositionY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundPositionY(builderState);
        else
            BuilderFunctions::applyValueBackgroundPositionY(builderState, value);
        break;
    case CSSPropertyBackgroundRepeat:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBackgroundRepeatX:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundRepeatX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundRepeatX(builderState);
        else
            BuilderFunctions::applyValueBackgroundRepeatX(builderState, value);
        break;
    case CSSPropertyBackgroundRepeatY:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundRepeatY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundRepeatY(builderState);
        else
            BuilderFunctions::applyValueBackgroundRepeatY(builderState, value);
        break;
    case CSSPropertyBackgroundSize:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundSize(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundSize(builderState);
        else
            BuilderFunctions::applyValueBackgroundSize(builderState, value);
        break;
    case CSSPropertyBaselineShift:
        if (isInitial)
            BuilderFunctions::applyInitialBaselineShift(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBaselineShift(builderState);
        else
            BuilderCustom::applyValueBaselineShift(builderState, value);
        break;
    case CSSPropertyBlockSize:
        break;
    case CSSPropertyBorder:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderBlock:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderBlockColor:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderBlockEnd:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderBlockEndColor:
        break;
    case CSSPropertyBorderBlockEndStyle:
        break;
    case CSSPropertyBorderBlockEndWidth:
        break;
    case CSSPropertyBorderBlockStart:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderBlockStartColor:
        break;
    case CSSPropertyBorderBlockStartStyle:
        break;
    case CSSPropertyBorderBlockStartWidth:
        break;
    case CSSPropertyBorderBlockStyle:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderBlockWidth:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderBottom:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderBottomColor:
        if (isInitial)
            BuilderFunctions::applyInitialBorderBottomColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderBottomColor(builderState);
        else
            BuilderFunctions::applyValueBorderBottomColor(builderState, value);
        break;
    case CSSPropertyBorderBottomLeftRadius:
        if (isInitial)
            BuilderFunctions::applyInitialBorderBottomLeftRadius(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderBottomLeftRadius(builderState);
        else
            BuilderFunctions::applyValueBorderBottomLeftRadius(builderState, value);
        break;
    case CSSPropertyBorderBottomRightRadius:
        if (isInitial)
            BuilderFunctions::applyInitialBorderBottomRightRadius(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderBottomRightRadius(builderState);
        else
            BuilderFunctions::applyValueBorderBottomRightRadius(builderState, value);
        break;
    case CSSPropertyBorderBottomStyle:
        if (isInitial)
            BuilderFunctions::applyInitialBorderBottomStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderBottomStyle(builderState);
        else
            BuilderFunctions::applyValueBorderBottomStyle(builderState, value);
        break;
    case CSSPropertyBorderBottomWidth:
        if (isInitial)
            BuilderFunctions::applyInitialBorderBottomWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderBottomWidth(builderState);
        else
            BuilderFunctions::applyValueBorderBottomWidth(builderState, value);
        break;
    case CSSPropertyBorderCollapse:
        if (isInitial)
            BuilderFunctions::applyInitialBorderCollapse(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderCollapse(builderState);
        else
            BuilderFunctions::applyValueBorderCollapse(builderState, value);
        break;
    case CSSPropertyBorderColor:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderImage:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderImageOutset:
        if (isInitial)
            BuilderCustom::applyInitialBorderImageOutset(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBorderImageOutset(builderState);
        else
            BuilderCustom::applyValueBorderImageOutset(builderState, value);
        break;
    case CSSPropertyBorderImageRepeat:
        if (isInitial)
            BuilderCustom::applyInitialBorderImageRepeat(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBorderImageRepeat(builderState);
        else
            BuilderCustom::applyValueBorderImageRepeat(builderState, value);
        break;
    case CSSPropertyBorderImageSlice:
        if (isInitial)
            BuilderCustom::applyInitialBorderImageSlice(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBorderImageSlice(builderState);
        else
            BuilderCustom::applyValueBorderImageSlice(builderState, value);
        break;
    case CSSPropertyBorderImageSource:
        if (isInitial)
            BuilderFunctions::applyInitialBorderImageSource(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderImageSource(builderState);
        else
            BuilderFunctions::applyValueBorderImageSource(builderState, value);
        break;
    case CSSPropertyBorderImageWidth:
        if (isInitial)
            BuilderCustom::applyInitialBorderImageWidth(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBorderImageWidth(builderState);
        else
            BuilderCustom::applyValueBorderImageWidth(builderState, value);
        break;
    case CSSPropertyBorderInline:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderInlineColor:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderInlineEnd:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderInlineEndColor:
        break;
    case CSSPropertyBorderInlineEndStyle:
        break;
    case CSSPropertyBorderInlineEndWidth:
        break;
    case CSSPropertyBorderInlineStart:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderInlineStartColor:
        break;
    case CSSPropertyBorderInlineStartStyle:
        break;
    case CSSPropertyBorderInlineStartWidth:
        break;
    case CSSPropertyBorderInlineStyle:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderInlineWidth:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderLeft:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderLeftColor:
        if (isInitial)
            BuilderFunctions::applyInitialBorderLeftColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderLeftColor(builderState);
        else
            BuilderFunctions::applyValueBorderLeftColor(builderState, value);
        break;
    case CSSPropertyBorderLeftStyle:
        if (isInitial)
            BuilderFunctions::applyInitialBorderLeftStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderLeftStyle(builderState);
        else
            BuilderFunctions::applyValueBorderLeftStyle(builderState, value);
        break;
    case CSSPropertyBorderLeftWidth:
        if (isInitial)
            BuilderFunctions::applyInitialBorderLeftWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderLeftWidth(builderState);
        else
            BuilderFunctions::applyValueBorderLeftWidth(builderState, value);
        break;
    case CSSPropertyBorderRadius:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderRight:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderRightColor:
        if (isInitial)
            BuilderFunctions::applyInitialBorderRightColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderRightColor(builderState);
        else
            BuilderFunctions::applyValueBorderRightColor(builderState, value);
        break;
    case CSSPropertyBorderRightStyle:
        if (isInitial)
            BuilderFunctions::applyInitialBorderRightStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderRightStyle(builderState);
        else
            BuilderFunctions::applyValueBorderRightStyle(builderState, value);
        break;
    case CSSPropertyBorderRightWidth:
        if (isInitial)
            BuilderFunctions::applyInitialBorderRightWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderRightWidth(builderState);
        else
            BuilderFunctions::applyValueBorderRightWidth(builderState, value);
        break;
    case CSSPropertyBorderSpacing:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderStyle:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderTop:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderTopColor:
        if (isInitial)
            BuilderFunctions::applyInitialBorderTopColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderTopColor(builderState);
        else
            BuilderFunctions::applyValueBorderTopColor(builderState, value);
        break;
    case CSSPropertyBorderTopLeftRadius:
        if (isInitial)
            BuilderFunctions::applyInitialBorderTopLeftRadius(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderTopLeftRadius(builderState);
        else
            BuilderFunctions::applyValueBorderTopLeftRadius(builderState, value);
        break;
    case CSSPropertyBorderTopRightRadius:
        if (isInitial)
            BuilderFunctions::applyInitialBorderTopRightRadius(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderTopRightRadius(builderState);
        else
            BuilderFunctions::applyValueBorderTopRightRadius(builderState, value);
        break;
    case CSSPropertyBorderTopStyle:
        if (isInitial)
            BuilderFunctions::applyInitialBorderTopStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderTopStyle(builderState);
        else
            BuilderFunctions::applyValueBorderTopStyle(builderState, value);
        break;
    case CSSPropertyBorderTopWidth:
        if (isInitial)
            BuilderFunctions::applyInitialBorderTopWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderTopWidth(builderState);
        else
            BuilderFunctions::applyValueBorderTopWidth(builderState, value);
        break;
    case CSSPropertyBorderWidth:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBottom:
        if (isInitial)
            BuilderFunctions::applyInitialBottom(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBottom(builderState);
        else
            BuilderFunctions::applyValueBottom(builderState, value);
        break;
    case CSSPropertyBoxShadow:
        if (isInitial)
            BuilderCustom::applyInitialBoxShadow(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBoxShadow(builderState);
        else
            BuilderCustom::applyValueBoxShadow(builderState, value);
        break;
    case CSSPropertyBoxSizing:
        if (isInitial)
            BuilderFunctions::applyInitialBoxSizing(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBoxSizing(builderState);
        else
            BuilderFunctions::applyValueBoxSizing(builderState, value);
        break;
    case CSSPropertyBreakAfter:
        if (isInitial)
            BuilderFunctions::applyInitialBreakAfter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBreakAfter(builderState);
        else
            BuilderFunctions::applyValueBreakAfter(builderState, value);
        break;
    case CSSPropertyBreakBefore:
        if (isInitial)
            BuilderFunctions::applyInitialBreakBefore(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBreakBefore(builderState);
        else
            BuilderFunctions::applyValueBreakBefore(builderState, value);
        break;
    case CSSPropertyBreakInside:
        if (isInitial)
            BuilderFunctions::applyInitialBreakInside(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBreakInside(builderState);
        else
            BuilderFunctions::applyValueBreakInside(builderState, value);
        break;
    case CSSPropertyBufferedRendering:
        if (isInitial)
            BuilderFunctions::applyInitialBufferedRendering(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBufferedRendering(builderState);
        else
            BuilderFunctions::applyValueBufferedRendering(builderState, value);
        break;
    case CSSPropertyCaptionSide:
        if (isInitial)
            BuilderFunctions::applyInitialCaptionSide(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritCaptionSide(builderState);
        else
            BuilderFunctions::applyValueCaptionSide(builderState, value);
        break;
    case CSSPropertyCaretColor:
        if (isInitial)
            BuilderFunctions::applyInitialCaretColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritCaretColor(builderState);
        else
            BuilderFunctions::applyValueCaretColor(builderState, value);
        break;
    case CSSPropertyClear:
        if (isInitial)
            BuilderFunctions::applyInitialClear(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritClear(builderState);
        else
            BuilderFunctions::applyValueClear(builderState, value);
        break;
    case CSSPropertyClip:
        if (isInitial)
            BuilderCustom::applyInitialClip(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritClip(builderState);
        else
            BuilderCustom::applyValueClip(builderState, value);
        break;
    case CSSPropertyClipPath:
        if (isInitial)
            BuilderFunctions::applyInitialClipPath(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritClipPath(builderState);
        else
            BuilderFunctions::applyValueClipPath(builderState, value);
        break;
    case CSSPropertyClipRule:
        if (isInitial)
            BuilderFunctions::applyInitialClipRule(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritClipRule(builderState);
        else
            BuilderFunctions::applyValueClipRule(builderState, value);
        break;
    case CSSPropertyColorInterpolation:
        if (isInitial)
            BuilderFunctions::applyInitialColorInterpolation(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColorInterpolation(builderState);
        else
            BuilderFunctions::applyValueColorInterpolation(builderState, value);
        break;
    case CSSPropertyColorInterpolationFilters:
        if (isInitial)
            BuilderFunctions::applyInitialColorInterpolationFilters(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColorInterpolationFilters(builderState);
        else
            BuilderFunctions::applyValueColorInterpolationFilters(builderState, value);
        break;
    case CSSPropertyColorProfile:
        break;
    case CSSPropertyColorRendering:
        if (isInitial)
            BuilderFunctions::applyInitialColorRendering(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColorRendering(builderState);
        else
            BuilderFunctions::applyValueColorRendering(builderState, value);
        break;
    case CSSPropertyColumnCount:
        if (isInitial)
            BuilderFunctions::applyInitialColumnCount(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnCount(builderState);
        else
            BuilderFunctions::applyValueColumnCount(builderState, value);
        break;
    case CSSPropertyColumnFill:
        if (isInitial)
            BuilderFunctions::applyInitialColumnFill(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnFill(builderState);
        else
            BuilderFunctions::applyValueColumnFill(builderState, value);
        break;
    case CSSPropertyColumnGap:
        if (isInitial)
            BuilderFunctions::applyInitialColumnGap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnGap(builderState);
        else
            BuilderFunctions::applyValueColumnGap(builderState, value);
        break;
    case CSSPropertyColumnRule:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyColumnRuleColor:
        if (isInitial)
            BuilderFunctions::applyInitialColumnRuleColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnRuleColor(builderState);
        else
            BuilderFunctions::applyValueColumnRuleColor(builderState, value);
        break;
    case CSSPropertyColumnRuleStyle:
        if (isInitial)
            BuilderFunctions::applyInitialColumnRuleStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnRuleStyle(builderState);
        else
            BuilderFunctions::applyValueColumnRuleStyle(builderState, value);
        break;
    case CSSPropertyColumnRuleWidth:
        if (isInitial)
            BuilderFunctions::applyInitialColumnRuleWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnRuleWidth(builderState);
        else
            BuilderFunctions::applyValueColumnRuleWidth(builderState, value);
        break;
    case CSSPropertyColumnSpan:
        if (isInitial)
            BuilderFunctions::applyInitialColumnSpan(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnSpan(builderState);
        else
            BuilderFunctions::applyValueColumnSpan(builderState, value);
        break;
    case CSSPropertyColumnWidth:
        if (isInitial)
            BuilderFunctions::applyInitialColumnWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnWidth(builderState);
        else
            BuilderFunctions::applyValueColumnWidth(builderState, value);
        break;
    case CSSPropertyColumns:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyContent:
        if (isInitial)
            BuilderCustom::applyInitialContent(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritContent(builderState);
        else
            BuilderCustom::applyValueContent(builderState, value);
        break;
    case CSSPropertyCounterIncrement:
        if (isInitial)
            BuilderCustom::applyInitialCounterIncrement(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritCounterIncrement(builderState);
        else
            BuilderCustom::applyValueCounterIncrement(builderState, value);
        break;
    case CSSPropertyCounterReset:
        if (isInitial)
            BuilderCustom::applyInitialCounterReset(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritCounterReset(builderState);
        else
            BuilderCustom::applyValueCounterReset(builderState, value);
        break;
    case CSSPropertyCursor:
        if (isInitial)
            BuilderCustom::applyInitialCursor(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritCursor(builderState);
        else
            BuilderCustom::applyValueCursor(builderState, value);
        break;
    case CSSPropertyCx:
        if (isInitial)
            BuilderFunctions::applyInitialCx(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritCx(builderState);
        else
            BuilderFunctions::applyValueCx(builderState, value);
        break;
    case CSSPropertyCy:
        if (isInitial)
            BuilderFunctions::applyInitialCy(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritCy(builderState);
        else
            BuilderFunctions::applyValueCy(builderState, value);
        break;
    case CSSPropertyDominantBaseline:
        if (isInitial)
            BuilderFunctions::applyInitialDominantBaseline(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritDominantBaseline(builderState);
        else
            BuilderFunctions::applyValueDominantBaseline(builderState, value);
        break;
    case CSSPropertyEmptyCells:
        if (isInitial)
            BuilderFunctions::applyInitialEmptyCells(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritEmptyCells(builderState);
        else
            BuilderFunctions::applyValueEmptyCells(builderState, value);
        break;
    case CSSPropertyEnableBackground:
        break;
    case CSSPropertyFill:
        if (isInitial)
            BuilderCustom::applyInitialFill(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFill(builderState);
        else
            BuilderCustom::applyValueFill(builderState, value);
        break;
    case CSSPropertyFillOpacity:
        if (isInitial)
            BuilderFunctions::applyInitialFillOpacity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFillOpacity(builderState);
        else
            BuilderFunctions::applyValueFillOpacity(builderState, value);
        break;
    case CSSPropertyFillRule:
        if (isInitial)
            BuilderFunctions::applyInitialFillRule(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFillRule(builderState);
        else
            BuilderFunctions::applyValueFillRule(builderState, value);
        break;
    case CSSPropertyFilter:
        if (isInitial)
            BuilderFunctions::applyInitialFilter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFilter(builderState);
        else
            BuilderFunctions::applyValueFilter(builderState, value);
        break;
    case CSSPropertyFlex:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyFlexBasis:
        if (isInitial)
            BuilderFunctions::applyInitialFlexBasis(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFlexBasis(builderState);
        else
            BuilderFunctions::applyValueFlexBasis(builderState, value);
        break;
    case CSSPropertyFlexDirection:
        if (isInitial)
            BuilderFunctions::applyInitialFlexDirection(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFlexDirection(builderState);
        else
            BuilderFunctions::applyValueFlexDirection(builderState, value);
        break;
    case CSSPropertyFlexFlow:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyFlexGrow:
        if (isInitial)
            BuilderFunctions::applyInitialFlexGrow(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFlexGrow(builderState);
        else
            BuilderFunctions::applyValueFlexGrow(builderState, value);
        break;
    case CSSPropertyFlexShrink:
        if (isInitial)
            BuilderFunctions::applyInitialFlexShrink(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFlexShrink(builderState);
        else
            BuilderFunctions::applyValueFlexShrink(builderState, value);
        break;
    case CSSPropertyFlexWrap:
        if (isInitial)
            BuilderFunctions::applyInitialFlexWrap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFlexWrap(builderState);
        else
            BuilderFunctions::applyValueFlexWrap(builderState, value);
        break;
    case CSSPropertyFloat:
        if (isInitial)
            BuilderFunctions::applyInitialFloat(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFloat(builderState);
        else
            BuilderFunctions::applyValueFloat(builderState, value);
        break;
    case CSSPropertyFloodColor:
        if (isInitial)
            BuilderFunctions::applyInitialFloodColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFloodColor(builderState);
        else
            BuilderFunctions::applyValueFloodColor(builderState, value);
        break;
    case CSSPropertyFloodOpacity:
        if (isInitial)
            BuilderFunctions::applyInitialFloodOpacity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFloodOpacity(builderState);
        else
            BuilderFunctions::applyValueFloodOpacity(builderState, value);
        break;
    case CSSPropertyFont:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyFontDisplay:
        break;
    case CSSPropertyFontVariant:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyGap:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyGlyphOrientationHorizontal:
        if (isInitial)
            BuilderFunctions::applyInitialGlyphOrientationHorizontal(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGlyphOrientationHorizontal(builderState);
        else
            BuilderFunctions::applyValueGlyphOrientationHorizontal(builderState, value);
        break;
    case CSSPropertyGlyphOrientationVertical:
        if (isInitial)
            BuilderFunctions::applyInitialGlyphOrientationVertical(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGlyphOrientationVertical(builderState);
        else
            BuilderFunctions::applyValueGlyphOrientationVertical(builderState, value);
        break;
    case CSSPropertyGrid:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyGridArea:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyGridAutoColumns:
        if (isInitial)
            BuilderFunctions::applyInitialGridAutoColumns(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridAutoColumns(builderState);
        else
            BuilderFunctions::applyValueGridAutoColumns(builderState, value);
        break;
    case CSSPropertyGridAutoFlow:
        if (isInitial)
            BuilderFunctions::applyInitialGridAutoFlow(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridAutoFlow(builderState);
        else
            BuilderFunctions::applyValueGridAutoFlow(builderState, value);
        break;
    case CSSPropertyGridAutoRows:
        if (isInitial)
            BuilderFunctions::applyInitialGridAutoRows(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridAutoRows(builderState);
        else
            BuilderFunctions::applyValueGridAutoRows(builderState, value);
        break;
    case CSSPropertyGridColumn:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyGridColumnEnd:
        if (isInitial)
            BuilderFunctions::applyInitialGridColumnEnd(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridColumnEnd(builderState);
        else
            BuilderFunctions::applyValueGridColumnEnd(builderState, value);
        break;
    case CSSPropertyGridColumnStart:
        if (isInitial)
            BuilderFunctions::applyInitialGridColumnStart(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridColumnStart(builderState);
        else
            BuilderFunctions::applyValueGridColumnStart(builderState, value);
        break;
    case CSSPropertyGridRow:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyGridRowEnd:
        if (isInitial)
            BuilderFunctions::applyInitialGridRowEnd(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridRowEnd(builderState);
        else
            BuilderFunctions::applyValueGridRowEnd(builderState, value);
        break;
    case CSSPropertyGridRowStart:
        if (isInitial)
            BuilderFunctions::applyInitialGridRowStart(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridRowStart(builderState);
        else
            BuilderFunctions::applyValueGridRowStart(builderState, value);
        break;
    case CSSPropertyGridTemplate:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyGridTemplateAreas:
        if (isInitial)
            BuilderCustom::applyInitialGridTemplateAreas(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritGridTemplateAreas(builderState);
        else
            BuilderCustom::applyValueGridTemplateAreas(builderState, value);
        break;
    case CSSPropertyGridTemplateColumns:
        if (isInitial)
            BuilderCustom::applyInitialGridTemplateColumns(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritGridTemplateColumns(builderState);
        else
            BuilderCustom::applyValueGridTemplateColumns(builderState, value);
        break;
    case CSSPropertyGridTemplateRows:
        if (isInitial)
            BuilderCustom::applyInitialGridTemplateRows(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritGridTemplateRows(builderState);
        else
            BuilderCustom::applyValueGridTemplateRows(builderState, value);
        break;
    case CSSPropertyHangingPunctuation:
        if (isInitial)
            BuilderFunctions::applyInitialHangingPunctuation(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritHangingPunctuation(builderState);
        else
            BuilderFunctions::applyValueHangingPunctuation(builderState, value);
        break;
    case CSSPropertyHeight:
        if (isInitial)
            BuilderFunctions::applyInitialHeight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritHeight(builderState);
        else
            BuilderFunctions::applyValueHeight(builderState, value);
        break;
    case CSSPropertyImageOrientation:
        if (isInitial)
            BuilderFunctions::applyInitialImageOrientation(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritImageOrientation(builderState);
        else
            BuilderFunctions::applyValueImageOrientation(builderState, value);
        break;
    case CSSPropertyImageRendering:
        if (isInitial)
            BuilderFunctions::applyInitialImageRendering(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritImageRendering(builderState);
        else
            BuilderFunctions::applyValueImageRendering(builderState, value);
        break;
    case CSSPropertyInlineSize:
        break;
    case CSSPropertyInset:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyInsetBlock:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyInsetBlockEnd:
        break;
    case CSSPropertyInsetBlockStart:
        break;
    case CSSPropertyInsetInline:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyInsetInlineEnd:
        break;
    case CSSPropertyInsetInlineStart:
        break;
    case CSSPropertyIsolation:
        if (isInitial)
            BuilderFunctions::applyInitialIsolation(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritIsolation(builderState);
        else
            BuilderFunctions::applyValueIsolation(builderState, value);
        break;
    case CSSPropertyJustifyContent:
        if (isInitial)
            BuilderFunctions::applyInitialJustifyContent(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritJustifyContent(builderState);
        else
            BuilderFunctions::applyValueJustifyContent(builderState, value);
        break;
    case CSSPropertyJustifyItems:
        if (isInitial)
            BuilderFunctions::applyInitialJustifyItems(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritJustifyItems(builderState);
        else
            BuilderFunctions::applyValueJustifyItems(builderState, value);
        break;
    case CSSPropertyJustifySelf:
        if (isInitial)
            BuilderFunctions::applyInitialJustifySelf(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritJustifySelf(builderState);
        else
            BuilderFunctions::applyValueJustifySelf(builderState, value);
        break;
    case CSSPropertyKerning:
        if (isInitial)
            BuilderFunctions::applyInitialKerning(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritKerning(builderState);
        else
            BuilderFunctions::applyValueKerning(builderState, value);
        break;
    case CSSPropertyLeft:
        if (isInitial)
            BuilderFunctions::applyInitialLeft(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritLeft(builderState);
        else
            BuilderFunctions::applyValueLeft(builderState, value);
        break;
    case CSSPropertyLetterSpacing:
        if (isInitial)
            BuilderFunctions::applyInitialLetterSpacing(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritLetterSpacing(builderState);
        else
            BuilderFunctions::applyValueLetterSpacing(builderState, value);
        break;
    case CSSPropertyLightingColor:
        if (isInitial)
            BuilderFunctions::applyInitialLightingColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritLightingColor(builderState);
        else
            BuilderFunctions::applyValueLightingColor(builderState, value);
        break;
    case CSSPropertyLineBreak:
        if (isInitial)
            BuilderFunctions::applyInitialLineBreak(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritLineBreak(builderState);
        else
            BuilderFunctions::applyValueLineBreak(builderState, value);
        break;
    case CSSPropertyLineHeight:
        if (isInitial)
            BuilderFunctions::applyInitialLineHeight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritLineHeight(builderState);
        else
            BuilderFunctions::applyValueLineHeight(builderState, value);
        break;
    case CSSPropertyListStyle:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyListStyleImage:
        if (isInitial)
            BuilderFunctions::applyInitialListStyleImage(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritListStyleImage(builderState);
        else
            BuilderFunctions::applyValueListStyleImage(builderState, value);
        break;
    case CSSPropertyListStylePosition:
        if (isInitial)
            BuilderFunctions::applyInitialListStylePosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritListStylePosition(builderState);
        else
            BuilderFunctions::applyValueListStylePosition(builderState, value);
        break;
    case CSSPropertyListStyleType:
        if (isInitial)
            BuilderFunctions::applyInitialListStyleType(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritListStyleType(builderState);
        else
            BuilderFunctions::applyValueListStyleType(builderState, value);
        break;
    case CSSPropertyMargin:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyMarginBlock:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyMarginBlockEnd:
        break;
    case CSSPropertyMarginBlockStart:
        break;
    case CSSPropertyMarginBottom:
        if (isInitial)
            BuilderFunctions::applyInitialMarginBottom(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarginBottom(builderState);
        else
            BuilderFunctions::applyValueMarginBottom(builderState, value);
        break;
    case CSSPropertyMarginInline:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyMarginInlineEnd:
        break;
    case CSSPropertyMarginInlineStart:
        break;
    case CSSPropertyMarginLeft:
        if (isInitial)
            BuilderFunctions::applyInitialMarginLeft(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarginLeft(builderState);
        else
            BuilderFunctions::applyValueMarginLeft(builderState, value);
        break;
    case CSSPropertyMarginRight:
        if (isInitial)
            BuilderFunctions::applyInitialMarginRight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarginRight(builderState);
        else
            BuilderFunctions::applyValueMarginRight(builderState, value);
        break;
    case CSSPropertyMarginTop:
        if (isInitial)
            BuilderFunctions::applyInitialMarginTop(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarginTop(builderState);
        else
            BuilderFunctions::applyValueMarginTop(builderState, value);
        break;
    case CSSPropertyMarker:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyMarkerEnd:
        if (isInitial)
            BuilderFunctions::applyInitialMarkerEnd(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarkerEnd(builderState);
        else
            BuilderFunctions::applyValueMarkerEnd(builderState, value);
        break;
    case CSSPropertyMarkerMid:
        if (isInitial)
            BuilderFunctions::applyInitialMarkerMid(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarkerMid(builderState);
        else
            BuilderFunctions::applyValueMarkerMid(builderState, value);
        break;
    case CSSPropertyMarkerStart:
        if (isInitial)
            BuilderFunctions::applyInitialMarkerStart(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarkerStart(builderState);
        else
            BuilderFunctions::applyValueMarkerStart(builderState, value);
        break;
    case CSSPropertyMask:
        if (isInitial)
            BuilderFunctions::applyInitialMask(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMask(builderState);
        else
            BuilderFunctions::applyValueMask(builderState, value);
        break;
    case CSSPropertyMaskType:
        if (isInitial)
            BuilderFunctions::applyInitialMaskType(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaskType(builderState);
        else
            BuilderFunctions::applyValueMaskType(builderState, value);
        break;
    case CSSPropertyMaxBlockSize:
        break;
    case CSSPropertyMaxHeight:
        if (isInitial)
            BuilderFunctions::applyInitialMaxHeight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaxHeight(builderState);
        else
            BuilderFunctions::applyValueMaxHeight(builderState, value);
        break;
    case CSSPropertyMaxInlineSize:
        break;
    case CSSPropertyMaxWidth:
        if (isInitial)
            BuilderFunctions::applyInitialMaxWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaxWidth(builderState);
        else
            BuilderFunctions::applyValueMaxWidth(builderState, value);
        break;
    case CSSPropertyMinBlockSize:
        break;
    case CSSPropertyMinHeight:
        if (isInitial)
            BuilderFunctions::applyInitialMinHeight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMinHeight(builderState);
        else
            BuilderFunctions::applyValueMinHeight(builderState, value);
        break;
    case CSSPropertyMinInlineSize:
        break;
    case CSSPropertyMinWidth:
        if (isInitial)
            BuilderFunctions::applyInitialMinWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMinWidth(builderState);
        else
            BuilderFunctions::applyValueMinWidth(builderState, value);
        break;
    case CSSPropertyMixBlendMode:
        if (isInitial)
            BuilderFunctions::applyInitialMixBlendMode(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMixBlendMode(builderState);
        else
            BuilderFunctions::applyValueMixBlendMode(builderState, value);
        break;
    case CSSPropertyObjectFit:
        if (isInitial)
            BuilderFunctions::applyInitialObjectFit(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritObjectFit(builderState);
        else
            BuilderFunctions::applyValueObjectFit(builderState, value);
        break;
    case CSSPropertyObjectPosition:
        if (isInitial)
            BuilderFunctions::applyInitialObjectPosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritObjectPosition(builderState);
        else
            BuilderFunctions::applyValueObjectPosition(builderState, value);
        break;
    case CSSPropertyOpacity:
        if (isInitial)
            BuilderFunctions::applyInitialOpacity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOpacity(builderState);
        else
            BuilderFunctions::applyValueOpacity(builderState, value);
        break;
    case CSSPropertyOrder:
        if (isInitial)
            BuilderFunctions::applyInitialOrder(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOrder(builderState);
        else
            BuilderFunctions::applyValueOrder(builderState, value);
        break;
    case CSSPropertyOrphans:
        if (isInitial)
            BuilderFunctions::applyInitialOrphans(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOrphans(builderState);
        else
            BuilderFunctions::applyValueOrphans(builderState, value);
        break;
    case CSSPropertyOutline:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyOutlineColor:
        if (isInitial)
            BuilderFunctions::applyInitialOutlineColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOutlineColor(builderState);
        else
            BuilderFunctions::applyValueOutlineColor(builderState, value);
        break;
    case CSSPropertyOutlineOffset:
        if (isInitial)
            BuilderFunctions::applyInitialOutlineOffset(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOutlineOffset(builderState);
        else
            BuilderFunctions::applyValueOutlineOffset(builderState, value);
        break;
    case CSSPropertyOutlineStyle:
        if (isInitial)
            BuilderCustom::applyInitialOutlineStyle(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritOutlineStyle(builderState);
        else
            BuilderCustom::applyValueOutlineStyle(builderState, value);
        break;
    case CSSPropertyOutlineWidth:
        if (isInitial)
            BuilderFunctions::applyInitialOutlineWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOutlineWidth(builderState);
        else
            BuilderFunctions::applyValueOutlineWidth(builderState, value);
        break;
    case CSSPropertyOverflow:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyOverflowWrap:
        if (isInitial)
            BuilderFunctions::applyInitialOverflowWrap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOverflowWrap(builderState);
        else
            BuilderFunctions::applyValueOverflowWrap(builderState, value);
        break;
    case CSSPropertyOverflowX:
        if (isInitial)
            BuilderFunctions::applyInitialOverflowX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOverflowX(builderState);
        else
            BuilderFunctions::applyValueOverflowX(builderState, value);
        break;
    case CSSPropertyOverflowY:
        if (isInitial)
            BuilderFunctions::applyInitialOverflowY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOverflowY(builderState);
        else
            BuilderFunctions::applyValueOverflowY(builderState, value);
        break;
    case CSSPropertyPadding:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyPaddingBlock:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyPaddingBlockEnd:
        break;
    case CSSPropertyPaddingBlockStart:
        break;
    case CSSPropertyPaddingBottom:
        if (isInitial)
            BuilderFunctions::applyInitialPaddingBottom(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPaddingBottom(builderState);
        else
            BuilderFunctions::applyValuePaddingBottom(builderState, value);
        break;
    case CSSPropertyPaddingInline:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyPaddingInlineEnd:
        break;
    case CSSPropertyPaddingInlineStart:
        break;
    case CSSPropertyPaddingLeft:
        if (isInitial)
            BuilderFunctions::applyInitialPaddingLeft(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPaddingLeft(builderState);
        else
            BuilderFunctions::applyValuePaddingLeft(builderState, value);
        break;
    case CSSPropertyPaddingRight:
        if (isInitial)
            BuilderFunctions::applyInitialPaddingRight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPaddingRight(builderState);
        else
            BuilderFunctions::applyValuePaddingRight(builderState, value);
        break;
    case CSSPropertyPaddingTop:
        if (isInitial)
            BuilderFunctions::applyInitialPaddingTop(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPaddingTop(builderState);
        else
            BuilderFunctions::applyValuePaddingTop(builderState, value);
        break;
    case CSSPropertyPage:
        break;
    case CSSPropertyPageBreakAfter:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyPageBreakBefore:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyPageBreakInside:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyPaintOrder:
        if (isInitial)
            BuilderFunctions::applyInitialPaintOrder(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPaintOrder(builderState);
        else
            BuilderFunctions::applyValuePaintOrder(builderState, value);
        break;
    case CSSPropertyPerspective:
        if (isInitial)
            BuilderFunctions::applyInitialPerspective(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPerspective(builderState);
        else
            BuilderFunctions::applyValuePerspective(builderState, value);
        break;
    case CSSPropertyPerspectiveOrigin:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyPerspectiveOriginX:
        if (isInitial)
            BuilderFunctions::applyInitialPerspectiveOriginX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPerspectiveOriginX(builderState);
        else
            BuilderFunctions::applyValuePerspectiveOriginX(builderState, value);
        break;
    case CSSPropertyPerspectiveOriginY:
        if (isInitial)
            BuilderFunctions::applyInitialPerspectiveOriginY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPerspectiveOriginY(builderState);
        else
            BuilderFunctions::applyValuePerspectiveOriginY(builderState, value);
        break;
    case CSSPropertyPlaceContent:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyPlaceItems:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyPlaceSelf:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyPointerEvents:
        if (isInitial)
            BuilderFunctions::applyInitialPointerEvents(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPointerEvents(builderState);
        else
            BuilderFunctions::applyValuePointerEvents(builderState, value);
        break;
    case CSSPropertyPosition:
        if (isInitial)
            BuilderFunctions::applyInitialPosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPosition(builderState);
        else
            BuilderFunctions::applyValuePosition(builderState, value);
        break;
    case CSSPropertyQuotes:
        if (isInitial)
            BuilderFunctions::applyInitialQuotes(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritQuotes(builderState);
        else
            BuilderFunctions::applyValueQuotes(builderState, value);
        break;
    case CSSPropertyR:
        if (isInitial)
            BuilderFunctions::applyInitialR(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritR(builderState);
        else
            BuilderFunctions::applyValueR(builderState, value);
        break;
    case CSSPropertyResize:
        if (isInitial)
            BuilderFunctions::applyInitialResize(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritResize(builderState);
        else
            BuilderFunctions::applyValueResize(builderState, value);
        break;
    case CSSPropertyRight:
        if (isInitial)
            BuilderFunctions::applyInitialRight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritRight(builderState);
        else
            BuilderFunctions::applyValueRight(builderState, value);
        break;
    case CSSPropertyRowGap:
        if (isInitial)
            BuilderFunctions::applyInitialRowGap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritRowGap(builderState);
        else
            BuilderFunctions::applyValueRowGap(builderState, value);
        break;
    case CSSPropertyRx:
        if (isInitial)
            BuilderFunctions::applyInitialRx(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritRx(builderState);
        else
            BuilderFunctions::applyValueRx(builderState, value);
        break;
    case CSSPropertyRy:
        if (isInitial)
            BuilderFunctions::applyInitialRy(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritRy(builderState);
        else
            BuilderFunctions::applyValueRy(builderState, value);
        break;
    case CSSPropertyScrollBehavior:
        if (isInitial)
            BuilderFunctions::applyInitialScrollBehavior(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollBehavior(builderState);
        else
            BuilderFunctions::applyValueScrollBehavior(builderState, value);
        break;
    case CSSPropertyShapeImageThreshold:
        if (isInitial)
            BuilderFunctions::applyInitialShapeImageThreshold(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritShapeImageThreshold(builderState);
        else
            BuilderFunctions::applyValueShapeImageThreshold(builderState, value);
        break;
    case CSSPropertyShapeMargin:
        if (isInitial)
            BuilderFunctions::applyInitialShapeMargin(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritShapeMargin(builderState);
        else
            BuilderFunctions::applyValueShapeMargin(builderState, value);
        break;
    case CSSPropertyShapeOutside:
        if (isInitial)
            BuilderFunctions::applyInitialShapeOutside(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritShapeOutside(builderState);
        else
            BuilderFunctions::applyValueShapeOutside(builderState, value);
        break;
    case CSSPropertyShapeRendering:
        if (isInitial)
            BuilderFunctions::applyInitialShapeRendering(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritShapeRendering(builderState);
        else
            BuilderFunctions::applyValueShapeRendering(builderState, value);
        break;
    case CSSPropertySize:
        if (isInitial)
            BuilderCustom::applyInitialSize(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritSize(builderState);
        else
            BuilderCustom::applyValueSize(builderState, value);
        break;
    case CSSPropertySpeakAs:
        if (isInitial)
            BuilderFunctions::applyInitialSpeakAs(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritSpeakAs(builderState);
        else
            BuilderFunctions::applyValueSpeakAs(builderState, value);
        break;
    case CSSPropertySrc:
        break;
    case CSSPropertyStopColor:
        if (isInitial)
            BuilderFunctions::applyInitialStopColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStopColor(builderState);
        else
            BuilderFunctions::applyValueStopColor(builderState, value);
        break;
    case CSSPropertyStopOpacity:
        if (isInitial)
            BuilderFunctions::applyInitialStopOpacity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStopOpacity(builderState);
        else
            BuilderFunctions::applyValueStopOpacity(builderState, value);
        break;
    case CSSPropertyStroke:
        if (isInitial)
            BuilderCustom::applyInitialStroke(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritStroke(builderState);
        else
            BuilderCustom::applyValueStroke(builderState, value);
        break;
    case CSSPropertyStrokeColor:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeColor(builderState);
        else
            BuilderCustom::applyValueStrokeColor(builderState, value);
        break;
    case CSSPropertyStrokeDasharray:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeDasharray(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeDasharray(builderState);
        else
            BuilderFunctions::applyValueStrokeDasharray(builderState, value);
        break;
    case CSSPropertyStrokeDashoffset:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeDashoffset(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeDashoffset(builderState);
        else
            BuilderFunctions::applyValueStrokeDashoffset(builderState, value);
        break;
    case CSSPropertyStrokeLinecap:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeLinecap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeLinecap(builderState);
        else
            BuilderFunctions::applyValueStrokeLinecap(builderState, value);
        break;
    case CSSPropertyStrokeLinejoin:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeLinejoin(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeLinejoin(builderState);
        else
            BuilderFunctions::applyValueStrokeLinejoin(builderState, value);
        break;
    case CSSPropertyStrokeMiterlimit:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeMiterlimit(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeMiterlimit(builderState);
        else
            BuilderFunctions::applyValueStrokeMiterlimit(builderState, value);
        break;
    case CSSPropertyStrokeOpacity:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeOpacity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeOpacity(builderState);
        else
            BuilderFunctions::applyValueStrokeOpacity(builderState, value);
        break;
    case CSSPropertyStrokeWidth:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeWidth(builderState);
        else
            BuilderCustom::applyValueStrokeWidth(builderState, value);
        break;
    case CSSPropertyTabSize:
        if (isInitial)
            BuilderFunctions::applyInitialTabSize(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTabSize(builderState);
        else
            BuilderFunctions::applyValueTabSize(builderState, value);
        break;
    case CSSPropertyTableLayout:
        if (isInitial)
            BuilderFunctions::applyInitialTableLayout(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTableLayout(builderState);
        else
            BuilderFunctions::applyValueTableLayout(builderState, value);
        break;
    case CSSPropertyTextAlign:
        if (isInitial)
            BuilderCustom::applyInitialTextAlign(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextAlign(builderState);
        else
            BuilderCustom::applyValueTextAlign(builderState, value);
        break;
    case CSSPropertyTextAnchor:
        if (isInitial)
            BuilderFunctions::applyInitialTextAnchor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextAnchor(builderState);
        else
            BuilderFunctions::applyValueTextAnchor(builderState, value);
        break;
    case CSSPropertyTextDecoration:
        if (isInitial)
            BuilderFunctions::applyInitialTextDecoration(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextDecoration(builderState);
        else
            BuilderFunctions::applyValueTextDecoration(builderState, value);
        break;
    case CSSPropertyTextDecorationColor:
        if (isInitial)
            BuilderFunctions::applyInitialTextDecorationColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextDecorationColor(builderState);
        else
            BuilderFunctions::applyValueTextDecorationColor(builderState, value);
        break;
    case CSSPropertyTextDecorationLine:
        if (isInitial)
            BuilderFunctions::applyInitialTextDecorationLine(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextDecorationLine(builderState);
        else
            BuilderFunctions::applyValueTextDecorationLine(builderState, value);
        break;
    case CSSPropertyTextDecorationSkip:
        if (isInitial)
            BuilderFunctions::applyInitialTextDecorationSkip(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextDecorationSkip(builderState);
        else
            BuilderFunctions::applyValueTextDecorationSkip(builderState, value);
        break;
    case CSSPropertyTextDecorationStyle:
        if (isInitial)
            BuilderFunctions::applyInitialTextDecorationStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextDecorationStyle(builderState);
        else
            BuilderFunctions::applyValueTextDecorationStyle(builderState, value);
        break;
    case CSSPropertyTextDecorationThickness:
        if (isInitial)
            BuilderFunctions::applyInitialTextDecorationThickness(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextDecorationThickness(builderState);
        else
            BuilderFunctions::applyValueTextDecorationThickness(builderState, value);
        break;
    case CSSPropertyTextIndent:
        if (isInitial)
            BuilderCustom::applyInitialTextIndent(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritTextIndent(builderState);
        else
            BuilderCustom::applyValueTextIndent(builderState, value);
        break;
    case CSSPropertyTextOverflow:
        if (isInitial)
            BuilderFunctions::applyInitialTextOverflow(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextOverflow(builderState);
        else
            BuilderFunctions::applyValueTextOverflow(builderState, value);
        break;
    case CSSPropertyTextShadow:
        if (isInitial)
            BuilderCustom::applyInitialTextShadow(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritTextShadow(builderState);
        else
            BuilderCustom::applyValueTextShadow(builderState, value);
        break;
    case CSSPropertyTextTransform:
        if (isInitial)
            BuilderFunctions::applyInitialTextTransform(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextTransform(builderState);
        else
            BuilderFunctions::applyValueTextTransform(builderState, value);
        break;
    case CSSPropertyTextUnderlineOffset:
        if (isInitial)
            BuilderFunctions::applyInitialTextUnderlineOffset(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextUnderlineOffset(builderState);
        else
            BuilderFunctions::applyValueTextUnderlineOffset(builderState, value);
        break;
    case CSSPropertyTextUnderlinePosition:
        if (isInitial)
            BuilderFunctions::applyInitialTextUnderlinePosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextUnderlinePosition(builderState);
        else
            BuilderFunctions::applyValueTextUnderlinePosition(builderState, value);
        break;
    case CSSPropertyTop:
        if (isInitial)
            BuilderFunctions::applyInitialTop(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTop(builderState);
        else
            BuilderFunctions::applyValueTop(builderState, value);
        break;
    case CSSPropertyTransform:
        if (isInitial)
            BuilderFunctions::applyInitialTransform(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransform(builderState);
        else
            BuilderFunctions::applyValueTransform(builderState, value);
        break;
    case CSSPropertyTransformBox:
        if (isInitial)
            BuilderFunctions::applyInitialTransformBox(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransformBox(builderState);
        else
            BuilderFunctions::applyValueTransformBox(builderState, value);
        break;
    case CSSPropertyTransformOrigin:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyTransformOriginX:
        if (isInitial)
            BuilderFunctions::applyInitialTransformOriginX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransformOriginX(builderState);
        else
            BuilderFunctions::applyValueTransformOriginX(builderState, value);
        break;
    case CSSPropertyTransformOriginY:
        if (isInitial)
            BuilderFunctions::applyInitialTransformOriginY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransformOriginY(builderState);
        else
            BuilderFunctions::applyValueTransformOriginY(builderState, value);
        break;
    case CSSPropertyTransformOriginZ:
        if (isInitial)
            BuilderFunctions::applyInitialTransformOriginZ(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransformOriginZ(builderState);
        else
            BuilderFunctions::applyValueTransformOriginZ(builderState, value);
        break;
    case CSSPropertyTransformStyle:
        if (isInitial)
            BuilderFunctions::applyInitialTransformStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransformStyle(builderState);
        else
            BuilderFunctions::applyValueTransformStyle(builderState, value);
        break;
    case CSSPropertyTransition:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyTransitionDelay:
        if (isInitial)
            BuilderFunctions::applyInitialTransitionDelay(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransitionDelay(builderState);
        else
            BuilderFunctions::applyValueTransitionDelay(builderState, value);
        break;
    case CSSPropertyTransitionDuration:
        if (isInitial)
            BuilderFunctions::applyInitialTransitionDuration(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransitionDuration(builderState);
        else
            BuilderFunctions::applyValueTransitionDuration(builderState, value);
        break;
    case CSSPropertyTransitionProperty:
        if (isInitial)
            BuilderFunctions::applyInitialTransitionProperty(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransitionProperty(builderState);
        else
            BuilderFunctions::applyValueTransitionProperty(builderState, value);
        break;
    case CSSPropertyTransitionTimingFunction:
        if (isInitial)
            BuilderFunctions::applyInitialTransitionTimingFunction(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransitionTimingFunction(builderState);
        else
            BuilderFunctions::applyValueTransitionTimingFunction(builderState, value);
        break;
    case CSSPropertyUnicodeBidi:
        if (isInitial)
            BuilderFunctions::applyInitialUnicodeBidi(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritUnicodeBidi(builderState);
        else
            BuilderFunctions::applyValueUnicodeBidi(builderState, value);
        break;
    case CSSPropertyUnicodeRange:
        break;
    case CSSPropertyVectorEffect:
        if (isInitial)
            BuilderFunctions::applyInitialVectorEffect(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritVectorEffect(builderState);
        else
            BuilderFunctions::applyValueVectorEffect(builderState, value);
        break;
    case CSSPropertyVerticalAlign:
        if (isInitial)
            BuilderFunctions::applyInitialVerticalAlign(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritVerticalAlign(builderState);
        else
            BuilderCustom::applyValueVerticalAlign(builderState, value);
        break;
    case CSSPropertyVisibility:
        if (isInitial)
            BuilderFunctions::applyInitialVisibility(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritVisibility(builderState);
        else
            BuilderFunctions::applyValueVisibility(builderState, value);
        break;
    case CSSPropertyWhiteSpace:
        if (isInitial)
            BuilderFunctions::applyInitialWhiteSpace(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWhiteSpace(builderState);
        else
            BuilderFunctions::applyValueWhiteSpace(builderState, value);
        break;
    case CSSPropertyWidows:
        if (isInitial)
            BuilderFunctions::applyInitialWidows(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWidows(builderState);
        else
            BuilderFunctions::applyValueWidows(builderState, value);
        break;
    case CSSPropertyWidth:
        if (isInitial)
            BuilderFunctions::applyInitialWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWidth(builderState);
        else
            BuilderFunctions::applyValueWidth(builderState, value);
        break;
    case CSSPropertyWillChange:
        if (isInitial)
            BuilderFunctions::applyInitialWillChange(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWillChange(builderState);
        else
            BuilderCustom::applyValueWillChange(builderState, value);
        break;
    case CSSPropertyWordBreak:
        if (isInitial)
            BuilderFunctions::applyInitialWordBreak(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWordBreak(builderState);
        else
            BuilderFunctions::applyValueWordBreak(builderState, value);
        break;
    case CSSPropertyWordSpacing:
        if (isInitial)
            BuilderFunctions::applyInitialWordSpacing(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWordSpacing(builderState);
        else
            BuilderFunctions::applyValueWordSpacing(builderState, value);
        break;
    case CSSPropertyWordWrap:
        if (isInitial)
            BuilderFunctions::applyInitialWordWrap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWordWrap(builderState);
        else
            BuilderFunctions::applyValueWordWrap(builderState, value);
        break;
    case CSSPropertyX:
        if (isInitial)
            BuilderFunctions::applyInitialX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritX(builderState);
        else
            BuilderFunctions::applyValueX(builderState, value);
        break;
    case CSSPropertyY:
        if (isInitial)
            BuilderFunctions::applyInitialY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritY(builderState);
        else
            BuilderFunctions::applyValueY(builderState, value);
        break;
    case CSSPropertyZIndex:
        if (isInitial)
            BuilderFunctions::applyInitialZIndex(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritZIndex(builderState);
        else
            BuilderFunctions::applyValueZIndex(builderState, value);
        break;
    case CSSPropertyAppleColorFilter:
        if (isInitial)
            BuilderFunctions::applyInitialAppleColorFilter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAppleColorFilter(builderState);
        else
            BuilderFunctions::applyValueAppleColorFilter(builderState, value);
        break;
    case CSSPropertyWebkitAppearance:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitAppearance(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitAppearance(builderState);
        else
            BuilderFunctions::applyValueWebkitAppearance(builderState, value);
        break;
    case CSSPropertyWebkitAspectRatio:
        if (isInitial)
            BuilderCustom::applyInitialWebkitAspectRatio(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritWebkitAspectRatio(builderState);
        else
            BuilderCustom::applyValueWebkitAspectRatio(builderState, value);
        break;
    case CSSPropertyWebkitBackdropFilter:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBackdropFilter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBackdropFilter(builderState);
        else
            BuilderFunctions::applyValueWebkitBackdropFilter(builderState, value);
        break;
    case CSSPropertyWebkitBackfaceVisibility:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBackfaceVisibility(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBackfaceVisibility(builderState);
        else
            BuilderFunctions::applyValueWebkitBackfaceVisibility(builderState, value);
        break;
    case CSSPropertyWebkitBackgroundClip:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBackgroundClip(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBackgroundClip(builderState);
        else
            BuilderFunctions::applyValueWebkitBackgroundClip(builderState, value);
        break;
    case CSSPropertyWebkitBackgroundComposite:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBackgroundComposite(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBackgroundComposite(builderState);
        else
            BuilderFunctions::applyValueWebkitBackgroundComposite(builderState, value);
        break;
    case CSSPropertyWebkitBackgroundOrigin:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBackgroundOrigin(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBackgroundOrigin(builderState);
        else
            BuilderFunctions::applyValueWebkitBackgroundOrigin(builderState, value);
        break;
    case CSSPropertyWebkitBackgroundSize:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBackgroundSize(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBackgroundSize(builderState);
        else
            BuilderFunctions::applyValueWebkitBackgroundSize(builderState, value);
        break;
    case CSSPropertyWebkitBorderFit:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBorderFit(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBorderFit(builderState);
        else
            BuilderFunctions::applyValueWebkitBorderFit(builderState, value);
        break;
    case CSSPropertyWebkitBorderHorizontalSpacing:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBorderHorizontalSpacing(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBorderHorizontalSpacing(builderState);
        else
            BuilderFunctions::applyValueWebkitBorderHorizontalSpacing(builderState, value);
        break;
    case CSSPropertyWebkitBorderImage:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBorderImage(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBorderImage(builderState);
        else
            BuilderFunctions::applyValueWebkitBorderImage(builderState, value);
        break;
    case CSSPropertyWebkitBorderRadius:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitBorderVerticalSpacing:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBorderVerticalSpacing(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBorderVerticalSpacing(builderState);
        else
            BuilderFunctions::applyValueWebkitBorderVerticalSpacing(builderState, value);
        break;
    case CSSPropertyWebkitBoxAlign:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxAlign(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxAlign(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxAlign(builderState, value);
        break;
    case CSSPropertyWebkitBoxDecorationBreak:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxDecorationBreak(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxDecorationBreak(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxDecorationBreak(builderState, value);
        break;
    case CSSPropertyWebkitBoxDirection:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxDirection(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxDirection(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxDirection(builderState, value);
        break;
    case CSSPropertyWebkitBoxFlex:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxFlex(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxFlex(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxFlex(builderState, value);
        break;
    case CSSPropertyWebkitBoxFlexGroup:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxFlexGroup(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxFlexGroup(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxFlexGroup(builderState, value);
        break;
    case CSSPropertyWebkitBoxLines:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxLines(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxLines(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxLines(builderState, value);
        break;
    case CSSPropertyWebkitBoxOrdinalGroup:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxOrdinalGroup(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxOrdinalGroup(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxOrdinalGroup(builderState, value);
        break;
    case CSSPropertyWebkitBoxOrient:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxOrient(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxOrient(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxOrient(builderState, value);
        break;
    case CSSPropertyWebkitBoxPack:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxPack(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxPack(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxPack(builderState, value);
        break;
    case CSSPropertyWebkitBoxReflect:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxReflect(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxReflect(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxReflect(builderState, value);
        break;
    case CSSPropertyWebkitBoxShadow:
        if (isInitial)
            BuilderCustom::applyInitialWebkitBoxShadow(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritWebkitBoxShadow(builderState);
        else
            BuilderCustom::applyValueWebkitBoxShadow(builderState, value);
        break;
    case CSSPropertyWebkitColumnAxis:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitColumnAxis(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitColumnAxis(builderState);
        else
            BuilderFunctions::applyValueWebkitColumnAxis(builderState, value);
        break;
    case CSSPropertyWebkitColumnBreakAfter:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitColumnBreakBefore:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitColumnBreakInside:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitColumnProgression:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitColumnProgression(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitColumnProgression(builderState);
        else
            BuilderFunctions::applyValueWebkitColumnProgression(builderState, value);
        break;
    case CSSPropertyWebkitCursorVisibility:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitCursorVisibility(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitCursorVisibility(builderState);
        else
            BuilderFunctions::applyValueWebkitCursorVisibility(builderState, value);
        break;
    case CSSPropertyWebkitFontSizeDelta:
        break;
    case CSSPropertyWebkitHyphenateCharacter:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitHyphenateCharacter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitHyphenateCharacter(builderState);
        else
            BuilderFunctions::applyValueWebkitHyphenateCharacter(builderState, value);
        break;
    case CSSPropertyWebkitHyphenateLimitAfter:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitHyphenateLimitAfter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitHyphenateLimitAfter(builderState);
        else
            BuilderFunctions::applyValueWebkitHyphenateLimitAfter(builderState, value);
        break;
    case CSSPropertyWebkitHyphenateLimitBefore:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitHyphenateLimitBefore(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitHyphenateLimitBefore(builderState);
        else
            BuilderFunctions::applyValueWebkitHyphenateLimitBefore(builderState, value);
        break;
    case CSSPropertyWebkitHyphenateLimitLines:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitHyphenateLimitLines(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitHyphenateLimitLines(builderState);
        else
            BuilderFunctions::applyValueWebkitHyphenateLimitLines(builderState, value);
        break;
    case CSSPropertyWebkitHyphens:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitHyphens(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitHyphens(builderState);
        else
            BuilderFunctions::applyValueWebkitHyphens(builderState, value);
        break;
    case CSSPropertyWebkitInitialLetter:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitInitialLetter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitInitialLetter(builderState);
        else
            BuilderFunctions::applyValueWebkitInitialLetter(builderState, value);
        break;
    case CSSPropertyWebkitLineAlign:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitLineAlign(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitLineAlign(builderState);
        else
            BuilderFunctions::applyValueWebkitLineAlign(builderState, value);
        break;
    case CSSPropertyWebkitLineBoxContain:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitLineBoxContain(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitLineBoxContain(builderState);
        else
            BuilderFunctions::applyValueWebkitLineBoxContain(builderState, value);
        break;
    case CSSPropertyWebkitLineClamp:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitLineClamp(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitLineClamp(builderState);
        else
            BuilderFunctions::applyValueWebkitLineClamp(builderState, value);
        break;
    case CSSPropertyWebkitLineGrid:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitLineGrid(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitLineGrid(builderState);
        else
            BuilderFunctions::applyValueWebkitLineGrid(builderState, value);
        break;
    case CSSPropertyWebkitLineSnap:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitLineSnap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitLineSnap(builderState);
        else
            BuilderFunctions::applyValueWebkitLineSnap(builderState, value);
        break;
    case CSSPropertyWebkitMarginAfterCollapse:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarginAfterCollapse(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarginAfterCollapse(builderState);
        else
            BuilderFunctions::applyValueWebkitMarginAfterCollapse(builderState, value);
        break;
    case CSSPropertyWebkitMarginBeforeCollapse:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarginBeforeCollapse(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarginBeforeCollapse(builderState);
        else
            BuilderFunctions::applyValueWebkitMarginBeforeCollapse(builderState, value);
        break;
    case CSSPropertyWebkitMarginBottomCollapse:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarginBottomCollapse(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarginBottomCollapse(builderState);
        else
            BuilderFunctions::applyValueWebkitMarginBottomCollapse(builderState, value);
        break;
    case CSSPropertyWebkitMarginCollapse:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitMarginTopCollapse:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarginTopCollapse(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarginTopCollapse(builderState);
        else
            BuilderFunctions::applyValueWebkitMarginTopCollapse(builderState, value);
        break;
    case CSSPropertyWebkitMarqueeDirection:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarqueeDirection(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarqueeDirection(builderState);
        else
            BuilderFunctions::applyValueWebkitMarqueeDirection(builderState, value);
        break;
    case CSSPropertyWebkitMarqueeIncrement:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarqueeIncrement(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarqueeIncrement(builderState);
        else
            BuilderFunctions::applyValueWebkitMarqueeIncrement(builderState, value);
        break;
    case CSSPropertyWebkitMarqueeRepetition:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarqueeRepetition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarqueeRepetition(builderState);
        else
            BuilderFunctions::applyValueWebkitMarqueeRepetition(builderState, value);
        break;
    case CSSPropertyWebkitMarqueeSpeed:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarqueeSpeed(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarqueeSpeed(builderState);
        else
            BuilderFunctions::applyValueWebkitMarqueeSpeed(builderState, value);
        break;
    case CSSPropertyWebkitMarqueeStyle:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarqueeStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarqueeStyle(builderState);
        else
            BuilderFunctions::applyValueWebkitMarqueeStyle(builderState, value);
        break;
    case CSSPropertyWebkitMask:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitMaskBoxImage:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskBoxImage(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskBoxImage(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskBoxImage(builderState, value);
        break;
    case CSSPropertyWebkitMaskBoxImageOutset:
        if (isInitial)
            BuilderCustom::applyInitialWebkitMaskBoxImageOutset(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritWebkitMaskBoxImageOutset(builderState);
        else
            BuilderCustom::applyValueWebkitMaskBoxImageOutset(builderState, value);
        break;
    case CSSPropertyWebkitMaskBoxImageRepeat:
        if (isInitial)
            BuilderCustom::applyInitialWebkitMaskBoxImageRepeat(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritWebkitMaskBoxImageRepeat(builderState);
        else
            BuilderCustom::applyValueWebkitMaskBoxImageRepeat(builderState, value);
        break;
    case CSSPropertyWebkitMaskBoxImageSlice:
        if (isInitial)
            BuilderCustom::applyInitialWebkitMaskBoxImageSlice(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritWebkitMaskBoxImageSlice(builderState);
        else
            BuilderCustom::applyValueWebkitMaskBoxImageSlice(builderState, value);
        break;
    case CSSPropertyWebkitMaskBoxImageSource:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskBoxImageSource(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskBoxImageSource(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskBoxImageSource(builderState, value);
        break;
    case CSSPropertyWebkitMaskBoxImageWidth:
        if (isInitial)
            BuilderCustom::applyInitialWebkitMaskBoxImageWidth(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritWebkitMaskBoxImageWidth(builderState);
        else
            BuilderCustom::applyValueWebkitMaskBoxImageWidth(builderState, value);
        break;
    case CSSPropertyWebkitMaskClip:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskClip(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskClip(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskClip(builderState, value);
        break;
    case CSSPropertyWebkitMaskComposite:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskComposite(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskComposite(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskComposite(builderState, value);
        break;
    case CSSPropertyWebkitMaskImage:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskImage(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskImage(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskImage(builderState, value);
        break;
    case CSSPropertyWebkitMaskOrigin:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskOrigin(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskOrigin(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskOrigin(builderState, value);
        break;
    case CSSPropertyWebkitMaskPosition:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitMaskPositionX:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskPositionX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskPositionX(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskPositionX(builderState, value);
        break;
    case CSSPropertyWebkitMaskPositionY:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskPositionY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskPositionY(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskPositionY(builderState, value);
        break;
    case CSSPropertyWebkitMaskRepeat:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitMaskRepeatX:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskRepeatX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskRepeatX(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskRepeatX(builderState, value);
        break;
    case CSSPropertyWebkitMaskRepeatY:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskRepeatY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskRepeatY(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskRepeatY(builderState, value);
        break;
    case CSSPropertyWebkitMaskSize:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskSize(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskSize(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskSize(builderState, value);
        break;
    case CSSPropertyWebkitMaskSourceType:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskSourceType(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskSourceType(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskSourceType(builderState, value);
        break;
    case CSSPropertyWebkitNbspMode:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitNbspMode(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitNbspMode(builderState);
        else
            BuilderFunctions::applyValueWebkitNbspMode(builderState, value);
        break;
    case CSSPropertyWebkitPrintColorAdjust:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitPrintColorAdjust(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitPrintColorAdjust(builderState);
        else
            BuilderFunctions::applyValueWebkitPrintColorAdjust(builderState, value);
        break;
    case CSSPropertyWebkitRtlOrdering:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitRtlOrdering(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitRtlOrdering(builderState);
        else
            BuilderFunctions::applyValueWebkitRtlOrdering(builderState, value);
        break;
    case CSSPropertyWebkitRubyPosition:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitRubyPosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitRubyPosition(builderState);
        else
            BuilderFunctions::applyValueWebkitRubyPosition(builderState, value);
        break;
    case CSSPropertyWebkitTextCombine:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextCombine(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextCombine(builderState);
        else
            BuilderFunctions::applyValueWebkitTextCombine(builderState, value);
        break;
    case CSSPropertyWebkitTextDecoration:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitTextDecorationsInEffect:
        break;
    case CSSPropertyWebkitTextEmphasis:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitTextEmphasisColor:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextEmphasisColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextEmphasisColor(builderState);
        else
            BuilderFunctions::applyValueWebkitTextEmphasisColor(builderState, value);
        break;
    case CSSPropertyWebkitTextEmphasisPosition:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextEmphasisPosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextEmphasisPosition(builderState);
        else
            BuilderFunctions::applyValueWebkitTextEmphasisPosition(builderState, value);
        break;
    case CSSPropertyWebkitTextEmphasisStyle:
        if (isInitial)
            BuilderCustom::applyInitialWebkitTextEmphasisStyle(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritWebkitTextEmphasisStyle(builderState);
        else
            BuilderCustom::applyValueWebkitTextEmphasisStyle(builderState, value);
        break;
    case CSSPropertyWebkitTextFillColor:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextFillColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextFillColor(builderState);
        else
            BuilderFunctions::applyValueWebkitTextFillColor(builderState, value);
        break;
    case CSSPropertyWebkitTextSecurity:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextSecurity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextSecurity(builderState);
        else
            BuilderFunctions::applyValueWebkitTextSecurity(builderState, value);
        break;
    case CSSPropertyWebkitTextStroke:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitTextStrokeColor:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextStrokeColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextStrokeColor(builderState);
        else
            BuilderFunctions::applyValueWebkitTextStrokeColor(builderState, value);
        break;
    case CSSPropertyWebkitTextStrokeWidth:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextStrokeWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextStrokeWidth(builderState);
        else
            BuilderFunctions::applyValueWebkitTextStrokeWidth(builderState, value);
        break;
    case CSSPropertyWebkitTransformStyle:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTransformStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTransformStyle(builderState);
        else
            BuilderFunctions::applyValueWebkitTransformStyle(builderState, value);
        break;
    case CSSPropertyWebkitUserDrag:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitUserDrag(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitUserDrag(builderState);
        else
            BuilderFunctions::applyValueWebkitUserDrag(builderState, value);
        break;
    case CSSPropertyWebkitUserModify:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitUserModify(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitUserModify(builderState);
        else
            BuilderFunctions::applyValueWebkitUserModify(builderState, value);
        break;
    case CSSPropertyWebkitUserSelect:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitUserSelect(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitUserSelect(builderState);
        else
            BuilderFunctions::applyValueWebkitUserSelect(builderState, value);
        break;
    };
}

} // namespace Style
} // namespace WebCore
