/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "WritableStreamInternalsBuiltins.h"

#if ENABLE(STREAMS_API)

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapInlines.h>
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSCJSValueInlines.h>
#include <JavaScriptCore/JSCellInlines.h>
#include <JavaScriptCore/StructureInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_writableStreamInternalsIsWritableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamInternalsIsWritableStreamCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamInternalsIsWritableStreamCodeLength = 126;
static const JSC::Intrinsic s_writableStreamInternalsIsWritableStreamCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamInternalsIsWritableStreamCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return @isObject(stream) && !!@getByIdDirectPrivate(stream, \"underlyingSink\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamInternalsSyncWritableStreamStateWithQueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamInternalsSyncWritableStreamStateWithQueueCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamInternalsSyncWritableStreamStateWithQueueCodeLength = 809;
static const JSC::Intrinsic s_writableStreamInternalsSyncWritableStreamStateWithQueueCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamInternalsSyncWritableStreamStateWithQueueCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    if (state === @streamClosing)\n" \
    "        return;\n" \
    "\n" \
    "    @assert(state === @streamWritable || state === @streamWaiting);\n" \
    "\n" \
    "    const shouldApplyBackpressure = @getByIdDirectPrivate(stream, \"queue\").size > @getByIdDirectPrivate(stream, \"strategy\").highWaterMark;\n" \
    "    if (shouldApplyBackpressure && state === @streamWritable) {\n" \
    "        @putByIdDirectPrivate(stream, \"state\", @streamWaiting);\n" \
    "        @putByIdDirectPrivate(stream, \"readyPromiseCapability\", @newPromiseCapability(@Promise));\n" \
    "    }\n" \
    "    if (!shouldApplyBackpressure && state === @streamWaiting) {\n" \
    "        @putByIdDirectPrivate(stream, \"state\", @streamWritable);\n" \
    "        @getByIdDirectPrivate(stream, \"readyPromiseCapability\").@resolve.@call();\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamInternalsErrorWritableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamInternalsErrorWritableStreamCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamInternalsErrorWritableStreamCodeLength = 771;
static const JSC::Intrinsic s_writableStreamInternalsErrorWritableStreamCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamInternalsErrorWritableStreamCode =
    "(function (stream, e)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    if (state === @streamClosed || state === @streamErrored)\n" \
    "        return;\n" \
    "    while (@getByIdDirectPrivate(stream, \"queue\").content.length > 0) {\n" \
    "        const writeRecord = @dequeueValue(@getByIdDirectPrivate(stream, \"queue\"));\n" \
    "        if (writeRecord !== \"close\")\n" \
    "            writeRecord.promiseCapability.@reject.@call(@undefined, e);\n" \
    "    }\n" \
    "    @putByIdDirectPrivate(stream, \"storedError\", e);\n" \
    "    if (state === @streamWaiting)\n" \
    "        @getByIdDirectPrivate(stream, \"readyPromiseCapability\").@resolve.@call();\n" \
    "    @getByIdDirectPrivate(stream, \"closedPromiseCapability\").@reject.@call(@undefined, e);\n" \
    "    @putByIdDirectPrivate(stream, \"state\", @streamErrored);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCodeLength = 264;
static const JSC::Intrinsic s_writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@getByIdDirectPrivate(stream, \"started\"))\n" \
    "        @getByIdDirectPrivate(stream, \"startedPromise\").@then(function() { @writableStreamAdvanceQueue(stream); });\n" \
    "    else\n" \
    "        @writableStreamAdvanceQueue(stream);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamInternalsWritableStreamAdvanceQueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamInternalsWritableStreamAdvanceQueueCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamInternalsWritableStreamAdvanceQueueCodeLength = 1237;
static const JSC::Intrinsic s_writableStreamInternalsWritableStreamAdvanceQueueCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamInternalsWritableStreamAdvanceQueueCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(stream, \"queue\").content.length === 0 || @getByIdDirectPrivate(stream, \"writing\"))\n" \
    "        return;\n" \
    "\n" \
    "    const writeRecord = @peekQueueValue(@getByIdDirectPrivate(stream, \"queue\"));\n" \
    "    if (writeRecord === \"close\") {\n" \
    "        @assert(@getByIdDirectPrivate(stream, \"state\") === @streamClosing);\n" \
    "        @dequeueValue(@getByIdDirectPrivate(stream, \"queue\"));\n" \
    "        @assert(@getByIdDirectPrivate(stream, \"queue\").content.length === 0);\n" \
    "        @closeWritableStream(stream);\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"writing\", true);\n" \
    "    @promiseInvokeOrNoop(@getByIdDirectPrivate(stream, \"underlyingSink\"), \"write\", [writeRecord.chunk]).@then(\n" \
    "        function() {\n" \
    "            if (@getByIdDirectPrivate(stream, \"state\") === @streamErrored)\n" \
    "                return;\n" \
    "            @putByIdDirectPrivate(stream, \"writing\", false);\n" \
    "            writeRecord.promiseCapability.@resolve.@call();\n" \
    "            @dequeueValue(@getByIdDirectPrivate(stream, \"queue\"));\n" \
    "            @syncWritableStreamStateWithQueue(stream);\n" \
    "            @writableStreamAdvanceQueue(stream);\n" \
    "        },\n" \
    "        function(r) {\n" \
    "            @errorWritableStream(stream, r);\n" \
    "        }\n" \
    "    );\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamInternalsCloseWritableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamInternalsCloseWritableStreamCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamInternalsCloseWritableStreamCodeLength = 654;
static const JSC::Intrinsic s_writableStreamInternalsCloseWritableStreamCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamInternalsCloseWritableStreamCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === @streamClosing);\n" \
    "    @promiseInvokeOrNoop(@getByIdDirectPrivate(stream, \"underlyingSink\"), \"close\").@then(\n" \
    "        function() {\n" \
    "            if (@getByIdDirectPrivate(stream, \"state\") === @streamErrored)\n" \
    "                return;\n" \
    "            @assert(@getByIdDirectPrivate(stream, \"state\") === @streamClosing);\n" \
    "            @getByIdDirectPrivate(stream, \"closedPromiseCapability\").@resolve.@call();\n" \
    "            @putByIdDirectPrivate(stream, \"state\", @streamClosed);\n" \
    "        },\n" \
    "        function(r) {\n" \
    "            @errorWritableStream(stream, r);\n" \
    "        }\n" \
    "    );\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().writableStreamInternalsBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().writableStreamInternalsBuiltins().codeName##Source(), WTF::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(STREAMS_API)
