/*
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies)
 * Copyright (C) 2012 Adobe Systems Incorporated
 * Copyright (C) 2012, 2016 Igalia S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "config.h"

#include "ClipStack.h"

 //+TELESCOPE_LIB_CHANGES
 //3/1/2020
 //Disable OpenGL
#if USE(TEXTURE_MAPPER_GL)
#include "TextureMapperGLHeaders.h"
//+TELESCOPE_LIB_CHANGES
// 8/31/2020
// Supporting Telescope hardware accelerated texture mapping
#elif USE(TEXTURE_MAPPER_TELESCOPE)
#define USE_WEBCORE_TYPE_CONVERTION_UTILITY
#include <Telescope/include/Render/HardwareRenderBase.h>
#undef USE_WEBCORE_TYPE_CONVERTION_UTILITY
//-TELESCOPE_LIB_CHANGES
#endif // USE(TEXTURE_MAPPER_GL)
//-TELESCOPE_LIB_CHANGES


namespace WebCore {

void ClipStack::push()
{
    clipStack.append(clipState);
    clipStateDirty = true;
}

void ClipStack::pop()
{
    if (clipStack.isEmpty())
        return;
    clipState = clipStack.last();
    clipStack.removeLast();
    clipStateDirty = true;
}

void ClipStack::reset(const IntRect& rect, ClipStack::YAxisMode mode)
{
    clipStack.clear();
    size = rect.size();
    yAxisMode = mode;
    clipState = State(rect);
    clipStateDirty = true;
}

void ClipStack::intersect(const IntRect& rect)
{
    clipState.scissorBox.intersect(rect);
    clipStateDirty = true;
}

void ClipStack::setStencilIndex(int stencilIndex)
{
    clipState.stencilIndex = stencilIndex;
    clipStateDirty = true;
}

void ClipStack::apply()
{
    if (clipState.scissorBox.isEmpty())
        return;

//+TELESCOPE_LIB_CHANGES
//8/14/2020
//Disable OpenGL
#if USE(TEXTURE_MAPPER_GL)
    glScissor(clipState.scissorBox.x(),
        (yAxisMode == YAxisMode::Inverted) ? size.height() - clipState.scissorBox.maxY() : clipState.scissorBox.y(),
        clipState.scissorBox.width(), clipState.scissorBox.height());
    glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);
    glStencilFunc(GL_EQUAL, clipState.stencilIndex - 1, clipState.stencilIndex - 1);
    if (clipState.stencilIndex == 1)
        glDisable(GL_STENCIL_TEST);
    else
        glEnable(GL_STENCIL_TEST);
//+TELESCOPE_LIB_CHANGES
// 8/31/2020
// Supporting Telescope hardware accelerated texture mapping
#elif USE(TEXTURE_MAPPER_TELESCOPE)
	m_render.ScissorClip( clipState.scissorBox );
	m_render.StencilClipAgainstValue( clipState.stencilIndex - 1 );
//-TELESCOPE_LIB_CHANGES
#endif // USE(TEXTURE_MAPPER_GL)
}

void ClipStack::applyIfNeeded()
{
    if (!clipStateDirty)
        return;

    clipStateDirty = false;
    apply();
}
} // namespace WebCore