/*
 * Copyright (C) 2019 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
 

#include "config.h"
#include <wtf/Language.h>

#include <wtf/text/WTFString.h>


//+TELESCOPE_LIB_CHANGES
// 3/16/2020
// WTF library for PS4
// 4/7/2020
// add place-holder comments for wtf
// 4/27/2020 
// [Telescope] fix Crash bug for PS version when opens "https://support.activision.com/modern-warfare"
#include <system_param.h>
#include <system_service.h>

#pragma comment(lib, "libSceSystemService_stub_weak.a")

namespace WTF {

Vector<String> platformUserPreferredLanguages()
{
    Vector<String> languages;

	int iLangCode = 0;
	sceSystemServiceParamGetInt( SCE_SYSTEM_SERVICE_PARAM_ID_LANG, &iLangCode) ;
	switch ( iLangCode )
	{
	case SCE_SYSTEM_PARAM_LANG_JAPANESE:
		languages.append("ja-jp");
		break;
	case SCE_SYSTEM_PARAM_LANG_ENGLISH_US:
		languages.append("en-us");
		break;
	case SCE_SYSTEM_PARAM_LANG_FRENCH:
		languages.append("fr-fr");
		break;
	case SCE_SYSTEM_PARAM_LANG_SPANISH:
		languages.append("es-es");
		break;
	case SCE_SYSTEM_PARAM_LANG_GERMAN:
		languages.append("de-de");
		break;
	case SCE_SYSTEM_PARAM_LANG_ITALIAN:
		languages.append("it-it");
		break;
	case SCE_SYSTEM_PARAM_LANG_DUTCH:
		languages.append("nl-nl");
		break;
	case SCE_SYSTEM_PARAM_LANG_PORTUGUESE_PT:
		languages.append("pt-pt");
		break;
	case SCE_SYSTEM_PARAM_LANG_RUSSIAN:
		languages.append("ru-ru");
		break;
	case SCE_SYSTEM_PARAM_LANG_KOREAN:
		languages.append("ko-kr");
		break;
	case SCE_SYSTEM_PARAM_LANG_CHINESE_T:
		languages.append("zh-tw");
		break;
	case SCE_SYSTEM_PARAM_LANG_CHINESE_S:
		languages.append("zh-cn");
		break;
	case SCE_SYSTEM_PARAM_LANG_FINNISH:
		languages.append("fi-fi");
		break;
	case SCE_SYSTEM_PARAM_LANG_SWEDISH:
		languages.append("sv-se");
		break;
	case SCE_SYSTEM_PARAM_LANG_DANISH:
		languages.append("da-dk");
		break;
	case SCE_SYSTEM_PARAM_LANG_NORWEGIAN:
		languages.append("no-no");
		break;
	case SCE_SYSTEM_PARAM_LANG_POLISH:
		languages.append("pl-pl");
		break;
	case SCE_SYSTEM_PARAM_LANG_PORTUGUESE_BR:
		languages.append("pt-br");
		break;
	case SCE_SYSTEM_PARAM_LANG_ENGLISH_GB:
		languages.append("en-gb");
		break;
	case SCE_SYSTEM_PARAM_LANG_TURKISH:
		languages.append("tr-tr");
		break;
	case SCE_SYSTEM_PARAM_LANG_SPANISH_LA:
		languages.append("es-la");
		break;
	case SCE_SYSTEM_PARAM_LANG_ARABIC:
		languages.append("ar-ar");
		break;
	case SCE_SYSTEM_PARAM_LANG_FRENCH_CA:
		languages.append("fr-ca");
		break;
	case SCE_SYSTEM_PARAM_LANG_CZECH:
		languages.append("cs-cz");
		break;
	case SCE_SYSTEM_PARAM_LANG_HUNGARIAN:
		languages.append("hu-hu");
		break;
	case SCE_SYSTEM_PARAM_LANG_GREEK:
		languages.append("el-gr");
		break;
	case SCE_SYSTEM_PARAM_LANG_ROMANIAN:
		languages.append("ro-ro");
		break;
	case SCE_SYSTEM_PARAM_LANG_THAI:
		languages.append("th-th");
		break;
	case SCE_SYSTEM_PARAM_LANG_VIETNAMESE:
		languages.append("vi-vn");
		break;
	case SCE_SYSTEM_PARAM_LANG_INDONESIAN:
		languages.append("id-id");
		break;
	default:
		languages.append("en-us");
	}

    return languages;
}
//-TELESCOPE_LIB_CHANGES

} // namespace WTF
