/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <windows.h>

#define FILE_MAP_WRITE      SECTION_MAP_WRITE
#define FILE_MAP_READ       SECTION_MAP_READ
#define FILE_MAP_ALL_ACCESS SECTION_ALL_ACCESS

#define DEFAULT_CHARSET 0

static inline LONG_PTR GetWindowLongPtr(
	HWND hWnd,
	int  nIndex
)
{
	return 0;
}

static inline LONG_PTR SetWindowLongPtr(
	HWND     hWnd,
	int      nIndex,
	LONG_PTR dwNewLong
)
{
	return 0;
}

static inline DWORD GetFinalPathNameByHandleW(
	HANDLE hFile,
	LPWSTR lpszFilePath,
	DWORD  cchFilePath,
	DWORD  dwFlags
)
{
	return MAX_PATH;
}

static inline DWORD GetTempPathW(
	DWORD  nBufferLength,
	LPWSTR lpBuffer
)
{
    wcscpy_s(lpBuffer, nBufferLength, L"T:\\");
	return 3;
}

static inline BOOL CreateHardLink(
	LPCWSTR               lpFileName,
	LPCWSTR               lpExistingFileName,
	LPSECURITY_ATTRIBUTES lpSecurityAttributes
)
{
	return 0;
}

static inline HRESULT CopyFile(
	LPCWSTR lpExistingFileName,
	LPCWSTR lpNewFileName,
	BOOL    bFailIfExists
)
{
	COPYFILE2_EXTENDED_PARAMETERS failIfExistsParameter = { sizeof(COPYFILE2_EXTENDED_PARAMETERS), COPY_FILE_FAIL_IF_EXISTS, false, nullptr, nullptr };
    return CopyFile2(lpExistingFileName, lpNewFileName, bFailIfExists ? &failIfExistsParameter : nullptr);
}

static inline LPVOID MapViewOfFile(
	HANDLE hFileMappingObject,
	DWORD  dwDesiredAccess,
	DWORD  dwFileOffsetHigh,
	DWORD  dwFileOffsetLow,
	SIZE_T dwNumberOfBytesToMap
)
{
	return NULL;
}

static inline BOOL UnmapViewOfFile(
	LPCVOID lpBaseAddress
)
{
	return false;
}

static inline HANDLE CreateFileMapping(
	HANDLE                hFile,
	LPSECURITY_ATTRIBUTES lpFileMappingAttributes,
	DWORD                 flProtect,
	DWORD                 dwMaximumSizeHigh,
	DWORD                 dwMaximumSizeLow,
	LPCWSTR               lpName
)
{
	return NULL;
}

static inline int GetLocaleInfo(
    LCID   Locale,
    LCTYPE LCType,
    LPWSTR lpLCData,
    int    cchData
)
{
    WCHAR lpName[LOCALE_NAME_MAX_LENGTH];
    LCIDToLocaleName(Locale, lpName, LOCALE_NAME_MAX_LENGTH, 0);
    return GetLocaleInfoEx(lpName, LCType, lpLCData, cchData);
}

static inline DWORD GetFileSize(
    HANDLE  hFile,
    LPDWORD lpFileSizeHigh
)
{
    LARGE_INTEGER bytesToReadLG;
    GetFileSizeEx(hFile, &bytesToReadLG);
    return static_cast<DWORD>(bytesToReadLG.QuadPart);

}

struct WNDCLASSW {
    UINT        style;
    int     lpfnWndProc;
    int         cbClsExtra;
    int         cbWndExtra;
    HINSTANCE   hInstance;
    HICON       hIcon;
    HCURSOR     hCursor;
    HBRUSH      hbrBackground;
    LPCWSTR     lpszMenuName;
    LPCWSTR     lpszClassName;
};


static inline ATOM RegisterClassW(const WNDCLASSW*lpWndClass)
{
    return 0;
}

static int DefWindowProcW = 0;

static inline DWORD NotifyAddrChange(
    PHANDLE      Handle,
    LPOVERLAPPED overlapped
)
{
    return ERROR_NOT_SUPPORTED;
}

static inline int lstrcmpW(
    LPCWSTR lpString1,
    LPCWSTR lpString2
)
{
    return CompareStringEx(LOCALE_NAME_USER_DEFAULT, 0, lpString1, -1, lpString2, -1, NULL, NULL, 0) - 2;
}