/*
 * Copyright (C) 2007, 2016, 2017 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#include <mutex>
#include <windows.h>
#include <wtf/Lock.h>
#include <wtf/Vector.h>
#include <wtf/text/WTFString.h>

namespace WTF {

static Lock platformLanguageMutex;

static String platformLanguage()
{
	std::lock_guard<Lock> lock(platformLanguageMutex);

	static String computedDefaultLanguage;
	if (!computedDefaultLanguage.isEmpty())
		return computedDefaultLanguage.isolatedCopy();

//+TELESCOPE_LIB_CHANGES
// 3/17/2020
// API GetUserDefaultUILanguage is unavailable in XBOX. Reimplement the feature by using GetUserDefaultLocaleName
	WCHAR wLocalName[LOCALE_NAME_MAX_LENGTH];
	if( GetUserDefaultLocaleName( wLocalName, LOCALE_NAME_MAX_LENGTH ) )
	{
		char localName[LOCALE_NAME_MAX_LENGTH] = "";
		WideCharToMultiByte( CP_UTF8, 0, wLocalName, -1, localName, sizeof( localName ), nullptr, nullptr );
		computedDefaultLanguage = localName;
	}
	else
	{
		computedDefaultLanguage = "en";
	}
//-TELESCOPE_LIB_CHANGES
	return computedDefaultLanguage;
}

Vector<String> platformUserPreferredLanguages()
{
	return { platformLanguage() };
}

} // namespace WTF
